/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.design;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import org.netbeans.core.windows.design.DesignViewComponent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class DesignView
implements Runnable,
PropertyChangeListener {
    private static final DesignView INSTANCE = new DesignView();
    static int designModeCounter;

    private DesignView() {
    }

    public static void initialize() {
        INSTANCE.cleanToolbarsAndMenu();
        WindowManager.getDefault().invokeWhenUIReady((Runnable)INSTANCE);
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)INSTANCE);
    }

    private void cleanToolbarsAndMenu() {
        FileObject fileObject;
        FileObject fileObject2;
        FileObject fileObject3 = FileUtil.getConfigFile((String)"Toolbars");
        if (fileObject3 != null) {
            fileObject2 = fileObject3.getChildren();
            int n = ((FileObject)fileObject2).length;
            for (int i = 0; i < n; ++i) {
                FileObject fileObject4 = fileObject2[i];
                try {
                    fileObject4.delete();
                    continue;
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            try {
                fileObject2 = fileObject3.createFolder("DesignView").createData("org-netbeans-core-windows-model-NewMode.shadow");
                fileObject2.setAttribute("originalFile", (Object)"Actions/System/org-netbeans-core-windows-model-NewMode.instance");
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if ((fileObject2 = FileUtil.getConfigFile((String)"Menu")) != null) {
            for (FileObject fileObject5 : fileObject2.getChildren()) {
                try {
                    fileObject5.delete();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
        if ((fileObject = FileUtil.getConfigFile((String)"Windows2Local")) != null) {
            try {
                fileObject.delete();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        WindowManager.getDefault().invokeWhenUIReady((Runnable)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("opened".equals(propertyChangeEvent.getPropertyName())) {
            for (Mode mode : WindowManager.getDefault().getModes()) {
                for (TopComponent topComponent : mode.getTopComponents()) {
                    if (topComponent instanceof DesignViewComponent) continue;
                    topComponent.close();
                }
            }
        }
    }

    @Override
    public void run() {
        for (Mode mode : WindowManager.getDefault().getModes()) {
            boolean bl = false;
            for (TopComponent topComponent : mode.getTopComponents()) {
                if (topComponent instanceof DesignViewComponent) {
                    bl = true;
                    continue;
                }
                topComponent.close();
            }
            if (bl) continue;
            DesignViewComponent designViewComponent = new DesignViewComponent();
            mode.dockInto((TopComponent)designViewComponent);
            designViewComponent.open();
        }
    }

    public static ActionListener newModeAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DesignViewComponent designViewComponent = new DesignViewComponent();
                designViewComponent.open();
                designViewComponent.requestAttention(true);
            }
        };
    }
}

