/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.graphics;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import org.stathissideris.ascii2image.core.ConversionOptions;
import org.stathissideris.ascii2image.core.Pair;
import org.stathissideris.ascii2image.graphics.BitmapRenderer;
import org.stathissideris.ascii2image.graphics.CompositeDiagramShape;
import org.stathissideris.ascii2image.graphics.CustomShapeDefinition;
import org.stathissideris.ascii2image.graphics.DiagramComponent;
import org.stathissideris.ascii2image.graphics.DiagramShape;
import org.stathissideris.ascii2image.graphics.DiagramText;
import org.stathissideris.ascii2image.graphics.FontMeasurer;
import org.stathissideris.ascii2image.graphics.ShapeEdge;
import org.stathissideris.ascii2image.graphics.ShapePoint;
import org.stathissideris.ascii2image.text.AbstractionGrid;
import org.stathissideris.ascii2image.text.CellSet;
import org.stathissideris.ascii2image.text.TextGrid;

public class Diagram {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_VERBOSE = false;
    private static final boolean DEBUG_MAKE_SHAPES = false;
    private ArrayList<DiagramShape> shapes = new ArrayList();
    private ArrayList<CompositeDiagramShape> compositeShapes = new ArrayList();
    private ArrayList<DiagramText> textObjects = new ArrayList();
    private int width;
    private int height;
    private int cellWidth;
    private int cellHeight;

    /*
     * WARNING - void declaration
     */
    public Diagram(TextGrid textGrid, ConversionOptions conversionOptions) {
        Object object;
        Object object2;
        Object object32;
        void var10_14;
        void var14_28;
        ArrayList<CellSet> arrayList;
        this.cellWidth = conversionOptions.renderingOptions.getCellWidth();
        this.cellHeight = conversionOptions.renderingOptions.getCellHeight();
        this.width = textGrid.getWidth() * this.cellWidth;
        this.height = textGrid.getHeight() * this.cellHeight;
        TextGrid textGrid2 = new TextGrid(textGrid);
        textGrid2.replaceTypeOnLine();
        textGrid2.replacePointMarkersOnLine();
        int n = textGrid.getWidth();
        int n2 = textGrid.getHeight();
        AbstractionGrid abstractionGrid = new AbstractionGrid(textGrid2, textGrid2.getAllBoundaries());
        ArrayList<CellSet> arrayList2 = abstractionGrid.getDistinctShapes();
        ArrayList<CellSet> arrayList3 = new ArrayList<CellSet>();
        for (CellSet iterable22 : arrayList2) {
            arrayList = new TextGrid(n * 3, n2 * 3);
            for (int i = 0; i < n2 * 3; ++i) {
                for (int j = 0; j < n * 3; ++j) {
                    TextGrid textGrid3;
                    TextGrid textGrid4;
                    if (!((TextGrid)((Object)arrayList)).isBlank(j, i)) continue;
                    TextGrid textGrid5 = textGrid4 = new AbstractionGrid(textGrid2, iterable22).getCopyOfInternalBuffer();
                    textGrid5.getClass();
                    CellSet cellSet = textGrid4.findBoundariesExpandingFrom(new TextGrid.Cell(textGrid5, j, i));
                    if (cellSet.size() == 0) continue;
                    arrayList3.add(cellSet.makeScaledOneThirdEquivalent());
                    TextGrid textGrid6 = textGrid3 = new AbstractionGrid(textGrid2, iterable22).getCopyOfInternalBuffer();
                    textGrid6.getClass();
                    CellSet cellSet2 = textGrid3.fillContinuousArea(new TextGrid.Cell(textGrid6, j, i), '*');
                    ((TextGrid)((Object)arrayList)).fillCellsWith(cellSet2, '*');
                    ((TextGrid)((Object)arrayList)).fillCellsWith(cellSet, '-');
                }
            }
        }
        arrayList3 = CellSet.removeDuplicateSets(arrayList3);
        int n3 = arrayList3.size();
        arrayList3 = CellSet.removeDuplicateSets(arrayList3);
        ArrayList<CellSet> arrayList4 = new ArrayList<CellSet>();
        arrayList = new ArrayList();
        ArrayList<CellSet> arrayList5 = new ArrayList<CellSet>();
        for (CellSet cellSet : arrayList3) {
            int n4 = cellSet.getType(textGrid2);
            if (n4 == 0) {
                arrayList.add(cellSet);
                continue;
            }
            if (n4 == 1) {
                arrayList4.add(cellSet);
                continue;
            }
            if (n4 != 2) continue;
            arrayList5.add(cellSet);
        }
        boolean bl = false;
        if (arrayList5.size() > 0 && arrayList.size() > 0) {
            boolean bl2 = true;
            for (CellSet cellSet : arrayList5) {
                for (CellSet cellSet3 : arrayList) {
                    cellSet.subtractSet(cellSet3);
                }
                if (cellSet.getType(textGrid2) != 1) continue;
                arrayList3.remove(cellSet);
                arrayList3.addAll(cellSet.breakIntoDistinctBoundaries(textGrid2));
            }
        } else if (arrayList5.size() > 0 && arrayList.size() == 0) {
            boolean bl3 = true;
            for (CellSet cellSet : arrayList5) {
                arrayList3.remove(cellSet);
                arrayList3.addAll(cellSet.breakTrulyMixedBoundaries(textGrid2));
            }
        }
        if (var14_28 != false) {
            ArrayList<CellSet> arrayList6 = new ArrayList<CellSet>();
            arrayList = new ArrayList<CellSet>();
            arrayList5 = new ArrayList();
            for (CellSet cellSet : arrayList3) {
                int n5 = cellSet.getType(textGrid2);
                if (n5 == 0) {
                    arrayList.add(cellSet);
                    continue;
                }
                if (n5 == 1) {
                    arrayList6.add(cellSet);
                    continue;
                }
                if (n5 != 2) continue;
                arrayList5.add(cellSet);
            }
        }
        boolean bl4 = this.removeObsoleteShapes(textGrid2, arrayList);
        boolean bl5 = false;
        if (conversionOptions.processingOptions.areAllCornersRound()) {
            bl5 = true;
        }
        ArrayList<DiagramComponent> arrayList7 = new ArrayList<DiagramComponent>();
        for (CellSet cellSet : arrayList) {
            DiagramComponent diagramComponent = DiagramComponent.createClosedFromBoundaryCells(textGrid2, cellSet, this.cellWidth, this.cellHeight, bl5);
            if (diagramComponent == null) continue;
            if (diagramComponent instanceof DiagramShape) {
                this.addToShapes((DiagramShape)diagramComponent);
                arrayList7.add(diagramComponent);
                continue;
            }
            if (!(diagramComponent instanceof CompositeDiagramShape)) continue;
            this.addToCompositeShapes((CompositeDiagramShape)diagramComponent);
        }
        if (conversionOptions.processingOptions.performSeparationOfCommonEdges()) {
            this.separateCommonEdges(arrayList7);
        }
        for (CellSet cellSet : var10_14) {
            if (cellSet.size() == 1) {
                DiagramShape diagramShape;
                TextGrid.Cell cell = cellSet.getFirst();
                if (textGrid.cellContainsDashedLineChar(cell) || (diagramShape = DiagramShape.createSmallLine(textGrid2, cell, this.cellWidth, this.cellHeight)) == null) continue;
                this.addToShapes(diagramShape);
                diagramShape.connectEndsToAnchors(textGrid2, this);
                continue;
            }
            DiagramComponent diagramComponent = CompositeDiagramShape.createOpenFromBoundaryCells(textGrid2, cellSet, this.cellWidth, this.cellHeight, bl5);
            if (diagramComponent == null) continue;
            if (diagramComponent instanceof CompositeDiagramShape) {
                this.addToCompositeShapes((CompositeDiagramShape)diagramComponent);
                ((CompositeDiagramShape)diagramComponent).connectEndsToAnchors(textGrid2, this);
                continue;
            }
            if (!(diagramComponent instanceof DiagramShape)) continue;
            this.addToShapes((DiagramShape)diagramComponent);
            ((DiagramShape)diagramComponent).connectEndsToAnchors(textGrid2, this);
            ((DiagramShape)diagramComponent).moveEndsToCellEdges(textGrid, this);
        }
        for (TextGrid.CellColorPair cellColorPair : textGrid.findColorCodes()) {
            ShapePoint shapePoint = new ShapePoint(this.getCellMidX(cellColorPair.cell), this.getCellMidY(cellColorPair.cell));
            DiagramShape diagramShape = this.findSmallestShapeContaining(shapePoint);
            if (diagramShape == null) continue;
            diagramShape.setFillColor(cellColorPair.color);
        }
        for (TextGrid.CellTagPair cellTagPair : textGrid.findMarkupTags()) {
            ShapePoint shapePoint = new ShapePoint(this.getCellMidX(cellTagPair.cell), this.getCellMidY(cellTagPair.cell));
            object32 = this.findSmallestShapeContaining(shapePoint);
            if (object32 == null) continue;
            if (cellTagPair.tag.equals("d")) {
                object2 = conversionOptions.processingOptions.getFromCustomShapes("d");
                if (object2 == null) {
                    ((DiagramShape)object32).setType(3);
                    continue;
                }
                ((DiagramShape)object32).setType(9999);
                ((DiagramShape)object32).setDefinition((CustomShapeDefinition)object2);
                continue;
            }
            if (cellTagPair.tag.equals("s")) {
                object2 = conversionOptions.processingOptions.getFromCustomShapes("s");
                if (object2 == null) {
                    ((DiagramShape)object32).setType(4);
                    continue;
                }
                ((DiagramShape)object32).setType(9999);
                ((DiagramShape)object32).setDefinition((CustomShapeDefinition)object2);
                continue;
            }
            if (cellTagPair.tag.equals("io")) {
                object2 = conversionOptions.processingOptions.getFromCustomShapes("io");
                if (object2 == null) {
                    ((DiagramShape)object32).setType(5);
                    continue;
                }
                ((DiagramShape)object32).setType(9999);
                ((DiagramShape)object32).setDefinition((CustomShapeDefinition)object2);
                continue;
            }
            if (cellTagPair.tag.equals("c")) {
                object2 = conversionOptions.processingOptions.getFromCustomShapes("c");
                if (object2 == null) {
                    ((DiagramShape)object32).setType(6);
                    continue;
                }
                ((DiagramShape)object32).setType(9999);
                ((DiagramShape)object32).setDefinition((CustomShapeDefinition)object2);
                continue;
            }
            if (cellTagPair.tag.equals("mo")) {
                object2 = conversionOptions.processingOptions.getFromCustomShapes("mo");
                if (object2 == null) {
                    ((DiagramShape)object32).setType(7);
                    continue;
                }
                ((DiagramShape)object32).setType(9999);
                ((DiagramShape)object32).setDefinition((CustomShapeDefinition)object2);
                continue;
            }
            if (cellTagPair.tag.equals("tr")) {
                object2 = conversionOptions.processingOptions.getFromCustomShapes("tr");
                if (object2 == null) {
                    ((DiagramShape)object32).setType(8);
                    continue;
                }
                ((DiagramShape)object32).setType(9999);
                ((DiagramShape)object32).setDefinition((CustomShapeDefinition)object2);
                continue;
            }
            if (cellTagPair.tag.equals("o")) {
                object2 = conversionOptions.processingOptions.getFromCustomShapes("o");
                if (object2 == null) {
                    ((DiagramShape)object32).setType(9);
                    continue;
                }
                ((DiagramShape)object32).setType(9999);
                ((DiagramShape)object32).setDefinition((CustomShapeDefinition)object2);
                continue;
            }
            object2 = conversionOptions.processingOptions.getFromCustomShapes(cellTagPair.tag);
            ((DiagramShape)object32).setType(9999);
            ((DiagramShape)object32).setDefinition((CustomShapeDefinition)object2);
        }
        for (TextGrid.Cell cell : textGrid2.findArrowheads()) {
            object32 = DiagramShape.createArrowhead(textGrid2, cell, this.cellWidth, this.cellHeight);
            if (object32 != null) {
                this.addToShapes((DiagramShape)object32);
                continue;
            }
            System.err.println("Could not create arrowhead shape. Unexpected error.");
        }
        for (Object object32 : textGrid.getPointMarkersOnLine()) {
            object2 = new DiagramShape();
            ((DiagramShape)object2).addToPoints(new ShapePoint(this.getCellMidX((TextGrid.Cell)object32), this.getCellMidY((TextGrid.Cell)object32)));
            ((DiagramShape)object2).setType(2);
            ((DiagramShape)object2).setFillColor(Color.white);
            this.shapes.add((DiagramShape)object2);
        }
        this.removeDuplicateShapes();
        textGrid2 = new TextGrid(textGrid);
        textGrid2.removeNonText();
        object32 = new TextGrid(textGrid2);
        object2 = ((TextGrid)object32).getAllBlanksBetweenCharacters();
        ((TextGrid)object32).fillCellsWith((Iterable)object2, '|');
        CellSet cellSet = ((TextGrid)object32).getAllNonBlank();
        ArrayList<CellSet> arrayList8 = cellSet.breakIntoDistinctBoundaries();
        Font font = FontMeasurer.instance().getFontFor(this.cellHeight);
        for (CellSet cellSet4 : arrayList8) {
            TextGrid textGrid7 = new TextGrid(n, n2);
            textGrid2.copyCellsTo(cellSet4, textGrid7);
            object = textGrid7.findStrings();
            Iterator iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                DiagramText diagramText;
                TextGrid.CellStringPair cellStringPair = (TextGrid.CellStringPair)iterator.next();
                TextGrid.Cell cell = cellStringPair.cell;
                String string = cellStringPair.string;
                TextGrid textGrid8 = textGrid7;
                textGrid8.getClass();
                TextGrid.Cell cell2 = new TextGrid.Cell(textGrid8, cell.x + string.length() - 1, cell.y);
                int n6 = this.getCellMinX(cell);
                int n7 = this.getCellMaxY(cell);
                int n8 = this.getCellMaxX(cell2);
                if (FontMeasurer.instance().getWidthFor(string, font) > n8 - n6) {
                    Font font2 = FontMeasurer.instance().getFontFor(n8 - n6, string);
                    diagramText = new DiagramText(n6, n7, string, font2);
                } else {
                    diagramText = new DiagramText(n6, n7, string, font);
                }
                diagramText.centerVerticallyBetween(this.getCellMinY(cell), this.getCellMaxY(cell));
                int n9 = textGrid7.otherStringsStartInTheSameColumn(cell);
                int n10 = textGrid7.otherStringsEndInTheSameColumn(cell2);
                if (0 == n9 && 0 == n10) {
                    diagramText.centerHorizontallyBetween(n6, n8);
                } else if (n10 > 0 && n9 == 0) {
                    diagramText.alignRightEdgeTo(n8);
                } else if (n10 > 0 && n9 > 0) {
                    if (n10 > n9) {
                        diagramText.alignRightEdgeTo(n8);
                    } else if (n10 == n9) {
                        diagramText.centerHorizontallyBetween(n6, n8);
                    }
                }
                this.addToTextObjects(diagramText);
            }
        }
        for (DiagramText diagramText : this.getTextObjects()) {
            object = this.findSmallestShapeIntersecting(diagramText.getBounds());
            if (object == null || ((DiagramShape)object).getFillColor() == null || !BitmapRenderer.isColorDark(((DiagramShape)object).getFillColor())) continue;
            diagramText.setColor(Color.white);
        }
        for (DiagramShape diagramShape : this.getAllDiagramShapes()) {
            if (diagramShape.getType() != 9999) continue;
            for (DiagramText diagramText : this.getTextObjects()) {
                diagramText.setHasOutline(true);
                diagramText.setColor(DiagramText.DEFAULT_COLOR);
            }
        }
    }

    public ArrayList<DiagramShape> getAllDiagramShapes() {
        ArrayList<DiagramShape> arrayList = new ArrayList<DiagramShape>();
        arrayList.addAll(this.getShapes());
        for (CompositeDiagramShape compositeDiagramShape : this.getCompositeShapes()) {
            arrayList.addAll(compositeDiagramShape.getShapes());
        }
        return arrayList;
    }

    private boolean removeObsoleteShapes(TextGrid textGrid, ArrayList<CellSet> arrayList) {
        Iterable<TextGrid.Cell> iterable2;
        boolean bl = false;
        ArrayList<CellSet> arrayList2 = new ArrayList<CellSet>();
        for (CellSet cellSet : arrayList) {
            CellSet iterable22 = cellSet.getFilledEquivalent(textGrid);
            if (iterable22 == null) {
                return false;
            }
            arrayList2.add(iterable22);
        }
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        for (Iterable<TextGrid.Cell> iterable2 : arrayList2) {
            Iterable<TextGrid.Cell> iterable32;
            ArrayList<Iterable<TextGrid.Cell>> cellSet = new ArrayList<Iterable<TextGrid.Cell>>();
            cellSet.add(iterable2);
            for (Iterable<TextGrid.Cell> iterable32 : arrayList2) {
                if (iterable2 == iterable32 || !((CellSet)iterable2).hasCommonCells((CellSet)iterable32)) continue;
                cellSet.add(iterable32);
            }
            if (cellSet.size() == 2) continue;
            iterable32 = iterable2;
            for (CellSet cellSet2 : cellSet) {
                if (cellSet2.size() <= ((CellSet)iterable32).size()) continue;
                iterable32 = cellSet2;
            }
            cellSet.remove(iterable32);
            TextGrid textGrid2 = new TextGrid(((CellSet)iterable32).getMaxX() + 2, ((CellSet)iterable32).getMaxY() + 2);
            CellSet cellSet3 = new CellSet();
            for (CellSet cellSet4 : cellSet) {
                textGrid2.fillCellsWith(cellSet4, '*');
            }
            TextGrid textGrid3 = new TextGrid(((CellSet)iterable32).getMaxX() + 2, ((CellSet)iterable32).getMaxY() + 2);
            textGrid3.fillCellsWith(iterable32, '*');
            int n = arrayList2.indexOf(iterable32);
            if (!textGrid3.equals(textGrid2) || arrayList3.contains(new Integer(n))) continue;
            arrayList3.add(new Integer(n));
        }
        iterable2 = new ArrayList();
        Iterator<CellSet> iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)((Object)iterator.next());
            ((ArrayList)iterable2).add((CellSet)arrayList.get(n));
        }
        for (CellSet cellSet : iterable2) {
            bl = true;
            arrayList.remove(cellSet);
        }
        return bl;
    }

    public float getMinimumOfCellDimension() {
        return Math.min(this.getCellWidth(), this.getCellHeight());
    }

    private void separateCommonEdges(ArrayList arrayList) {
        Object object;
        Object object22;
        float f = this.getMinimumOfCellDimension() / 5.0f;
        ArrayList arrayList2 = new ArrayList();
        for (Object object22 : arrayList) {
            arrayList2.addAll(((DiagramShape)object22).getEdges());
        }
        object22 = new ArrayList();
        Iterator iterator = arrayList2.iterator();
        int n = 1;
        while (iterator.hasNext()) {
            object = (ShapeEdge)iterator.next();
            for (int i = n; i < arrayList2.size(); ++i) {
                ShapeEdge shapeEdge = (ShapeEdge)arrayList2.get(i);
                if (!((ShapeEdge)object).touchesWith(shapeEdge)) continue;
                ((ArrayList)object22).add(new Pair<Object, ShapeEdge>(object, shapeEdge));
            }
            ++n;
        }
        object = new ArrayList();
        iterator = ((ArrayList)object22).iterator();
        while (iterator.hasNext()) {
            Pair pair = (Pair)iterator.next();
            if (!((ArrayList)object).contains(pair.first)) {
                ((ShapeEdge)pair.first).moveInwardsBy(f);
                ((ArrayList)object).add(pair.first);
            }
            if (((ArrayList)object).contains(pair.second)) continue;
            ((ShapeEdge)pair.second).moveInwardsBy(f);
            ((ArrayList)object).add(pair.second);
        }
    }

    private void removeDuplicateShapes() {
        ArrayList<DiagramShape> arrayList = new ArrayList<DiagramShape>();
        Iterator iterator = this.getShapesIterator();
        while (iterator.hasNext()) {
            DiagramShape diagramShape = (DiagramShape)iterator.next();
            boolean bl = true;
            for (DiagramShape diagramShape2 : arrayList) {
                if (!diagramShape.equals(diagramShape2)) continue;
                bl = false;
            }
            if (!bl) continue;
            arrayList.add(diagramShape);
        }
        this.shapes.clear();
        this.shapes.addAll(arrayList);
    }

    private DiagramShape findSmallestShapeContaining(ShapePoint shapePoint) {
        DiagramShape diagramShape = null;
        for (DiagramShape diagramShape2 : this.getShapes()) {
            if (!diagramShape2.contains(shapePoint)) continue;
            if (diagramShape == null) {
                diagramShape = diagramShape2;
                continue;
            }
            if (!diagramShape2.isSmallerThan(diagramShape)) continue;
            diagramShape = diagramShape2;
        }
        return diagramShape;
    }

    private DiagramShape findSmallestShapeIntersecting(Rectangle2D rectangle2D) {
        DiagramShape diagramShape = null;
        for (DiagramShape diagramShape2 : this.getShapes()) {
            if (!diagramShape2.intersects(rectangle2D)) continue;
            if (diagramShape == null) {
                diagramShape = diagramShape2;
                continue;
            }
            if (!diagramShape2.isSmallerThan(diagramShape)) continue;
            diagramShape = diagramShape2;
        }
        return diagramShape;
    }

    private void addToTextObjects(DiagramText diagramText) {
        this.textObjects.add(diagramText);
    }

    private void addToCompositeShapes(CompositeDiagramShape compositeDiagramShape) {
        this.compositeShapes.add(compositeDiagramShape);
    }

    private void addToShapes(DiagramShape diagramShape) {
        this.shapes.add(diagramShape);
    }

    public Iterator getShapesIterator() {
        return this.shapes.iterator();
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getCellWidth() {
        return this.cellWidth;
    }

    public int getCellHeight() {
        return this.cellHeight;
    }

    public ArrayList<CompositeDiagramShape> getCompositeShapes() {
        return this.compositeShapes;
    }

    public ArrayList<DiagramShape> getShapes() {
        return this.shapes;
    }

    public int getCellMinX(TextGrid.Cell cell) {
        return Diagram.getCellMinX(cell, this.cellWidth);
    }

    public static int getCellMinX(TextGrid.Cell cell, int n) {
        return cell.x * n;
    }

    public int getCellMidX(TextGrid.Cell cell) {
        return Diagram.getCellMidX(cell, this.cellWidth);
    }

    public static int getCellMidX(TextGrid.Cell cell, int n) {
        return cell.x * n + n / 2;
    }

    public int getCellMaxX(TextGrid.Cell cell) {
        return Diagram.getCellMaxX(cell, this.cellWidth);
    }

    public static int getCellMaxX(TextGrid.Cell cell, int n) {
        return cell.x * n + n;
    }

    public int getCellMinY(TextGrid.Cell cell) {
        return Diagram.getCellMinY(cell, this.cellHeight);
    }

    public static int getCellMinY(TextGrid.Cell cell, int n) {
        return cell.y * n;
    }

    public int getCellMidY(TextGrid.Cell cell) {
        return Diagram.getCellMidY(cell, this.cellHeight);
    }

    public static int getCellMidY(TextGrid.Cell cell, int n) {
        return cell.y * n + n / 2;
    }

    public int getCellMaxY(TextGrid.Cell cell) {
        return Diagram.getCellMaxY(cell, this.cellHeight);
    }

    public static int getCellMaxY(TextGrid.Cell cell, int n) {
        return cell.y * n + n;
    }

    public TextGrid.Cell getCellFor(ShapePoint shapePoint) {
        TextGrid textGrid;
        if (shapePoint == null) {
            throw new IllegalArgumentException("ShapePoint cannot be null");
        }
        TextGrid textGrid2 = textGrid = new TextGrid();
        textGrid2.getClass();
        return new TextGrid.Cell(textGrid2, (int)shapePoint.x / this.cellWidth, (int)shapePoint.y / this.cellHeight);
    }

    public ArrayList<DiagramText> getTextObjects() {
        return this.textObjects;
    }
}

