/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.MultiFloatFunction;
import org.apache.lucene.queries.function.valuesource.MultiFunction;

public class MaxFloatFunction
extends MultiFloatFunction {
    public MaxFloatFunction(ValueSource[] sources) {
        super(sources);
    }

    @Override
    protected String name() {
        return "max";
    }

    @Override
    protected float func(int doc, FunctionValues[] valsArr) {
        if (!this.exists(doc, valsArr)) {
            return 0.0f;
        }
        float val = Float.NEGATIVE_INFINITY;
        for (FunctionValues vals : valsArr) {
            if (!vals.exists(doc)) continue;
            val = Math.max(vals.floatVal(doc), val);
        }
        return val;
    }

    @Override
    protected boolean exists(int doc, FunctionValues[] valsArr) {
        return MultiFunction.anyExists(doc, valsArr);
    }
}

