/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping.term;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.grouping.AllGroupHeadsCollector;
import org.apache.lucene.search.grouping.AllGroupsCollector;
import org.apache.lucene.search.grouping.FirstPassGroupingCollector;
import org.apache.lucene.search.grouping.Grouper;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.search.grouping.SecondPassGroupingCollector;
import org.apache.lucene.search.grouping.term.TermAllGroupHeadsCollector;
import org.apache.lucene.search.grouping.term.TermAllGroupsCollector;
import org.apache.lucene.search.grouping.term.TermFirstPassGroupingCollector;
import org.apache.lucene.search.grouping.term.TermSecondPassGroupingCollector;
import org.apache.lucene.util.BytesRef;

public class TermGrouper
extends Grouper<BytesRef> {
    private final String field;
    private final int initialSize;

    public TermGrouper(String field) {
        this(field, 128);
    }

    public TermGrouper(String field, int initialSize) {
        this.field = field;
        this.initialSize = initialSize;
    }

    @Override
    public FirstPassGroupingCollector<BytesRef> getFirstPassCollector(Sort sort, int count) throws IOException {
        return new TermFirstPassGroupingCollector(this.field, sort, count);
    }

    @Override
    public AllGroupHeadsCollector<BytesRef> getGroupHeadsCollector(Sort sort) {
        return TermAllGroupHeadsCollector.create(this.field, sort, this.initialSize);
    }

    @Override
    public AllGroupsCollector<BytesRef> getAllGroupsCollector() {
        return new TermAllGroupsCollector(this.field, this.initialSize);
    }

    @Override
    public SecondPassGroupingCollector<BytesRef> getSecondPassCollector(Collection<SearchGroup<BytesRef>> groups, Sort groupSort, Sort withinGroupSort, int maxDocsPerGroup, boolean getScores, boolean getMaxScores, boolean fillSortFields) throws IOException {
        return new TermSecondPassGroupingCollector(this.field, groups, groupSort, withinGroupSort, maxDocsPerGroup, getScores, getMaxScores, fillSortFields);
    }
}

