#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: dbus
version: 0.10.13
id: dbus-0.10.13-JltdCkqkMZ5DCQ1EDtIzNh
key: dbus-0.10.13-JltdCkqkMZ5DCQ1EDtIzNh
license: GPL-3
maintainer: Andrey Sverdlichenko <blaze@ruddy.ru>, John Millikin <john@john-millikin.com>
stability: experimental
homepage: https://github.com/rblaze/haskell-dbus#readme
synopsis: A client library for the D-Bus IPC system.
description:
    D-Bus is a simple, message-based protocol for inter-process
    communication, which allows applications to interact with other parts of
    the machine and the user'\''s session using remote procedure calls.
    .
    D-Bus is a essential part of the modern Linux desktop, where it replaces
    earlier protocols such as CORBA and DCOP.
    .
    This library is an implementation of the D-Bus protocol in Haskell. It
    can be used to add D-Bus support to Haskell applications, without the
    awkward interfaces common to foreign bindings.
    .
    Example: connect to the session bus, and get a list of active names.
    .
    @
    &#x7b;-\# LANGUAGE OverloadedStrings \#-&#x7d;
    .
    import Data.List (sort)
    import DBus
    import DBus.Client
    .
    main = do
    &#x20;   client <- connectSession
    &#x20;   //
    &#x20;   \-- Request a list of connected clients from the bus
    &#x20;   reply <- call_ client (methodCall \"\/org\/freedesktop\/DBus\" \"org.freedesktop.DBus\" \"ListNames\")
    &#x20;       &#x7b; methodCallDestination = Just \"org.freedesktop.DBus\"
    &#x20;       &#x7d;
    &#x20;   //
    &#x20;   \-- org.freedesktop.DBus.ListNames() returns a single value, which is
    &#x20;   \-- a list of names (here represented as [String])
    &#x20;   let Just names = fromVariant (methodReturnBody reply !! 0)
    &#x20;   //
    &#x20;   \-- Print each name on a line, sorted so reserved names are below
    &#x20;   \-- temporary names.
    &#x20;   mapM_ putStrLn (sort names)
    @
    .
    >$ ghc --make list-names.hs
    >$ ./list-names
    >:1.0
    >:1.1
    >:1.10
    >:1.106
    >:1.109
    >:1.110
    >ca.desrt.dconf
    >org.freedesktop.DBus
    >org.freedesktop.Notifications
    >org.freedesktop.secrets
    >org.gnome.ScreenSaver
category: Network, Desktop
author: John Millikin <john@john-millikin.com>
exposed: True
exposed-modules:
    DBus DBus.Client DBus.Introspection DBus.Socket DBus.Transport
    DBus.Internal.Address DBus.Internal.Message DBus.Internal.Types
    DBus.Internal.Wire
abi: d70c87ab694c49c89f9f09d7cf2ba5ca
trusted: False
import-dirs: /usr/lib/ghc-8.0.2/site-local/dbus-0.10.13
library-dirs: /usr/lib/ghc-8.0.2/site-local/dbus-0.10.13
dynamic-library-dirs: /usr/lib/arm-linux-ghc-8.0.2
data-dir: /usr/share/arm-linux-ghc-8.0.2/dbus-0.10.13
hs-libraries: HSdbus-0.10.13-JltdCkqkMZ5DCQ1EDtIzNh
depends:
    base-4.9.1.0 bytestring-0.10.8.1
    cereal-0.5.4.0-KtX8p6mYm6IKYn6d7ncsjw containers-0.5.7.1
    libxml-sax-0.7.5-7rRvabQfZem8Z79i4dLJr0
    network-2.6.3.2-IsLM4TXcLoRI0fmmBYVyQz
    parsec-3.1.11-1CA7c0vSU7tJHGhveOjoXR
    random-1.1-9tceXaeYIMZ4JrKq20Egog
    text-1.2.2.2-3ENqlljngKa6xj1Go2fVWq transformers-0.5.2.0
    unix-2.7.2.1 vector-0.12.0.1-692PQMDMB6pIQ1uGwefDcQ
    xml-types-0.3.6-8botxRFeY0wCHMVWLruSRf
haddock-interfaces: /usr/share/doc/haskell-dbus/html/dbus.haddock
haddock-html: /usr/share/doc/haskell-dbus/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
