/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.V3;
import org.jmol.java.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.Elements;
import org.jmol.util.Logger;
import org.jmol.util.SimpleEdge;
import org.jmol.util.SimpleNode;
import org.jmol.viewer.JC;

public class CIPChirality {
    static final String RULE_2_nXX_EQ_XX = ";9Be;19F;23Na;27Al;31P;45Sc;55Mn;59Co;75As;89Y;93Nb;98Tc;103Rh;127I;133Cs;141Pr;145Pm;159Tb;165Ho;169Tm;197Au;209Bi;209Po;210At;222Rn;223Fr;226Ra;227Ac;231Pa;232Th;and all > U (atomno > 92)";
    static final String RULE_2_nXX_REV_XX = ";4He;16O;52Cr;96Mo;175Lu;";
    static final int NO_CHIRALITY = 0;
    static final int TIED = 0;
    static final int A_WINS = -1;
    static final int B_WINS = 1;
    static final int DIASTEREOMERIC = -3;
    static final int DIASTEREOMERIC_A_WINS = -2;
    static final int DIASTEREOMERIC_B_WINS = 2;
    static final int ENANTIOMERIC_A_WINS = -3;
    static final int ENANTIOMERIC_B_WINS = 3;
    static final int IGNORE = Integer.MIN_VALUE;
    static final int UNDETERMINED = -1;
    static final int STEREO_R = 1;
    static final int STEREO_S = 2;
    static final int STEREO_M = 17;
    static final int STEREO_P = 18;
    static final int STEREO_Z = 5;
    static final int STEREO_E = 6;
    static final int STEREO_BOTH_RS = 3;
    static final int STEREO_BOTH_EZ = 7;
    static final int RULE_1a = 1;
    static final int RULE_1b = 2;
    static final int RULE_2 = 3;
    static final int RULE_3 = 4;
    static final int RULE_4a = 5;
    static final int RULE_4bTEST = 6;
    static final int RULE_4b = 7;
    static final int RULE_4c = 8;
    static final int RULE_5 = 9;
    boolean isRule4TEST = false;
    static String prefixString = "..........";
    static Integer zero = 0;
    static final float TRIGONALITY_MIN = 0.2f;
    static final int MAX_PATH = 50;
    static final int SMALL_RING_MAX = 7;
    int ptID;
    CIPAtom root;
    int currentRule = 1;
    Lst<BS> lstSmallRings = new Lst();
    BS bsAtropisomeric;
    BS bsKekuleAmbiguous;
    BS bsAzacyclic;
    V3 vNorm = new V3();
    V3 vNorm2 = new V3();
    V3 vTemp = new V3();
    static final int RULE_1b_TEST_OPTION_0_UNCHANGED = 0;
    static final int RULE_1b_TEST_OPTION_A_PARENT = 1;
    static final int RULE_1b_TEST_OPTION_B_SELF = 2;
    static final int RULE_1b_TEST_OPTION_C_NONE = 3;
    static final int RULE_1b_TEST_OPTION_D_SELF_KEKULE = 4;
    int rule1bOption = 1;
    boolean setAuxiliary;
    public boolean haveIsotopes;

    public String getRuleName() {
        return JC.getCIPRuleName(this.currentRule);
    }

    public CIPChirality() {
        System.out.println("TESTING Rule 1b option " + this.rule1bOption);
        this.isRule4TEST = false;
        System.out.println("TESTING Rule 4b option " + this.isRule4TEST);
    }

    private void init() {
        this.ptID = 0;
        this.lstSmallRings.clear();
        this.bsKekuleAmbiguous = null;
        this.bsAtropisomeric = new BS();
    }

    public void getChiralityForAtoms(SimpleNode[] atoms, BS bsAtoms, BS bsAtropisomeric, BS bsHelixM, BS bsHelixP, boolean setAuxiliary) {
        if (bsAtoms.isEmpty()) {
            return;
        }
        this.init();
        this.setAuxiliary = setAuxiliary && bsAtoms.cardinality() == 1;
        this.bsAtropisomeric = bsAtropisomeric == null ? new BS() : bsAtropisomeric;
        BS bs = BSUtil.copy(bsAtoms);
        this.lstSmallRings = new Lst();
        while (!bs.isEmpty()) {
            this.getSmallRings(atoms[bs.nextSetBit(0)], bs);
        }
        this.bsKekuleAmbiguous = this.getKekule(atoms);
        this.bsAzacyclic = this.getAzacyclic(atoms, bsAtoms);
        BS bsToDo = BSUtil.copy(bsAtoms);
        boolean haveAlkenes = this.preFilterAtomList(atoms, bsToDo);
        int i = bsToDo.nextSetBit(0);
        while (i >= 0) {
            SimpleNode a = atoms[i];
            a.setCIPChirality(0);
            this.ptID = 0;
            int c = this.getAtomChiralityLimited(a, null, null);
            a.setCIPChirality(c == 0 ? 3 : c | this.currentRule - 1 << 5);
            i = bsToDo.nextSetBit(i + 1);
        }
        if (haveAlkenes) {
            Lst<int[]> lstEZ = new Lst<int[]>();
            int i2 = bsToDo.nextSetBit(0);
            while (i2 >= 0) {
                this.getAtomBondChirality(atoms[i2], lstEZ, bsToDo);
                i2 = bsToDo.nextSetBit(i2 + 1);
            }
            if (this.lstSmallRings.size() > 0 && lstEZ.size() > 0) {
                this.clearSmallRingEZ(atoms, lstEZ);
            }
            if (bsHelixM != null) {
                i2 = bsHelixM.nextSetBit(0);
                while (i2 >= 0) {
                    atoms[i2].setCIPChirality(17);
                    i2 = bsHelixM.nextSetBit(i2 + 1);
                }
            }
            if (bsHelixP != null) {
                i2 = bsHelixP.nextSetBit(0);
                while (i2 >= 0) {
                    atoms[i2].setCIPChirality(18);
                    i2 = bsHelixP.nextSetBit(i2 + 1);
                }
            }
        }
        if (Logger.debugging) {
            Logger.info("sp2-aromatic = " + this.bsKekuleAmbiguous);
            Logger.info("smallRings = " + PT.toJSON(null, this.lstSmallRings));
        }
    }

    private BS getAzacyclic(SimpleNode[] atoms, BS bsAtoms) {
        BS bsAza = null;
        int i = bsAtoms.nextSetBit(0);
        while (i >= 0) {
            SimpleNode atom = atoms[i];
            if (atom.getElementNumber() == 7 && atom.getCovalentBondCount() == 3 && !this.bsKekuleAmbiguous.get(i)) {
                Lst<BS> nRings = new Lst<BS>();
                int j = this.lstSmallRings.size();
                while (--j >= 0) {
                    BS bsRing = (BS)this.lstSmallRings.get(j);
                    if (!bsRing.get(i)) continue;
                    nRings.addLast(bsRing);
                }
                int nr = nRings.size();
                if (nr >= 2) {
                    BS bsSubs = new BS();
                    SimpleEdge[] bonds = atom.getEdges();
                    int b = bonds.length;
                    while (--b >= 0) {
                        if (!bonds[b].isCovalent()) continue;
                        bsSubs.set(bonds[b].getOtherNode(atom).getIndex());
                    }
                    BS bsBoth = new BS();
                    BS bsAll = new BS();
                    for (int j2 = 0; j2 < nr - 1 && bsAll != null; ++j2) {
                        BS bs1 = (BS)nRings.get(j2);
                        for (int k = j2 + 1; k < nr && bsAll != null; ++k) {
                            BS bs2 = (BS)nRings.get(k);
                            BSUtil.copy2(bs1, bsBoth);
                            bsBoth.and(bs2);
                            if (bsBoth.cardinality() <= 2) continue;
                            BSUtil.copy2(bs1, bsAll);
                            bsAll.or(bs2);
                            bsAll.and(bsSubs);
                            if (bsAll.cardinality() != 3) continue;
                            if (bsAza == null) {
                                bsAza = new BS();
                            }
                            bsAza.set(i);
                            bsAll = null;
                        }
                    }
                }
            }
            i = bsAtoms.nextSetBit(i + 1);
        }
        return bsAza;
    }

    private boolean preFilterAtomList(SimpleNode[] atoms, BS bsToDo) {
        boolean haveAlkenes = false;
        int i = bsToDo.nextSetBit(0);
        while (i >= 0) {
            if (!this.couldBeChiralAtom(atoms[i])) {
                bsToDo.clear(i);
            } else if (!haveAlkenes && this.couldBeChiralAlkene(atoms[i], null) != -1) {
                haveAlkenes = true;
            }
            i = bsToDo.nextSetBit(i + 1);
        }
        return haveAlkenes;
    }

    private boolean couldBeChiralAtom(SimpleNode a) {
        boolean mustBePlanar = false;
        block0 : switch (a.getCovalentBondCount()) {
            default: {
                System.out.println("?? too many bonds! " + a);
                return false;
            }
            case 0: {
                return false;
            }
            case 1: {
                return false;
            }
            case 2: {
                return a.getElementNumber() == 7;
            }
            case 3: {
                switch (a.getElementNumber()) {
                    case 7: {
                        if (this.bsAzacyclic != null && this.bsAzacyclic.get(a.getIndex())) break block0;
                        return false;
                    }
                    case 6: {
                        mustBePlanar = true;
                        break block0;
                    }
                    case 15: 
                    case 16: 
                    case 33: 
                    case 34: 
                    case 51: 
                    case 52: 
                    case 83: 
                    case 84: {
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                    default: {
                        return false;
                    }
                }
            }
            case 4: 
        }
        SimpleEdge[] edges = a.getEdges();
        int nH = 0;
        boolean haveDouble = false;
        int j = edges.length;
        while (--j >= 0) {
            if (mustBePlanar && edges[j].getCovalentOrder() == 2) {
                haveDouble = true;
            }
            if (edges[j].getOtherNode(a).getIsotopeNumber() != 1) continue;
            ++nH;
        }
        return nH < 2 && (haveDouble || mustBePlanar == Math.abs(this.getTrigonality(a, this.vNorm)) < 0.2f);
    }

    private int couldBeChiralAlkene(SimpleNode a, SimpleNode b) {
        switch (a.getCovalentBondCount()) {
            default: {
                return -1;
            }
            case 2: {
                if (a.getElementNumber() == 7) break;
                return -1;
            }
            case 3: {
                if (this.isFirstRow(a)) break;
                return -1;
            }
        }
        SimpleEdge[] bonds = a.getEdges();
        int n = 0;
        int i = bonds.length;
        while (--i >= 0) {
            if (bonds[i].getCovalentOrder() != 2) continue;
            if (++n > 1) {
                return 17;
            }
            SimpleNode other = bonds[i].getOtherNode(a);
            if (!this.isFirstRow(other)) {
                return -1;
            }
            if (b == null || other == b && b.getCovalentBondCount() != 1) continue;
            return -1;
        }
        return 5;
    }

    boolean isFirstRow(SimpleNode a) {
        int n = a.getElementNumber();
        return n > 2 && n <= 10;
    }

    private BS getKekule(SimpleNode[] atoms) {
        int nRings = this.lstSmallRings.size();
        BS bs = new BS();
        BS bsDone = new BS();
        int i = nRings;
        while (--i >= 0) {
            if (bsDone.get(i)) continue;
            BS bsRing = (BS)this.lstSmallRings.get(i);
            if (bsRing.cardinality() != 6) {
                bsDone.set(i);
                continue;
            }
            int nPI = 0;
            int j = bsRing.nextSetBit(0);
            while (j >= 0) {
                SimpleNode a = atoms[j];
                if (bs.get(a.getIndex())) {
                    ++nPI;
                } else {
                    int nb = a.getCovalentBondCount();
                    if (nb == 3 || nb == 2) {
                        SimpleEdge[] bonds = a.getEdges();
                        int k = bonds.length;
                        while (--k >= 0) {
                            SimpleEdge b = bonds[k];
                            if (b.getCovalentOrder() != 2 || !bsRing.get(b.getOtherNode(a).getIndex())) continue;
                            ++nPI;
                            break;
                        }
                    }
                }
                j = bsRing.nextSetBit(j + 1);
            }
            if (nPI != 6) continue;
            bs.or(bsRing);
            bsDone.set(i);
            i = nRings;
        }
        return bs;
    }

    private void getSmallRings(SimpleNode atom, BS bs) {
        this.root = new CIPAtom().create(atom, null, false, false, false);
        this.root.addSmallRings(bs);
    }

    private void clearSmallRingEZ(SimpleNode[] atoms, Lst<int[]> lstEZ) {
        int j = this.lstSmallRings.size();
        while (--j >= 0) {
            ((BS)this.lstSmallRings.get(j)).andNot(this.bsAtropisomeric);
        }
        int i = lstEZ.size();
        while (--i >= 0) {
            int[] ab = (int[])lstEZ.get(i);
            int j2 = this.lstSmallRings.size();
            while (--j2 >= 0) {
                BS ring = (BS)this.lstSmallRings.get(j2);
                if (!ring.get(ab[0]) || !ring.get(ab[1])) continue;
                atoms[ab[0]].setCIPChirality(3);
                atoms[ab[1]].setCIPChirality(3);
            }
        }
    }

    float getTrigonality(SimpleNode a, V3 vNorm) {
        int n;
        P3[] pts = new P3[4];
        SimpleEdge[] bonds = a.getEdges();
        int i = n = bonds.length;
        int pt = 0;
        while (--i >= 0 && pt < 4) {
            if (!bonds[i].isCovalent()) continue;
            pts[pt++] = bonds[i].getOtherNode(a).getXYZ();
        }
        P4 plane = Measure.getPlaneThroughPoints(pts[0], pts[1], pts[2], vNorm, this.vTemp, new P4());
        return Measure.distanceToPlane(plane, pts[3] == null ? a.getXYZ() : pts[3]);
    }

    private void getAtomBondChirality(SimpleNode atom, Lst<int[]> lstEZ, BS bsToDo) {
        int index = atom.getIndex();
        SimpleEdge[] bonds = atom.getEdges();
        int c = 0;
        boolean isAtropic = this.bsAtropisomeric.get(index);
        int j = bonds.length;
        while (--j >= 0) {
            int index1;
            SimpleNode atom1;
            SimpleEdge bond = bonds[j];
            if (isAtropic) {
                atom1 = bonds[j].getOtherNode(atom);
                index1 = atom1.getIndex();
                if (!this.bsAtropisomeric.get(index1)) continue;
                c = this.setBondChirality(atom, atom1, atom, atom1, true);
            } else {
                if (bond.getCovalentOrder() != 2 || (index1 = (atom1 = this.getLastCumuleneAtom(bond, atom, null, null)).getIndex()) < index) continue;
                c = this.getBondChiralityLimited(bond, atom);
            }
            if (c != 0) {
                if (!isAtropic) {
                    lstEZ.addLast(new int[]{index, index1});
                }
                bsToDo.clear(index);
                bsToDo.clear(index1);
            }
            if (!isAtropic) continue;
            break;
        }
    }

    private SimpleNode getLastCumuleneAtom(SimpleEdge bond, SimpleNode atom, int[] nSP2, SimpleNode[] parents) {
        SimpleNode atom2 = bond.getOtherNode(atom);
        if (parents != null) {
            parents[0] = atom2;
            parents[1] = atom;
        }
        if (nSP2 != null) {
            nSP2[0] = 2;
        }
        boolean ppt = false;
        block0: while (atom2.getCovalentBondCount() == 2) {
            SimpleNode atom3;
            SimpleEdge[] edges = atom2.getEdges();
            int i = edges.length;
            do {
                if (--i < 0) continue block0;
            } while ((atom3 = (bond = edges[i]).getOtherNode(atom2)) == atom);
            if (bond.getCovalentOrder() != 2) {
                return atom2;
            }
            if (parents != null) {
                if (!ppt) {
                    parents[0] = atom2;
                    ppt = true;
                }
                parents[1] = atom2;
            }
            if (nSP2 != null) {
                nSP2[0] = nSP2[0] + 1;
            }
            atom = atom2;
            atom2 = atom3;
        }
        return atom2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getAtomChiralityLimited(SimpleNode atom, CIPAtom cipAtom, SimpleNode parentAtom) {
        int rs = 0;
        try {
            boolean isAlkeneEndCheck;
            boolean bl = isAlkeneEndCheck = atom == null;
            if (isAlkeneEndCheck) {
                this.root = cipAtom;
                atom = this.root.atom;
                cipAtom.parent = new CIPAtom().create(parentAtom, null, true, false, false);
                cipAtom.htPathPoints = cipAtom.parent.htPathPoints;
            } else {
                this.root = cipAtom = new CIPAtom().create(atom, null, false, false, false);
                if (!cipAtom.canBePseudo) {
                    return 0;
                }
                this.haveIsotopes = false;
            }
            if (!cipAtom.setNode()) return rs;
            this.currentRule = 1;
            while (this.currentRule <= 9) {
                block16: {
                    if (Logger.debugging) {
                        Logger.info("-Rule " + this.getRuleName() + " CIPChirality for " + cipAtom + "-----");
                    }
                    switch (this.currentRule) {
                        case 6: 
                        case 7: {
                            if (this.isRule4TEST == (this.currentRule == 6)) break;
                            break block16;
                        }
                        case 5: 
                        case 8: {
                            if (this.currentRule == 5) {
                                cipAtom.createRule4AuxiliaryData(null, null);
                                if (cipAtom.rule4Type == 0) break;
                            }
                            cipAtom.sortSubstituents(Integer.MIN_VALUE);
                        }
                    }
                    if (cipAtom.sortSubstituents(0)) {
                        if (Logger.debugging) {
                            Logger.info(this.currentRule + ">>>>" + cipAtom);
                            for (int i = 0; i < cipAtom.bondCount; ++i) {
                                if (cipAtom.atoms[i] == null) continue;
                                Logger.info(cipAtom.atoms[i] + " " + cipAtom.priorities[i]);
                            }
                        }
                        if (isAlkeneEndCheck) {
                            if (!cipAtom.atoms[0].isDuplicate) return 1;
                            return 2;
                        }
                        rs = cipAtom.checkHandedness() | (this.currentRule == 9 && cipAtom.canBePseudo ? 8 : 0);
                        if (!Logger.debugging) return rs;
                        Logger.info(atom + " " + JC.getCIPChiralityName(rs) + " by Rule " + this.getRuleName() + "\n----------------------------------");
                        return rs;
                    }
                }
                ++this.currentRule;
            }
            return rs;
        }
        catch (Throwable e) {
            System.out.println(e + " in CIPChirality");
            e.printStackTrace();
            return 3;
        }
    }

    private int getBondChiralityLimited(SimpleEdge bond, SimpleNode a) {
        if (Logger.debugging) {
            Logger.info("get Bond Chirality " + bond);
        }
        if (a == null) {
            a = bond.getOtherNode(null);
        }
        if (this.couldBeChiralAlkene(a, bond.getOtherNode(a)) == -1) {
            return 0;
        }
        int[] nSP2 = new int[1];
        SimpleNode[] parents = new SimpleNode[2];
        SimpleNode b = this.getLastCumuleneAtom(bond, a, nSP2, parents);
        boolean isAxial = nSP2[0] % 2 == 1;
        return this.setBondChirality(a, parents[0], parents[1], b, isAxial);
    }

    private int setBondChirality(SimpleNode a, SimpleNode pa, SimpleNode pb, SimpleNode b, boolean isAxial) {
        int c;
        CIPAtom a1 = new CIPAtom().create(a, null, true, false, false);
        int atop = this.getAlkeneEndTopPriority(a1, pa, isAxial);
        int ruleA = this.currentRule;
        CIPAtom b2 = new CIPAtom().create(b, null, true, false, false);
        int btop = this.getAlkeneEndTopPriority(b2, pb, isAxial);
        int ruleB = this.currentRule;
        int n = c = atop >= 0 && btop >= 0 ? this.getEneChirality(b2.atoms[btop], b2, a1, a1.atoms[atop], isAxial, true) : 0;
        if (c != 0 && (isAxial || !this.bsAtropisomeric.get(a.getIndex()) && !this.bsAtropisomeric.get(b.getIndex()))) {
            if (isAxial && ruleA == 9 != (ruleB == 9)) {
                c |= 8;
            }
            a.setCIPChirality(c | ruleA - 1 << 5);
            b.setCIPChirality(c | ruleB - 1 << 5);
            if (Logger.debugging) {
                Logger.info(a + "-" + b + " " + JC.getCIPChiralityName(c));
            }
        }
        return c;
    }

    int getEneChirality(CIPAtom top1, CIPAtom end1, CIPAtom end2, CIPAtom top2, boolean isAxial, boolean allowPseudo) {
        return top1 == null || top2 == null || top1.atom == null || top2.atom == null ? 0 : (isAxial ? (this.isPos(top1, end1, end2, top2) ? 18 : 17) : (this.isCis(top1, end1, end2, top2) ? 5 : 6));
    }

    private int getAlkeneEndTopPriority(CIPAtom a, SimpleNode pa, boolean isAxial) {
        a.canBePseudo = isAxial;
        return this.getAtomChiralityLimited(null, a, pa) - 1;
    }

    boolean isCis(CIPAtom a, CIPAtom b, CIPAtom c, CIPAtom d) {
        Measure.getNormalThroughPoints(a.atom.getXYZ(), b.atom.getXYZ(), c.atom.getXYZ(), this.vNorm, this.vTemp);
        V3 vNorm2 = new V3();
        Measure.getNormalThroughPoints(b.atom.getXYZ(), c.atom.getXYZ(), d.atom.getXYZ(), vNorm2, this.vTemp);
        return this.vNorm.dot(vNorm2) > 0.0f;
    }

    boolean isPos(CIPAtom a, CIPAtom b, CIPAtom c, CIPAtom d) {
        float angle = Measure.computeTorsion(a.atom.getXYZ(), b.atom.getXYZ(), c.atom.getXYZ(), d.atom.getXYZ(), true);
        return angle > 0.0f;
    }

    private class CIPAtom
    implements Comparable<CIPAtom>,
    Cloneable {
        private int id;
        private int sphere;
        private int rootDistance;
        private int priority;
        private boolean isSet;
        boolean isDuplicate = true;
        private boolean isTerminal;
        private boolean isAlkene;
        SimpleNode atom;
        private int atomIndex;
        int bondCount;
        private float elemNo;
        private float mass = -1.0f;
        CIPAtom parent;
        private CIPAtom rootSubstituent;
        private int h1Count;
        CIPAtom[] atoms = new CIPAtom[4];
        private int nAtoms;
        private BS bsPath;
        private String myPath = "";
        int[] priorities = new int[4];
        private int nPriorities;
        private CIPAtom spiroEnd;
        private CIPAtom spiroEnd1;
        private int nSpiro;
        Map<Integer, Integer> htPathPoints;
        private CIPAtom alkeneParent;
        private CIPAtom alkeneChild;
        private boolean isAlkeneAtom2;
        private boolean isKekuleAmbiguous;
        private CIPAtom nextSP2;
        private boolean multipleBondDuplicate;
        private boolean isEvenEne = true;
        private int auxEZ = -1;
        boolean canBePseudo = true;
        private char auxChirality = (char)126;
        private CIPAtom nextChiralBranch;
        private Object[] rule4Count;
        private String[] rule4List;
        private Lst<String[]> rootRule4Paths;
        private String priorityPath;
        int rule4Type;
        private boolean rule4checkIdentical = true;
        private char rule4Ref = (char)82;
        private BS bsTemp = new BS();
        private boolean reverseRule2;

        CIPAtom() {
        }

        CIPAtom create(SimpleNode atom, CIPAtom parent, boolean isAlkene, boolean isDuplicate, boolean isParentBond) {
            this.id = ++CIPChirality.this.ptID;
            this.parent = parent;
            if (atom == null) {
                return this;
            }
            this.isAlkene = isAlkene;
            this.atom = atom;
            this.atomIndex = atom.getIndex();
            this.isKekuleAmbiguous = CIPChirality.this.bsKekuleAmbiguous != null && CIPChirality.this.bsKekuleAmbiguous.get(this.atomIndex);
            this.elemNo = isDuplicate && this.isKekuleAmbiguous ? parent.getKekuleElementNumber() : (float)atom.getElementNumber();
            this.bondCount = atom.getCovalentBondCount();
            boolean bl = this.canBePseudo = this.bondCount == 4 || this.bondCount == 3 && !isAlkene && (this.elemNo > 10.0f || CIPChirality.this.bsAzacyclic != null && CIPChirality.this.bsAzacyclic.get(this.atomIndex));
            if (parent != null) {
                this.sphere = parent.sphere + 1;
            }
            if (this.sphere == 1) {
                this.rootSubstituent = this;
                this.htPathPoints = new Hashtable<Integer, Integer>();
            } else if (parent != null) {
                this.rootSubstituent = parent.rootSubstituent;
                this.htPathPoints = (Map)((Hashtable)parent.htPathPoints).clone();
            }
            this.bsPath = parent == null ? new BS() : BSUtil.copy(parent.bsPath);
            this.multipleBondDuplicate = isDuplicate;
            this.rootDistance = this.sphere;
            if (parent == null) {
                this.bsPath.set(this.atomIndex);
            } else if (!this.multipleBondDuplicate || (CIPChirality.this.rule1bOption != 4 || !this.isKekuleAmbiguous) && CIPChirality.this.rule1bOption != 2) {
                if (this.multipleBondDuplicate && CIPChirality.this.rule1bOption == 1) {
                    --this.rootDistance;
                } else if (atom == CIPChirality.this.root.atom) {
                    isDuplicate = true;
                    this.rootDistance = 0;
                    ++CIPChirality.this.root.nSpiro;
                    if (this.rootSubstituent.spiroEnd == null) {
                        this.rootSubstituent.spiroEnd = parent;
                    } else if (this.rootSubstituent.spiroEnd.sphere > parent.sphere) {
                        this.rootSubstituent.spiroEnd1 = this.rootSubstituent.spiroEnd;
                        this.rootSubstituent.spiroEnd = parent;
                    } else if (this.rootSubstituent.spiroEnd1 == null || this.rootSubstituent.spiroEnd1.sphere > parent.sphere) {
                        this.rootSubstituent.spiroEnd1 = parent;
                    }
                } else if (this.bsPath.get(this.atomIndex)) {
                    isDuplicate = true;
                    this.rootDistance = isParentBond ? parent.sphere : this.htPathPoints.get(this.atomIndex);
                } else {
                    this.bsPath.set(this.atomIndex);
                    this.htPathPoints.put(this.atomIndex, this.rootDistance);
                }
            }
            this.isDuplicate = isDuplicate;
            if (Logger.debuggingHigh) {
                if (this.sphere < 50) {
                    this.myPath = (parent != null ? parent.myPath + "-" : "") + this;
                }
                Logger.info("new CIPAtom " + this.myPath);
            }
            return this;
        }

        private float getMass() {
            if (this.mass == -1.0f && (this.mass = this.atom.getMass()) == (float)((int)this.mass)) {
                CIPChirality.this.haveIsotopes = true;
                if (this.isType(CIPChirality.RULE_2_nXX_REV_XX)) {
                    this.reverseRule2 = true;
                } else if (this.elemNo > 92.0f || this.isType(CIPChirality.RULE_2_nXX_EQ_XX)) {
                    this.mass = Elements.getAtomicMass((int)this.elemNo);
                }
            }
            return this.mass;
        }

        private boolean isType(String rule2Type) {
            return PT.isOneOf((int)this.mass + Elements.elementSymbolFromNumber((int)this.elemNo), rule2Type);
        }

        private float getKekuleElementNumber() {
            SimpleEdge[] edges = this.atom.getEdges();
            float ave = 0.0f;
            int n = 0;
            int i = edges.length;
            while (--i >= 0) {
                SimpleNode other;
                SimpleEdge bond = edges[i];
                if (!bond.isCovalent() || !CIPChirality.this.bsKekuleAmbiguous.get((other = bond.getOtherNode(this.atom)).getIndex())) continue;
                ++n;
                ave += (float)other.getElementNumber();
            }
            return ave / (float)n;
        }

        void updateRingList() {
            BS bsRing = BSUtil.newAndSetBit(this.atomIndex);
            CIPAtom p = this;
            int index = -1;
            while ((p = p.parent) != null && index != this.atomIndex) {
                index = p.atomIndex;
                bsRing.set(index);
            }
            if (bsRing.cardinality() <= 7) {
                int i = CIPChirality.this.lstSmallRings.size();
                while (--i >= 0) {
                    if (!((BS)CIPChirality.this.lstSmallRings.get(i)).equals(bsRing)) continue;
                    return;
                }
                CIPChirality.this.lstSmallRings.addLast(bsRing);
            }
        }

        boolean setNode() {
            block19: {
                block18: {
                    if (this.isSet) break block18;
                    this.isSet = true;
                    if (!true || !this.isDuplicate) break block19;
                }
                return true;
            }
            SimpleEdge[] bonds = this.atom.getEdges();
            int nBonds = bonds.length;
            if (Logger.debuggingHigh) {
                Logger.info("set " + this);
            }
            int pt = 0;
            block5: for (int i = 0; i < nBonds; ++i) {
                SimpleEdge bond = bonds[i];
                if (!bond.isCovalent()) continue;
                SimpleNode other = bond.getOtherNode(this.atom);
                boolean isParentBond = this.parent != null && this.parent.atom == other;
                int order = bond.getCovalentOrder();
                if (order == 2) {
                    if (this.elemNo > 10.0f || !CIPChirality.this.isFirstRow(other)) {
                        order = 1;
                    } else {
                        this.isAlkene = true;
                        if (isParentBond) {
                            this.setEne();
                        }
                    }
                }
                if (nBonds == 1 && order == 1 && isParentBond) {
                    this.isTerminal = true;
                    return true;
                }
                switch (order) {
                    case 3: {
                        if (this.addAtom(pt++, other, isParentBond, false, isParentBond) == null) {
                            this.isTerminal = true;
                            return !true;
                        }
                    }
                    case 2: {
                        if (this.addAtom(pt++, other, order != 2 || isParentBond, order == 2, isParentBond) == null) {
                            this.isTerminal = true;
                            return !true;
                        }
                    }
                    case 1: {
                        if (isParentBond || this.addAtom(pt++, other, order != 1 && this.elemNo <= 10.0f, false, false) != null) continue block5;
                    }
                    default: {
                        this.isTerminal = true;
                        return !true;
                    }
                }
            }
            this.nAtoms = pt;
            while (pt < this.atoms.length) {
                this.atoms[pt] = new CIPAtom().create(null, this, false, true, false);
                ++pt;
            }
            Arrays.sort(this.atoms);
            return true;
        }

        private void setEne() {
            this.parent.alkeneChild = null;
            this.alkeneParent = this.parent.alkeneParent == null ? this.parent : this.parent.alkeneParent;
            this.alkeneParent.alkeneChild = this;
            this.nextSP2 = this.parent;
            if (this.parent.alkeneParent == null) {
                this.parent.nextSP2 = this;
            }
            if (this.atom.getCovalentBondCount() == 2 && this.atom.getValence() == 4) {
                this.parent.isAlkeneAtom2 = false;
                this.alkeneParent.isEvenEne = !this.alkeneParent.isEvenEne;
            } else {
                this.isAlkeneAtom2 = true;
            }
        }

        CIPAtom addAtom(int i, SimpleNode other, boolean isDuplicate, boolean isAlkene, boolean isParentBond) {
            if (i >= this.atoms.length) {
                if (Logger.debugging) {
                    Logger.info(" too many bonds on " + this.atom);
                }
                return null;
            }
            if (this.parent == null && other.getIsotopeNumber() == 1 && ++this.h1Count > 1) {
                if (Logger.debuggingHigh) {
                    Logger.info(" second H atom found on " + this.atom);
                }
                return null;
            }
            this.atoms[i] = new CIPAtom().create(other, this, isAlkene, isDuplicate, isParentBond);
            return this.atoms[i];
        }

        boolean sortSubstituents(int sphere) {
            int i;
            int i2;
            boolean ignoreTies;
            if (this.nPriorities == (sphere == 0 ? 4 : 3)) {
                return true;
            }
            boolean bl = ignoreTies = sphere == Integer.MIN_VALUE;
            if (ignoreTies) {
                if (this.isTerminal) {
                    return false;
                }
                for (int i3 = 0; i3 < 4; ++i3) {
                    if (this.rule4List[i3] == null || this.atoms[i3].atom == null || this.atoms[i3].isTerminal) continue;
                    this.atoms[i3].sortSubstituents(Integer.MIN_VALUE);
                }
                if (!this.canBePseudo) {
                    return false;
                }
            }
            int[] indices = new int[4];
            int[] prevPrior = new int[4];
            int nPrioritiesPrev = this.nPriorities;
            for (i2 = 0; i2 < 4; ++i2) {
                prevPrior[i2] = this.priorities[i2];
                this.priorities[i2] = 0;
            }
            if (Logger.debuggingHigh) {
                Logger.info(CIPChirality.this.root + "---sortSubstituents---" + this);
                for (i2 = 0; i2 < 4; ++i2) {
                    Logger.info(CIPChirality.this.getRuleName() + ": " + this + "[" + i2 + "]=" + this.atoms[i2].myPath + " " + Integer.toHexString(prevPrior[i2]));
                }
                Logger.info("---");
            }
            for (int i4 = 0; i4 < 4; ++i4) {
                CIPAtom a = this.atoms[i4];
                for (int j = i4 + 1; j < 4; ++j) {
                    int score;
                    int loser = j;
                    CIPAtom b = this.atoms[loser];
                    switch (a.atom == null ? 1 : (b.atom == null ? -1 : (prevPrior[i4] < prevPrior[j] ? -1 : (prevPrior[j] < prevPrior[i4] ? 1 : ((score = this.checkPriority(a, b, i4, j)) != 0 ? score : (ignoreTies ? Integer.MIN_VALUE : this.sign(a.breakTie(b, sphere + 1)))))))) {
                        case 1: {
                            loser = i4;
                        }
                        case -1: {
                            int n = loser;
                            this.priorities[n] = this.priorities[n] + 1;
                            break;
                        }
                    }
                    int n = loser;
                    indices[n] = indices[n] + 1;
                }
            }
            CIPAtom[] newAtoms = new CIPAtom[4];
            int[] newPriorities = new int[4];
            String[] newRule4List = this.rule4List == null ? null : new String[4];
            this.bsTemp.clearAll();
            for (i = 0; i < 4; ++i) {
                int pt = indices[i];
                CIPAtom a = newAtoms[pt] = this.atoms[i];
                newPriorities[pt] = this.priorities[i];
                if (this.rule4List != null) {
                    newRule4List[pt] = this.rule4List[i];
                }
                if (a.atom == null) continue;
                this.bsTemp.set(this.priorities[i]);
            }
            this.atoms = newAtoms;
            this.priorities = newPriorities;
            this.rule4List = newRule4List;
            this.nPriorities = this.bsTemp.cardinality();
            if (this.parent == null) {
                int nprev;
                if (this.nSpiro > 0 && (nprev = this.checkSpiro()) == 2) {
                    nPrioritiesPrev = 2;
                }
                if (CIPChirality.this.currentRule == 9 && this.nPriorities == 4 && nPrioritiesPrev == 2) {
                    this.canBePseudo = false;
                }
            }
            if (Logger.debuggingHigh && this.atoms[2].atom != null && this.atoms[2].elemNo != 1.0f) {
                Logger.info(this.dots() + this.atom + " nPriorities = " + this.nPriorities);
                for (i = 0; i < 4; ++i) {
                    Logger.info(this.dots() + this.myPath + "[" + i + "]=" + this.atoms[i] + " " + this.priorities[i] + " " + Integer.toHexString(this.priorities[i]));
                }
                Logger.info(this.dots() + "-------");
            }
            return this.nPriorities == this.bondCount;
        }

        private int checkSpiro() {
            if (this.nSpiro >= 42) {
                return -1;
            }
            boolean swap23 = false;
            int nPrev = 0;
            if (this.nPriorities == 1) {
                int a3;
                int a2;
                if (this.getSpiroType(0, false) >= 0 && (a2 = this.getSpiroType(0, true)) >= 0 && this.getSpiroType(1, false) >= 0 && (a3 = this.getSpiroType(1, true)) >= 0 && this.getSpiroType(2, false) >= 0 && this.getSpiroType(2, true) >= 0 && this.getSpiroType(3, false) >= 0 && this.getSpiroType(3, true) >= 0) {
                    this.nPriorities = 4;
                    swap23 = a2 < a3;
                }
            } else if (this.nPriorities == 2) {
                swap23 = false;
                switch (this.priorities[3]) {
                    case 1: 
                    case 3: {
                        int first = this.priorities[3] == 1 ? 1 : 0;
                        int a1 = this.getSpiroType(first, false);
                        if (a1 < 0) break;
                        int a2 = this.getSpiroType(a1, false);
                        int a3 = this.getSpiroType(a2, false);
                        if (a1 == a2 || a2 == a3 || a3 == a1) break;
                        this.nPriorities = 4;
                        swap23 = a2 > a1;
                        break;
                    }
                    case 2: {
                        int end1;
                        int end0 = this.getSpiroType(0, false);
                        if (end0 < 2 || (end1 = this.getSpiroType(1, false)) < 2 || end0 == end1) break;
                        nPrev = 2;
                        this.nPriorities = 4;
                        boolean bl = swap23 = end1 == 2;
                    }
                }
            }
            if (swap23) {
                CIPAtom a = this.atoms[2];
                this.atoms[2] = this.atoms[3];
                this.atoms[3] = a;
            }
            return nPrev;
        }

        private int getSpiroType(int i0, boolean checkEnd1) {
            CIPAtom a;
            CIPAtom cIPAtom = i0 < 0 ? null : (a = checkEnd1 ? this.atoms[i0].spiroEnd1 : this.atoms[i0].spiroEnd);
            if (a != null) {
                for (int i = 0; i < 4; ++i) {
                    if (i == i0 || a.atom != this.atoms[i].atom) continue;
                    return i;
                }
            }
            return -1;
        }

        private String dots() {
            return ".....................".substring(0, Math.min(20, this.sphere));
        }

        private int breakTie(CIPAtom b, int sphere) {
            if (this.isDuplicate && b.isDuplicate && this.atom == b.atom && this.rootDistance == b.rootDistance) {
                return 0;
            }
            int score = this.checkIsDuplicate(b);
            if (score != 0) {
                return score * (sphere + 1);
            }
            if (!this.setNode() || !b.setNode() || this.isTerminal && b.isTerminal || this.isDuplicate && b.isDuplicate) {
                return 0;
            }
            if (this.isTerminal != b.isTerminal) {
                return (this.isTerminal ? 1 : -1) * (sphere + 1);
            }
            score = this.compareShallowly(b, sphere);
            if (score != 0) {
                return score;
            }
            this.sortSubstituents(sphere);
            b.sortSubstituents(sphere);
            int finalScore = this.nAtoms == 0 ? 1 : 0;
            int absScore = Integer.MAX_VALUE;
            for (int i = 0; i < this.nAtoms; ++i) {
                int abs;
                CIPAtom ai = this.atoms[i];
                CIPAtom bi = b.atoms[i];
                score = ai.breakTie(bi, sphere + 1);
                if (score == 0 || (abs = Math.abs(score)) >= absScore) continue;
                absScore = abs;
                finalScore = score;
            }
            return finalScore;
        }

        private int compareShallowly(CIPAtom b, int sphere) {
            for (int i = 0; i < this.nAtoms; ++i) {
                CIPAtom ai = this.atoms[i];
                CIPAtom bi = b.atoms[i];
                int score = ai.checkCurrentRule(bi);
                if (score == Integer.MIN_VALUE || score == 0) continue;
                return score * (sphere + 1);
            }
            return 0;
        }

        @Override
        public int compareTo(CIPAtom b) {
            int score;
            int n = b == null ? -1 : (this.atom == null != (b.atom == null) ? (this.atom == null ? 1 : -1) : ((score = this.checkRule1a(b)) != 0 ? score : ((score = this.checkIsDuplicate(b)) != 0 ? score : (this.isDuplicate && (score = this.checkRule1b(b)) != 0 ? score : this.checkRule2(b)))));
            return n;
        }

        private int checkPriority(CIPAtom a, CIPAtom b, int i, int j) {
            int score;
            switch (CIPChirality.this.currentRule) {
                case 7: 
                case 9: {
                    return this.rule4List[i] == null && this.rule4List[j] == null ? Integer.MIN_VALUE : (this.rule4List[j] == null ? -1 : (this.rule4List[i] == null ? 1 : this.compareMataPair(a, b)));
                }
            }
            int n = a.atom == null != (b.atom == null) ? (a.atom == null ? 1 : -1) : ((score = a.checkCurrentRule(b)) == Integer.MIN_VALUE ? 0 : score);
            return n;
        }

        private int checkIsDuplicate(CIPAtom b) {
            return b.isDuplicate == this.isDuplicate ? 0 : (b.isDuplicate ? -1 : 1);
        }

        private int sortToRule(int maxRule) {
            for (int i = 1; i <= maxRule; ++i) {
                if (!this.sortByRule(i)) continue;
                return i;
            }
            return 0;
        }

        private boolean sortByRule(int rule) {
            if ((rule == 7 || rule == 6) && rule == 6 != CIPChirality.this.isRule4TEST) {
                return false;
            }
            int current = CIPChirality.this.currentRule;
            CIPChirality.this.currentRule = rule;
            boolean isChiral = this.sortSubstituents(0);
            CIPChirality.this.currentRule = current;
            return isChiral;
        }

        public int checkCurrentRule(CIPAtom b) {
            switch (CIPChirality.this.currentRule) {
                default: {
                    return this.checkRule1a(b);
                }
                case 2: {
                    return this.checkRule1b(b);
                }
                case 3: {
                    return this.checkRule2(b);
                }
                case 4: {
                    return this.checkRule3(b);
                }
                case 5: {
                    return this.checkRules4ac(b, " sr SR PM");
                }
                case 8: {
                    return this.checkRules4ac(b, " s r p m");
                }
                case 6: {
                    return this.checkRule4Test(b);
                }
                case 7: 
                case 9: 
            }
            return 0;
        }

        private int checkRule4Test(CIPAtom b) {
            boolean isNS;
            boolean bl = isNS = this.auxChirality == '~';
            if (this.rootSubstituent.atomIndex == b.rootSubstituent.atomIndex) {
                if (isNS || b.auxChirality == '~') {
                    return !isNS ? -1 : (b.auxChirality != '~' ? 1 : 0);
                }
                return this.auxChirality == b.auxChirality ? 0 : (this.auxChirality == this.rootSubstituent.rule4Ref ? -1 : 1);
            }
            return isNS ? 0 : (this.auxChirality == b.auxChirality == this.rootSubstituent.rule4checkIdentical ? 0 : (this.auxChirality == this.rootSubstituent.rule4Ref ? -1 : 1));
        }

        private int checkRule1a(CIPAtom b) {
            return b.atom == null ? -1 : (this.atom == null ? 1 : (b.elemNo < this.elemNo ? -1 : (b.elemNo > this.elemNo ? 1 : 0)));
        }

        private int checkRule1b(CIPAtom b) {
            return b.isDuplicate != this.isDuplicate ? 0 : (CIPChirality.this.rule1bOption == 3 && (this.parent.isAlkene || b.parent.isAlkene) ? 0 : (b.rootDistance != this.rootDistance ? (b.rootDistance > this.rootDistance ? -1 : 1) : 0));
        }

        private int checkRule2(CIPAtom b) {
            System.out.println(this.getMass() + " vs " + b.getMass() + " " + (b.getMass() == this.getMass() ? 0 : ((this.reverseRule2 || b.reverseRule2) == b.mass > this.mass ? -1 : 1)));
            return b.getMass() == this.getMass() ? 0 : ((this.reverseRule2 || b.reverseRule2) == b.mass > this.mass ? -1 : 1);
        }

        private int checkRule3(CIPAtom b) {
            int zb;
            int za;
            return this.isDuplicate || b.isDuplicate || !this.parent.isAlkeneAtom2 || !b.parent.isAlkeneAtom2 || !this.parent.alkeneParent.isEvenEne || !b.parent.alkeneParent.isEvenEne ? Integer.MIN_VALUE : (this.parent == b.parent ? this.sign(this.breakTie(b, 0)) : ((za = this.parent.getRule3auxEZ()) < (zb = b.parent.getRule3auxEZ()) ? -1 : (za > zb ? 1 : 0)));
        }

        private int getRule3auxEZ() {
            this.alkeneParent.auxEZ = this.auxEZ != -1 ? this.auxEZ : ((this.auxEZ = this.getAuxEneWinnerChirality(this.alkeneParent, this, false, 4)) == 0 ? (this.auxEZ = 7) : this.auxEZ);
            return this.alkeneParent.auxEZ;
        }

        private int getAuxEneWinnerChirality(CIPAtom end1, CIPAtom end2, boolean isAxial, int maxRule) {
            CIPAtom winner1 = this.getAuxEneEndWinner(end1, end1.nextSP2, maxRule);
            CIPAtom winner2 = winner1 == null || winner1.atom == null ? null : this.getAuxEneEndWinner(end2, end2.nextSP2, maxRule);
            return CIPChirality.this.getEneChirality(winner1, end1, end2, winner2, isAxial, false);
        }

        private CIPAtom getAuxEneEndWinner(CIPAtom end, CIPAtom prevSP2, int maxRule) {
            CIPAtom atom1 = (CIPAtom)end.clone();
            if (atom1.parent != prevSP2) {
                atom1.addReturnPath(prevSP2, end);
            } else if (maxRule == 9) {
                atom1.rule4List = end.rule4List;
            }
            for (int i = 1; i <= maxRule; ++i) {
                CIPAtom a = atom1.getTopSorted(i);
                if (a == null) continue;
                return a.atom == null ? null : a;
            }
            return null;
        }

        private CIPAtom getTopSorted(int rule) {
            if (this.sortByRule(rule)) {
                for (int i = 0; i < 4; ++i) {
                    CIPAtom a = this.atoms[i];
                    if (a.multipleBondDuplicate) continue;
                    return this.priorities[i] == this.priorities[i + 1] ? null : this.atoms[i];
                }
            }
            return null;
        }

        private void addReturnPath(CIPAtom newParent, CIPAtom fromAtom) {
            Lst<CIPAtom> path = new Lst<CIPAtom>();
            CIPAtom thisAtom = this;
            CIPAtom oldParent = fromAtom;
            CIPAtom oldSub = newParent;
            while (oldParent.parent != null && oldParent.parent.atoms[0] != null) {
                if (Logger.debuggingHigh) {
                    Logger.info("path:" + oldParent.parent + "->" + oldParent);
                }
                oldParent = oldParent.parent;
                path.addLast(oldParent);
            }
            path.addLast(null);
            int n = path.size();
            for (int i = 0; i < n; ++i) {
                oldParent = (CIPAtom)path.get(i);
                CIPAtom newSub = oldParent == null ? new CIPAtom().create(null, this, this.isAlkene, true, false) : (CIPAtom)oldParent.clone();
                newSub.sphere = thisAtom.sphere + 1;
                thisAtom.replaceParentSubstituent(oldSub, newParent, newSub);
                if (i > 0 && thisAtom.isAlkene && !thisAtom.isAlkeneAtom2) {
                    if (newParent.isAlkeneAtom2) {
                        newParent.isAlkeneAtom2 = false;
                        thisAtom.alkeneParent = newParent;
                    }
                    thisAtom.setEne();
                }
                newParent = thisAtom;
                thisAtom = newSub;
                oldSub = fromAtom;
                fromAtom = oldParent;
            }
        }

        private void replaceParentSubstituent(CIPAtom oldSub, CIPAtom newParent, CIPAtom newSub) {
            for (int i = 0; i < 4; ++i) {
                if (this.atoms[i] != oldSub && (newParent != null || this.atoms[i].atom != null)) continue;
                if (Logger.debuggingHigh) {
                    Logger.info("reversed: " + newParent + "->" + this + "->" + newSub);
                }
                this.parent = newParent;
                this.atoms[i] = newSub;
                Arrays.sort(this.atoms);
                break;
            }
        }

        private int compareMataPair(CIPAtom a, CIPAtom b) {
            boolean haveRSOptions;
            a.generateRule4Paths(this);
            b.generateRule4Paths(this);
            boolean isRule5 = CIPChirality.this.currentRule == 9;
            char aref = isRule5 ? (char)'R' : (char)a.getRule4ReferenceDescriptor();
            char bref = isRule5 ? (char)'R' : (char)b.getRule4ReferenceDescriptor();
            boolean bl = haveRSOptions = aref == '?';
            if (Logger.debugging) {
                Logger.info("reference descriptors are " + aref + " and " + bref);
            }
            int score = 0;
            String reason = "Rule 4b";
            if (aref == '?' != (bref == '?')) {
                score = haveRSOptions ? 1 : -1;
                reason = reason + " RS on only one side";
            } else {
                String bStr2;
                String aStr = haveRSOptions ? a.flattenRule4Paths('R') : a.flattenRule4Paths(aref);
                String aStr2 = haveRSOptions ? a.flattenRule4Paths('S') : "";
                String bStr = haveRSOptions ? b.flattenRule4Paths('R') : b.flattenRule4Paths(bref);
                String string = bStr2 = haveRSOptions ? b.flattenRule4Paths('S') : "";
                if (isRule5) {
                    score = this.sign(haveRSOptions ? (aStr + aStr2).compareTo(bStr + bStr2) : aStr.compareTo(bStr));
                    reason = "Rule 5";
                } else {
                    aStr = this.cleanRule4Str(aStr);
                    bStr = this.cleanRule4Str(bStr);
                    if (haveRSOptions) {
                        if (this.compareRule4PairStr(aStr, aStr2 = this.cleanRule4Str(aStr2), true) > 0) {
                            aStr = aStr2;
                        }
                        if (this.compareRule4PairStr(bStr, bStr2 = this.cleanRule4Str(bStr2), true) > 0) {
                            bStr = bStr2;
                        }
                    }
                    score = this.compareRule4PairStr(aStr, bStr, false);
                }
            }
            if (Logger.debugging && (score == -1 || score == 1)) {
                Logger.info((score == -1 ? a : b) + " > " + (score == -1 ? b : a) + " by " + reason + "\n");
            }
            return score == 0 ? Integer.MIN_VALUE : score;
        }

        void generateRule4Paths(CIPAtom ignore) {
            this.getRule4PriorityPaths("", ignore.atom);
            this.rootRule4Paths = new Lst();
            this.appendRule4Paths(this, new String[3]);
            this.rule4Count = new Object[]{null, zero, zero, 10000};
            this.getRule4Counts(this.rule4Count);
            if (Logger.debugging) {
                Logger.info("Rule 4b paths for " + this + "=\n");
                for (int i = 0; i < this.rootRule4Paths.size(); ++i) {
                    String s = ((String[])this.rootRule4Paths.get(i))[0].toString();
                    int prefixLen = ((String[])this.rootRule4Paths.get(i))[1].length();
                    while (prefixString.length() < prefixLen) {
                        prefixString = prefixString + prefixString;
                    }
                    Logger.info(prefixString.substring(0, prefixLen) + s.substring(prefixLen) + " " + this.priorityPath);
                }
                Logger.info("");
            }
        }

        private void getRule4PriorityPaths(String path, SimpleNode ignore) {
            this.priorityPath = path + (this.priority + 1);
            for (int i = 0; i < 4; ++i) {
                if (this.rule4List[i] == null || this.atoms[i].atom == ignore) continue;
                this.atoms[i].getRule4PriorityPaths(this.priorityPath, null);
            }
        }

        private void getRule4Counts(Object[] counts) {
            if (this.sphere > (Integer)counts[3]) {
                return;
            }
            if (this.rule4Type > 0) {
                int val = this.sign(this.priorityPath.length() - (counts[0] == null ? 10000 : ((String)counts[0]).length()));
                if (val == 0) {
                    val = this.sign(this.priorityPath.compareTo(counts[0].toString()));
                }
                switch (val) {
                    case -1: {
                        counts[0] = this.priorityPath;
                        counts[1] = counts[2] = zero;
                        counts[3] = this.sphere;
                    }
                    case 0: {
                        counts[this.rule4Type] = (Integer)counts[this.rule4Type] + 1;
                    }
                }
                if (Logger.debugging) {
                    Logger.info(this + " addRule4Ref " + this.sphere + " " + this.priority + " " + this.rule4Type + " " + PT.toJSON("rule4Count", counts));
                }
            }
            for (int i = 0; i < 4; ++i) {
                if (this.rule4List[i] == null) continue;
                this.atoms[i].getRule4Counts(counts);
            }
        }

        private void appendRule4Paths(CIPAtom rootsub, String[] pathInfo) {
            String s0;
            String string = s0 = pathInfo[0] == null ? "" + this.auxChirality : pathInfo[0];
            if (pathInfo[2] == null) {
                pathInfo = new String[]{s0, "", this.priorityPath};
                rootsub.rootRule4Paths.addLast(pathInfo);
            }
            boolean isFirst = true;
            for (int i = 0; i < 4; ++i) {
                if (this.rule4List[i] == null) continue;
                if (isFirst) {
                    pathInfo[2] = this.priorityPath;
                } else {
                    pathInfo = new String[]{s0, s0, this.priorityPath};
                    rootsub.rootRule4Paths.addLast(pathInfo);
                }
                isFirst = false;
                pathInfo[0] = pathInfo[0] + this.rule4List[i];
                if (this.atoms[i].nextChiralBranch == null) continue;
                this.atoms[i].nextChiralBranch.appendRule4Paths(rootsub, pathInfo);
            }
        }

        private char getRule4ReferenceDescriptor() {
            int nS;
            if (this.rule4Count == null) {
                return this.auxChirality;
            }
            int nR = (Integer)this.rule4Count[1];
            return (char)(nR > (nS = ((Integer)this.rule4Count[2]).intValue()) ? 82 : (nR < nS ? 83 : 63));
        }

        private String flattenRule4Paths(char ref) {
            int i;
            int nPaths = this.rootRule4Paths.size();
            Object[] paths = new String[nPaths];
            int nMax = 0;
            for (i = 0; i < nPaths; ++i) {
                String path = ((String[])this.rootRule4Paths.get(i))[0];
                String priorityPath = ((String[])this.rootRule4Paths.get(i))[2];
                String s = PT.replaceAllCharacters(path, "srctmp", "~");
                s = priorityPath + s.replace(ref, 'A');
                paths[i] = s;
                if (s.length() <= nMax) continue;
                nMax = s.length();
            }
            Arrays.sort(paths);
            for (i = 0; i < nPaths; ++i) {
                paths[i] = PT.replaceAllCharacters((String)paths[i], "1234", "").replace('A', ref);
                if (!Logger.debugging) continue;
                Logger.info("Flattened[" + i + "]=" + (String)paths[i]);
            }
            SB sb = new SB();
            for (int i2 = 0; i2 < nMax; ++i2) {
                for (int k = 0; k < nPaths; ++k) {
                    Object s = paths[k];
                    sb.append(i2 < ((String)s).length() ? ((String)s).substring(i2, i2 + 1) : "~");
                }
            }
            return sb.toString();
        }

        private String cleanRule4Str(String aStr) {
            return aStr.length() > 1 ? PT.replaceAllCharacters(aStr, "rsmpct~", "") : aStr;
        }

        private int compareRule4PairStr(String aStr, String bStr, boolean isRSTest) {
            int n;
            if (Logger.debugging) {
                Logger.info(this.dots() + this.myPath + " Rule 4b comparing " + aStr + " " + bStr);
            }
            if ((n = aStr.length()) == 0 || n != bStr.length()) {
                return 0;
            }
            char aref = aStr.charAt(0);
            char bref = bStr.charAt(0);
            for (int c = 1; c < n; ++c) {
                boolean alike = aref == aStr.charAt(c);
                if (alike == (bref == bStr.charAt(c))) continue;
                return (isRSTest ? c : 1) * (alike ? -1 : 1);
            }
            return isRSTest ? 0 : Integer.MIN_VALUE;
        }

        String createRule4AuxiliaryData(CIPAtom node1, CIPAtom[] ret) {
            String retThread = "";
            int c = 126;
            if (this.atom == null) {
                return "" + (char)c;
            }
            this.rule4List = new String[4];
            if (this.nPriorities == 0 && !this.isSet) {
                this.setNode();
                if (!(this.isAlkene || this.isDuplicate || this.isTerminal)) {
                    this.sortToRule(4);
                }
            }
            int rs = -1;
            int nRS = 0;
            CIPAtom[] ret1 = new CIPAtom[1];
            int ruleMax = 9;
            boolean prevIsChiral = true;
            for (int i = 0; i < 4; ++i) {
                CIPAtom a = this.atoms[i];
                if (a == null || a.isDuplicate || a.isTerminal) continue;
                a.priority = this.priorities[i];
                ret1[0] = null;
                String rsPath = a.createRule4AuxiliaryData(node1 == null ? a : node1, ret1);
                if (ret1[0] != null) {
                    a.nextChiralBranch = ret1[0];
                    if (ret != null) {
                        ret[0] = ret1[0];
                    }
                }
                this.rule4List[i] = rsPath;
                if (a.nextChiralBranch != null || rsPath.indexOf("R") >= 0 || rsPath.indexOf("S") >= 0 || rsPath.indexOf("r") >= 0 || rsPath.indexOf("s") >= 0) {
                    ++nRS;
                    retThread = rsPath;
                    prevIsChiral = true;
                    continue;
                }
                if (!prevIsChiral && this.priorities[i] == this.priorities[i - 1]) {
                    return "~";
                }
                prevIsChiral = false;
            }
            boolean isBranch = nRS >= 2;
            switch (nRS) {
                case 0: {
                    retThread = "";
                }
                case 1: {
                    ruleMax = 4;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    c = 126;
                    retThread = "";
                    if (ret == null) break;
                    ret[0] = this;
                }
            }
            if (this.isAlkene) {
                if (!isBranch && this.alkeneChild != null) {
                    boolean isSeqCT;
                    boolean bl = isSeqCT = ret != null && ret[0] == this.alkeneChild;
                    if (!this.isEvenEne || (this.auxEZ == 7 || this.auxEZ == -1) && this.alkeneChild.bondCount >= 2 && !this.isKekuleAmbiguous) {
                        rs = this.getAuxEneWinnerChirality(this, this.alkeneChild, !this.isEvenEne, 9);
                        switch (rs) {
                            case 5: 
                            case 17: {
                                rs = 1;
                                c = 82;
                                break;
                            }
                            case 6: 
                            case 18: {
                                rs = 2;
                                c = 83;
                            }
                        }
                        if (rs != 0) {
                            this.auxChirality = (char)c;
                            this.rule4Type = rs;
                            retThread = "";
                            if (isSeqCT) {
                                this.nextChiralBranch = this.alkeneChild;
                                ret[0] = this;
                            }
                        }
                    }
                }
            } else if (this.canBePseudo) {
                CIPAtom atom1 = (CIPAtom)this.clone();
                if (atom1.setNode()) {
                    atom1.addReturnPath(null, this);
                    atom1.rule4List = new String[4];
                    block10: for (int i = 0; i < 4; ++i) {
                        for (int j = 0; j < 4; ++j) {
                            if (atom1.atoms[i] != this.atoms[j]) continue;
                            atom1.rule4List[i] = this.rule4List[j];
                            continue block10;
                        }
                    }
                    int rule = atom1.sortToRule(ruleMax);
                    if (rule == 0) {
                        c = 126;
                    } else {
                        rs = atom1.checkHandedness();
                        int n = rs == 1 ? 82 : (c = rs == 2 ? 83 : 126);
                        if (rule == 9) {
                            c = c == 82 ? 114 : (c == 83 ? 115 : 126);
                        } else {
                            this.rule4Type = rs;
                        }
                    }
                }
                this.auxChirality = c;
            }
            if (CIPChirality.this.setAuxiliary && this.auxChirality != '~') {
                this.atom.setCIPChirality(JC.getCIPChiralityCode(this.auxChirality));
            }
            if (node1 == null) {
                this.rule4Type = nRS;
            }
            retThread = (char)c + retThread;
            if (Logger.debugging && !retThread.equals("~")) {
                Logger.info("creating aux " + (char)c + " for " + this + " = " + this.myPath);
            }
            return retThread;
        }

        private int checkRules4ac(CIPAtom b, String test) {
            int isRb;
            if (this.isTerminal || this.isDuplicate) {
                return 0;
            }
            int isRa = test.indexOf(this.auxChirality);
            return isRa > (isRb = test.indexOf(b.auxChirality)) + 1 ? -1 : (isRb > isRa + 1 ? 1 : 0);
        }

        int checkHandedness() {
            P3 p1 = this.atoms[0].atom.getXYZ();
            P3 p2 = this.atoms[1].atom.getXYZ();
            P3 p3 = this.atoms[2].atom.getXYZ();
            Measure.getNormalThroughPoints(p1, p2, p3, CIPChirality.this.vNorm, CIPChirality.this.vTemp);
            CIPChirality.this.vTemp.setT((this.atoms[3].atom == null ? this.atom : this.atoms[3].atom).getXYZ());
            CIPChirality.this.vTemp.sub(p1);
            return CIPChirality.this.vTemp.dot(CIPChirality.this.vNorm) > 0.0f ? 1 : 2;
        }

        public int sign(int score) {
            return score < 0 ? -1 : (score > 0 ? 1 : 0);
        }

        void addSmallRings(BS bs) {
            if (this.atom == null || this.sphere > 7) {
                return;
            }
            if (bs != null) {
                bs.clear(this.atom.getIndex());
            }
            if (this.isTerminal || this.isDuplicate || this.atom.getCovalentBondCount() > 4) {
                return;
            }
            int pt = 0;
            SimpleEdge[] bonds = this.atom.getEdges();
            int i = bonds.length;
            while (--i >= 0) {
                SimpleNode atom2;
                SimpleEdge bond = bonds[i];
                if (!bond.isCovalent() || (atom2 = bond.getOtherNode(this.atom)).getCovalentBondCount() == 1 || this.parent != null && atom2 == this.parent.atom) continue;
                CIPAtom r = this.addAtom(pt++, atom2, false, false, false);
                if (!r.isDuplicate) continue;
                r.updateRingList();
            }
            for (i = 0; i < pt; ++i) {
                if (this.atoms[i] == null) continue;
                this.atoms[i].addSmallRings(bs);
            }
        }

        public Object clone() {
            CIPAtom a = null;
            try {
                a = (CIPAtom)super.clone();
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
            a.id = CIPChirality.this.ptID++;
            a.atoms = new CIPAtom[4];
            a.priorities = new int[4];
            a.htPathPoints = this.htPathPoints;
            a.alkeneParent = null;
            a.rule4Count = null;
            a.rule4List = null;
            a.rootRule4Paths = null;
            a.priority = 0;
            for (int i = 0; i < 4; ++i) {
                if (this.atoms[i] == null) continue;
                a.atoms[i] = this.atoms[i];
            }
            return a;
        }

        public String toString() {
            return this.atom == null ? "<null>" : "[" + CIPChirality.this.currentRule + "." + this.sphere + "." + this.priority + "," + this.id + "." + this.atom.getAtomName() + (this.isDuplicate ? "*(" + this.rootDistance + ")" : "") + (this.auxChirality == '~' ? "" : "" + this.auxChirality) + "]";
        }
    }
}

