/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.proj;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.proj.AbstractProj;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Utils;

public class SwissObliqueMercator
extends AbstractProj {
    private Ellipsoid ellps;
    private double kR;
    private double alpha;
    private double b0;
    private double k;
    private double phi0;
    private static final double EPSILON = 1.0E-11;

    @Override
    public void initialize(ProjParameters projParameters) throws ProjectionConfigurationException {
        super.initialize(projParameters);
        if (projParameters.lat0 == null) {
            throw new ProjectionConfigurationException(I18n.tr("Parameter ''{0}'' required.", "lat_0"));
        }
        this.ellps = projParameters.ellps;
        this.initialize(projParameters.lat0);
    }

    private void initialize(double d) {
        this.phi0 = Utils.toRadians(d);
        this.kR = Math.sqrt(1.0 - this.ellps.e2) / (1.0 - this.ellps.e2 * Math.pow(Math.sin(this.phi0), 2.0));
        this.alpha = Math.sqrt(1.0 + this.ellps.eb2 * Math.pow(Math.cos(this.phi0), 4.0));
        this.b0 = Math.asin(Math.sin(this.phi0) / this.alpha);
        this.k = Math.log(Math.tan(0.7853981633974483 + this.b0 / 2.0)) - this.alpha * Math.log(Math.tan(0.7853981633974483 + this.phi0 / 2.0)) + this.alpha * this.ellps.e / 2.0 * Math.log((1.0 + this.ellps.e * Math.sin(this.phi0)) / (1.0 - this.ellps.e * Math.sin(this.phi0)));
    }

    @Override
    public String getName() {
        return I18n.tr("Swiss Oblique Mercator", new Object[0]);
    }

    @Override
    public String getProj4Id() {
        return "somerc";
    }

    @Override
    public double[] project(double d, double d2) {
        double d3 = this.alpha * Math.log(Math.tan(0.7853981633974483 + d / 2.0)) - this.alpha * this.ellps.e / 2.0 * Math.log((1.0 + this.ellps.e * Math.sin(d)) / (1.0 - this.ellps.e * Math.sin(d))) + this.k;
        double d4 = 2.0 * (Math.atan(Math.exp(d3)) - 0.7853981633974483);
        double d5 = this.alpha * d2;
        double d6 = Math.atan2(Math.sin(d5), Math.sin(this.b0) * Math.tan(d4) + Math.cos(this.b0) * Math.cos(d5));
        double d7 = Math.asin(Math.cos(this.b0) * Math.sin(d4) - Math.sin(this.b0) * Math.cos(d4) * Math.cos(d5));
        double d8 = this.kR * d6;
        double d9 = this.kR / 2.0 * Math.log((1.0 + Math.sin(d7)) / (1.0 - Math.sin(d7)));
        return new double[]{d8, d9};
    }

    @Override
    public double[] invproject(double d, double d2) {
        double d3 = d / this.kR;
        double d4 = 2.0 * (Math.atan(Math.exp(d2 / this.kR)) - 0.7853981633974483);
        double d5 = Math.asin(Math.cos(this.b0) * Math.sin(d4) + Math.sin(this.b0) * Math.cos(d4) * Math.cos(d3));
        double d6 = Math.atan2(Math.sin(d3), Math.cos(this.b0) * Math.cos(d3) - Math.sin(this.b0) * Math.tan(d4));
        double d7 = d6 / this.alpha;
        double d8 = d5;
        double d9 = -1000.0;
        int n = 0;
        while (Math.abs(d8 - d9) > 1.0E-11) {
            if (++n > 30) {
                throw new JosmRuntimeException("Too many iterations");
            }
            d9 = d8;
            double d10 = 1.0 / this.alpha * (Math.log(Math.tan(0.7853981633974483 + d5 / 2.0)) - this.k) + this.ellps.e * Math.log(Math.tan(0.7853981633974483 + Math.asin(this.ellps.e * Math.sin(d8)) / 2.0));
            d8 = 2.0 * Math.atan(Math.exp(d10)) - 1.5707963267948966;
        }
        return new double[]{d8, d7};
    }

    @Override
    public Bounds getAlgorithmBounds() {
        if (this.phi0 > 0.0) {
            return new Bounds(-10.0, -40.0, 85.0, 40.0, false);
        }
        return new Bounds(-85.0, -40.0, 10.0, 40.0, false);
    }
}

