/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Stream;
import org.openstreetmap.josm.tools.Logging;

public class ProgramArguments {
    private final Map<Option, List<String>> argMap = new EnumMap<Option, List<String>>(Option.class);

    public ProgramArguments(String ... stringArray) {
        Stream.of(Option.values()).forEach(option -> {
            List cfr_ignored_0 = this.argMap.put((Option)((Object)option), new ArrayList());
        });
        this.buildCommandLineArgumentMap(stringArray);
    }

    private void buildCommandLineArgumentMap(String ... stringArray) {
        int n;
        LongOpt[] longOptArray = (LongOpt[])Stream.of(Option.values()).map(Option::toLongOpt).toArray(LongOpt[]::new);
        Getopt getopt = new Getopt("JOSM", stringArray, "hv", longOptArray);
        while ((n = getopt.getopt()) != -1) {
            Option option;
            switch (n) {
                case 104: {
                    option = Option.HELP;
                    break;
                }
                case 118: {
                    option = Option.VERSION;
                    break;
                }
                case 0: {
                    option = Option.values()[getopt.getLongind()];
                    break;
                }
                default: {
                    option = null;
                }
            }
            if (option != null) {
                this.addOption(option, getopt.getOptarg());
                continue;
            }
            throw new IllegalArgumentException("Invalid option: " + (char)n);
        }
        for (int i = getopt.getOptind(); i < stringArray.length; ++i) {
            this.addOption(Option.DOWNLOAD, stringArray[i]);
        }
    }

    private void addOption(Option option, String string) {
        this.argMap.get((Object)option).add(string);
    }

    public Optional<String> getSingle(Option option) {
        return this.get(option).stream().findFirst();
    }

    public Collection<String> get(Option option) {
        return Collections.unmodifiableList(this.argMap.get((Object)option));
    }

    public boolean hasOption(Option option) {
        return !this.get(option).isEmpty();
    }

    public boolean showVersion() {
        return this.hasOption(Option.VERSION);
    }

    public boolean showHelp() {
        return !this.get(Option.HELP).isEmpty();
    }

    public Level getLogLevel() {
        if (this.hasOption(Option.TRACE)) {
            return Logging.LEVEL_TRACE;
        }
        if (this.hasOption(Option.DEBUG)) {
            return Logging.LEVEL_DEBUG;
        }
        return Logging.LEVEL_INFO;
    }

    public Map<String, String> getPreferencesToSet() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.get(Option.SET).stream().map(string -> string.split("=", 2)).forEach(stringArray -> hashMap.put(stringArray[0], ProgramArguments.getValue(stringArray)));
        return hashMap;
    }

    private static String getValue(String ... stringArray) {
        if (stringArray.length < 2) {
            return "";
        }
        if ("null".equals(stringArray[1])) {
            return null;
        }
        return stringArray[1];
    }

    public static enum Option {
        HELP(false),
        VERSION(false),
        DEBUG(false),
        TRACE(false),
        LANGUAGE(true),
        RESET_PREFERENCES(false),
        LOAD_PREFERENCES(true),
        SET(true),
        GEOMETRY(true),
        NO_MAXIMIZE(false),
        MAXIMIZE(false),
        DOWNLOAD(true),
        DOWNLOADGPS(true),
        SELECTION(true),
        OFFLINE(true),
        SKIP_PLUGINS(false);

        private final String name = this.name().toLowerCase(Locale.ENGLISH).replace('_', '-');
        private final boolean requiresArg;

        private Option(boolean bl) {
            this.requiresArg = bl;
        }

        public String getName() {
            return this.name;
        }

        public boolean requiresArgument() {
            return this.requiresArg;
        }

        LongOpt toLongOpt() {
            return new LongOpt(this.getName(), this.requiresArgument() ? 1 : 0, null, 0);
        }
    }
}

