/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.view.tree;

import ch.softenvironment.view.BaseDialog;
import ch.softenvironment.view.tree.AutoScrollingTree;
import ch.softenvironment.view.tree.NavigationTreeCellRenderer;
import ch.softenvironment.view.tree.NavigationTreeModel;
import ch.softenvironment.view.tree.TreeNodeUtility;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultTreeSelectionModel;

public class TreeSelectionDialog
extends BaseDialog {
    private Object selectedPackage = null;
    private JPanel ivjBaseDialogContentPane = null;
    private JButton ivjBtnCancel = null;
    private JButton ivjBtnOk = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JScrollPane ivjScpTree = null;
    private JTree ivjTreTree = null;

    public TreeSelectionDialog(Frame owner, String title, TreeNodeUtility utility, boolean packagesOnly) {
        super(owner, true);
        this.initialize();
        if (title != null) {
            this.setTitle(title);
        }
        this.initializeTree(utility, packagesOnly);
        this.show();
    }

    public TreeSelectionDialog(Frame owner, boolean modal) {
        super(owner, modal);
        this.initialize();
    }

    private void connEtoC1(ActionEvent arg1) {
        try {
            this.okPressed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(ActionEvent arg1) {
        try {
            this.cancelPressed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private JPanel getBaseDialogContentPane() {
        if (this.ivjBaseDialogContentPane == null) {
            try {
                this.ivjBaseDialogContentPane = new JPanel();
                this.ivjBaseDialogContentPane.setName("BaseDialogContentPane");
                this.ivjBaseDialogContentPane.setLayout(new GridBagLayout());
                GridBagConstraints constraintsBtnOk = new GridBagConstraints();
                constraintsBtnOk.gridx = 1;
                constraintsBtnOk.gridy = 2;
                constraintsBtnOk.ipadx = 60;
                constraintsBtnOk.insets = new Insets(8, 87, 20, 4);
                this.getBaseDialogContentPane().add((Component)this.getBtnOk(), constraintsBtnOk);
                GridBagConstraints constraintsBtnCancel = new GridBagConstraints();
                constraintsBtnCancel.gridx = 2;
                constraintsBtnCancel.gridy = 2;
                constraintsBtnCancel.ipadx = 14;
                constraintsBtnCancel.insets = new Insets(8, 4, 20, 109);
                this.getBaseDialogContentPane().add((Component)this.getBtnCancel(), constraintsBtnCancel);
                GridBagConstraints constraintsScpTree = new GridBagConstraints();
                constraintsScpTree.gridx = 1;
                constraintsScpTree.gridy = 1;
                constraintsScpTree.gridwidth = 2;
                constraintsScpTree.fill = 1;
                constraintsScpTree.weightx = 1.0;
                constraintsScpTree.weighty = 1.0;
                constraintsScpTree.ipadx = 376;
                constraintsScpTree.ipady = 254;
                constraintsScpTree.insets = new Insets(12, 13, 7, 15);
                this.getBaseDialogContentPane().add((Component)this.getScpTree(), constraintsScpTree);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBaseDialogContentPane;
    }

    private JButton getBtnCancel() {
        if (this.ivjBtnCancel == null) {
            try {
                this.ivjBtnCancel = new JButton();
                this.ivjBtnCancel.setName("BtnCancel");
                this.ivjBtnCancel.setText("Abbrechen");
                this.ivjBtnCancel.setText(TreeSelectionDialog.getCancelString());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBtnCancel;
    }

    private JButton getBtnOk() {
        if (this.ivjBtnOk == null) {
            try {
                this.ivjBtnOk = new JButton();
                this.ivjBtnOk.setName("BtnOk");
                this.ivjBtnOk.setText("OK");
                this.ivjBtnOk.setText(TreeSelectionDialog.getOKString());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBtnOk;
    }

    private JScrollPane getScpTree() {
        if (this.ivjScpTree == null) {
            try {
                this.ivjScpTree = new JScrollPane();
                this.ivjScpTree.setName("ScpTree");
                this.getScpTree().setViewportView(this.getTreTree());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjScpTree;
    }

    public Object getSelectedObject() {
        return this.selectedPackage;
    }

    private JTree getTreTree() {
        if (this.ivjTreTree == null) {
            try {
                this.ivjTreTree = new AutoScrollingTree(0);
                this.ivjTreTree.setName("TreTree");
                this.ivjTreTree.setBounds(0, 0, 165, 148);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTreTree;
    }

    @Override
    protected void handleException(Throwable exception) {
        super.handleException(exception);
    }

    private void initConnections() throws Exception {
        this.getBtnOk().addActionListener(this.ivjEventHandler);
        this.getBtnCancel().addActionListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("PackageSelectionDialog");
            this.setDefaultCloseOperation(2);
            this.setSize(426, 348);
            this.setContentPane(this.getBaseDialogContentPane());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.setTitle("<PackageSelection>");
    }

    private void initializeTree(TreeNodeUtility utility, boolean packagesOnly) {
        this.getTreTree().setModel(new NavigationTreeModel(packagesOnly, utility));
        this.getTreTree().setCellRenderer(new NavigationTreeCellRenderer());
        this.getTreTree().setRowHeight(-1);
        this.getTreTree().setRootVisible(true);
        DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
        selectionModel.setSelectionMode(1);
        this.getTreTree().setSelectionModel(selectionModel);
        ToolTipManager.sharedInstance().registerComponent(this.getTreTree());
        this.getTreTree().putClientProperty("JTree.lineStyle", "Angled");
    }

    @Override
    protected boolean save() {
        if (this.getTreTree().getSelectionPath() == null) {
            this.cancelPressed();
            return false;
        }
        this.selectedPackage = this.getTreTree().getSelectionPath().getLastPathComponent();
        return super.save();
    }

    class IvjEventHandler
    implements ActionListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == TreeSelectionDialog.this.getBtnOk()) {
                TreeSelectionDialog.this.connEtoC1(e);
            }
            if (e.getSource() == TreeSelectionDialog.this.getBtnCancel()) {
                TreeSelectionDialog.this.connEtoC2(e);
            }
        }
    }
}

