/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.data;

import org.jfree.report.DataRow;
import org.jfree.report.DataSourceException;
import org.jfree.report.data.GlobalMasterRow;
import org.jfree.report.data.StaticDataRow;
import org.jfree.report.flow.ParameterMapping;

public class ImportedVariablesDataRow
extends StaticDataRow {
    private String[] outerNames;
    private String[] innerNames;

    public ImportedVariablesDataRow(GlobalMasterRow globalMasterRow) throws DataSourceException {
        DataRow dataRow = globalMasterRow.getGlobalView();
        int n = dataRow.getColumnCount();
        this.outerNames = new String[n];
        this.innerNames = this.outerNames;
        Object[] objectArray = new Object[this.outerNames.length];
        for (int i = 0; i < this.outerNames.length; ++i) {
            this.outerNames[i] = dataRow.getColumnName(i);
            objectArray[i] = dataRow.get(i);
        }
        this.setData(this.outerNames, objectArray);
    }

    public ImportedVariablesDataRow(GlobalMasterRow globalMasterRow, ParameterMapping[] parameterMappingArray) throws DataSourceException {
        this.outerNames = new String[parameterMappingArray.length];
        this.innerNames = new String[parameterMappingArray.length];
        Object[] objectArray = new Object[parameterMappingArray.length];
        DataRow dataRow = globalMasterRow.getGlobalView();
        for (int i = 0; i < parameterMappingArray.length; ++i) {
            ParameterMapping parameterMapping = parameterMappingArray[i];
            String string = parameterMapping.getAlias();
            objectArray[i] = dataRow.get(string);
            this.innerNames[i] = string;
            this.outerNames[i] = parameterMapping.getName();
        }
        this.setData(this.outerNames, objectArray);
    }

    protected ImportedVariablesDataRow(ImportedVariablesDataRow importedVariablesDataRow) {
        super(importedVariablesDataRow);
        this.outerNames = importedVariablesDataRow.outerNames;
        this.innerNames = importedVariablesDataRow.innerNames;
    }

    public ImportedVariablesDataRow advance(GlobalMasterRow globalMasterRow) throws DataSourceException {
        DataRow dataRow = globalMasterRow.getGlobalView();
        Object[] objectArray = new Object[this.outerNames.length];
        for (int i = 0; i < this.innerNames.length; ++i) {
            String string = this.innerNames[i];
            objectArray[i] = dataRow.get(string);
        }
        ImportedVariablesDataRow importedVariablesDataRow = new ImportedVariablesDataRow(this);
        importedVariablesDataRow.setData(this.outerNames, objectArray);
        return importedVariablesDataRow;
    }
}

