/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.misc.survey;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import org.jfree.report.JFreeReportBoot;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.serializer.SerializerHelper;

public class SurveyScale
implements Serializable {
    private static final Number[] EMPTY_VALUES = new Number[0];
    private int lowest;
    private int highest;
    private double lowerMargin = 0.1;
    private double upperMargin = 0.1;
    private ArrayList fillShapes;
    private Number[] values;
    private Number rangeLowerBound;
    private Number rangeUpperBound;
    private boolean drawBorder;
    private boolean drawTickMarks;
    private boolean drawScaleValues;
    private Font scaleValueFont;
    private transient Paint scaleValuePaint;
    private transient Paint rangePaint;
    private transient ArrayList shapes;
    private transient Paint fillPaint;
    private transient Stroke outlineStroke;
    private transient Shape defaultShape;
    private transient Paint tickMarkPaint;
    private transient Paint borderPaint;
    private int range;
    private double lowerBound;
    private double upperBound;
    private boolean useFontMetricsGetStringBounds;
    private boolean autoConfigure;

    public SurveyScale() {
        this(1, 5, EMPTY_VALUES);
    }

    public SurveyScale(int n, int n2, Number[] numberArray) {
        String string = JFreeReportBoot.getInstance().getGlobalConfig().getConfigProperty("org.jfree.report.modules.misc.survey.UseFontMetricsGetStringBounds", "auto");
        this.useFontMetricsGetStringBounds = "auto".equals(string) ? ObjectUtilities.isJDK14() : "true".equals(string);
        this.lowest = n;
        this.highest = n2;
        this.values = numberArray == null ? EMPTY_VALUES : (Number[])numberArray.clone();
        this.drawTickMarks = true;
        this.tickMarkPaint = Color.gray;
        this.scaleValuePaint = Color.black;
        this.defaultShape = new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0);
        this.rangeLowerBound = null;
        this.rangeUpperBound = null;
        this.rangePaint = Color.lightGray;
        this.shapes = this.createShapeList();
        this.fillShapes = new ArrayList();
        this.fillShapes.add(0, Boolean.TRUE);
        this.fillPaint = Color.black;
        this.outlineStroke = new BasicStroke(0.5f);
        this.recompute();
    }

    public boolean isAutoConfigure() {
        return this.autoConfigure;
    }

    public void setAutoConfigure(boolean bl) {
        this.autoConfigure = bl;
        this.recompute();
    }

    public int getLowest() {
        return this.lowest;
    }

    public void setLowest(int n) {
        this.lowest = n;
        this.recompute();
    }

    public int getHighest() {
        return this.highest;
    }

    public void setHighest(int n) {
        this.highest = n;
        this.recompute();
    }

    protected void recompute() {
        this.range = Math.max(0, this.highest - this.lowest);
        this.lowerBound = (double)this.lowest - (double)this.range * this.lowerMargin;
        this.upperBound = (double)this.highest + (double)this.range * this.upperMargin;
    }

    protected int getRange() {
        return this.range;
    }

    protected void setRange(int n) {
        this.range = n;
    }

    protected double getLowerBound() {
        return this.lowerBound;
    }

    protected void setLowerBound(double d) {
        this.lowerBound = d;
    }

    protected double getUpperBound() {
        return this.upperBound;
    }

    protected void setUpperBound(double d) {
        this.upperBound = d;
    }

    protected ArrayList createShapeList() {
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        arrayList.add(new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0));
        arrayList.add(SurveyScale.createDownTriangle(4.0f));
        arrayList.add(SurveyScale.createUpTriangle(4.0f));
        arrayList.add(SurveyScale.createDiamond(4.0f));
        arrayList.add(new Rectangle2D.Double(-4.0, -4.0, 8.0, 8.0));
        arrayList.add(new Ellipse2D.Double(-4.0, -4.0, 8.0, 8.0));
        return arrayList;
    }

    public static Shape createDiamond(float f) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, -f);
        generalPath.lineTo(f, 0.0f);
        generalPath.lineTo(0.0f, f);
        generalPath.lineTo(-f, 0.0f);
        generalPath.closePath();
        return generalPath;
    }

    public static Shape createUpTriangle(float f) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, -f);
        generalPath.lineTo(f, f);
        generalPath.lineTo(-f, f);
        generalPath.closePath();
        return generalPath;
    }

    public static Shape createDownTriangle(float f) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, f);
        generalPath.lineTo(f, -f);
        generalPath.lineTo(-f, -f);
        generalPath.closePath();
        return generalPath;
    }

    public Number getRangeLowerBound() {
        return this.rangeLowerBound;
    }

    public void setRangeLowerBound(Number number) {
        this.rangeLowerBound = number;
    }

    public Number getRangeUpperBound() {
        return this.rangeUpperBound;
    }

    public void setRangeUpperBound(Number number) {
        this.rangeUpperBound = number;
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean bl) {
        this.drawBorder = bl;
    }

    public boolean isDrawTickMarks() {
        return this.drawTickMarks;
    }

    public void setDrawTickMarks(boolean bl) {
        this.drawTickMarks = bl;
    }

    public boolean isDrawScaleValues() {
        return this.drawScaleValues;
    }

    public void setDrawScaleValues(boolean bl) {
        this.drawScaleValues = bl;
    }

    public Font getScaleValueFont() {
        return this.scaleValueFont;
    }

    public void setScaleValueFont(Font font) {
        this.scaleValueFont = font;
    }

    public Paint getScaleValuePaint() {
        return this.scaleValuePaint;
    }

    public void setScaleValuePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.scaleValuePaint = paint;
    }

    public Shape getShape(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n < this.shapes.size()) {
            return (Shape)this.shapes.get(n);
        }
        return null;
    }

    public void setShape(int n, Shape shape) {
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.shapes.size() > n) {
            this.shapes.set(n, shape);
        } else {
            while (this.shapes.size() < n) {
                this.shapes.ensureCapacity(n);
                this.shapes.add(null);
                this.shapes.add(shape);
            }
        }
    }

    public boolean isShapeFilled(int n) {
        Boolean bl;
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n < this.fillShapes.size() && (bl = (Boolean)this.fillShapes.get(n)) != null) {
            return bl;
        }
        return false;
    }

    public void setShapeFilled(int n, boolean bl) {
        this.fillShapes.set(n, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public Paint getRangePaint() {
        return this.rangePaint;
    }

    public void setRangePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.rangePaint = paint;
    }

    public Paint getBorderPaint() {
        return this.borderPaint;
    }

    public void setBorderPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.borderPaint = paint;
    }

    public Shape getDefaultShape() {
        return this.defaultShape;
    }

    public void setDefaultShape(Shape shape) {
        if (shape == null) {
            throw new NullPointerException("The default shape must not be null.");
        }
        this.defaultShape = shape;
    }

    public Paint getTickMarkPaint() {
        return this.tickMarkPaint;
    }

    public void setTickMarkPaint(Paint paint) {
        if (paint == null) {
            throw new NullPointerException();
        }
        this.tickMarkPaint = paint;
    }

    public Number[] getValues() {
        return (Number[])this.values.clone();
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public void setFillPaint(Paint paint) {
        if (paint == null) {
            throw new NullPointerException();
        }
        this.fillPaint = paint;
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new NullPointerException();
        }
        this.outlineStroke = stroke;
    }

    public double getUpperMargin() {
        return this.upperMargin;
    }

    public void setUpperMargin(double d) {
        this.upperMargin = d;
    }

    public double getLowerMargin() {
        return this.lowerMargin;
    }

    public void setLowerMargin(double d) {
        this.lowerMargin = d;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (this.isDrawBorder()) {
            this.drawBorder(graphics2D, rectangle2D);
        }
        this.drawRangeArea(rectangle2D, graphics2D);
        if (this.isDrawTickMarks()) {
            this.drawTickMarks(graphics2D, rectangle2D);
        }
        if (this.isDrawScaleValues()) {
            this.drawScaleValues(graphics2D, rectangle2D);
        }
        this.drawValues(graphics2D, rectangle2D);
    }

    protected void drawValues(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Number[] numberArray = this.getValues();
        if (numberArray.length == 0) {
            return;
        }
        double d = rectangle2D.getCenterY();
        Stroke stroke = this.getOutlineStroke();
        Shape shape = this.getDefaultShape();
        graphics2D.setPaint(this.getFillPaint());
        for (int i = 0; i < numberArray.length; ++i) {
            Number number = numberArray[i];
            if (number == null) continue;
            double d2 = number.doubleValue();
            double d3 = this.valueToJava2D(d2, rectangle2D);
            Shape shape2 = this.getShape(i);
            if (shape2 == null) {
                shape2 = shape;
            }
            if (this.isShapeFilled(i)) {
                graphics2D.translate(d3, d);
                graphics2D.fill(shape2);
                graphics2D.translate(-d3, -d);
                continue;
            }
            graphics2D.setStroke(stroke);
            graphics2D.translate(d3, d);
            graphics2D.draw(shape2);
            graphics2D.translate(-d3, -d);
        }
    }

    protected void drawScaleValues(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        graphics2D.setPaint(this.getScaleValuePaint());
        Font font = this.getScaleValueFont();
        if (font != null) {
            graphics2D.setFont(font);
        }
        Font font2 = graphics2D.getFont();
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font2);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        double d = rectangle2D.getCenterY();
        int n = this.getHighest();
        for (int i = this.getLowest(); i <= n; ++i) {
            float f;
            Object object;
            double d2 = this.valueToJava2D(i, rectangle2D);
            String string = String.valueOf(i);
            if (this.useFontMetricsGetStringBounds) {
                object = fontMetrics.getStringBounds(string, graphics2D);
                f = (float)((RectangularShape)object).getWidth();
            } else {
                f = fontMetrics.stringWidth(string);
            }
            object = font2.getLineMetrics(string, fontRenderContext);
            float f2 = ((LineMetrics)object).getDescent();
            float f3 = ((LineMetrics)object).getLeading();
            float f4 = -f2 - f3 + (float)((double)((LineMetrics)object).getHeight() / 2.0);
            float f5 = -f / 2.0f;
            graphics2D.drawString(string, (float)(d2 + (double)f5), (float)(d + (double)f4));
        }
    }

    protected void drawTickMarks(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        graphics2D.setPaint(this.getTickMarkPaint());
        graphics2D.setStroke(new BasicStroke(0.1f));
        int n = this.getHighest();
        for (int i = this.getLowest(); i <= n; ++i) {
            for (int j = 0; j < 10; ++j) {
                double d = this.valueToJava2D((double)i + (double)j / 10.0, rectangle2D);
                Line2D.Double double_ = new Line2D.Double(d, rectangle2D.getCenterY() - 2.0, d, rectangle2D.getCenterY() + 2.0);
                graphics2D.draw(double_);
            }
        }
        double d = this.valueToJava2D(n, rectangle2D);
        Line2D.Double double_ = new Line2D.Double(d, rectangle2D.getCenterY() - 2.0, d, rectangle2D.getCenterY() + 2.0);
        graphics2D.draw(double_);
    }

    protected void drawRangeArea(Rectangle2D rectangle2D, Graphics2D graphics2D) {
        Number number = this.getRangeUpperBound();
        Number number2 = this.getRangeLowerBound();
        if (number2 == null || number == null) {
            return;
        }
        double d = this.valueToJava2D(number2.doubleValue(), rectangle2D);
        double d2 = this.valueToJava2D(number.doubleValue(), rectangle2D);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, rectangle2D.getY(), d2 - d, rectangle2D.getHeight());
        graphics2D.setPaint(this.getRangePaint());
        graphics2D.fill(double_);
    }

    protected void drawBorder(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        graphics2D.setStroke(this.getOutlineStroke());
        graphics2D.setPaint(this.getBorderPaint());
        graphics2D.draw(rectangle2D);
    }

    private double valueToJava2D(double d, Rectangle2D rectangle2D) {
        double d2 = this.getUpperBound();
        double d3 = this.getLowerBound();
        return rectangle2D.getMinX() + (d - d3) / (d2 - d3) * rectangle2D.getWidth();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerializerHelper serializerHelper = SerializerHelper.getInstance();
        serializerHelper.writeObject((Object)this.scaleValuePaint, objectOutputStream);
        serializerHelper.writeObject((Object)this.rangePaint, objectOutputStream);
        serializerHelper.writeObject((Object)this.fillPaint, objectOutputStream);
        serializerHelper.writeObject((Object)this.outlineStroke, objectOutputStream);
        serializerHelper.writeObject((Object)this.defaultShape, objectOutputStream);
        serializerHelper.writeObject((Object)this.tickMarkPaint, objectOutputStream);
        serializerHelper.writeObject((Object)this.borderPaint, objectOutputStream);
        int n = this.shapes.size();
        objectOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            Shape shape = (Shape)this.shapes.get(i);
            serializerHelper.writeObject((Object)shape, objectOutputStream);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        SerializerHelper serializerHelper = SerializerHelper.getInstance();
        this.scaleValuePaint = (Paint)serializerHelper.readObject(objectInputStream);
        this.rangePaint = (Paint)serializerHelper.readObject(objectInputStream);
        this.fillPaint = (Paint)serializerHelper.readObject(objectInputStream);
        this.outlineStroke = (Stroke)serializerHelper.readObject(objectInputStream);
        this.defaultShape = (Shape)serializerHelper.readObject(objectInputStream);
        this.tickMarkPaint = (Paint)serializerHelper.readObject(objectInputStream);
        this.borderPaint = (Paint)serializerHelper.readObject(objectInputStream);
        this.shapes = new ArrayList();
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            Shape shape = (Shape)serializerHelper.readObject(objectInputStream);
            this.shapes.add(shape);
        }
    }
}

