/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.store;

import java.util.NoSuchElementException;
import org.hsqldb.lib.ArrayCounter;
import org.hsqldb.lib.Iterator;
import org.hsqldb.store.HashIndex;

public class BaseHashMap {
    boolean isIntKey;
    boolean isLongKey;
    boolean isObjectKey;
    boolean isNoValue;
    boolean isIntValue;
    boolean isLongValue;
    boolean isObjectValue;
    protected HashIndex hashIndex;
    protected int[] intKeyTable;
    protected Object[] objectKeyTable;
    protected long[] longKeyTable;
    protected int[] intValueTable;
    protected Object[] objectValueTable;
    protected long[] longValueTable;
    int accessMin;
    int accessCount;
    int[] accessTable;
    final float loadFactor;
    final int initialCapacity;
    int threshold;
    int maxCapacity;
    protected int purgePolicy = 0;
    protected boolean minimizeOnEmpty;
    boolean hasZeroKey;
    int zeroKeyIndex = -1;
    protected static final int noKeyOrValue = 0;
    protected static final int intKeyOrValue = 1;
    protected static final int longKeyOrValue = 2;
    protected static final int objectKeyOrValue = 3;
    protected static final int NO_PURGE = 0;
    protected static final int PURGE_ALL = 1;
    protected static final int PURGE_HALF = 2;
    protected static final int PURGE_QUARTER = 3;

    protected BaseHashMap(int n, float f, int n2, int n3, boolean bl) throws IllegalArgumentException {
        int n4;
        this.loadFactor = f;
        this.initialCapacity = n;
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.threshold = n;
        if (this.threshold < 3) {
            this.threshold = 3;
        }
        if ((n4 = (int)((float)n * f)) < 3) {
            n4 = 3;
        }
        this.hashIndex = new HashIndex(n4, n, true);
        int n5 = this.threshold;
        if (n2 == 1) {
            this.isIntKey = true;
            this.intKeyTable = new int[n5];
        } else if (n2 == 3) {
            this.isObjectKey = true;
            this.objectKeyTable = new Object[n5];
        } else {
            this.isLongKey = true;
            this.longKeyTable = new long[n5];
        }
        if (n3 == 1) {
            this.isIntValue = true;
            this.intValueTable = new int[n5];
        } else if (n3 == 3) {
            this.isObjectValue = true;
            this.objectValueTable = new Object[n5];
        } else if (n3 == 2) {
            this.isLongValue = true;
            this.longValueTable = new long[n5];
        } else {
            this.isNoValue = true;
        }
        if (bl) {
            this.accessTable = new int[n5];
        }
    }

    protected int getLookup(Object object, int n) {
        int n2 = this.hashIndex.getLookup(n);
        while (n2 >= 0) {
            Object object2 = this.objectKeyTable[n2];
            if (object.equals(object2)) {
                return n2;
            }
            n2 = this.hashIndex.getNextLookup(n2);
        }
        return n2;
    }

    protected int getLookup(int n) {
        int n2 = this.hashIndex.getLookup(n);
        while (n2 >= 0) {
            int n3 = this.intKeyTable[n2];
            if (n == n3) {
                return n2;
            }
            n2 = this.hashIndex.getNextLookup(n2);
        }
        return n2;
    }

    protected int getLookup(long l) {
        int n = this.hashIndex.getLookup((int)l);
        while (n >= 0) {
            long l2 = this.longKeyTable[n];
            if (l == l2) {
                return n;
            }
            n = this.hashIndex.getNextLookup(n);
        }
        return n;
    }

    protected Object addOrRemove(long l, long l2, Object object, Object object2, boolean bl) {
        int n = (int)l;
        if (this.isObjectKey) {
            if (object == null) {
                return null;
            }
            n = object.hashCode();
        }
        int n2 = this.hashIndex.getHashIndex(n);
        int n3 = this.hashIndex.hashTable[n2];
        int n4 = -1;
        Object object3 = null;
        while (n3 >= 0 && !(this.isObjectKey ? this.objectKeyTable[n3].equals(object) : (this.isIntKey ? l == (long)this.intKeyTable[n3] : this.isLongKey && l == this.longKeyTable[n3]))) {
            n4 = n3;
            n3 = this.hashIndex.getNextLookup(n3);
        }
        if (n3 >= 0) {
            if (bl) {
                if (this.isObjectKey) {
                    this.objectKeyTable[n3] = null;
                } else {
                    if (l == 0L) {
                        this.hasZeroKey = false;
                        this.zeroKeyIndex = -1;
                    }
                    if (this.isIntKey) {
                        this.intKeyTable[n3] = 0;
                    } else {
                        this.longKeyTable[n3] = 0L;
                    }
                }
                if (this.isObjectValue) {
                    object3 = this.objectValueTable[n3];
                    this.objectValueTable[n3] = null;
                } else if (this.isIntValue) {
                    this.intValueTable[n3] = 0;
                } else if (this.isLongValue) {
                    this.longValueTable[n3] = 0L;
                }
                this.hashIndex.unlinkNode(n2, n4, n3);
                if (this.accessTable != null) {
                    this.accessTable[n3] = 0;
                }
                if (this.minimizeOnEmpty && this.hashIndex.elementCount == 0) {
                    this.rehash(this.initialCapacity);
                }
                return object3;
            }
            if (this.isObjectValue) {
                object3 = this.objectValueTable[n3];
                this.objectValueTable[n3] = object2;
            } else if (this.isIntValue) {
                this.intValueTable[n3] = (int)l2;
            } else if (this.isLongValue) {
                this.longValueTable[n3] = l2;
            }
            if (this.accessTable != null) {
                ++this.accessCount;
            }
            return object3;
        }
        if (bl) {
            return null;
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            if (this.reset()) {
                return this.addOrRemove(l, l2, object, object2, bl);
            }
            return null;
        }
        n3 = this.hashIndex.linkNode(n2, n4);
        if (this.isObjectKey) {
            this.objectKeyTable[n3] = object;
        } else if (this.isIntKey) {
            this.intKeyTable[n3] = (int)l;
            if (l == 0L) {
                this.hasZeroKey = true;
                this.zeroKeyIndex = n3;
            }
        } else if (this.isLongKey) {
            this.longKeyTable[n3] = l;
            if (l == 0L) {
                this.hasZeroKey = true;
                this.zeroKeyIndex = n3;
            }
        }
        if (this.isObjectValue) {
            this.objectValueTable[n3] = object2;
        } else if (this.isIntValue) {
            this.intValueTable[n3] = (int)l2;
        } else if (this.isLongValue) {
            this.longValueTable[n3] = l2;
        }
        if (this.accessTable != null) {
            ++this.accessCount;
        }
        return object3;
    }

    protected Object addOrRemove(int n, Object object, boolean bl) {
        int n2 = n;
        int n3 = this.hashIndex.getHashIndex(n2);
        int n4 = this.hashIndex.hashTable[n3];
        int n5 = -1;
        Object object2 = null;
        while (n4 >= 0 && n != this.intKeyTable[n4]) {
            n5 = n4;
            n4 = this.hashIndex.getNextLookup(n4);
        }
        if (n4 >= 0) {
            if (bl) {
                if (n == 0) {
                    this.hasZeroKey = false;
                    this.zeroKeyIndex = -1;
                }
                this.intKeyTable[n4] = 0;
                object2 = this.objectValueTable[n4];
                this.objectValueTable[n4] = null;
                this.hashIndex.unlinkNode(n3, n5, n4);
                if (this.accessTable != null) {
                    this.accessTable[n4] = 0;
                }
                return object2;
            }
            if (this.isObjectValue) {
                object2 = this.objectValueTable[n4];
                this.objectValueTable[n4] = object;
            }
            if (this.accessTable != null) {
                ++this.accessCount;
            }
            return object2;
        }
        if (bl) {
            return object2;
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            if (this.reset()) {
                return this.addOrRemove(n, object, bl);
            }
            return null;
        }
        n4 = this.hashIndex.linkNode(n3, n5);
        this.intKeyTable[n4] = n;
        if (n == 0) {
            this.hasZeroKey = true;
            this.zeroKeyIndex = n4;
        }
        this.objectValueTable[n4] = object;
        if (this.accessTable != null) {
            ++this.accessCount;
        }
        return object2;
    }

    protected Object removeObject(Object object) {
        if (object == null) {
            return null;
        }
        int n = object.hashCode();
        int n2 = this.hashIndex.getHashIndex(n);
        int n3 = this.hashIndex.hashTable[n2];
        int n4 = -1;
        Object object2 = null;
        while (n3 >= 0) {
            if (this.objectKeyTable[n3].equals(object)) {
                this.objectKeyTable[n3] = null;
                this.hashIndex.unlinkNode(n2, n4, n3);
                if (this.isObjectValue) {
                    object2 = this.objectValueTable[n3];
                    this.objectValueTable[n3] = null;
                }
                return object2;
            }
            n4 = n3;
            n3 = this.hashIndex.getNextLookup(n3);
        }
        return object2;
    }

    protected boolean reset() {
        if (this.maxCapacity == 0 || this.maxCapacity > this.threshold) {
            this.rehash(this.hashIndex.hashTable.length * 2);
            return true;
        }
        if (this.purgePolicy == 1) {
            this.clear();
            return true;
        }
        if (this.purgePolicy == 3) {
            this.clear(this.threshold / 4, this.threshold >> 8);
            return true;
        }
        if (this.purgePolicy == 2) {
            this.clear(this.threshold / 2, this.threshold >> 8);
            return true;
        }
        if (this.purgePolicy == 0) {
            return false;
        }
        return false;
    }

    protected void rehash(int n) {
        int n2 = this.hashIndex.newNodePointer;
        boolean bl = this.hasZeroKey;
        int n3 = this.zeroKeyIndex;
        if (n < this.hashIndex.elementCount) {
            return;
        }
        this.hashIndex.reset((int)((float)n * this.loadFactor), n);
        this.hasZeroKey = false;
        this.zeroKeyIndex = -1;
        this.threshold = n;
        int n4 = -1;
        while ((n4 = this.nextLookup(n4, n2, bl, n3)) < n2) {
            long l = 0L;
            long l2 = 0L;
            Object object = null;
            Object object2 = null;
            if (this.isObjectKey) {
                object = this.objectKeyTable[n4];
            } else {
                l = this.isIntKey ? (long)this.intKeyTable[n4] : this.longKeyTable[n4];
            }
            if (this.isObjectValue) {
                object2 = this.objectValueTable[n4];
            } else if (this.isIntValue) {
                l2 = this.intValueTable[n4];
            } else if (this.isLongValue) {
                l2 = this.longValueTable[n4];
            }
            this.addOrRemove(l, l2, object, object2, false);
            if (this.accessTable == null) continue;
            this.accessTable[this.hashIndex.elementCount - 1] = this.accessTable[n4];
        }
        this.resizeElementArrays(this.hashIndex.newNodePointer, n);
    }

    private void resizeElementArrays(int n, int n2) {
        Object[] objectArray;
        int n3;
        int n4 = n3 = n2 > n ? n : n2;
        if (this.isIntKey) {
            objectArray = this.intKeyTable;
            this.intKeyTable = new int[n2];
            System.arraycopy(objectArray, 0, this.intKeyTable, 0, n3);
        }
        if (this.isIntValue) {
            objectArray = this.intValueTable;
            this.intValueTable = new int[n2];
            System.arraycopy(objectArray, 0, this.intValueTable, 0, n3);
        }
        if (this.isLongKey) {
            objectArray = this.longKeyTable;
            this.longKeyTable = new long[n2];
            System.arraycopy(objectArray, 0, this.longKeyTable, 0, n3);
        }
        if (this.isLongValue) {
            objectArray = this.longValueTable;
            this.longValueTable = new long[n2];
            System.arraycopy(objectArray, 0, this.longValueTable, 0, n3);
        }
        if (this.isObjectKey) {
            objectArray = this.objectKeyTable;
            this.objectKeyTable = new Object[n2];
            System.arraycopy(objectArray, 0, this.objectKeyTable, 0, n3);
        }
        if (this.isObjectValue) {
            objectArray = this.objectValueTable;
            this.objectValueTable = new Object[n2];
            System.arraycopy(objectArray, 0, this.objectValueTable, 0, n3);
        }
        if (this.accessTable != null) {
            objectArray = this.accessTable;
            this.accessTable = new int[n2];
            System.arraycopy(objectArray, 0, this.accessTable, 0, n3);
        }
    }

    private void clearElementArrays(int n, int n2) {
        int n3;
        if (this.isIntKey) {
            n3 = n2;
            while (--n3 >= n) {
                this.intKeyTable[n3] = 0;
            }
        }
        if (this.isLongKey) {
            n3 = n2;
            while (--n3 >= n) {
                this.longKeyTable[n3] = 0L;
            }
        }
        if (this.isObjectKey) {
            n3 = n2;
            while (--n3 >= n) {
                this.objectKeyTable[n3] = null;
            }
        }
        if (this.isIntValue) {
            n3 = n2;
            while (--n3 >= n) {
                this.intValueTable[n3] = 0;
            }
        }
        if (this.isLongValue) {
            n3 = n2;
            while (--n3 >= n) {
                this.longValueTable[n3] = 0L;
            }
        }
        if (this.isObjectValue) {
            n3 = n2;
            while (--n3 >= n) {
                this.objectValueTable[n3] = null;
            }
        }
        if (this.accessTable != null) {
            n3 = n2;
            while (--n3 >= n) {
                this.accessTable[n3] = 0;
            }
        }
    }

    void removeFromElementArrays(int n) {
        Object[] objectArray;
        int n2 = this.hashIndex.linkTable.length;
        if (this.isIntKey) {
            objectArray = this.intKeyTable;
            System.arraycopy(objectArray, n + 1, objectArray, n, n2 - n - 1);
            this.intKeyTable[n2 - 1] = 0;
        }
        if (this.isLongKey) {
            objectArray = this.longKeyTable;
            System.arraycopy(objectArray, n + 1, objectArray, n, n2 - n - 1);
            this.longKeyTable[n2 - 1] = 0L;
        }
        if (this.isObjectKey) {
            objectArray = this.objectKeyTable;
            System.arraycopy(objectArray, n + 1, objectArray, n, n2 - n - 1);
            this.objectKeyTable[n2 - 1] = null;
        }
        if (this.isIntValue) {
            objectArray = this.intValueTable;
            System.arraycopy(objectArray, n + 1, objectArray, n, n2 - n - 1);
            this.intValueTable[n2 - 1] = 0;
        }
        if (this.isLongValue) {
            objectArray = this.longValueTable;
            System.arraycopy(objectArray, n + 1, objectArray, n, n2 - n - 1);
            this.longValueTable[n2 - 1] = 0L;
        }
        if (this.isObjectValue) {
            objectArray = this.objectValueTable;
            System.arraycopy(objectArray, n + 1, objectArray, n, n2 - n - 1);
            this.objectValueTable[n2 - 1] = null;
        }
    }

    int nextLookup(int n, int n2, boolean bl, int n3) {
        ++n;
        while (n < n2) {
            if (this.isObjectKey) {
                if (this.objectKeyTable[n] != null) {
                    return n;
                }
            } else if (this.isIntKey) {
                if (this.intKeyTable[n] != 0) {
                    return n;
                }
                if (bl && n == n3) {
                    return n;
                }
            } else {
                if (this.longKeyTable[n] != 0L) {
                    return n;
                }
                if (bl && n == n3) {
                    return n;
                }
            }
            ++n;
        }
        return n;
    }

    protected int nextLookup(int n) {
        ++n;
        while (n < this.hashIndex.newNodePointer) {
            if (this.isObjectKey) {
                if (this.objectKeyTable[n] != null) {
                    return n;
                }
            } else if (this.isIntKey) {
                if (this.intKeyTable[n] != 0) {
                    return n;
                }
                if (this.hasZeroKey && n == this.zeroKeyIndex) {
                    return n;
                }
            } else {
                if (this.longKeyTable[n] != 0L) {
                    return n;
                }
                if (this.hasZeroKey && n == this.zeroKeyIndex) {
                    return n;
                }
            }
            ++n;
        }
        return n;
    }

    protected void removeRow(int n) {
        this.hashIndex.removeEmptyNode(n);
        this.removeFromElementArrays(n);
    }

    protected Object removeLookup(int n) {
        if (this.isObjectKey) {
            return this.addOrRemove(0L, 0L, this.objectKeyTable[n], null, true);
        }
        return this.addOrRemove(this.intKeyTable[n], 0L, null, null, true);
    }

    public void clear() {
        this.accessMin = this.accessCount = 0;
        this.hasZeroKey = false;
        this.zeroKeyIndex = -1;
        this.clearElementArrays(0, this.hashIndex.linkTable.length);
        this.hashIndex.clear();
        if (this.minimizeOnEmpty) {
            this.rehash(this.initialCapacity);
        }
    }

    protected int getAccessCountCeiling(int n, int n2) {
        return ArrayCounter.rank(this.accessTable, this.hashIndex.newNodePointer, n, this.accessMin + 1, this.accessCount, n2);
    }

    protected void clear(int n, int n2) {
        if (n2 < 64) {
            n2 = 64;
        }
        int n3 = this.hashIndex.newNodePointer;
        int n4 = this.getAccessCountCeiling(n, n2);
        for (int i = 0; i < n3; ++i) {
            Object object = this.objectKeyTable[i];
            if (object == null || this.accessTable[i] >= n4) continue;
            this.removeObject(object);
        }
        this.accessMin = n4;
    }

    void resetAccessCount() {
        if (this.accessCount < Integer.MAX_VALUE) {
            return;
        }
        this.accessMin >>= 2;
        this.accessCount >>= 2;
        int n = this.accessTable.length;
        while (--n >= 0) {
            int n2 = n;
            this.accessTable[n2] = this.accessTable[n2] >> 2;
        }
    }

    public int size() {
        return this.hashIndex.elementCount;
    }

    public boolean isEmpty() {
        return this.hashIndex.elementCount == 0;
    }

    protected boolean containsKey(Object object) {
        if (object == null) {
            return false;
        }
        int n = this.getLookup(object, object.hashCode());
        return n != -1;
    }

    protected boolean containsKey(int n) {
        int n2 = this.getLookup(n);
        return n2 != -1;
    }

    protected boolean containsKey(long l) {
        int n = this.getLookup(l);
        return n != -1;
    }

    protected boolean containsValue(Object object) {
        int n;
        if (object == null) {
            for (n = 0; n < this.hashIndex.newNodePointer; ++n) {
                if (this.objectValueTable[n] != null) continue;
                if (this.isObjectKey) {
                    if (this.objectKeyTable[n] == null) continue;
                    return true;
                }
                if (this.isIntKey) {
                    if (this.intKeyTable[n] != 0) {
                        return true;
                    }
                    if (!this.hasZeroKey || n != this.zeroKeyIndex) continue;
                    return true;
                }
                if (this.longKeyTable[n] != 0L) {
                    return true;
                }
                if (!this.hasZeroKey || n != this.zeroKeyIndex) continue;
                return true;
            }
        } else {
            while (n < this.hashIndex.newNodePointer) {
                if (object.equals(this.objectValueTable[n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    protected class BaseHashIterator
    implements Iterator {
        boolean keys;
        int lookup = -1;
        int counter;
        boolean removed;

        public BaseHashIterator() {
        }

        public BaseHashIterator(boolean bl) {
            this.keys = bl;
        }

        public boolean hasNext() {
            return this.counter < BaseHashMap.this.hashIndex.elementCount;
        }

        public Object next() throws NoSuchElementException {
            if (this.keys && !BaseHashMap.this.isObjectKey || !this.keys && !BaseHashMap.this.isObjectValue) {
                throw new NoSuchElementException("Hash Iterator");
            }
            this.removed = false;
            if (this.hasNext()) {
                ++this.counter;
                this.lookup = BaseHashMap.this.nextLookup(this.lookup);
                if (this.keys) {
                    return BaseHashMap.this.objectKeyTable[this.lookup];
                }
                return BaseHashMap.this.objectValueTable[this.lookup];
            }
            throw new NoSuchElementException("Hash Iterator");
        }

        public int nextInt() throws NoSuchElementException {
            if (this.keys && !BaseHashMap.this.isIntKey || !this.keys && !BaseHashMap.this.isIntValue) {
                throw new NoSuchElementException("Hash Iterator");
            }
            this.removed = false;
            if (this.hasNext()) {
                ++this.counter;
                this.lookup = BaseHashMap.this.nextLookup(this.lookup);
                if (this.keys) {
                    return BaseHashMap.this.intKeyTable[this.lookup];
                }
                return BaseHashMap.this.intValueTable[this.lookup];
            }
            throw new NoSuchElementException("Hash Iterator");
        }

        public long nextLong() throws NoSuchElementException {
            if (!BaseHashMap.this.isLongKey || !this.keys) {
                throw new NoSuchElementException("Hash Iterator");
            }
            this.removed = false;
            if (this.hasNext()) {
                ++this.counter;
                this.lookup = BaseHashMap.this.nextLookup(this.lookup);
                if (this.keys) {
                    return BaseHashMap.this.longKeyTable[this.lookup];
                }
                return BaseHashMap.this.longValueTable[this.lookup];
            }
            throw new NoSuchElementException("Hash Iterator");
        }

        public void remove() throws NoSuchElementException {
            if (this.removed) {
                throw new NoSuchElementException("Hash Iterator");
            }
            --this.counter;
            this.removed = true;
            BaseHashMap.this.removeLookup(this.lookup);
        }

        public int getAccessCount() {
            if (this.removed || BaseHashMap.this.accessTable == null) {
                throw new NoSuchElementException();
            }
            return BaseHashMap.this.accessTable[this.lookup];
        }
    }
}

