/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.settings;

import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;

final class SettingsUpdater {
    final Settings.Builder transientUpdates = Settings.builder();
    final Settings.Builder persistentUpdates = Settings.builder();
    private final ClusterSettings clusterSettings;

    SettingsUpdater(ClusterSettings clusterSettings) {
        this.clusterSettings = clusterSettings;
    }

    synchronized Settings getTransientUpdates() {
        return this.transientUpdates.build();
    }

    synchronized Settings getPersistentUpdate() {
        return this.persistentUpdates.build();
    }

    synchronized ClusterState updateSettings(ClusterState currentState, Settings transientToApply, Settings persistentToApply) {
        boolean updatedReadOnlyAllowDelete;
        boolean updatedReadOnly;
        boolean changed = false;
        Settings.Builder transientSettings = Settings.builder();
        transientSettings.put(currentState.metaData().transientSettings());
        changed |= this.clusterSettings.updateDynamicSettings(transientToApply, transientSettings, this.transientUpdates, "transient");
        Settings.Builder persistentSettings = Settings.builder();
        persistentSettings.put(currentState.metaData().persistentSettings());
        if (!(changed |= this.clusterSettings.updateDynamicSettings(persistentToApply, persistentSettings, this.persistentUpdates, "persistent"))) {
            return currentState;
        }
        MetaData.Builder metaData = MetaData.builder(currentState.metaData()).persistentSettings(persistentSettings.build()).transientSettings(transientSettings.build());
        ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
        boolean bl = updatedReadOnly = MetaData.SETTING_READ_ONLY_SETTING.get(metaData.persistentSettings()) != false || MetaData.SETTING_READ_ONLY_SETTING.get(metaData.transientSettings()) != false;
        if (updatedReadOnly) {
            blocks.addGlobalBlock(MetaData.CLUSTER_READ_ONLY_BLOCK);
        } else {
            blocks.removeGlobalBlock(MetaData.CLUSTER_READ_ONLY_BLOCK);
        }
        boolean bl2 = updatedReadOnlyAllowDelete = MetaData.SETTING_READ_ONLY_ALLOW_DELETE_SETTING.get(metaData.persistentSettings()) != false || MetaData.SETTING_READ_ONLY_ALLOW_DELETE_SETTING.get(metaData.transientSettings()) != false;
        if (updatedReadOnlyAllowDelete) {
            blocks.addGlobalBlock(MetaData.CLUSTER_READ_ONLY_ALLOW_DELETE_BLOCK);
        } else {
            blocks.removeGlobalBlock(MetaData.CLUSTER_READ_ONLY_ALLOW_DELETE_BLOCK);
        }
        ClusterState build = ClusterState.builder(currentState).metaData(metaData).blocks(blocks).build();
        Settings settings = build.metaData().settings();
        this.clusterSettings.validateUpdate(settings);
        return build;
    }
}

