/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import java.io.IOException;
import java.util.Locale;
import java.util.function.Supplier;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.xcontent.XContentLocation;
import org.elasticsearch.common.xcontent.XContentParser;

public final class XContentParserUtils {
    private XContentParserUtils() {
    }

    public static void ensureFieldName(XContentParser parser, XContentParser.Token token, String fieldName) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser::getTokenLocation);
        String currentName = parser.currentName();
        if (!currentName.equals(fieldName)) {
            String message = "Failed to parse object: expecting field with name [%s] but found [%s]";
            throw new ParsingException(parser.getTokenLocation(), String.format(Locale.ROOT, message, fieldName, currentName), new Object[0]);
        }
    }

    public static void throwUnknownField(String field, XContentLocation location) {
        String message = "Failed to parse object: unknown field [%s] found";
        throw new ParsingException(location, String.format(Locale.ROOT, message, field), new Object[0]);
    }

    public static void throwUnknownToken(XContentParser.Token token, XContentLocation location) {
        String message = "Failed to parse object: unexpected token [%s] found";
        throw new ParsingException(location, String.format(Locale.ROOT, message, new Object[]{token}), new Object[0]);
    }

    public static void ensureExpectedToken(XContentParser.Token expected, XContentParser.Token actual, Supplier<XContentLocation> location) {
        if (actual != expected) {
            String message = "Failed to parse object: expecting token of type [%s] but found [%s]";
            throw new ParsingException(location.get(), String.format(Locale.ROOT, message, new Object[]{expected, actual}), new Object[0]);
        }
    }

    public static Object parseStoredFieldsValue(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        Object value = null;
        if (token == XContentParser.Token.VALUE_STRING) {
            value = parser.text();
        } else if (token == XContentParser.Token.VALUE_NUMBER) {
            value = parser.numberValue();
        } else if (token == XContentParser.Token.VALUE_BOOLEAN) {
            value = parser.booleanValue();
        } else if (token == XContentParser.Token.VALUE_EMBEDDED_OBJECT) {
            value = new BytesArray(parser.binaryValue());
        } else {
            XContentParserUtils.throwUnknownToken(token, parser.getTokenLocation());
        }
        return value;
    }

    public static <T> T parseTypedKeysObject(XContentParser parser, String delimiter, Class<T> objectClass) throws IOException {
        int position;
        String currentFieldName = parser.currentName();
        if (Strings.hasLength(currentFieldName) && (position = currentFieldName.indexOf(delimiter)) > 0) {
            String type = currentFieldName.substring(0, position);
            String name = currentFieldName.substring(position + 1);
            return parser.namedObject(objectClass, type, name);
        }
        throw new ParsingException(parser.getTokenLocation(), "Cannot parse object of class [" + objectClass.getSimpleName() + "] without type information. Set [" + "typed_keys" + "] parameter on the request to ensure the type information is added to the response output", new Object[0]);
    }
}

