/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.painless.GenericElasticsearchScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.LeafSearchScript;
import org.elasticsearch.search.lookup.LeafDocLookup;
import org.elasticsearch.search.lookup.LeafSearchLookup;

final class ScriptImpl
implements ExecutableScript,
LeafSearchScript {
    private final GenericElasticsearchScript script;
    private final Map<String, Object> variables;
    private final LeafSearchLookup lookup;
    private final LeafDocLookup doc;
    private final ScoreLookup scoreLookup;
    private final Function<Map<String, Object>, Map<?, ?>> ctxLookup;
    private Scorer scorer;
    private Object aggregationValue;

    ScriptImpl(GenericElasticsearchScript script, Map<String, Object> vars, LeafSearchLookup lookup) {
        this.script = script;
        this.lookup = lookup;
        this.variables = new HashMap<String, Object>();
        if (vars != null) {
            this.variables.putAll(vars);
        }
        if (lookup != null) {
            this.variables.putAll(lookup.asMap());
            this.doc = lookup.doc();
        } else {
            this.doc = null;
        }
        this.scoreLookup = script.uses$_score() ? ScriptImpl::getScore : scorer -> 0.0;
        this.ctxLookup = script.uses$ctx() ? variables -> (Map)variables.get("ctx") : variables -> null;
    }

    public void setNextVar(String name, Object value) {
        this.variables.put(name, value);
    }

    public void setNextAggregationValue(Object value) {
        this.aggregationValue = value;
    }

    public Object run() {
        return this.script.execute(this.variables, this.scoreLookup.apply(this.scorer), (Map<String, ScriptDocValues<?>>)this.doc, this.aggregationValue, this.ctxLookup.apply(this.variables));
    }

    public double runAsDouble() {
        return ((Number)this.run()).doubleValue();
    }

    public long runAsLong() {
        return ((Number)this.run()).longValue();
    }

    public void setScorer(Scorer scorer) {
        this.scorer = scorer;
    }

    public void setDocument(int doc) {
        if (this.lookup != null) {
            this.lookup.setDocument(doc);
        }
    }

    public void setSource(Map<String, Object> source) {
        if (this.lookup != null) {
            this.lookup.source().setSource(source);
        }
    }

    private static double getScore(Scorer scorer) {
        try {
            return scorer.score();
        }
        catch (IOException e) {
            throw new ElasticsearchException("couldn't lookup score", (Throwable)e, new Object[0]);
        }
    }

    static interface ScoreLookup {
        public double apply(Scorer var1);
    }
}

