#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: tls
version: 1.3.11
id: tls-1.3.11-dVuXcUJiqb5IVLSkRRbXb
key: tls-1.3.11-dVuXcUJiqb5IVLSkRRbXb
license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
stability: experimental
homepage: http://github.com/vincenthz/hs-tls
synopsis: TLS/SSL protocol native implementation (Server and Client)
description:
    Native Haskell TLS and SSL protocol implementation for server and client.
    .
    This provides a high-level implementation of a sensitive security protocol,
    eliminating a common set of security issues through the use of the advanced
    type system, high level constructions and common Haskell features.
    .
    Currently implement the SSL3.0, TLS1.0, TLS1.1 and TLS1.2 protocol,
    and support RSA and Ephemeral (Elliptic curve and regular) Diffie Hellman key exchanges,
    and many extensions.
    .
    Some debug tools linked with tls, are available through the
    <http://hackage.haskell.org/package/tls-debug/>.
category: Network
author: Vincent Hanquez <vincent@snarc.org>
exposed: True
exposed-modules:
    Network.TLS Network.TLS.Cipher Network.TLS.Compression
    Network.TLS.Internal Network.TLS.Extra Network.TLS.Extra.Cipher
    Network.TLS.Extra.FFDHE
hidden-modules: Network.TLS.Cap Network.TLS.Struct Network.TLS.Core
                Network.TLS.Context Network.TLS.Context.Internal
                Network.TLS.Credentials Network.TLS.Backend Network.TLS.Crypto
                Network.TLS.Crypto.DH Network.TLS.Crypto.ECDH Network.TLS.ErrT
                Network.TLS.Extension Network.TLS.Extension.EC
                Network.TLS.Handshake Network.TLS.Handshake.Common
                Network.TLS.Handshake.Certificate Network.TLS.Handshake.Key
                Network.TLS.Handshake.Client Network.TLS.Handshake.Server
                Network.TLS.Handshake.Process Network.TLS.Handshake.Signature
                Network.TLS.Handshake.State Network.TLS.Hooks Network.TLS.IO
                Network.TLS.Imports Network.TLS.MAC Network.TLS.Measurement
                Network.TLS.Packet Network.TLS.Parameters Network.TLS.Record
                Network.TLS.Record.Types Network.TLS.Record.Engage
                Network.TLS.Record.Disengage Network.TLS.Record.State
                Network.TLS.RNG Network.TLS.State Network.TLS.Session
                Network.TLS.Sending Network.TLS.Receiving Network.TLS.Util
                Network.TLS.Util.ASN1 Network.TLS.Util.Serialization
                Network.TLS.Types Network.TLS.Wire Network.TLS.X509
abi: bf73b0a8e1f147b81df81500fa0ecc40
trusted: False
import-dirs: /usr/lib/ghc-8.0.2/site-local/tls-1.3.11
library-dirs: /usr/lib/ghc-8.0.2/site-local/tls-1.3.11
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.0.2/tls-1.3.11
hs-libraries: HStls-1.3.11-dVuXcUJiqb5IVLSkRRbXb
depends:
    asn1-encoding-0.9.5-IYQwkkfu141LtkpgWZ9ola
    asn1-types-0.3.2-9aXDFyarEaR4iFeC6pBR3x
    async-2.1.1.1-2GwQEYzLBsdIBCHbNA3HGy base-4.9.1.0
    bytestring-0.10.8.1 cereal-0.5.4.0-KtX8p6mYm6IKYn6d7ncsjw
    cryptonite-0.24-AqnDXA3gQAj4DhJJp41U2O
    data-default-class-0.1.2.0-N42RtcTZUUAlapzICmPz4
    memory-0.14.6-8f3xLObLA3p67pVexclvQP
    mtl-2.2.1-BLKBelFsPB3BoFeSWSOYj6
    network-2.6.3.2-IsLM4TXcLoRI0fmmBYVyQz transformers-0.5.2.0
    x509-1.7.2-AiuPvN6jbzg6DtCxEbpLCq
    x509-store-1.6.5-207oZgxuxx4LgKrjjYCdAl
    x509-validation-1.6.8-IJN0VWVZi6mDioSGqJCAAM
haddock-interfaces: /usr/share/doc/haskell-tls/html/tls.haddock
haddock-html: /usr/share/doc/haskell-tls/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
