#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: shake
version: 0.15.11
id: shake-0.15.11-I3FMMGXKgF5KhpnpvvNJWr
key: shake-0.15.11-I3FMMGXKgF5KhpnpvvNJWr
license: BSD3
copyright: Neil Mitchell 2011-2017
maintainer: Neil Mitchell <ndmitchell@gmail.com>
homepage: http://shakebuild.com
synopsis: Build system library, like Make, but more accurate dependencies.
description:
    Shake is a Haskell library for writing build systems - designed as a
    replacement for @make@. See "Development.Shake" for an introduction,
    including an example. Further examples are included in the Cabal tarball,
    under the @Examples@ directory. The homepage contains links to a user
    manual, an academic paper and further information:
    <http://shakebuild.com>
    .
    To use Shake the user writes a Haskell program
    that imports "Development.Shake", defines some build rules, and calls
    the '\''Development.Shake.shakeArgs'\'' function. Thanks to do notation and infix
    operators, a simple Shake build system
    is not too dissimilar from a simple Makefile. However, as build systems
    get more complex, Shake is able to take advantage of the excellent
    abstraction facilities offered by Haskell and easily support much larger
    projects. The Shake library provides all the standard features available in other
    build systems, including automatic parallelism and minimal rebuilds.
    Shake also provides more accurate dependency tracking, including seamless
    support for generated files, and dependencies on system information
    (e.g. compiler version).
category: Development, Shake
author: Neil Mitchell <ndmitchell@gmail.com>
exposed: True
exposed-modules:
    Development.Shake Development.Shake.Classes
    Development.Shake.Command Development.Shake.Config
    Development.Shake.FilePath Development.Shake.Forward
    Development.Shake.Rule Development.Shake.Util
hidden-modules: Development.Ninja.Env Development.Ninja.Lexer
                Development.Ninja.Parse Development.Ninja.Type
                Development.Shake.Args Development.Shake.ByteString
                Development.Shake.Core Development.Shake.CmdOption
                Development.Shake.Database Development.Shake.Demo
                Development.Shake.Derived Development.Shake.Errors
                Development.Shake.FileInfo Development.Shake.FilePattern
                Development.Shake.Monad Development.Shake.Pool
                Development.Shake.Profile Development.Shake.Progress
                Development.Shake.Resource Development.Shake.Rules.Directory
                Development.Shake.Rules.File Development.Shake.Rules.Files
                Development.Shake.Rules.Oracle Development.Shake.Rules.OrderOnly
                Development.Shake.Rules.Rerun Development.Shake.Shake
                Development.Shake.Special Development.Shake.Storage
                Development.Shake.Types Development.Shake.Value General.Bilist
                General.Binary General.Cleanup General.Concurrent General.Extra
                General.FileLock General.Intern General.Process General.String
                General.Template General.Timing Paths_shake
abi: 17f8312bcaf2f219559de1bb360f4e43
trusted: False
import-dirs: /usr/lib/ghc-8.0.2/site-local/shake-0.15.11
library-dirs: /usr/lib/ghc-8.0.2/site-local/shake-0.15.11
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/haskell-shake
hs-libraries: HSshake-0.15.11-I3FMMGXKgF5KhpnpvvNJWr
depends:
    base-4.9.1.0 binary-0.8.3.0 bytestring-0.10.8.1 deepseq-1.4.2.0
    directory-1.3.0.0 extra-1.5.3-D0CTSfwIrg4DdcYZmgSnz1
    filepath-1.4.1.1 hashable-1.2.6.1-2nPqxcHq7mUGgurrYaLtXr
    js-flot-0.8.3-FFINNwUg9vmHMMWQsN8uhg
    js-jquery-3.2.1-GtxtZ651RlV17366fNzcXt process-1.4.3.0
    random-1.1-9tceXaeYIMZ4JrKq20Egog time-1.6.0.1 transformers-0.5.2.0
    unix-2.7.2.1 unordered-containers-0.2.8.0-1tqMF698WJE3INvmpuzQZc
    utf8-string-1.0.1.1-1DpjxLeTvGg7ttZZojxJR5
haddock-interfaces: /usr/share/doc/haskell-shake/html/shake.haddock
haddock-html: /usr/share/doc/haskell-shake/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
