#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: tamarin-prover-theory
version: 1.2.2
id: tamarin-prover-theory-1.2.2-EV7eUt1BKoC9po7rFgFJ6I
key: tamarin-prover-theory-1.2.2-EV7eUt1BKoC9po7rFgFJ6I
license: GPL
copyright: Benedikt Schmidt, Simon Meier, ETH Zurich, 2010-2012
maintainer: Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>
homepage: http://www.infsec.ethz.ch/research/software/tamarin
synopsis: Term manipulation library for the tamarin prover.
description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).
    .
    This library provides the types to represent security
    protocol, and it implements the constraint solver.
category: Theorem Provers
author: Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>,
        Simon Meier <simon.meier@inf.ethz.ch>
exposed: True
exposed-modules:
    Theory Theory.Proof Theory.Constraint.Solver
    Theory.Constraint.Solver.Sources
    Theory.Constraint.Solver.Contradictions
    Theory.Constraint.Solver.Goals Theory.Constraint.Solver.ProofMethod
    Theory.Constraint.Solver.Reduction
    Theory.Constraint.Solver.Simplify Theory.Constraint.Solver.Types
    Theory.Constraint.System Theory.Constraint.System.Constraints
    Theory.Constraint.System.Dot Theory.Constraint.System.JSON
    Theory.Constraint.System.Guarded Theory.Model Theory.Model.Atom
    Theory.Model.Fact Theory.Model.Formula Theory.Model.Rule
    Theory.Model.Signature Theory.Text.Pretty Theory.Text.Parser
    Theory.Text.Parser.Token Theory.Tools.AbstractInterpretation
    Theory.Tools.EquationStore Theory.Tools.InjectiveFactInstances
    Theory.Tools.IntruderRules Theory.Tools.LoopBreakers
    Theory.Tools.RuleVariants Theory.Tools.Wellformedness
abi: da3f73215a168bcf9e6763af56a7d1c0
trusted: False
import-dirs: /usr/lib/ghc-8.0.2/site-local/tamarin-prover-theory-1.2.2
library-dirs: /usr/lib/ghc-8.0.2/site-local/tamarin-prover-theory-1.2.2
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.0.2/tamarin-prover-theory-1.2.2
hs-libraries: HStamarin-prover-theory-1.2.2-EV7eUt1BKoC9po7rFgFJ6I
depends:
    aeson-1.1.2.0-8R262j8BseM7FTnCfGfbwu
    aeson-pretty-0.8.5-8gwmmjZBfv22BueFqs3ea6 base-4.9.1.0
    binary-0.8.3.0 bytestring-0.10.8.1 containers-0.5.7.1
    deepseq-1.4.2.0 dlist-0.8.0.3-BHFBNaw8k6n9WiaUNzoXpk
    fclabels-2.0.3.2-4EezQlp7n1w9uoh5Y3yxAt
    mtl-2.2.1-BLKBelFsPB3BoFeSWSOYj6
    parallel-3.2.1.1-KQJHWCcq2Ka569Stb10nhx
    parsec-3.1.11-1CA7c0vSU7tJHGhveOjoXR process-1.4.3.0
    safe-0.3.15-2Yd45VWFfdcKqKyispOifY
    tamarin-prover-term-1.2.2-AAX5pCkSPqj7TesI35mR1r
    tamarin-prover-utils-1.2.2-DJZpg9PLIgz1PvIcXekJ5D
    text-1.2.2.2-3ENqlljngKa6xj1Go2fVWq transformers-0.5.2.0
    uniplate-1.6.12-A02jTsyQmCWKBCl3BhcKvP
haddock-interfaces: /usr/share/doc/haskell-tamarin-prover-theory/html/tamarin-prover-theory.haddock
haddock-html: /usr/share/doc/haskell-tamarin-prover-theory/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
