#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: hledger
version: 1.3
id: hledger-1.3-Lu67cVRIDEQERXcR7GRB6Z
key: hledger-1.3-Lu67cVRIDEQERXcR7GRB6Z
license: GPL-3
maintainer: Simon Michael <simon@joyful.com>
stability: stable
homepage: http://hledger.org
synopsis: Command-line interface for the hledger accounting tool
description:
    This is hledger'\''s command-line interface.
    Its basic function is to read a plain text file describing
    financial transactions and produce useful reports.
    .
    hledger is a cross-platform program for tracking money, time, or
    any other commodity, using double-entry accounting and a simple,
    editable file format. It is inspired by and largely compatible
    with ledger(1).  hledger provides command-line, curses and web
    interfaces, and aims to be a reliable, practical tool for daily
    use.
category: Finance, Console
author: Simon Michael <simon@joyful.com>
exposed: True
exposed-modules:
    Hledger.Cli Hledger.Cli.Main Hledger.Cli.CliOptions
    Hledger.Cli.DocFiles Hledger.Cli.Tests Hledger.Cli.Utils
    Hledger.Cli.Version Hledger.Cli.Add Hledger.Cli.Accounts
    Hledger.Cli.Balance Hledger.Cli.Balancesheet
    Hledger.Cli.BalanceView Hledger.Cli.Cashflow Hledger.Cli.Help
    Hledger.Cli.Histogram Hledger.Cli.Incomestatement Hledger.Cli.Info
    Hledger.Cli.Man Hledger.Cli.Print Hledger.Cli.Register
    Hledger.Cli.Stats Text.Tabular.AsciiWide
hidden-modules: Paths_hledger
abi: 9ecdb353efb7e2a02d9f4ae654ecf5ee
trusted: False
import-dirs: /usr/lib/ghc-8.0.2/site-local/hledger-1.3
library-dirs: /usr/lib/ghc-8.0.2/site-local/hledger-1.3
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/hledger
hs-libraries: HShledger-1.3-Lu67cVRIDEQERXcR7GRB6Z
depends:
    HUnit-1.6.0.0-60ZLMGxowdyCquCGGOoE3I
    ansi-terminal-0.6.3.1-59sjf9WqHYuFAo9gQw9Bhp base-4.9.1.0
    base-compat-0.9.3-KeJp8zYMpcS9WibvTcxU22 bytestring-0.10.8.1
    cmdargs-0.10.17-gTr0lzwrHbBcQQ47pfTGo containers-0.5.7.1
    csv-0.1.2-IUnXEueXED9ELeVORJac7R
    data-default-0.7.1.1-BNa3MzH41nV77yjS9K2Umq directory-1.3.0.0
    file-embed-0.0.10-KWMmUDaNSRP7AxWSEHlrrK filepath-1.4.1.1
    hashable-1.2.6.1-2nPqxcHq7mUGgurrYaLtXr haskeline-0.7.3.0
    here-1.2.11-J0PMfFPIwflA1CZ2kh75V5
    hledger-lib-1.3-92jrkUykEU38AWlukeydoO
    megaparsec-5.3.1-9NkUd2RGYlu1wtR645IhSo
    mtl-2.2.1-BLKBelFsPB3BoFeSWSOYj6
    old-time-1.1.0.3-EZzkBJ4NQxX4hHavrKxgaT
    pretty-show-1.6.13-LSgpbeg7Zcd2id7s8ra4bM process-1.4.3.0
    regex-tdfa-1.2.2-JFeutuWiS2vGBM4qXQlqio
    safe-0.3.15-2Yd45VWFfdcKqKyispOifY
    shakespeare-2.0.13-KCXl8uUSnCQKF0QGMG79cz
    split-0.2.3.2-CJl40zTyCIV16Pr60nb7CT
    tabular-0.2.2.7-E3mf3ECVuWqCqIaml40ALC
    temporary-1.2.1.1-6DswsWwyVfs4EvmtlA0bHh terminfo-0.4.0.2
    text-1.2.2.2-3ENqlljngKa6xj1Go2fVWq time-1.6.0.1
    transformers-0.5.2.0
    unordered-containers-0.2.8.0-1tqMF698WJE3INvmpuzQZc
    utf8-string-1.0.1.1-1DpjxLeTvGg7ttZZojxJR5
    wizards-1.0.2-3C14iHNvdkt3uJhP46rNMR
haddock-interfaces: /usr/share/doc/hledger/html/hledger.haddock
haddock-html: /usr/share/doc/hledger/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
