/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.util.Map;
import javajs.awt.Font;
import javajs.util.A4;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.T3;
import org.jmol.export.UseTable;
import org.jmol.export._VrmlExporter;
import org.jmol.java.BS;
import org.jmol.viewer.Viewer;

public class _X3dExporter
extends _VrmlExporter {
    public _X3dExporter() {
        this.useTable = new UseTable("USE='");
    }

    @Override
    protected void outputHeader() {
        this.output("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
        this.output("<!DOCTYPE X3D PUBLIC \"ISO//Web3D//DTD X3D 3.1//EN\" \"http://www.web3d.org/specifications/x3d-3.1.dtd\">\n");
        this.output("<X3D profile='Immersive' version='3.1' xmlns:xsd='http://www.w3.org/2001/XMLSchema-instance' xsd:noNamespaceSchemaLocation=' http://www.web3d.org/specifications/x3d-3.1.xsd '>\n");
        this.output("<head>\n");
        this.output("<meta name='title' content=" + PT.esc(this.vwr.ms.modelSetName).replace('<', ' ').replace('>', ' ').replace('&', ' ') + "/>\n");
        this.output("<meta name='description' content='Jmol rendering'/>\n");
        this.output("<meta name='creator' content=' '/>\n");
        this.output("<meta name='created' content='" + this.getExportDate() + "'/>\n");
        this.output("<meta name='generator' content='Jmol " + Viewer.getJmolVersion() + ", http://www.jmol.org'/>\n");
        this.output("<meta name='license' content='http://www.gnu.org/licenses/licenses.html#LGPL'/>\n");
        this.output("</head>\n");
        this.output("<Scene>\n");
        this.output("<NavigationInfo type='EXAMINE'/>\n");
        this.output("<Background skyColor='" + this.rgbFractionalFromColix(this.backgroundColix) + "'/>\n");
        float angle = this.getViewpoint();
        this.output("<Viewpoint fieldOfView='" + angle);
        this.output("' position='");
        this.cameraPosition.z *= this.exportScale;
        this.output(this.cameraPosition);
        this.output("' orientation='");
        this.output(this.tempP1);
        this.output(" " + -this.viewpoint.angle + "'\n jump='true' description='v1'/>\n");
        this.output("\n  <!-- \n");
        this.output(this.getJmolPerspective());
        this.output("\n  -->\n\n");
        this.commentChar = null;
        this.outputInitialTransform();
    }

    @Override
    protected void outputAttrPt(String attr, T3 pt) {
        this.output(" " + attr + "='" + pt.x + " " + pt.y + " " + pt.z + "'");
    }

    @Override
    protected void pushMatrix() {
        this.output("<Transform ");
    }

    @Override
    protected void popMatrix() {
        this.output("</Transform>\n");
    }

    @Override
    protected void outputAttr(String attr, float x, float y, float z) {
        this.output(" " + attr + "='" + _X3dExporter.round(x) + " " + _X3dExporter.round(y) + " " + _X3dExporter.round(z) + "'");
    }

    @Override
    protected void outputRotation(A4 a) {
        this.output(" rotation='" + a.x + " " + a.y + " " + a.z + " " + a.angle + "'");
    }

    @Override
    protected void outputFooter() {
        this.useTable = null;
        this.popMatrix();
        this.popMatrix();
        this.output("</Scene>\n");
        this.output("</X3D>\n");
    }

    @Override
    protected void outputAppearance(short colix, boolean isText) {
        String def = this.getDef((isText ? "T" : "") + colix);
        this.output("<Appearance ");
        if (def.charAt(0) == '_') {
            String color = this.rgbFractionalFromColix(colix);
            this.output("DEF='" + def + "'><Material diffuseColor='");
            if (isText) {
                this.output("0 0 0' specularColor='0 0 0' ambientIntensity='0.0' shininess='0.0' emissiveColor='" + color + "'/>");
            } else {
                this.output(color + "' transparency='" + _X3dExporter.translucencyFractionalFromColix(colix) + "'/>");
            }
        } else {
            this.output(def + ">");
        }
        this.output("</Appearance>");
    }

    @Override
    protected void outputChildShapeStart() {
        this.outputShapeStart();
    }

    @Override
    protected void outputShapeStart() {
        this.output("<Shape>");
        this.outputFaceSetStart();
    }

    @Override
    protected void outputChildStart() {
    }

    @Override
    protected void outputChildClose() {
    }

    @Override
    protected void outputDefChildFaceSet(String child) {
        if (child != null) {
            this.output("DEF='" + child + "'");
        }
    }

    @Override
    protected void outputFaceSetStart() {
        this.output("<IndexedFaceSet ");
    }

    @Override
    protected void outputFaceSetClose() {
        this.output("</IndexedFaceSet>\n");
    }

    @Override
    protected void outputUseChildClose(String child) {
        this.output(child + "/>");
    }

    @Override
    protected void outputChildShapeClose() {
        this.outputShapeClose();
    }

    @Override
    protected void outputShapeClose() {
        this.output("</Shape>\n");
    }

    @Override
    protected void outputCloseTag() {
        this.output(">\n");
    }

    @Override
    protected void outputTriangle(T3 pt1, T3 pt2, T3 pt3, short colix) {
        this.output("<Shape>\n");
        this.output("<IndexedFaceSet solid='false' ");
        this.output("coordIndex='0 1 2 -1'>");
        this.output("<Coordinate point='");
        this.output(pt1);
        this.output(" ");
        this.output(pt2);
        this.output(" ");
        this.output(pt3);
        this.output("'/>");
        this.output("</IndexedFaceSet>\n");
        this.outputAppearance(colix, false);
        this.output("\n</Shape>\n");
    }

    @Override
    protected void outputCircle(P3 pt1, P3 pt2, float radius, short colix, boolean doFill) {
        if (doFill) {
            this.pushMatrix();
            this.output("translation='");
            this.tempV1.ave(this.tempP3, pt1);
            this.output(this.tempV1);
            this.output("'><Billboard axisOfRotation='0 0 0'>");
            this.pushMatrix();
            this.output("rotation='1 0 0 1.5708'");
            float height = pt1.distance(pt2);
            this.outputAttr("scale", radius, height, radius);
            this.output(">");
            this.outputCylinderChildScaled(colix, (byte)2);
            this.popMatrix();
            this.output("</Billboard>");
            this.popMatrix();
            return;
        }
        String child = this.getDef("C" + colix + "_" + radius);
        this.pushMatrix();
        this.outputTransRot(this.tempP3, pt1, 0, 0, 1);
        this.tempP3.set(1.0f, 1.0f, 1.0f);
        this.tempP3.scale(radius);
        this.outputAttr("scale", this.tempP3.x, this.tempP3.y, this.tempP3.z);
        this.output(">\n<Billboard ");
        if (child.charAt(0) == '_') {
            int i;
            this.output("DEF='" + child + "'");
            this.output(" axisOfRotation='0 0 0'>");
            this.pushMatrix();
            this.output("<Shape><Extrusion beginCap='false' convex='false' endCap='false' creaseAngle='1.57'");
            this.output(" crossSection='");
            float rpd = (float)Math.PI / 180;
            float scale = 0.02f / radius;
            for (i = 0; i <= 360; i += 10) {
                this.output(_X3dExporter.round(Math.cos((float)i * rpd) * (double)scale) + " ");
                this.output(_X3dExporter.round(Math.sin((float)i * rpd) * (double)scale) + " ");
            }
            this.output("' spine='");
            for (i = 0; i <= 360; i += 10) {
                this.output(_X3dExporter.round(Math.cos((float)i * rpd)) + " ");
                this.output(_X3dExporter.round(Math.sin((float)i * rpd)) + " 0 ");
            }
            this.output("'/>");
            this.outputAppearance(colix, false);
            this.output("</Shape>");
            this.popMatrix();
        } else {
            this.output(child + ">");
        }
        this.output("</Billboard>\n");
        this.popMatrix();
    }

    @Override
    protected void outputGeometry(T3[] vertices, T3[] normals, short[] colixes, int[][] indices, short[] polygonColixes, int nVertices, int nPolygons, BS bsPolygons, int faceVertexMax, Lst<Short> colorList, Map<Short, Integer> htColixes, P3 offset) {
        this.output(" creaseAngle='0.5'\n");
        if (polygonColixes != null) {
            this.output(" colorPerVertex='false'\n");
        }
        this.output("coordIndex='\n");
        int[] map = new int[nVertices];
        this.getCoordinateMap(vertices, map, null);
        this.outputIndices(indices, map, nPolygons, bsPolygons, faceVertexMax);
        this.output("'\n");
        Lst<String> vNormals = null;
        if (normals != null) {
            vNormals = new Lst<String>();
            map = this.getNormalMap(normals, nVertices, null, vNormals);
            this.output("  solid='false'\n  normalPerVertex='true'\n  normalIndex='\n");
            this.outputIndices(indices, map, nPolygons, bsPolygons, faceVertexMax);
            this.output("'\n");
        }
        map = null;
        if (colorList != null) {
            this.output("  colorIndex='\n");
            this.outputColorIndices(indices, nPolygons, bsPolygons, faceVertexMax, htColixes, colixes, polygonColixes);
            this.output("'\n");
        }
        this.output(">\n");
        this.output("<Coordinate point='\n");
        this.outputVertices(vertices, nVertices, offset);
        this.output("'/>\n");
        if (normals != null) {
            this.output("<Normal vector='\n");
            this.outputNormals(vNormals);
            vNormals = null;
            this.output("'/>\n");
        }
        if (colorList != null) {
            this.output("<Color color='\n");
            this.outputColors(colorList);
            this.output("'/>\n");
        }
    }

    @Override
    protected void outputTextPixel(P3 pt, int argb) {
    }

    @Override
    void plotText(int x, int y, int z, short colix, String text, Font font3d) {
    }
}

