/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.ChangesetDataSet;
import org.openstreetmap.josm.data.osm.ChangesetDiscussionComment;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.date.DateUtils;

public final class Changeset
implements Tagged,
Comparable<Changeset> {
    public static final int MAX_CHANGESET_TAG_LENGTH = 255;
    private int id;
    private User user;
    private Date createdAt;
    private Date closedAt;
    private boolean open;
    private LatLon min;
    private LatLon max;
    private int commentsCount;
    private Map<String, String> tags;
    private boolean incomplete;
    private ChangesetDataSet content;
    private List<ChangesetDiscussionComment> discussion;

    public Changeset() {
        this(0);
    }

    public Changeset(int n) {
        this.id = n;
        this.incomplete = n > 0;
        this.tags = new HashMap<String, String>();
    }

    public Changeset(Changeset changeset) {
        if (changeset == null) {
            this.id = 0;
            this.tags = new HashMap<String, String>();
        } else if (changeset.isIncomplete()) {
            this.setId(changeset.getId());
            this.incomplete = true;
            this.tags = new HashMap<String, String>();
        } else {
            this.id = changeset.id;
            this.mergeFrom(changeset);
            this.incomplete = false;
        }
    }

    public static Changeset fromPrimitive(OsmPrimitive osmPrimitive) {
        Changeset changeset = new Changeset(osmPrimitive.getChangesetId());
        changeset.setUser(osmPrimitive.getUser());
        changeset.setCreatedAt(osmPrimitive.getTimestamp());
        return changeset;
    }

    public void visit(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public int compareTo(Changeset changeset) {
        return Integer.compare(this.getId(), changeset.getId());
    }

    public String getName() {
        return "changeset " + this.getId();
    }

    public String getDisplayName(NameFormatter nameFormatter) {
        return nameFormatter.format(this);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Date getCreatedAt() {
        return DateUtils.cloneDate(this.createdAt);
    }

    public void setCreatedAt(Date date) {
        this.createdAt = DateUtils.cloneDate(date);
    }

    public Date getClosedAt() {
        return DateUtils.cloneDate(this.closedAt);
    }

    public void setClosedAt(Date date) {
        this.closedAt = DateUtils.cloneDate(date);
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean bl) {
        this.open = bl;
    }

    public LatLon getMin() {
        return this.min;
    }

    public void setMin(LatLon latLon) {
        this.min = latLon;
    }

    public LatLon getMax() {
        return this.max;
    }

    public void setMax(LatLon latLon) {
        this.max = latLon;
    }

    public Bounds getBounds() {
        if (this.min != null && this.max != null) {
            return new Bounds(this.min, this.max);
        }
        return null;
    }

    public String getComment() {
        return Optional.ofNullable(this.get("comment")).orElse("");
    }

    public int getCommentsCount() {
        return this.commentsCount;
    }

    public void setCommentsCount(int n) {
        this.commentsCount = n;
    }

    @Override
    public Map<String, String> getKeys() {
        return this.tags;
    }

    @Override
    public void setKeys(Map<String, String> map) {
        CheckParameterUtil.ensureParameterNotNull(map, "keys");
        map.values().stream().filter(string -> string != null && string.length() > 255).findFirst().ifPresent(string -> {
            throw new IllegalArgumentException("Changeset tag value is too long: " + string);
        });
        this.tags = map;
    }

    public boolean isIncomplete() {
        return this.incomplete;
    }

    public void setIncomplete(boolean bl) {
        this.incomplete = bl;
    }

    @Override
    public void put(String string, String string2) {
        CheckParameterUtil.ensureParameterNotNull(string, "key");
        if (string2 != null && string2.length() > 255) {
            throw new IllegalArgumentException("Changeset tag value is too long: " + string2);
        }
        this.tags.put(string, string2);
    }

    @Override
    public String get(String string) {
        return this.tags.get(string);
    }

    @Override
    public void remove(String string) {
        this.tags.remove(string);
    }

    @Override
    public void removeAll() {
        this.tags.clear();
    }

    public boolean hasEqualSemanticAttributes(Changeset changeset) {
        if (changeset == null) {
            return false;
        }
        if (this.closedAt == null ? changeset.closedAt != null : !this.closedAt.equals(changeset.closedAt)) {
            return false;
        }
        if (this.createdAt == null ? changeset.createdAt != null : !this.createdAt.equals(changeset.createdAt)) {
            return false;
        }
        if (this.id != changeset.id) {
            return false;
        }
        if (this.max == null ? changeset.max != null : !this.max.equals(changeset.max)) {
            return false;
        }
        if (this.min == null ? changeset.min != null : !this.min.equals(changeset.min)) {
            return false;
        }
        if (this.open != changeset.open) {
            return false;
        }
        if (!this.tags.equals(changeset.tags)) {
            return false;
        }
        if (this.user == null ? changeset.user != null : !this.user.equals(changeset.user)) {
            return false;
        }
        return this.commentsCount == changeset.commentsCount;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Changeset changeset = (Changeset)object;
        return this.id == changeset.id;
    }

    @Override
    public boolean hasKeys() {
        return !this.tags.keySet().isEmpty();
    }

    @Override
    public Collection<String> keySet() {
        return this.tags.keySet();
    }

    public boolean isNew() {
        return this.id <= 0;
    }

    public void mergeFrom(Changeset changeset) {
        if (changeset == null) {
            return;
        }
        if (this.id != changeset.id) {
            return;
        }
        this.user = changeset.user;
        this.createdAt = DateUtils.cloneDate(changeset.createdAt);
        this.closedAt = DateUtils.cloneDate(changeset.closedAt);
        this.open = changeset.open;
        this.min = changeset.min;
        this.max = changeset.max;
        this.commentsCount = changeset.commentsCount;
        this.tags = new HashMap<String, String>(changeset.tags);
        this.incomplete = changeset.incomplete;
        this.discussion = changeset.discussion != null ? new ArrayList<ChangesetDiscussionComment>(changeset.discussion) : null;
        this.content = changeset.content;
    }

    public boolean hasContent() {
        return this.content != null;
    }

    public ChangesetDataSet getContent() {
        return this.content;
    }

    public void setContent(ChangesetDataSet changesetDataSet) {
        this.content = changesetDataSet;
    }

    public synchronized List<ChangesetDiscussionComment> getDiscussion() {
        if (this.discussion == null) {
            return Collections.emptyList();
        }
        return new ArrayList<ChangesetDiscussionComment>(this.discussion);
    }

    public synchronized void addDiscussionComment(ChangesetDiscussionComment changesetDiscussionComment) {
        if (changesetDiscussionComment == null) {
            return;
        }
        if (this.discussion == null) {
            this.discussion = new ArrayList<ChangesetDiscussionComment>();
        }
        this.discussion.add(changesetDiscussionComment);
    }
}

