/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Objects;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.tools.Pair;

public class NodePair {
    private final Node a;
    private final Node b;

    public NodePair(Node node, Node node2) {
        this.a = node;
        this.b = node2;
    }

    public NodePair(Pair<Node, Node> pair) {
        this((Node)pair.a, (Node)pair.b);
    }

    public Node getA() {
        return this.a;
    }

    public Node getB() {
        return this.b;
    }

    public boolean isSuccessorOf(NodePair nodePair) {
        return nodePair.getB() == this.a;
    }

    public boolean isPredecessorOf(NodePair nodePair) {
        return this.b == nodePair.getA();
    }

    public NodePair swap() {
        return new NodePair(this.b, this.a);
    }

    public String toString() {
        return "" + '[' + this.a.getId() + ',' + this.b.getId() + ']';
    }

    public boolean contains(Node node) {
        return this.a == node || this.b == node;
    }

    public int hashCode() {
        return Objects.hash(this.a, this.b);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        NodePair nodePair = (NodePair)object;
        return Objects.equals(this.a, nodePair.a) && Objects.equals(this.b, nodePair.b);
    }
}

