/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.mapcss;

import java.awt.Color;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.mapcss.Expression;
import org.openstreetmap.josm.gui.util.RotationAngle;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.AlphanumComparator;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.RightAndLefthandTraffic;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.Territories;
import org.openstreetmap.josm.tools.Utils;

public final class ExpressionFactory {
    private static final List<Method> arrayFunctions = new ArrayList<Method>();
    private static final List<Method> parameterFunctions = new ArrayList<Method>();
    private static final List<Method> parameterFunctionsEnv = new ArrayList<Method>();

    private ExpressionFactory() {
    }

    public static Expression createFunctionExpression(String string, List<Expression> list) {
        if ("cond".equals(string) && list.size() == 3) {
            return new CondOperator(list.get(0), list.get(1), list.get(2));
        }
        if ("and".equals(string)) {
            return new AndOperator(list);
        }
        if ("or".equals(string)) {
            return new OrOperator(list);
        }
        if ("length".equals(string) && list.size() == 1) {
            return new LengthFunction(list.get(0));
        }
        if ("max".equals(string) && !list.isEmpty()) {
            return new MinMaxFunction(list, true);
        }
        if ("min".equals(string) && !list.isEmpty()) {
            return new MinMaxFunction(list, false);
        }
        for (Method method : arrayFunctions) {
            if (!method.getName().equals(string)) continue;
            return new ArrayFunction(method, list);
        }
        for (Method method : parameterFunctions) {
            if (!method.getName().equals(string) || list.size() != method.getParameterTypes().length) continue;
            return new ParameterFunction(method, list, false);
        }
        for (Method method : parameterFunctionsEnv) {
            if (!method.getName().equals(string) || list.size() != method.getParameterTypes().length - 1) continue;
            return new ParameterFunction(method, list, true);
        }
        return NullExpression.INSTANCE;
    }

    static {
        for (Method method : Functions.class.getDeclaredMethods()) {
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length == 1 && classArray[0].isArray()) {
                arrayFunctions.add(method);
                continue;
            }
            if (classArray.length >= 1 && classArray[0].equals(Environment.class)) {
                parameterFunctionsEnv.add(method);
                continue;
            }
            parameterFunctions.add(method);
        }
        try {
            parameterFunctions.add(Math.class.getMethod("abs", Float.TYPE));
            parameterFunctions.add(Math.class.getMethod("acos", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("asin", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("atan", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("atan2", Double.TYPE, Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("ceil", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("cos", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("cosh", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("exp", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("floor", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("log", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("max", Float.TYPE, Float.TYPE));
            parameterFunctions.add(Math.class.getMethod("min", Float.TYPE, Float.TYPE));
            parameterFunctions.add(Math.class.getMethod("random", new Class[0]));
            parameterFunctions.add(Math.class.getMethod("round", Float.TYPE));
            parameterFunctions.add(Math.class.getMethod("signum", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("sin", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("sinh", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("sqrt", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("tan", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("tanh", Double.TYPE));
        }
        catch (NoSuchMethodException | SecurityException exception) {
            throw new JosmRuntimeException(exception);
        }
    }

    public static class ArrayFunction
    implements Expression {
        private final Method m;
        private final boolean nullable;
        private final List<Expression> args;
        private final Class<?>[] expectedParameterTypes;
        private final Class<?> arrayComponentType;

        public ArrayFunction(Method method, List<Expression> list) {
            this.m = method;
            this.nullable = method.getAnnotation(NullableArguments.class) != null;
            this.args = list;
            this.expectedParameterTypes = method.getParameterTypes();
            this.arrayComponentType = this.expectedParameterTypes[0].getComponentType();
        }

        @Override
        public Object evaluate(Environment environment) {
            Object[] objectArray = new Object[this.expectedParameterTypes.length];
            Object object = Array.newInstance(this.arrayComponentType, this.args.size());
            for (int i = 0; i < this.args.size(); ++i) {
                Object obj = Cascade.convertTo(this.args.get(i).evaluate(environment), this.arrayComponentType);
                if (obj == null && !this.nullable) {
                    return null;
                }
                Array.set(object, i, obj);
            }
            objectArray[0] = object;
            Object object2 = null;
            try {
                object2 = this.m.invoke(null, objectArray);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                throw new JosmRuntimeException(exception);
            }
            catch (InvocationTargetException invocationTargetException) {
                Main.error(invocationTargetException);
                return null;
            }
            return object2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("ArrayFunction~");
            stringBuilder.append(this.m.getName()).append('(');
            for (int i = 0; i < this.args.size(); ++i) {
                if (i > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(this.arrayComponentType).append(' ').append(this.args.get(i));
            }
            stringBuilder.append(')');
            return stringBuilder.toString();
        }
    }

    public static class ParameterFunction
    implements Expression {
        private final Method m;
        private final boolean nullable;
        private final List<Expression> args;
        private final Class<?>[] expectedParameterTypes;
        private final boolean needsEnvironment;

        public ParameterFunction(Method method, List<Expression> list, boolean bl) {
            this.m = method;
            this.nullable = method.getAnnotation(NullableArguments.class) != null;
            this.args = list;
            this.expectedParameterTypes = method.getParameterTypes();
            this.needsEnvironment = bl;
        }

        @Override
        public Object evaluate(Environment environment) {
            int n;
            Object[] objectArray;
            if (this.needsEnvironment) {
                objectArray = new Object[this.args.size() + 1];
                objectArray[0] = environment;
                for (n = 1; n < objectArray.length; ++n) {
                    objectArray[n] = Cascade.convertTo(this.args.get(n - 1).evaluate(environment), this.expectedParameterTypes[n]);
                    if (objectArray[n] != null || this.nullable) continue;
                    return null;
                }
            } else {
                objectArray = new Object[this.args.size()];
                for (n = 0; n < objectArray.length; ++n) {
                    objectArray[n] = Cascade.convertTo(this.args.get(n).evaluate(environment), this.expectedParameterTypes[n]);
                    if (objectArray[n] != null || this.nullable) continue;
                    return null;
                }
            }
            Object object = null;
            try {
                object = this.m.invoke(null, objectArray);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                throw new JosmRuntimeException(exception);
            }
            catch (InvocationTargetException invocationTargetException) {
                Main.error(invocationTargetException);
                return null;
            }
            return object;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("ParameterFunction~");
            stringBuilder.append(this.m.getName()).append('(');
            for (int i = 0; i < this.expectedParameterTypes.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(this.expectedParameterTypes[i]);
                if (!this.needsEnvironment) {
                    stringBuilder.append(' ').append(this.args.get(i));
                    continue;
                }
                if (i <= 0) continue;
                stringBuilder.append(' ').append(this.args.get(i - 1));
            }
            stringBuilder.append(')');
            return stringBuilder.toString();
        }
    }

    public static class MinMaxFunction
    implements Expression {
        private final List<Expression> args;
        private final boolean computeMax;

        public MinMaxFunction(List<Expression> list, boolean bl) {
            this.args = list;
            this.computeMax = bl;
        }

        public Float aggregateList(List<?> list) {
            List<Float> list2 = Utils.transform(list, object -> Cascade.convertTo(object, Float.TYPE));
            SubclassFilteredCollection<Float, Float> subclassFilteredCollection = SubclassFilteredCollection.filter(list2, Objects::nonNull);
            return subclassFilteredCollection.isEmpty() ? Float.valueOf(Float.NaN) : (this.computeMax ? (Float)Collections.max(subclassFilteredCollection) : (Float)Collections.min(subclassFilteredCollection));
        }

        @Override
        public Object evaluate(Environment environment) {
            List<Object> list = Cascade.convertTo(this.args.get(0).evaluate(environment), List.class);
            if (this.args.size() != 1 || list == null) {
                list = Utils.transform(this.args, expression -> expression.evaluate(environment));
            }
            return this.aggregateList(list);
        }
    }

    public static class LengthFunction
    implements Expression {
        private final Expression arg;

        public LengthFunction(Expression expression) {
            this.arg = expression;
        }

        @Override
        public Object evaluate(Environment environment) {
            List list = Cascade.convertTo(this.arg.evaluate(environment), List.class);
            if (list != null) {
                return list.size();
            }
            String string = Cascade.convertTo(this.arg.evaluate(environment), String.class);
            if (string != null) {
                return string.length();
            }
            return null;
        }
    }

    public static class OrOperator
    implements Expression {
        private final List<Expression> args;

        public OrOperator(List<Expression> list) {
            this.args = list;
        }

        @Override
        public Object evaluate(Environment environment) {
            for (Expression expression : this.args) {
                Boolean bl = Cascade.convertTo(expression.evaluate(environment), Boolean.TYPE);
                if (bl == null || !bl.booleanValue()) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }

    public static class AndOperator
    implements Expression {
        private final List<Expression> args;

        public AndOperator(List<Expression> list) {
            this.args = list;
        }

        @Override
        public Object evaluate(Environment environment) {
            for (Expression expression : this.args) {
                Boolean bl = Cascade.convertTo(expression.evaluate(environment), Boolean.TYPE);
                if (bl != null && bl.booleanValue()) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
    }

    public static class CondOperator
    implements Expression {
        private final Expression condition;
        private final Expression firstOption;
        private final Expression secondOption;

        public CondOperator(Expression expression, Expression expression2, Expression expression3) {
            this.condition = expression;
            this.firstOption = expression2;
            this.secondOption = expression3;
        }

        @Override
        public Object evaluate(Environment environment) {
            Boolean bl = Cascade.convertTo(this.condition.evaluate(environment), Boolean.TYPE);
            if (bl != null && bl.booleanValue()) {
                return this.firstOption.evaluate(environment);
            }
            return this.secondOption.evaluate(environment);
        }
    }

    public static class NullExpression
    implements Expression {
        public static final NullExpression INSTANCE = new NullExpression();

        @Override
        public Object evaluate(Environment environment) {
            return null;
        }
    }

    public static final class Functions {
        private Functions() {
        }

        public static Object eval(Object object) {
            return object;
        }

        public static float plus(float ... fArray) {
            float f = 0.0f;
            for (float f2 : fArray) {
                f += f2;
            }
            return f;
        }

        public static Float minus(float ... fArray) {
            if (fArray.length == 0) {
                return Float.valueOf(0.0f);
            }
            if (fArray.length == 1) {
                return Float.valueOf(-fArray[0]);
            }
            float f = fArray[0];
            for (int i = 1; i < fArray.length; ++i) {
                f -= fArray[i];
            }
            return Float.valueOf(f);
        }

        public static float times(float ... fArray) {
            float f = 1.0f;
            for (float f2 : fArray) {
                f *= f2;
            }
            return f;
        }

        public static Float divided_by(float ... fArray) {
            if (fArray.length == 0) {
                return Float.valueOf(1.0f);
            }
            float f = fArray[0];
            for (int i = 1; i < fArray.length; ++i) {
                if (fArray[i] == 0.0f) {
                    return null;
                }
                f /= fArray[i];
            }
            return Float.valueOf(f);
        }

        public static List<Object> list(Object ... objectArray) {
            return Arrays.asList(objectArray);
        }

        public static Integer count(List<?> list) {
            return list.size();
        }

        @NullableArguments
        public static Object any(Object ... objectArray) {
            return Utils.firstNonNull(objectArray);
        }

        public static Object get(List<?> list, float f) {
            int n = Math.round(f);
            if (n >= 0 && n < list.size()) {
                return list.get(n);
            }
            return null;
        }

        public static List<String> split(String string, String string2) {
            return Arrays.asList(string2.split(Pattern.quote(string), -1));
        }

        public static Color rgb(float f, float f2, float f3) {
            try {
                return new Color(f, f2, f3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Main.trace(illegalArgumentException);
                return null;
            }
        }

        public static Color rgba(float f, float f2, float f3, float f4) {
            try {
                return new Color(f, f2, f3, f4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Main.trace(illegalArgumentException);
                return null;
            }
        }

        public static Color hsb_color(float f, float f2, float f3) {
            try {
                return Color.getHSBColor(f, f2, f3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Main.trace(illegalArgumentException);
                return null;
            }
        }

        public static Color html2color(String string) {
            return ColorHelper.html2color(string);
        }

        public static String color2html(Color color) {
            return ColorHelper.color2html(color);
        }

        public static float red(Color color) {
            return Utils.colorInt2float(color.getRed()).floatValue();
        }

        public static float green(Color color) {
            return Utils.colorInt2float(color.getGreen()).floatValue();
        }

        public static float blue(Color color) {
            return Utils.colorInt2float(color.getBlue()).floatValue();
        }

        public static float alpha(Color color) {
            return Utils.colorInt2float(color.getAlpha()).floatValue();
        }

        @NullableArguments
        public static String concat(Object ... objectArray) {
            return Utils.join("", Arrays.asList(objectArray));
        }

        @NullableArguments
        public static String join(String ... stringArray) {
            return Utils.join(stringArray[0], Arrays.asList(stringArray).subList(1, stringArray.length));
        }

        public static String join_list(String string, List<String> list) {
            return Utils.join(string, list);
        }

        public static Object prop(Environment environment, String string) {
            return Functions.prop(environment, string, null);
        }

        public static Object prop(Environment environment, String string, String string2) {
            return environment.getCascade(string2).get(string);
        }

        public static Boolean is_prop_set(Environment environment, String string) {
            return Functions.is_prop_set(environment, string, null);
        }

        public static Boolean is_prop_set(Environment environment, String string, String string2) {
            return environment.getCascade(string2).containsKey(string);
        }

        public static String tag(Environment environment, String string) {
            return environment.osm == null ? null : environment.osm.get(string);
        }

        public static String parent_tag(Environment environment, String string) {
            if (environment.parent == null) {
                if (environment.osm != null) {
                    for (OsmPrimitive osmPrimitive : environment.osm.getReferrers()) {
                        String string2 = osmPrimitive.get(string);
                        if (string2 == null) continue;
                        return string2;
                    }
                }
                return null;
            }
            return environment.parent.get(string);
        }

        public static List<String> parent_tags(Environment environment, String string) {
            if (environment.parent == null) {
                if (environment.osm != null) {
                    TreeSet<String> treeSet = new TreeSet<String>(AlphanumComparator.getInstance());
                    for (OsmPrimitive osmPrimitive : environment.osm.getReferrers()) {
                        String string2 = osmPrimitive.get(string);
                        if (string2 == null) continue;
                        treeSet.add(string2);
                    }
                    return new ArrayList<String>(treeSet);
                }
                return Collections.emptyList();
            }
            return Collections.singletonList(environment.parent.get(string));
        }

        public static String child_tag(Environment environment, String string) {
            return environment.child == null ? null : environment.child.get(string);
        }

        public static boolean has_tag_key(Environment environment, String string) {
            return environment.osm.hasKey(string);
        }

        public static Float index(Environment environment) {
            if (environment.index == null) {
                return null;
            }
            return Float.valueOf((float)environment.index.intValue() + 1.0f);
        }

        public static String role(Environment environment) {
            return environment.getRole();
        }

        public static Float areasize(Environment environment) {
            Double d = Geometry.computeArea(environment.osm);
            return d == null ? null : Float.valueOf(d.floatValue());
        }

        public static Float waylength(Environment environment) {
            if (environment.osm instanceof Way) {
                return Float.valueOf((float)((Way)environment.osm).getLength());
            }
            return null;
        }

        public static boolean not(boolean bl) {
            return !bl;
        }

        public static boolean greater_equal(float f, float f2) {
            return f >= f2;
        }

        public static boolean less_equal(float f, float f2) {
            return f <= f2;
        }

        public static boolean greater(float f, float f2) {
            return f > f2;
        }

        public static boolean less(float f, float f2) {
            return f < f2;
        }

        public static double degree_to_radians(double d) {
            return Utils.toRadians(d);
        }

        public static Double cardinal_to_radians(String string) {
            try {
                return RotationAngle.parseCardinalRotation(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Main.trace(illegalArgumentException);
                return null;
            }
        }

        public static boolean equal(Object object, Object object2) {
            if (object.getClass() == object2.getClass()) {
                return object.equals(object2);
            }
            if (object.equals(Cascade.convertTo(object2, object.getClass()))) {
                return true;
            }
            return object2.equals(Cascade.convertTo(object, object2.getClass()));
        }

        public static boolean not_equal(Object object, Object object2) {
            return !Functions.equal(object, object2);
        }

        public static Boolean JOSM_search(Environment environment, String string) {
            SearchCompiler.Match match;
            try {
                match = SearchCompiler.compile(string);
            }
            catch (SearchCompiler.ParseError parseError) {
                Main.trace(parseError);
                return null;
            }
            return match.match(environment.osm);
        }

        public static String JOSM_pref(Environment environment, String string, String string2) {
            return MapPaintStyles.getStyles().getPreferenceCached(string, string2);
        }

        public static boolean regexp_test(String string, String string2) {
            return Pattern.matches(string, string2);
        }

        public static boolean regexp_test(String string, String string2, String string3) {
            int n = 0;
            if (string3.contains("i")) {
                n |= 2;
            }
            if (string3.contains("s")) {
                n |= 0x20;
            }
            if (string3.contains("m")) {
                n |= 8;
            }
            return Pattern.compile(string, n).matcher(string2).matches();
        }

        public static List<String> regexp_match(String string, String string2, String string3) {
            int n = 0;
            if (string3.contains("i")) {
                n |= 2;
            }
            if (string3.contains("s")) {
                n |= 0x20;
            }
            if (string3.contains("m")) {
                n |= 8;
            }
            return Utils.getMatches(Pattern.compile(string, n).matcher(string2));
        }

        public static List<String> regexp_match(String string, String string2) {
            return Utils.getMatches(Pattern.compile(string).matcher(string2));
        }

        public static long osm_id(Environment environment) {
            return environment.osm.getUniqueId();
        }

        @NullableArguments
        public static String tr(String ... stringArray) {
            String string = stringArray[0];
            System.arraycopy(stringArray, 1, stringArray, 0, stringArray.length - 1);
            return I18n.tr(string, stringArray);
        }

        public static String substring(String string, float f) {
            return string == null ? null : string.substring((int)f);
        }

        public static String substring(String string, float f, float f2) {
            return string == null ? null : string.substring((int)f, (int)f2);
        }

        public static String replace(String string, String string2, String string3) {
            return string == null ? null : string.replace(string2, string3);
        }

        public static String upper(String string) {
            return string == null ? null : string.toUpperCase(Locale.ENGLISH);
        }

        public static String lower(String string) {
            return string == null ? null : string.toLowerCase(Locale.ENGLISH);
        }

        public static String trim(String string) {
            return Utils.strip(string);
        }

        public static String URL_decode(String string) {
            if (string == null) {
                return null;
            }
            try {
                return Utils.decodeUrl(string);
            }
            catch (IllegalStateException illegalStateException) {
                Main.debug(illegalStateException);
                return string;
            }
        }

        public static String URL_encode(String string) {
            return string == null ? null : Utils.encodeUrl(string);
        }

        public static String XML_encode(String string) {
            return string == null ? null : XmlWriter.encode(string);
        }

        public static long CRC32_checksum(String string) {
            CRC32 cRC32 = new CRC32();
            cRC32.update(string.getBytes(StandardCharsets.UTF_8));
            return cRC32.getValue();
        }

        public static boolean is_right_hand_traffic(Environment environment) {
            return RightAndLefthandTraffic.isRightHandTraffic(Functions.center(environment));
        }

        public static boolean is_clockwise(Environment environment) {
            if (!(environment.osm instanceof Way)) {
                return false;
            }
            Way way = (Way)environment.osm;
            return way.isClosed() && Geometry.isClockwise(way) || !way.isClosed() && way.getNodesCount() > 2 && Geometry.angleIsClockwise(way.getNode(0), way.getNode(1), way.lastNode());
        }

        public static boolean is_anticlockwise(Environment environment) {
            if (!(environment.osm instanceof Way)) {
                return false;
            }
            Way way = (Way)environment.osm;
            return way.isClosed() && !Geometry.isClockwise(way) || !way.isClosed() && way.getNodesCount() > 2 && !Geometry.angleIsClockwise(way.getNode(0), way.getNode(1), way.lastNode());
        }

        @NullableArguments
        public static Object print(Object object) {
            System.out.print(object == null ? "none" : object.toString());
            return object;
        }

        @NullableArguments
        public static Object println(Object object) {
            System.out.println(object == null ? "none" : object.toString());
            return object;
        }

        public static int number_of_tags(Environment environment) {
            return environment.osm.getNumKeys();
        }

        public static Object setting(Environment environment, String string) {
            return environment.source.settingValues.get(string);
        }

        public static LatLon center(Environment environment) {
            return environment.osm instanceof Node ? ((Node)environment.osm).getCoor() : environment.osm.getBBox().getCenter();
        }

        public static boolean inside(Environment environment, String string) {
            for (String string2 : string.toUpperCase(Locale.ENGLISH).split(",")) {
                if (!Territories.isIso3166Code(string2.trim(), Functions.center(environment))) continue;
                return true;
            }
            return false;
        }

        public static boolean outside(Environment environment, String string) {
            return !Functions.inside(environment, string);
        }

        public static boolean at(Environment environment, double d, double d2) {
            return new LatLon(d, d2).equalsEpsilon(Functions.center(environment));
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface NullableArguments {
    }
}

