/**
 * Composes single-argument functions from right to left.
 *
 * @param {...Function} funcs The functions to compose.
 * @returns {Function} A function obtained by composing functions from right to
 * left. For example, compose(f, g, h) is identical to x => h(g(f(x))).
 */
export default function compose(...funcs) {
  return arg => funcs.reduceRight((composed, f) => f(composed), arg);
}
