/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ReadOnlyModificationException;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.editor.impl.LineSet;
import com.intellij.openapi.editor.impl.LockFreeCOWSortedArray;
import com.intellij.openapi.editor.impl.PersistentRangeMarker;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.ImmutableCharSequence;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class DocumentImpl
extends UserDataHolderBase
implements DocumentEx {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.editor.impl.DocumentImpl");
    private final LockFreeCOWSortedArray<DocumentListener> myDocumentListeners;
    private final List<DocumentBulkUpdateListener> myBulkDocumentInternalListeners;
    private final RangeMarkerTree<RangeMarkerEx> myRangeMarkers;
    private final RangeMarkerTree<RangeMarkerEx> myPersistentRangeMarkers;
    private final List<RangeMarker> myGuardedBlocks;
    private final Object myLineSetLock;
    private volatile LineSet myLineSet;
    private volatile ImmutableCharSequence myText;
    private volatile SoftReference<String> myTextString;
    private volatile FrozenDocument myFrozen;
    private boolean myIsReadOnly;
    private volatile boolean isStripTrailingSpacesEnabled;
    private volatile long myModificationStamp;
    private final PropertyChangeSupport myPropertyChangeSupport;
    private final List<Object> myReadOnlyListeners;
    private int myCheckGuardedBlocks;
    private boolean myGuardsSuppressed;
    private boolean myEventsHandling;
    private final boolean myAssertThreading;
    private volatile boolean myDoingBulkUpdate;
    private volatile boolean myAcceptSlashR;
    private boolean myChangeInProgress;
    private volatile int myBufferSize;
    private final CharSequence myMutableCharSequence;
    private final AtomicInteger sequence;

    public DocumentImpl(@NotNull CharSequence chars) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/editor/impl/DocumentImpl", "<init>"));
        }
        this(chars, false);
    }

    public DocumentImpl(@NotNull CharSequence chars, boolean forUseInNonAWTThread) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/editor/impl/DocumentImpl", "<init>"));
        }
        this(chars, false, forUseInNonAWTThread);
    }

    public DocumentImpl(@NotNull CharSequence chars, boolean acceptSlashR, boolean forUseInNonAWTThread) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/editor/impl/DocumentImpl", "<init>"));
        }
        this.myDocumentListeners = new LockFreeCOWSortedArray<DocumentListener>(PrioritizedDocumentListener.COMPARATOR, DocumentListener.ARRAY_FACTORY);
        this.myBulkDocumentInternalListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myRangeMarkers = new RangeMarkerTree(this);
        this.myPersistentRangeMarkers = new RangeMarkerTree(this);
        this.myGuardedBlocks = new ArrayList<RangeMarker>();
        this.myLineSetLock = new String("line set lock");
        this.isStripTrailingSpacesEnabled = true;
        this.myPropertyChangeSupport = new PropertyChangeSupport(this);
        this.myReadOnlyListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myMutableCharSequence = new CharSequence(){

            @Override
            public int length() {
                return DocumentImpl.this.myText.length();
            }

            @Override
            public char charAt(int index2) {
                return DocumentImpl.this.myText.charAt(index2);
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                return DocumentImpl.this.myText.subSequence(start, end);
            }

            @Override
            @NotNull
            public String toString() {
                String string = DocumentImpl.this.doGetText();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl$1", "toString"));
                }
                return string;
            }
        };
        this.sequence = new AtomicInteger();
        this.setAcceptSlashR(acceptSlashR);
        this.assertValidSeparators(chars);
        this.myText = CharArrayUtil.createImmutableCharSequence(chars);
        this.setCyclicBufferSize(0);
        this.setModificationStamp(LocalTimeCounter.currentTime());
        this.myAssertThreading = !forUseInNonAWTThread;
    }

    public boolean setAcceptSlashR(boolean accept) {
        try {
            boolean bl = this.myAcceptSlashR;
            return bl;
        }
        finally {
            this.myAcceptSlashR = accept;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LineSet getLineSet() {
        LineSet lineSet = this.myLineSet;
        if (lineSet == null) {
            Object object = this.myLineSetLock;
            synchronized (object) {
                lineSet = this.myLineSet;
                if (lineSet == null) {
                    this.myLineSet = lineSet = LineSet.createLineSet(this.myText);
                }
            }
        }
        return lineSet;
    }

    @Override
    public void setReadOnly(boolean isReadOnly) {
        if (this.myIsReadOnly != isReadOnly) {
            this.myIsReadOnly = isReadOnly;
            this.myPropertyChangeSupport.firePropertyChange("writable", !isReadOnly, isReadOnly);
        }
    }

    @Override
    public boolean isWritable() {
        return !this.myIsReadOnly;
    }

    private RangeMarkerTree<RangeMarkerEx> treeFor(@NotNull RangeMarkerEx rangeMarker) {
        if (rangeMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/intellij/openapi/editor/impl/DocumentImpl", "treeFor"));
        }
        return rangeMarker instanceof PersistentRangeMarker ? this.myPersistentRangeMarkers : this.myRangeMarkers;
    }

    @Override
    public boolean removeRangeMarker(@NotNull RangeMarkerEx rangeMarker) {
        if (rangeMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/intellij/openapi/editor/impl/DocumentImpl", "removeRangeMarker"));
        }
        return this.treeFor(rangeMarker).removeInterval(rangeMarker);
    }

    public RangeMarker getRangeGuard(int start, int end) {
        for (RangeMarker block : this.myGuardedBlocks) {
            if (!DocumentImpl.rangesIntersect(start, end, true, true, block.getStartOffset(), block.getEndOffset(), block.isGreedyToLeft(), block.isGreedyToRight())) continue;
            return block;
        }
        return null;
    }

    private static boolean rangesIntersect(int start0, int end0, boolean start0Inclusive, boolean end0Inclusive, int start1, int end1, boolean start1Inclusive, boolean end1Inclusive) {
        if (start0 > start1 || start0 == start1 && !start0Inclusive) {
            if (end1 == start0) {
                return start0Inclusive && end1Inclusive;
            }
            return end1 > start0;
        }
        if (end0 == start1) {
            return start1Inclusive && end0Inclusive;
        }
        return end0 > start1;
    }

    @Override
    public long getModificationStamp() {
        return this.myModificationStamp;
    }

    @Override
    public void setModificationStamp(long modificationStamp) {
        this.myModificationStamp = modificationStamp;
    }

    private void trimToSize() {
        if (this.myBufferSize != 0 && this.getTextLength() > this.myBufferSize) {
            this.deleteString(0, this.getTextLength() - this.myBufferSize);
        }
    }

    public void deleteString(int startOffset, int endOffset) {
        this.assertBounds(startOffset, endOffset);
        this.assertWriteAccess();
        if (!this.isWritable()) {
            throw new ReadOnlyModificationException(this);
        }
        if (startOffset == endOffset) {
            return;
        }
        RangeMarker marker = this.getRangeGuard(startOffset, endOffset);
        if (marker != null) {
            this.throwGuardedFragment(marker, startOffset, this.myText.subSequence(startOffset, endOffset), "");
        }
        ImmutableCharSequence newText = this.myText.delete(startOffset, endOffset);
        ImmutableCharSequence oldString = this.myText.subtext(startOffset, endOffset);
        this.updateText(newText, startOffset, oldString, "", false, LocalTimeCounter.currentTime(), startOffset, endOffset - startOffset);
    }

    @Override
    public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/editor/impl/DocumentImpl", "replaceString"));
        }
        this.replaceString(startOffset, endOffset, s, LocalTimeCounter.currentTime(), false);
    }

    private void replaceString(int startOffset, int endOffset, @NotNull CharSequence s, long newModificationStamp, boolean bl) {
        ImmutableCharSequence newText;
        boolean wholeTextReplaced;
        int newEndInString;
        int newStartInString;
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/editor/impl/DocumentImpl", "replaceString"));
        }
        this.assertBounds(startOffset, endOffset);
        this.assertWriteAccess();
        this.assertValidSeparators(s);
        if (!this.isWritable()) {
            throw new ReadOnlyModificationException(this);
        }
        int initialStartOffset = startOffset;
        int initialOldLength = endOffset - startOffset;
        int newStringLength = s.length();
        ImmutableCharSequence chars = this.myText;
        for (newStartInString = 0; newStartInString < newStringLength && startOffset < endOffset && s.charAt(newStartInString) == chars.charAt(startOffset); ++startOffset, ++newStartInString) {
        }
        for (newEndInString = newStringLength; endOffset > startOffset && newEndInString > newStartInString && s.charAt(newEndInString - 1) == chars.charAt(endOffset - 1); --newEndInString, --endOffset) {
        }
        if (startOffset == 0 && endOffset == this.getTextLength()) {
            wholeTextReplaced = true;
        }
        CharSequence changedPart = s.subSequence(newStartInString, newEndInString);
        ImmutableCharSequence sToDelete = this.myText.subtext(startOffset, endOffset);
        RangeMarker guard = this.getRangeGuard(startOffset, endOffset);
        if (guard != null) {
            this.throwGuardedFragment(guard, startOffset, sToDelete, changedPart);
        }
        if (wholeTextReplaced && s instanceof ImmutableCharSequence) {
            newText = (ImmutableCharSequence)s;
        } else {
            newText = this.myText.delete(startOffset, endOffset).insert(startOffset, changedPart);
            changedPart = newText.subtext(startOffset, startOffset + changedPart.length());
        }
        this.updateText(newText, startOffset, sToDelete, changedPart, wholeTextReplaced, newModificationStamp, initialStartOffset, initialOldLength);
        this.trimToSize();
    }

    private void assertBounds(int startOffset, int endOffset) {
        if (startOffset < 0 || startOffset > this.getTextLength()) {
            throw new IndexOutOfBoundsException("Wrong startOffset: " + startOffset + "; documentLength: " + this.getTextLength());
        }
        if (endOffset < 0 || endOffset > this.getTextLength()) {
            throw new IndexOutOfBoundsException("Wrong endOffset: " + endOffset + "; documentLength: " + this.getTextLength());
        }
        if (endOffset < startOffset) {
            throw new IllegalArgumentException("endOffset < startOffset: " + endOffset + " < " + startOffset + "; documentLength: " + this.getTextLength());
        }
    }

    private void assertWriteAccess() {
        Application application;
        if (this.myAssertThreading && (application = ApplicationManager.getApplication()) != null) {
            application.assertWriteAccessAllowed();
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(this);
            if (file2 != null && file2.isInLocalFileSystem()) {
                ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
            }
        }
    }

    private void assertValidSeparators(@NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/editor/impl/DocumentImpl", "assertValidSeparators"));
        }
        if (this.myAcceptSlashR) {
            return;
        }
        StringUtil.assertValidSeparators(s);
    }

    private void assertNotNestedModification() throws IllegalStateException {
        if (this.myChangeInProgress) {
            throw new IllegalStateException("Detected document modification from DocumentListener");
        }
    }

    private void throwGuardedFragment(@NotNull RangeMarker guard, int offset2, @NotNull CharSequence oldString, @NotNull CharSequence newString) {
        if (guard == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "guard", "com/intellij/openapi/editor/impl/DocumentImpl", "throwGuardedFragment"));
        }
        if (oldString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldString", "com/intellij/openapi/editor/impl/DocumentImpl", "throwGuardedFragment"));
        }
        if (newString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newString", "com/intellij/openapi/editor/impl/DocumentImpl", "throwGuardedFragment"));
        }
        if (this.myCheckGuardedBlocks > 0 && !this.myGuardsSuppressed) {
            DocumentEventImpl event = new DocumentEventImpl(this, offset2, oldString, newString, this.myModificationStamp, false);
            throw new ReadOnlyFragmentModificationException(event, guard);
        }
    }

    @Override
    public void suppressGuardedExceptions() {
        this.myGuardsSuppressed = true;
    }

    @Override
    public void unSuppressGuardedExceptions() {
        this.myGuardsSuppressed = false;
    }

    @Override
    public boolean isInEventsHandling() {
        return this.myEventsHandling;
    }

    public void clearLineModificationFlags() {
        this.myLineSet = this.getLineSet().clearModificationFlags();
        this.myFrozen = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void updateText(@NotNull ImmutableCharSequence newText, int offset2, @NotNull CharSequence oldString, @NotNull CharSequence newString, boolean wholeTextReplaced, long newModificationStamp, int initialStartOffset, int n) {
        if (newText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newText", "com/intellij/openapi/editor/impl/DocumentImpl", "updateText"));
        }
        if (oldString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldString", "com/intellij/openapi/editor/impl/DocumentImpl", "updateText"));
        }
        if (newString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newString", "com/intellij/openapi/editor/impl/DocumentImpl", "updateText"));
        }
        this.assertNotNestedModification();
        this.myChangeInProgress = true;
        try {
            void initialOldLength;
            DocumentEventImpl event = new DocumentEventImpl(this, offset2, oldString, newString, this.myModificationStamp, wholeTextReplaced, initialStartOffset, (int)initialOldLength);
            this.beforeChangedUpdate(event);
            this.myTextString = null;
            ImmutableCharSequence prevText = this.myText;
            this.myText = newText;
            this.sequence.incrementAndGet();
            this.changedUpdate(event, newModificationStamp, prevText);
        }
        finally {
            this.myChangeInProgress = false;
        }
    }

    @Override
    public int getModificationSequence() {
        return this.sequence.get();
    }

    private void beforeChangedUpdate(DocumentEvent event) {
        FileDocumentManager manager;
        VirtualFile file2;
        Application app = ApplicationManager.getApplication();
        if (app != null && (file2 = (manager = FileDocumentManager.getInstance()).getFile(this)) != null && !file2.isValid()) {
            LOG.error("File of this document has been deleted.");
        }
        this.assertInsideCommand();
        this.getLineSet();
        if (!ShutDownTracker.isShutdownHookRunning()) {
            DocumentListener[] listeners = this.getListeners();
            for (int i = listeners.length - 1; i >= 0; --i) {
                try {
                    listeners[i].beforeDocumentChange(event);
                    continue;
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
        this.myEventsHandling = true;
    }

    private void assertInsideCommand() {
        if (!this.myAssertThreading) {
            return;
        }
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        if (!commandProcessor.isUndoTransparentActionInProgress() && commandProcessor.getCurrentCommand() == null) {
            throw new IncorrectOperationException("Must not change document outside command or undo-transparent action. See com.intellij.openapi.command.WriteCommandAction or com.intellij.openapi.command.CommandProcessor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void changedUpdate(@NotNull DocumentEvent event, long newModificationStamp, @NotNull CharSequence charSequence) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/DocumentImpl", "changedUpdate"));
        }
        if (charSequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prevText", "com/intellij/openapi/editor/impl/DocumentImpl", "changedUpdate"));
        }
        try {
            void prevText;
            if (LOG.isDebugEnabled()) {
                LOG.debug(event.toString());
            }
            assert (event.getOldFragment().length() == event.getOldLength()) : "event.getOldFragment().length() = " + event.getOldFragment().length() + "; event.getOldLength() = " + event.getOldLength();
            assert (event.getNewFragment().length() == event.getNewLength()) : "event.getNewFragment().length() = " + event.getNewFragment().length() + "; event.getNewLength() = " + event.getNewLength();
            assert (prevText.length() + event.getNewLength() - event.getOldLength() == this.getTextLength()) : "prevText.length() = " + prevText.length() + "; event.getNewLength() = " + event.getNewLength() + "; event.getOldLength() = " + event.getOldLength() + "; getTextLength() = " + this.getTextLength();
            this.myLineSet = this.getLineSet().update((CharSequence)prevText, event.getOffset(), event.getOffset() + event.getOldLength(), event.getNewFragment(), event.isWholeTextReplaced());
            assert (this.getTextLength() == this.myLineSet.getLength()) : "getTextLength() = " + this.getTextLength() + "; myLineSet.getLength() = " + this.myLineSet.getLength();
            this.myFrozen = null;
            this.setModificationStamp(newModificationStamp);
            if (!ShutDownTracker.isShutdownHookRunning()) {
                DocumentListener[] listeners;
                for (DocumentListener listener : listeners = this.getListeners()) {
                    try {
                        listener.documentChanged(event);
                    }
                    catch (ProcessCanceledException e) {
                        if (!this.myAssertThreading) {
                            throw e;
                        }
                        LOG.error("ProcessCanceledException must not be thrown from document listeners for real document", new Throwable(e));
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                    }
                }
            }
        }
        finally {
            this.myEventsHandling = false;
        }
    }

    @Override
    @NotNull
    public String getText() {
        String string = ApplicationManager.getApplication().runReadAction(() -> this.doGetText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "getText"));
        }
        return string;
    }

    @NotNull
    private String doGetText() {
        String s = SoftReference.dereference(this.myTextString);
        if (s == null) {
            s = this.myText.toString();
            this.myTextString = new SoftReference<String>(s);
        }
        String string = s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "doGetText"));
        }
        return string;
    }

    @Override
    public int getTextLength() {
        return this.myText.length();
    }

    @Override
    @NotNull
    public CharSequence getCharsSequence() {
        CharSequence charSequence = this.myMutableCharSequence;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "getCharsSequence"));
        }
        return charSequence;
    }

    @Override
    @NotNull
    public CharSequence getImmutableCharSequence() {
        ImmutableCharSequence immutableCharSequence = this.myText;
        if (immutableCharSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "getImmutableCharSequence"));
        }
        return immutableCharSequence;
    }

    @Override
    public void addDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/DocumentImpl", "addDocumentListener"));
        }
        if (ArrayUtil.contains(listener, this.getListeners())) {
            LOG.error("Already registered: " + listener);
        }
        this.myDocumentListeners.add(listener);
    }

    @Override
    public void removeDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/DocumentImpl", "removeDocumentListener"));
        }
        boolean success = this.myDocumentListeners.remove(listener);
        if (!success) {
            LOG.error("Can't remove document listener (" + listener + "). Registered listeners: " + Arrays.toString(this.getListeners()));
        }
    }

    @Override
    public int getLineNumber(int offset2) {
        return this.getLineSet().findLineIndex(offset2);
    }

    @Override
    public final int getLineStartOffset(int line) {
        if (line == 0) {
            return 0;
        }
        return this.getLineSet().getLineStart(line);
    }

    @Override
    public final int getLineEndOffset(int line) {
        if (this.getTextLength() == 0 && line == 0) {
            return 0;
        }
        int result2 = this.getLineSet().getLineEnd(line) - this.getLineSeparatorLength(line);
        assert (result2 >= 0);
        return result2;
    }

    public final int getLineSeparatorLength(int line) {
        int separatorLength = this.getLineSet().getSeparatorLength(line);
        assert (separatorLength >= 0);
        return separatorLength;
    }

    @Override
    public final int getLineCount() {
        int lineCount = this.getLineSet().getLineCount();
        assert (lineCount >= 0);
        return lineCount;
    }

    @NotNull
    private DocumentListener[] getListeners() {
        DocumentListener[] documentListenerArray = this.myDocumentListeners.getArray();
        if (documentListenerArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "getListeners"));
        }
        return documentListenerArray;
    }

    public void setCyclicBufferSize(int bufferSize) {
        assert (bufferSize >= 0) : bufferSize;
        this.myBufferSize = bufferSize;
    }

    @Override
    public void setText(@NotNull CharSequence text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/DocumentImpl", "setText"));
        }
        Runnable runnable = () -> {
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/DocumentImpl", "lambda$setText$3"));
            }
            this.replaceString(0, this.getTextLength(), text2, LocalTimeCounter.currentTime(), true);
        };
        if (CommandProcessor.getInstance().isUndoTransparentActionInProgress()) {
            runnable.run();
        } else {
            CommandProcessor.getInstance().executeCommand(null, runnable, "", DocCommandGroupId.noneGroupId(this));
        }
        this.clearLineModificationFlags();
    }

    @Override
    public final boolean isInBulkUpdate() {
        return this.myDoingBulkUpdate;
    }

    public String toString() {
        return "DocumentImpl[" + FileDocumentManager.getInstance().getFile(this) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public FrozenDocument freeze() {
        FrozenDocument frozen = this.myFrozen;
        if (frozen == null) {
            Object object = this.myLineSetLock;
            synchronized (object) {
                frozen = this.myFrozen;
                if (frozen == null) {
                    frozen = new FrozenDocument(this.myText, this.myLineSet, this.myModificationStamp, SoftReference.dereference(this.myTextString));
                }
            }
        }
        FrozenDocument frozenDocument = frozen;
        if (frozenDocument == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "freeze"));
        }
        return frozenDocument;
    }
}

