/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class PsiPolyExpressionUtil {
    public static boolean hasStandaloneForm(PsiExpression expression2) {
        return !(expression2 instanceof PsiFunctionalExpression) && !(expression2 instanceof PsiParenthesizedExpression) && !(expression2 instanceof PsiConditionalExpression) && !(expression2 instanceof PsiCallExpression);
    }

    public static boolean isPolyExpression(PsiExpression expression2) {
        ConditionalKind conditionalKind;
        if (expression2 instanceof PsiFunctionalExpression) {
            return true;
        }
        if (expression2 instanceof PsiParenthesizedExpression) {
            return PsiPolyExpressionUtil.isPolyExpression(((PsiParenthesizedExpression)expression2).getExpression());
        }
        if (expression2 instanceof PsiNewExpression && PsiDiamondType.hasDiamond((PsiNewExpression)expression2)) {
            return PsiPolyExpressionUtil.isInAssignmentOrInvocationContext(expression2);
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            MethodCandidateInfo.CurrentCandidateProperties candidateProperties = MethodCandidateInfo.getCurrentMethod(((PsiMethodCallExpression)expression2).getArgumentList());
            return PsiPolyExpressionUtil.isMethodCallPolyExpression(expression2, candidateProperties != null ? candidateProperties.getMethod() : ((PsiMethodCallExpression)expression2).resolveMethod());
        }
        if (expression2 instanceof PsiConditionalExpression && (conditionalKind = PsiPolyExpressionUtil.isBooleanOrNumeric(expression2)) == null) {
            return PsiPolyExpressionUtil.isInAssignmentOrInvocationContext(expression2);
        }
        return false;
    }

    public static boolean isMethodCallPolyExpression(PsiExpression expression2, PsiMethod method) {
        if (PsiPolyExpressionUtil.isInAssignmentOrInvocationContext(expression2) && ((PsiCallExpression)expression2).getTypeArguments().length == 0) {
            if (method != null) {
                return PsiPolyExpressionUtil.isMethodCallTypeDependsOnInference(expression2, method);
            }
            return true;
        }
        return false;
    }

    public static boolean isMethodCallTypeDependsOnInference(PsiExpression expression2, PsiMethod method) {
        HashSet<PsiTypeParameter> typeParameters = new HashSet<PsiTypeParameter>(Arrays.asList(method.getTypeParameters()));
        if (!typeParameters.isEmpty()) {
            PsiType returnType = method.getReturnType();
            if (returnType != null) {
                return PsiPolyExpressionUtil.mentionsTypeParameters(returnType, typeParameters);
            }
        } else if (method.isConstructor() && expression2 instanceof PsiNewExpression && PsiDiamondType.hasDiamond((PsiNewExpression)expression2)) {
            return true;
        }
        return false;
    }

    public static Boolean mentionsTypeParameters(@Nullable PsiType returnType, final Set<PsiTypeParameter> typeParameters) {
        if (returnType == null) {
            return false;
        }
        return returnType.accept(new PsiTypeVisitor<Boolean>(){

            @Override
            @Nullable
            public Boolean visitType(PsiType type2) {
                return false;
            }

            @Override
            @Nullable
            public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                PsiType bound = wildcardType.getBound();
                if (bound != null) {
                    return bound.accept(this);
                }
                return false;
            }

            @Override
            @Nullable
            public Boolean visitClassType(PsiClassType classType) {
                for (PsiType type2 : classType.getParameters()) {
                    if (!type2.accept(this).booleanValue()) continue;
                    return true;
                }
                PsiClass psiClass = classType.resolve();
                return psiClass instanceof PsiTypeParameter && typeParameters.contains(psiClass);
            }

            @Override
            @Nullable
            public Boolean visitArrayType(PsiArrayType arrayType) {
                return arrayType.getComponentType().accept(this);
            }
        });
    }

    private static boolean isInAssignmentOrInvocationContext(PsiExpression expr) {
        PsiElement context = PsiUtil.skipParenthesizedExprUp(expr.getParent());
        return context instanceof PsiExpressionList || context instanceof PsiArrayInitializerExpression || context instanceof PsiConditionalExpression && (expr instanceof PsiCallExpression || PsiPolyExpressionUtil.isPolyExpression((PsiExpression)context)) || PsiPolyExpressionUtil.isAssignmentContext(expr, context);
    }

    private static boolean isAssignmentContext(PsiExpression expr, PsiElement context) {
        return PsiUtil.isCondition(expr, context) || context instanceof PsiReturnStatement || context instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)context).getOperationTokenType() == JavaTokenType.EQ || context instanceof PsiVariable || context instanceof PsiLambdaExpression;
    }

    public static boolean isExpressionOfPrimitiveType(@Nullable PsiExpression arg) {
        if (arg != null && !PsiPolyExpressionUtil.isPolyExpression(arg)) {
            PsiType type2 = arg.getType();
            return type2 instanceof PsiPrimitiveType && type2 != PsiType.NULL;
        }
        if (arg instanceof PsiNewExpression || arg instanceof PsiFunctionalExpression) {
            return false;
        }
        if (arg instanceof PsiParenthesizedExpression) {
            return PsiPolyExpressionUtil.isExpressionOfPrimitiveType(((PsiParenthesizedExpression)arg).getExpression());
        }
        if (arg instanceof PsiConditionalExpression) {
            return PsiPolyExpressionUtil.isBooleanOrNumeric(arg) != null;
        }
        if (arg instanceof PsiMethodCallExpression) {
            PsiMethod method = ((PsiMethodCallExpression)arg).resolveMethod();
            return method != null && method.getReturnType() instanceof PsiPrimitiveType;
        }
        assert (false) : arg;
        return false;
    }

    private static ConditionalKind isBooleanOrNumeric(PsiExpression expr) {
        PsiMethod method;
        if (expr instanceof PsiParenthesizedExpression) {
            return PsiPolyExpressionUtil.isBooleanOrNumeric(((PsiParenthesizedExpression)expr).getExpression());
        }
        if (expr == null) {
            return null;
        }
        PsiType type2 = null;
        if (expr instanceof PsiNewExpression && !PsiDiamondType.hasDiamond((PsiNewExpression)expr) || PsiPolyExpressionUtil.hasStandaloneForm(expr)) {
            type2 = expr.getType();
        } else if (expr instanceof PsiMethodCallExpression && (method = ((PsiMethodCallExpression)expr).resolveMethod()) != null) {
            type2 = method.getReturnType();
        }
        ConditionalKind kind = PsiPolyExpressionUtil.isBooleanOrNumericType(type2);
        if (kind != null) {
            return kind;
        }
        if (expr instanceof PsiConditionalExpression) {
            ConditionalKind elseKind;
            PsiExpression thenExpression = ((PsiConditionalExpression)expr).getThenExpression();
            PsiExpression elseExpression = ((PsiConditionalExpression)expr).getElseExpression();
            ConditionalKind thenKind = PsiPolyExpressionUtil.isBooleanOrNumeric(thenExpression);
            if (thenKind == (elseKind = PsiPolyExpressionUtil.isBooleanOrNumeric(elseExpression)) || elseKind == ConditionalKind.NULL) {
                return thenKind;
            }
            if (thenKind == ConditionalKind.NULL) {
                return elseKind;
            }
        }
        return null;
    }

    @Nullable
    private static ConditionalKind isBooleanOrNumericType(PsiType type2) {
        if (type2 == PsiType.NULL) {
            return ConditionalKind.NULL;
        }
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly(type2);
        if (TypeConversionUtil.isNumericType(type2)) {
            return ConditionalKind.NUMERIC;
        }
        if (TypeConversionUtil.isBooleanType(type2)) {
            return ConditionalKind.BOOLEAN;
        }
        if (psiClass instanceof PsiTypeParameter) {
            for (PsiClassType classType : psiClass.getExtendsListTypes()) {
                ConditionalKind kind = PsiPolyExpressionUtil.isBooleanOrNumericType(classType);
                if (kind == null) continue;
                return kind;
            }
        }
        return null;
    }

    private static enum ConditionalKind {
        BOOLEAN,
        NUMERIC,
        NULL;

    }
}

