/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import com.intellij.psi.tree.IElementType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;

public final class PsiUtils {
    private PsiUtils() {
    }

    @Nullable
    public static KtSimpleNameExpression getSimpleName(@NotNull KtExpression expression2) {
        if (expression2 == null) {
            PsiUtils.$$$reportNull$$$0(0);
        }
        if (expression2 instanceof KtSimpleNameExpression) {
            return (KtSimpleNameExpression)expression2;
        }
        if (expression2 instanceof KtQualifiedExpression) {
            return PsiUtils.getSelectorAsSimpleName((KtQualifiedExpression)expression2);
        }
        return null;
    }

    @Nullable
    public static KtSimpleNameExpression getSelectorAsSimpleName(@NotNull KtQualifiedExpression expression2) {
        KtExpression selectorExpression;
        if (expression2 == null) {
            PsiUtils.$$$reportNull$$$0(1);
        }
        if (!((selectorExpression = PsiUtils.getSelector(expression2)) instanceof KtSimpleNameExpression)) {
            return null;
        }
        return (KtSimpleNameExpression)selectorExpression;
    }

    @NotNull
    public static KtExpression getSelector(@NotNull KtQualifiedExpression expression2) {
        if (expression2 == null) {
            PsiUtils.$$$reportNull$$$0(2);
        }
        KtExpression selectorExpression = expression2.getSelectorExpression();
        assert (selectorExpression != null) : "Selector should not be null.";
        KtExpression ktExpression = selectorExpression;
        if (ktExpression == null) {
            PsiUtils.$$$reportNull$$$0(3);
        }
        return ktExpression;
    }

    @NotNull
    public static KtSimpleNameExpression getNotNullSimpleNameSelector(@NotNull KtQualifiedExpression expression2) {
        if (expression2 == null) {
            PsiUtils.$$$reportNull$$$0(4);
        }
        KtSimpleNameExpression selectorAsSimpleName = PsiUtils.getSelectorAsSimpleName(expression2);
        assert (selectorAsSimpleName != null);
        KtSimpleNameExpression ktSimpleNameExpression = selectorAsSimpleName;
        if (ktSimpleNameExpression == null) {
            PsiUtils.$$$reportNull$$$0(5);
        }
        return ktSimpleNameExpression;
    }

    @NotNull
    public static KtToken getOperationToken(@NotNull KtOperationExpression expression2) {
        if (expression2 == null) {
            PsiUtils.$$$reportNull$$$0(6);
        }
        KtSimpleNameExpression operationExpression = expression2.getOperationReference();
        IElementType elementType = operationExpression.getReferencedNameElementType();
        assert (elementType instanceof KtToken) : "Expected KtToken type, but " + elementType.getClass() + ", expression: " + expression2.getText();
        KtToken ktToken = (KtToken)elementType;
        if (ktToken == null) {
            PsiUtils.$$$reportNull$$$0(7);
        }
        return ktToken;
    }

    @NotNull
    public static KtExpression getBaseExpression(@NotNull KtUnaryExpression expression2) {
        if (expression2 == null) {
            PsiUtils.$$$reportNull$$$0(8);
        }
        KtExpression baseExpression = expression2.getBaseExpression();
        assert (baseExpression != null);
        KtExpression ktExpression = baseExpression;
        if (ktExpression == null) {
            PsiUtils.$$$reportNull$$$0(9);
        }
        return ktExpression;
    }

    public static boolean isPrefix(@NotNull KtUnaryExpression expression2) {
        if (expression2 == null) {
            PsiUtils.$$$reportNull$$$0(10);
        }
        return expression2 instanceof KtPrefixExpression;
    }

    public static boolean isAssignment(KtToken token) {
        return token == KtTokens.EQ;
    }

    public static boolean isInOrNotInOperation(@NotNull KtBinaryExpression binaryExpression) {
        if (binaryExpression == null) {
            PsiUtils.$$$reportNull$$$0(11);
        }
        return PsiUtils.isInOperation(binaryExpression) || PsiUtils.isNotInOperation(binaryExpression);
    }

    private static boolean isNotInOperation(@NotNull KtBinaryExpression binaryExpression) {
        if (binaryExpression == null) {
            PsiUtils.$$$reportNull$$$0(12);
        }
        return binaryExpression.getOperationToken() == KtTokens.NOT_IN;
    }

    public static boolean isNegatedOperation(@NotNull KtBinaryExpression binaryExpression) {
        if (binaryExpression == null) {
            PsiUtils.$$$reportNull$$$0(13);
        }
        return binaryExpression.getOperationToken() == KtTokens.EXCLEQ || PsiUtils.isNotInOperation(binaryExpression);
    }

    private static boolean isInOperation(@NotNull KtBinaryExpression binaryExpression) {
        if (binaryExpression == null) {
            PsiUtils.$$$reportNull$$$0(14);
        }
        return binaryExpression.getOperationToken() == KtTokens.IN_KEYWORD;
    }

    @NotNull
    public static List<KtParameter> getPrimaryConstructorParameters(@NotNull KtClassOrObject classDeclaration) {
        if (classDeclaration == null) {
            PsiUtils.$$$reportNull$$$0(15);
        }
        if (classDeclaration instanceof KtClass) {
            List<KtParameter> list2 = classDeclaration.getPrimaryConstructorParameters();
            if (list2 == null) {
                PsiUtils.$$$reportNull$$$0(16);
            }
            return list2;
        }
        List<KtParameter> list3 = Collections.emptyList();
        if (list3 == null) {
            PsiUtils.$$$reportNull$$$0(17);
        }
        return list3;
    }

    @NotNull
    public static KtExpression getLoopRange(@NotNull KtForExpression expression2) {
        if (expression2 == null) {
            PsiUtils.$$$reportNull$$$0(18);
        }
        KtExpression rangeExpression = expression2.getLoopRange();
        assert (rangeExpression != null);
        KtExpression ktExpression = rangeExpression;
        if (ktExpression == null) {
            PsiUtils.$$$reportNull$$$0(19);
        }
        return ktExpression;
    }

    @NotNull
    public static CallableDescriptor getFunctionDescriptor(ResolvedCall<?> resolvedCall2) {
        if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
            VariableDescriptor variableDescriptor = ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall().getCandidateDescriptor();
            if (variableDescriptor == null) {
                PsiUtils.$$$reportNull$$$0(20);
            }
            return variableDescriptor;
        }
        Object obj = resolvedCall2.getCandidateDescriptor();
        if (obj == null) {
            PsiUtils.$$$reportNull$$$0(21);
        }
        return obj;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/utils/PsiUtils";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpression";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDeclaration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/utils/PsiUtils";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelector";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullSimpleNameSelector";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationToken";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseExpression";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimaryConstructorParameters";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoopRange";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSelectorAsSimpleName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSelector";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNotNullSimpleNameSelector";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOperationToken";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getBaseExpression";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isPrefix";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isInOrNotInOperation";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isNotInOperation";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isNegatedOperation";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isInOperation";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPrimaryConstructorParameters";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getLoopRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

