/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.epub;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import writer2latex.api.ContentEntry;
import writer2latex.api.ConverterResult;
import writer2latex.api.OutputFile;
import writer2latex.base.DOMDocument;
import writer2latex.util.Misc;

public class OPFWriter
extends DOMDocument {
    private String sUID = null;

    public OPFWriter(ConverterResult cr) {
        super("book", "opf");
        String[] sKeys;
        Document contentDOM = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            DOMImplementation domImpl = builder.getDOMImplementation();
            DocumentType doctype = domImpl.createDocumentType("package", "", "");
            contentDOM = domImpl.createDocument("http://www.idpf.org/2007/opf", "package", doctype);
        }
        catch (ParserConfigurationException t) {
            throw new RuntimeException(t);
        }
        Element pack = contentDOM.getDocumentElement();
        pack.setAttribute("version", "2.0");
        pack.setAttribute("xmlns", "http://www.idpf.org/2007/opf");
        pack.setAttribute("unique-identifier", "BookId");
        Element metadata = contentDOM.createElement("metadata");
        metadata.setAttribute("xmlns:dc", "http://purl.org/dc/elements/1.1/");
        metadata.setAttribute("xmlns:opf", "http://www.idpf.org/2007/opf");
        pack.appendChild(metadata);
        this.appendElement(contentDOM, metadata, "dc:title", cr.getMetaData().getTitle());
        this.appendElement(contentDOM, metadata, "dc:language", cr.getMetaData().getLanguage());
        if (cr.getMetaData().getSubject().length() > 0) {
            this.appendElement(contentDOM, metadata, "dc:subject", cr.getMetaData().getSubject());
        }
        if (cr.getMetaData().getKeywords().length() > 0) {
            String[] sKeywords;
            for (String sKeyword : sKeywords = cr.getMetaData().getKeywords().split(",")) {
                this.appendElement(contentDOM, metadata, "dc:subject", sKeyword.trim());
            }
        }
        if (cr.getMetaData().getDescription().length() > 0) {
            this.appendElement(contentDOM, metadata, "dc:description", cr.getMetaData().getDescription());
        }
        boolean bHasIdentifier = false;
        boolean bHasCreator = false;
        boolean bHasDate = false;
        Map<String, String> userDefinedMetaData = cr.getMetaData().getUserDefinedMetaData();
        HashMap<String, String[]> dc = new HashMap<String, String[]>();
        for (String sKey : userDefinedMetaData.keySet()) {
            String sNewKey;
            if (sKey.length() <= 0) continue;
            String[] sValue = new String[2];
            sValue[0] = userDefinedMetaData.get(sKey);
            int nDot = sKey.indexOf(".");
            if (nDot > 0) {
                sNewKey = sKey.substring(0, nDot).toLowerCase();
                sValue[1] = sKey.substring(nDot + 1);
            } else {
                sNewKey = sKey.toLowerCase();
                sValue[1] = null;
            }
            dc.put(sNewKey, sValue);
        }
        for (String sKey : sKeys = Misc.sortStringSet(dc.keySet())) {
            String sValue = ((String[])dc.get(sKey))[0];
            String sAttributeValue = ((String[])dc.get(sKey))[1];
            if (sKey.startsWith("identifier")) {
                Element identifier = this.appendElement(contentDOM, metadata, "dc:identifier", sValue);
                if (!bHasIdentifier) {
                    identifier.setAttribute("id", "BookId");
                    this.sUID = sValue;
                }
                if (sAttributeValue != null) {
                    identifier.setAttribute("opf:scheme", sAttributeValue);
                }
                bHasIdentifier = true;
                continue;
            }
            if (sKey.startsWith("creator")) {
                Element creator = this.appendElement(contentDOM, metadata, "dc:creator", sValue);
                creator.setAttribute("opf:file-as", this.fileAs(sValue));
                if (sAttributeValue != null) {
                    creator.setAttribute("opf:role", sAttributeValue);
                }
                bHasCreator = true;
                continue;
            }
            if (sKey.startsWith("contributor")) {
                Element contributor = this.appendElement(contentDOM, metadata, "dc:contributor", sValue);
                contributor.setAttribute("opf:file-as", this.fileAs(sValue));
                if (sAttributeValue == null) continue;
                contributor.setAttribute("opf:role", sAttributeValue);
                continue;
            }
            if (sKey.startsWith("date")) {
                Element date = this.appendElement(contentDOM, metadata, "dc:date", sValue);
                if (sAttributeValue != null) {
                    date.setAttribute("opf:event", sAttributeValue);
                }
                bHasDate = true;
                continue;
            }
            if (sAttributeValue != null) continue;
            if ("publisher".equals(sKey)) {
                this.appendElement(contentDOM, metadata, "dc:publisher", sValue);
                continue;
            }
            if ("type".equals(sKey)) {
                this.appendElement(contentDOM, metadata, "dc:type", sValue);
                continue;
            }
            if ("format".equals(sKey)) {
                this.appendElement(contentDOM, metadata, "dc:format", sValue);
                continue;
            }
            if ("source".equals(sKey)) {
                this.appendElement(contentDOM, metadata, "dc:source", sValue);
                continue;
            }
            if ("relation".equals(sKey)) {
                this.appendElement(contentDOM, metadata, "dc:relation", sValue);
                continue;
            }
            if ("coverage".equals(sKey)) {
                this.appendElement(contentDOM, metadata, "dc:coverage", sValue);
                continue;
            }
            if (!"rights".equals(sKey)) continue;
            this.appendElement(contentDOM, metadata, "dc:rights", sValue);
        }
        if (!bHasIdentifier) {
            this.sUID = UUID.randomUUID().toString();
            Element identifier = this.appendElement(contentDOM, metadata, "dc:identifier", this.sUID);
            identifier.setAttribute("id", "BookId");
            identifier.setAttribute("opf:scheme", "UUID");
        }
        if (!bHasCreator && cr.getMetaData().getCreator().length() > 0) {
            this.appendElement(contentDOM, metadata, "dc:creator", cr.getMetaData().getCreator()).setAttribute("opf:file-as", this.fileAs(cr.getMetaData().getCreator()));
        }
        if (!bHasDate && cr.getMetaData().getDate().length() > 0) {
            this.appendElement(contentDOM, metadata, "dc:date", Misc.dateOnly(cr.getMetaData().getDate()));
        }
        Element manifest = contentDOM.createElement("manifest");
        pack.appendChild(manifest);
        Element spine = contentDOM.createElement("spine");
        spine.setAttribute("toc", "ncx");
        pack.appendChild(spine);
        int nMasterCount = 0;
        int nResourceCount = 0;
        Iterator<OutputFile> iterator = cr.iterator();
        while (iterator.hasNext()) {
            OutputFile file = iterator.next();
            Element item = contentDOM.createElement("item");
            manifest.appendChild(item);
            item.setAttribute("href", Misc.makeHref(file.getFileName()));
            item.setAttribute("media-type", file.getMIMEType());
            if (cr.getCoverFile() != null && cr.getCoverFile().getFile() == file) {
                item.setAttribute("id", "cover");
                Element itemref = contentDOM.createElement("itemref");
                itemref.setAttribute("idref", "cover");
                itemref.setAttribute("linear", "no");
                spine.appendChild(itemref);
                continue;
            }
            if (cr.getCoverImageFile() != null && cr.getCoverImageFile().getFile() == file) {
                item.setAttribute("id", "cover-image");
                Element meta = contentDOM.createElement("meta");
                meta.setAttribute("name", "cover");
                meta.setAttribute("content", "cover-image");
                metadata.appendChild(meta);
                continue;
            }
            if (file.isMasterDocument()) {
                String sId = "text" + ++nMasterCount;
                item.setAttribute("id", sId);
                Element itemref = contentDOM.createElement("itemref");
                itemref.setAttribute("idref", sId);
                spine.appendChild(itemref);
                continue;
            }
            item.setAttribute("id", "resource" + ++nResourceCount);
        }
        Element item = contentDOM.createElement("item");
        item.setAttribute("href", "book.ncx");
        item.setAttribute("media-type", "application/x-dtbncx+xml");
        item.setAttribute("id", "ncx");
        manifest.appendChild(item);
        Element guide = contentDOM.createElement("guide");
        pack.appendChild(guide);
        this.addGuideReference(contentDOM, guide, "cover", cr.getCoverFile());
        this.addGuideReference(contentDOM, guide, "title-page", cr.getTitlePageFile());
        this.addGuideReference(contentDOM, guide, "text", cr.getTextFile());
        this.addGuideReference(contentDOM, guide, "toc", cr.getTocFile());
        this.addGuideReference(contentDOM, guide, "index", cr.getIndexFile());
        this.addGuideReference(contentDOM, guide, "loi", cr.getLofFile());
        this.addGuideReference(contentDOM, guide, "lot", cr.getLotFile());
        this.addGuideReference(contentDOM, guide, "bibliography", cr.getBibliographyFile());
        this.setContentDOM(contentDOM);
    }

    public String getUid() {
        return this.sUID;
    }

    private String fileAs(String sName) {
        int nSpace = sName.lastIndexOf(32);
        if (nSpace > -1) {
            return sName.substring(nSpace + 1).trim() + ", " + sName.substring(0, nSpace).trim();
        }
        return sName.trim();
    }

    private Element appendElement(Document contentDOM, Element node, String sTagName, String sContent) {
        Element child = contentDOM.createElement(sTagName);
        node.appendChild(child);
        child.appendChild(contentDOM.createTextNode(sContent));
        return child;
    }

    private void addGuideReference(Document contentDOM, Element guide, String sType, ContentEntry entry) {
        if (entry != null) {
            Element reference = contentDOM.createElement("reference");
            reference.setAttribute("type", sType);
            reference.setAttribute("title", entry.getTitle());
            String sHref = Misc.makeHref(entry.getFile().getFileName());
            if (entry.getTarget() != null) {
                sHref = sHref + "#" + entry.getTarget();
            }
            reference.setAttribute("href", sHref);
            guide.appendChild(reference);
        }
    }
}

