/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.db.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DbUtils;
import org.parosproxy.paros.db.RecordAlert;
import org.parosproxy.paros.db.TableAlert;
import org.zaproxy.zap.db.sql.DbSQL;
import org.zaproxy.zap.db.sql.SqlAbstractTable;
import org.zaproxy.zap.db.sql.SqlPreparedStatementWrapper;

public class SqlTableAlert
extends SqlAbstractTable
implements TableAlert {
    private static final String TABLE_NAME = DbSQL.getSQL("alert.table_name");
    private static final String ALERT_INDEX = DbSQL.getSQL("alert.field.alert_index");
    private static final String ALERTID = DbSQL.getSQL("alert.field.alertid");
    private static final String SCANID = DbSQL.getSQL("alert.field.scanid");
    private static final String PLUGINID = DbSQL.getSQL("alert.field.pluginid");
    private static final String ALERT = DbSQL.getSQL("alert.field.alert");
    private static final String RISK = DbSQL.getSQL("alert.field.risk");
    private static final String RELIABILITY = DbSQL.getSQL("alert.field.reliability");
    private static final String DESCRIPTION = DbSQL.getSQL("alert.field.description");
    private static final String URI = DbSQL.getSQL("alert.field.uri");
    private static final String PARAM = DbSQL.getSQL("alert.field.param");
    private static final String ATTACK = DbSQL.getSQL("alert.field.attack");
    private static final String OTHERINFO = DbSQL.getSQL("alert.field.otherinfo");
    private static final String SOLUTION = DbSQL.getSQL("alert.field.solution");
    private static final String REFERENCE = DbSQL.getSQL("alert.field.reference");
    private static final String EVIDENCE = DbSQL.getSQL("alert.field.evidence");
    private static final String CWEID = DbSQL.getSQL("alert.field.cweid");
    private static final String WASCID = DbSQL.getSQL("alert.field.wascid");
    private static final String HISTORYID = DbSQL.getSQL("alert.field.historyid");
    private static final String SOURCEHISTORYID = DbSQL.getSQL("alert.field.sourcehistoryid");
    private static final String SOURCEID = DbSQL.getSQL("alert.field.sourceid");

    @Override
    protected void reconnect(Connection connection) throws DatabaseException {
        try {
            this.updateTable(connection);
        }
        catch (Exception exception) {
            throw new DatabaseException(exception);
        }
    }

    private void updateTable(Connection connection) throws DatabaseException {
        try {
            if (!DbUtils.hasColumn(connection, TABLE_NAME, SOURCEHISTORYID)) {
                DbUtils.executeAndClose(connection.prepareStatement(DbSQL.getSQL("alert.ps.addsourcehistoryid")));
            }
            if (!DbUtils.hasColumn(connection, TABLE_NAME, ATTACK)) {
                DbUtils.executeAndClose(connection.prepareStatement(DbSQL.getSQL("alert.ps.addattack")));
            }
            if (!DbUtils.hasColumn(connection, TABLE_NAME, EVIDENCE)) {
                DbUtils.executeAndClose(connection.prepareStatement(DbSQL.getSQL("alert.ps.addevidence")));
                DbUtils.executeAndClose(connection.prepareStatement(DbSQL.getSQL("alert.ps.addcweid")));
                DbUtils.executeAndClose(connection.prepareStatement(DbSQL.getSQL("alert.ps.addwascid")));
            }
            if (!DbUtils.hasIndex(connection, TABLE_NAME, ALERT_INDEX)) {
                DbUtils.executeAndClose(connection.prepareStatement(DbSQL.getSQL("alert.ps.addalertindex")));
            }
            if (!DbUtils.hasColumn(connection, TABLE_NAME, SOURCEID)) {
                DbUtils.executeAndClose(connection.prepareStatement(DbSQL.getSQL("alert.ps.addsourceid")));
                DbUtils.executeAndClose(connection.prepareStatement(DbSQL.getSQL("alert.ps.addsourceidindex")));
            }
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public synchronized RecordAlert read(int var1_1) throws DatabaseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public synchronized RecordAlert write(int n, int n2, String string, int n3, int n4, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, int n5, int n6, int n7, int n8, int n9) throws DatabaseException {
        SqlPreparedStatementWrapper sqlPreparedStatementWrapper = null;
        try {
            int n10;
            sqlPreparedStatementWrapper = DbSQL.getSingleton().getPreparedStatement("alert.ps.insert");
            sqlPreparedStatementWrapper.getPs().setInt(1, n);
            sqlPreparedStatementWrapper.getPs().setInt(2, n2);
            sqlPreparedStatementWrapper.getPs().setString(3, string);
            sqlPreparedStatementWrapper.getPs().setInt(4, n3);
            sqlPreparedStatementWrapper.getPs().setInt(5, n4);
            sqlPreparedStatementWrapper.getPs().setString(6, string2);
            sqlPreparedStatementWrapper.getPs().setString(7, string3);
            sqlPreparedStatementWrapper.getPs().setString(8, string4);
            sqlPreparedStatementWrapper.getPs().setString(9, string5);
            sqlPreparedStatementWrapper.getPs().setString(10, string6);
            sqlPreparedStatementWrapper.getPs().setString(11, string7);
            sqlPreparedStatementWrapper.getPs().setString(12, string8);
            sqlPreparedStatementWrapper.getPs().setString(13, string9);
            sqlPreparedStatementWrapper.getPs().setInt(14, n5);
            sqlPreparedStatementWrapper.getPs().setInt(15, n6);
            sqlPreparedStatementWrapper.getPs().setInt(16, n7);
            sqlPreparedStatementWrapper.getPs().setInt(17, n8);
            sqlPreparedStatementWrapper.getPs().setInt(18, n9);
            sqlPreparedStatementWrapper.getPs().executeUpdate();
            try (Object object = sqlPreparedStatementWrapper.getLastInsertedId();){
                object.next();
                n10 = object.getInt(1);
            }
            object = this.read(n10);
            return object;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(sqlPreparedStatementWrapper);
        }
    }

    private RecordAlert build(ResultSet resultSet) throws DatabaseException {
        try {
            RecordAlert recordAlert = null;
            if (resultSet.next()) {
                recordAlert = new RecordAlert(resultSet.getInt(ALERTID), resultSet.getInt(SCANID), resultSet.getInt(PLUGINID), resultSet.getString(ALERT), resultSet.getInt(RISK), resultSet.getInt(RELIABILITY), resultSet.getString(DESCRIPTION), resultSet.getString(URI), resultSet.getString(PARAM), resultSet.getString(ATTACK), resultSet.getString(OTHERINFO), resultSet.getString(SOLUTION), resultSet.getString(REFERENCE), resultSet.getString(EVIDENCE), resultSet.getInt(CWEID), resultSet.getInt(WASCID), resultSet.getInt(HISTORYID), resultSet.getInt(SOURCEHISTORYID), resultSet.getInt(SOURCEID));
            }
            return recordAlert;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public void deleteAlert(int n) throws DatabaseException {
        SqlPreparedStatementWrapper sqlPreparedStatementWrapper = null;
        try {
            sqlPreparedStatementWrapper = DbSQL.getSingleton().getPreparedStatement("alert.ps.delete");
            sqlPreparedStatementWrapper.getPs().setInt(1, n);
            sqlPreparedStatementWrapper.getPs().execute();
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(sqlPreparedStatementWrapper);
        }
    }

    @Override
    public int deleteAllAlerts() throws DatabaseException {
        SqlPreparedStatementWrapper sqlPreparedStatementWrapper = null;
        try {
            sqlPreparedStatementWrapper = DbSQL.getSingleton().getPreparedStatement("alert.ps.deleteall");
            int n = sqlPreparedStatementWrapper.getPs().executeUpdate();
            return n;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(sqlPreparedStatementWrapper);
        }
    }

    @Override
    public synchronized void update(int n, String string, int n2, int n3, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, int n4, int n5, int n6) throws DatabaseException {
        SqlPreparedStatementWrapper sqlPreparedStatementWrapper = null;
        try {
            sqlPreparedStatementWrapper = DbSQL.getSingleton().getPreparedStatement("alert.ps.update");
            sqlPreparedStatementWrapper.getPs().setString(1, string);
            sqlPreparedStatementWrapper.getPs().setInt(2, n2);
            sqlPreparedStatementWrapper.getPs().setInt(3, n3);
            sqlPreparedStatementWrapper.getPs().setString(4, string2);
            sqlPreparedStatementWrapper.getPs().setString(5, string3);
            sqlPreparedStatementWrapper.getPs().setString(6, string4);
            sqlPreparedStatementWrapper.getPs().setString(7, string5);
            sqlPreparedStatementWrapper.getPs().setString(8, string6);
            sqlPreparedStatementWrapper.getPs().setString(9, string7);
            sqlPreparedStatementWrapper.getPs().setString(10, string8);
            sqlPreparedStatementWrapper.getPs().setString(11, string9);
            sqlPreparedStatementWrapper.getPs().setInt(12, n4);
            sqlPreparedStatementWrapper.getPs().setInt(13, n5);
            sqlPreparedStatementWrapper.getPs().setInt(14, n6);
            sqlPreparedStatementWrapper.getPs().setInt(15, n);
            sqlPreparedStatementWrapper.getPs().executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(sqlPreparedStatementWrapper);
        }
    }

    @Override
    public synchronized void updateHistoryIds(int n, int n2, int n3) throws DatabaseException {
        SqlPreparedStatementWrapper sqlPreparedStatementWrapper = null;
        try {
            sqlPreparedStatementWrapper = DbSQL.getSingleton().getPreparedStatement("alert.ps.updatehistoryid");
            sqlPreparedStatementWrapper.getPs().setInt(1, n2);
            sqlPreparedStatementWrapper.getPs().setInt(2, n3);
            sqlPreparedStatementWrapper.getPs().setInt(3, n);
            sqlPreparedStatementWrapper.getPs().executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(sqlPreparedStatementWrapper);
        }
    }

    @Override
    public List<RecordAlert> getAlertsBySourceHistoryId(int n) throws DatabaseException {
        SqlPreparedStatementWrapper sqlPreparedStatementWrapper = null;
        try {
            sqlPreparedStatementWrapper = DbSQL.getSingleton().getPreparedStatement("alert.ps.getalertsforhistoryid");
            ArrayList<RecordAlert> arrayList = new ArrayList<RecordAlert>();
            sqlPreparedStatementWrapper.getPs().setLong(1, n);
            try (Object object = sqlPreparedStatementWrapper.getPs().executeQuery();){
                RecordAlert recordAlert = this.build((ResultSet)object);
                while (recordAlert != null) {
                    arrayList.add(recordAlert);
                    recordAlert = this.build((ResultSet)object);
                }
            }
            object = arrayList;
            return object;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(sqlPreparedStatementWrapper);
        }
    }

    @Override
    public Vector<Integer> getAlertListBySession(long l) throws DatabaseException {
        SqlPreparedStatementWrapper sqlPreparedStatementWrapper = null;
        try {
            sqlPreparedStatementWrapper = DbSQL.getSingleton().getPreparedStatement("alert.ps.getalertsforsession");
            Vector<Integer> vector = new Vector<Integer>();
            sqlPreparedStatementWrapper.getPs().setLong(1, l);
            try (Object object = sqlPreparedStatementWrapper.getPs().executeQuery();){
                while (object.next()) {
                    int n = object.getInt(ALERTID);
                    vector.add(n);
                }
            }
            object = vector;
            return object;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(sqlPreparedStatementWrapper);
        }
    }

    @Override
    public Vector<Integer> getAlertList() throws DatabaseException {
        SqlPreparedStatementWrapper sqlPreparedStatementWrapper = null;
        try {
            sqlPreparedStatementWrapper = DbSQL.getSingleton().getPreparedStatement("alert.ps.getallalertids");
            Vector<Integer> vector = new Vector<Integer>();
            try (Object object = sqlPreparedStatementWrapper.getPs().executeQuery();){
                while (object.next()) {
                    vector.add(object.getInt(ALERTID));
                }
            }
            object = vector;
            return object;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(sqlPreparedStatementWrapper);
        }
    }
}

