/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public class ContainerAnnotation
extends SingleMemberAnnotation {
    private Annotation[] containees;
    private ArrayInitializer memberValues;

    public ContainerAnnotation(Annotation annotation, ReferenceBinding referenceBinding, BlockScope blockScope) {
        char[][] cArray = referenceBinding.compoundName;
        this.type = cArray.length == 1 ? new SingleTypeReference(cArray[0], 0L) : new QualifiedTypeReference(cArray, new long[cArray.length]);
        this.sourceStart = annotation.sourceStart;
        this.sourceEnd = annotation.sourceEnd;
        this.resolvedType = referenceBinding;
        this.recipient = annotation.recipient;
        this.containees = new Annotation[0];
        this.memberValues = new ArrayInitializer();
        this.memberValue = this.memberValues;
        this.addContainee(annotation);
    }

    public void addContainee(Annotation annotation) {
        int n = this.containees.length;
        this.containees = new Annotation[n + 1];
        System.arraycopy(this.containees, 0, this.containees, 0, n);
        this.containees[n] = annotation;
        this.memberValues.expressions = this.containees;
        annotation.setPersistibleAnnotation(n == 0 ? this : null);
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        if (this.compilerAnnotation != null) {
            return this.resolvedType;
        }
        this.constant = Constant.NotAConstant;
        ReferenceBinding referenceBinding = (ReferenceBinding)this.resolvedType;
        if (!referenceBinding.isValidBinding()) {
            referenceBinding = (ReferenceBinding)referenceBinding.closestMatch();
        }
        Annotation annotation = this.containees[0];
        ReferenceBinding referenceBinding2 = (ReferenceBinding)annotation.resolvedType;
        if (!referenceBinding2.isDeprecated() && this.isTypeUseDeprecated(referenceBinding, blockScope)) {
            blockScope.problemReporter().deprecatedType(referenceBinding, annotation);
        }
        ContainerAnnotation.checkContainerAnnotationType(annotation, blockScope, referenceBinding, referenceBinding2, true);
        referenceBinding = referenceBinding2.containerAnnotationType();
        this.resolvedType = referenceBinding;
        if (!this.resolvedType.isValidBinding()) {
            return this.resolvedType;
        }
        MethodBinding[] methodBindingArray = referenceBinding.methods();
        MemberValuePair memberValuePair = this.memberValuePairs()[0];
        for (MethodBinding methodBinding : methodBindingArray) {
            if (!CharOperation.equals(methodBinding.selector, TypeConstants.VALUE)) continue;
            memberValuePair.binding = methodBinding;
            memberValuePair.resolveTypeExpecting(blockScope, methodBinding.returnType);
        }
        this.compilerAnnotation = blockScope.environment().createAnnotation((ReferenceBinding)this.resolvedType, this.computeElementValuePairs());
        return this.resolvedType;
    }
}

