/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.host;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import com.sun.tools.visualvm.core.datasupport.Utils;
import com.sun.tools.visualvm.core.model.ModelProvider;
import com.sun.tools.visualvm.host.Host;
import com.sun.tools.visualvm.host.RemoteHostsContainer;
import com.sun.tools.visualvm.host.impl.HostDescriptorProvider;
import com.sun.tools.visualvm.host.impl.HostProperties;
import com.sun.tools.visualvm.host.impl.HostProvider;
import com.sun.tools.visualvm.host.impl.HostsSupportImpl;
import java.io.File;
import java.net.InetAddress;

public final class HostsSupport {
    private static final Object hostsStorageDirectoryLock = new Object();
    private static File hostsStorageDirectory;
    private static HostsSupport instance;
    private final HostProvider hostProvider = new HostProvider();

    public static synchronized HostsSupport getInstance() {
        if (instance == null) {
            instance = new HostsSupport();
        }
        return instance;
    }

    public Host createHost(String hostname) {
        return this.createHost(new HostProperties(hostname, hostname, null), true, true);
    }

    public Host createHost(String hostname, String displayname) {
        return this.createHost(new HostProperties(hostname, displayname, null), true, true);
    }

    public Host getOrCreateHost(String hostname, boolean interactive) {
        return this.createHost(new HostProperties(hostname, hostname, null), false, interactive);
    }

    Host createHost(HostProperties properties, boolean createOnly, boolean interactive) {
        return this.hostProvider.createHost(properties, createOnly, interactive);
    }

    public Host getHostByAddress(InetAddress inetAddress) {
        return this.hostProvider.getHostByAddress(inetAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getStorageDirectory() {
        Object object = hostsStorageDirectoryLock;
        synchronized (object) {
            if (hostsStorageDirectory == null) {
                String snapshotsStorageString = HostsSupportImpl.getStorageDirectoryString();
                hostsStorageDirectory = new File(snapshotsStorageString);
                if (hostsStorageDirectory.exists() && hostsStorageDirectory.isFile()) {
                    throw new IllegalStateException("Cannot create hosts storage directory " + snapshotsStorageString + ", file in the way");
                }
                if (!(!hostsStorageDirectory.exists() || hostsStorageDirectory.canRead() && hostsStorageDirectory.canWrite())) {
                    throw new IllegalStateException("Cannot access hosts storage directory " + snapshotsStorageString + ", read&write permission required");
                }
                if (!Utils.prepareDirectory((File)hostsStorageDirectory)) {
                    throw new IllegalStateException("Cannot create hosts storage directory " + snapshotsStorageString);
                }
            }
            return hostsStorageDirectory;
        }
    }

    public static boolean storageDirectoryExists() {
        return new File(HostsSupportImpl.getStorageDirectoryString()).isDirectory();
    }

    Host createLocalHost() {
        return this.hostProvider.createLocalHost();
    }

    Host createUnknownHost() {
        return this.hostProvider.createUnknownHost();
    }

    private HostsSupport() {
        DataSourceDescriptorFactory.getDefault().registerProvider((ModelProvider)new HostDescriptorProvider());
        RemoteHostsContainer container = RemoteHostsContainer.sharedInstance();
        DataSource.ROOT.getRepository().addDataSource((DataSource)container);
        this.hostProvider.initialize();
    }
}

