/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gnu.trove.TDoubleObjectHashMap;
import org.jetbrains.kotlin.gnu.trove.THashMap;
import org.jetbrains.kotlin.gnu.trove.TIntObjectHashMap;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsNumberLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsObjectScope;
import org.jetbrains.kotlin.js.backend.ast.JsProgramFragment;
import org.jetbrains.kotlin.js.backend.ast.JsRootScope;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;

public final class JsProgram
extends SourceInfoAwareJsNode {
    private JsProgramFragment[] fragments;
    private final TDoubleObjectHashMap<JsNumberLiteral.JsDoubleLiteral> doubleLiteralMap = new TDoubleObjectHashMap();
    private final TIntObjectHashMap<JsNumberLiteral.JsIntLiteral> intLiteralMap = new TIntObjectHashMap();
    private final JsRootScope rootScope;
    private final Map<String, JsStringLiteral> stringLiteralMap = new THashMap<String, JsStringLiteral>();
    private final JsObjectScope topScope;

    public JsProgram() {
        this.rootScope = new JsRootScope(this);
        this.topScope = new JsObjectScope(this.rootScope, "Global");
        this.setFragmentCount(1);
    }

    public JsBlock getFragmentBlock(int fragment) {
        if (fragment < 0 || fragment >= this.fragments.length) {
            throw new IllegalArgumentException("Invalid fragment: " + fragment);
        }
        return this.fragments[fragment].getGlobalBlock();
    }

    public JsBlock getGlobalBlock() {
        return this.getFragmentBlock(0);
    }

    public JsNumberLiteral getNumberLiteral(double value) {
        JsNumberLiteral.JsDoubleLiteral literal = this.doubleLiteralMap.get(value);
        if (literal == null) {
            literal = new JsNumberLiteral.JsDoubleLiteral(value);
            this.doubleLiteralMap.put(value, literal);
        }
        return literal;
    }

    public JsNumberLiteral getNumberLiteral(int value) {
        JsNumberLiteral.JsIntLiteral literal = this.intLiteralMap.get(value);
        if (literal == null) {
            literal = new JsNumberLiteral.JsIntLiteral(value);
            this.intLiteralMap.put(value, literal);
        }
        return literal;
    }

    public JsRootScope getRootScope() {
        return this.rootScope;
    }

    public JsObjectScope getScope() {
        return this.topScope;
    }

    @NotNull
    public JsStringLiteral getStringLiteral(String value) {
        JsStringLiteral literal = this.stringLiteralMap.get(value);
        if (literal == null) {
            literal = new JsStringLiteral(value);
            this.stringLiteralMap.put(value, literal);
        }
        JsStringLiteral jsStringLiteral = literal;
        if (jsStringLiteral == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsProgram", "getStringLiteral"));
        }
        return jsStringLiteral;
    }

    public void setFragmentCount(int fragments2) {
        this.fragments = new JsProgramFragment[fragments2];
        for (int i = 0; i < fragments2; ++i) {
            this.fragments[i] = new JsProgramFragment();
        }
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitProgram(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        for (JsProgramFragment fragment : this.fragments) {
            visitor2.accept(fragment);
        }
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            for (JsProgramFragment fragment : this.fragments) {
                v.accept(fragment);
            }
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsProgram deepCopy() {
        throw new UnsupportedOperationException();
    }
}

