/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.DefaultModuleVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusion;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusions;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.AmbiguousConfigurationSelectionException;
import org.gradle.internal.component.IncompatibleConfigurationSelectionException;
import org.gradle.internal.component.NoMatchingConfigurationSelectionException;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.local.model.LocalConfigurationMetadata;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.ConfigurationNotFoundException;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;
import org.gradle.internal.component.model.VariantMetadata;
import org.gradle.internal.exceptions.ConfigurationNotConsumableException;
import org.gradle.util.GUtil;

public class LocalComponentDependencyMetadata
implements LocalOriginDependencyMetadata {
    private final ComponentSelector selector;
    private final ModuleVersionSelector requested;
    private final String moduleConfiguration;
    private final String dependencyConfiguration;
    private final List<Exclude> excludes;
    private final Set<IvyArtifactName> artifactNames;
    private final boolean force;
    private final boolean changing;
    private final boolean transitive;
    private final AttributeContainer moduleAttributes;

    public LocalComponentDependencyMetadata(ComponentSelector selector, ModuleVersionSelector requested, String moduleConfiguration, AttributeContainer moduleAttributes, String dependencyConfiguration, Set<IvyArtifactName> artifactNames, List<Exclude> excludes, boolean force, boolean changing, boolean transitive) {
        this.selector = selector;
        this.requested = requested;
        this.moduleConfiguration = moduleConfiguration;
        this.moduleAttributes = moduleAttributes;
        this.dependencyConfiguration = dependencyConfiguration;
        this.artifactNames = artifactNames;
        this.excludes = excludes;
        this.force = force;
        this.changing = changing;
        this.transitive = transitive;
    }

    public String toString() {
        return "dependency: " + this.requested + " from-conf: " + this.moduleConfiguration + " to-conf: " + this.dependencyConfiguration;
    }

    @Override
    public ModuleVersionSelector getRequested() {
        return this.requested;
    }

    @Override
    public ComponentSelector getSelector() {
        return this.selector;
    }

    @Override
    public String getModuleConfiguration() {
        return this.moduleConfiguration;
    }

    @Override
    public String getDependencyConfiguration() {
        return LocalComponentDependencyMetadata.getOrDefaultConfiguration(this.dependencyConfiguration);
    }

    @Override
    public Set<ConfigurationMetadata> selectConfigurations(ComponentResolveMetadata fromComponent, ConfigurationMetadata fromConfiguration, ComponentResolveMetadata targetComponent, AttributesSchemaInternal consumerSchema) {
        AttributeContainerInternal fromConfigurationAttributes = fromConfiguration.getAttributes();
        boolean consumerHasAttributes = !fromConfigurationAttributes.isEmpty();
        boolean useConfigurationAttributes = this.dependencyConfiguration == null && consumerHasAttributes;
        AttributesSchemaInternal producerAttributeSchema = targetComponent.getAttributesSchema();
        if (useConfigurationAttributes) {
            List<ConfigurationMetadata> matches;
            List<? extends ConfigurationMetadata> consumableConfigurations = targetComponent.getConsumableConfigurationsHavingAttributes();
            AttributeMatcher attributeMatcher = consumerSchema.withProducer(producerAttributeSchema);
            ConfigurationMetadata fallbackConfiguration = targetComponent.getConfiguration("default");
            if (fallbackConfiguration != null && !fallbackConfiguration.isCanBeConsumed()) {
                fallbackConfiguration = null;
            }
            if ((matches = attributeMatcher.matches(consumableConfigurations, fromConfigurationAttributes, fallbackConfiguration)).size() == 1) {
                return ImmutableSet.of((Object)ClientAttributesPreservingConfigurationMetadata.wrapIfLocal(matches.get(0), fromConfigurationAttributes));
            }
            if (!matches.isEmpty()) {
                throw new AmbiguousConfigurationSelectionException((AttributeContainer)fromConfigurationAttributes, attributeMatcher, matches, targetComponent);
            }
            throw new NoMatchingConfigurationSelectionException((AttributeContainer)fromConfigurationAttributes, attributeMatcher, targetComponent);
        }
        String targetConfiguration = (String)GUtil.elvis((Object)this.dependencyConfiguration, (Object)"default");
        ConfigurationMetadata toConfiguration = targetComponent.getConfiguration(targetConfiguration);
        if (toConfiguration == null) {
            throw new ConfigurationNotFoundException(fromComponent.getComponentId(), this.moduleConfiguration, targetConfiguration, targetComponent.getComponentId());
        }
        if (!toConfiguration.isCanBeConsumed()) {
            throw new ConfigurationNotConsumableException(targetComponent.toString(), toConfiguration.getName());
        }
        if (consumerHasAttributes && !toConfiguration.getAttributes().isEmpty() && !consumerSchema.withProducer(producerAttributeSchema).isMatching((AttributeContainer)toConfiguration.getAttributes(), (AttributeContainer)fromConfigurationAttributes)) {
            throw new IncompatibleConfigurationSelectionException((AttributeContainer)fromConfigurationAttributes, consumerSchema.withProducer(producerAttributeSchema), targetComponent, targetConfiguration);
        }
        if (useConfigurationAttributes) {
            toConfiguration = ClientAttributesPreservingConfigurationMetadata.wrapIfLocal(toConfiguration, fromConfigurationAttributes);
        }
        return ImmutableSet.of((Object)toConfiguration);
    }

    private static String getOrDefaultConfiguration(String configuration) {
        return (String)GUtil.elvis((Object)configuration, (Object)"default");
    }

    @Override
    public Set<String> getModuleConfigurations() {
        return ImmutableSet.of((Object)LocalComponentDependencyMetadata.getOrDefaultConfiguration(this.moduleConfiguration));
    }

    @Override
    public List<Exclude> getExcludes() {
        return this.excludes;
    }

    @Override
    public List<Exclude> getExcludes(Collection<String> configurations) {
        return this.excludes;
    }

    @Override
    public boolean isChanging() {
        return this.changing;
    }

    @Override
    public boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public boolean isForce() {
        return this.force;
    }

    @Override
    public String getDynamicConstraintVersion() {
        return this.requested.getVersion();
    }

    @Override
    public Set<ComponentArtifactMetadata> getArtifacts(ConfigurationMetadata fromConfiguration, ConfigurationMetadata toConfiguration) {
        if (this.artifactNames.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<ComponentArtifactMetadata> artifacts = new LinkedHashSet<ComponentArtifactMetadata>();
        for (IvyArtifactName artifactName : this.artifactNames) {
            artifacts.add(toConfiguration.artifact(artifactName));
        }
        return artifacts;
    }

    @Override
    public Set<IvyArtifactName> getArtifacts() {
        return this.artifactNames;
    }

    @Override
    public LocalOriginDependencyMetadata withRequestedVersion(String requestedVersion) {
        if (requestedVersion.equals(this.requested.getVersion())) {
            return this;
        }
        ModuleVersionSelector newRequested = DefaultModuleVersionSelector.newSelector(this.requested.getGroup(), this.requested.getName(), requestedVersion);
        ModuleComponentSelector newSelector = DefaultModuleComponentSelector.newSelector(newRequested);
        return this.copyWithTarget((ComponentSelector)newSelector, newRequested);
    }

    @Override
    public LocalOriginDependencyMetadata withTarget(ComponentSelector target) {
        if (target instanceof ModuleComponentSelector) {
            ModuleComponentSelector moduleTarget = (ModuleComponentSelector)target;
            ModuleVersionSelector requestedVersion = DefaultModuleVersionSelector.newSelector(moduleTarget.getGroup(), moduleTarget.getModule(), moduleTarget.getVersion());
            if (this.selector.equals(target) && this.requested.equals(requestedVersion)) {
                return this;
            }
            return this.copyWithTarget((ComponentSelector)moduleTarget, requestedVersion);
        }
        if (target instanceof ProjectComponentSelector) {
            if (target.equals(this.selector)) {
                return this;
            }
            return this.copyWithTarget(target, this.requested);
        }
        throw new AssertionError((Object)("Invalid component selector type for substitution: " + target));
    }

    private LocalOriginDependencyMetadata copyWithTarget(ComponentSelector selector, ModuleVersionSelector requested) {
        return new LocalComponentDependencyMetadata(selector, requested, this.moduleConfiguration, this.moduleAttributes, this.dependencyConfiguration, this.artifactNames, this.excludes, this.force, this.changing, this.transitive);
    }

    private static class ClientAttributesPreservingConfigurationMetadata
    implements LocalConfigurationMetadata {
        private final LocalConfigurationMetadata delegate;
        private final AttributeContainerInternal attributes;

        private static ConfigurationMetadata wrapIfLocal(ConfigurationMetadata md, AttributeContainerInternal attributes) {
            if (md instanceof LocalConfigurationMetadata) {
                return new ClientAttributesPreservingConfigurationMetadata((LocalConfigurationMetadata)md, attributes);
            }
            return md;
        }

        private ClientAttributesPreservingConfigurationMetadata(LocalConfigurationMetadata delegate, AttributeContainerInternal attributes) {
            this.delegate = delegate;
            this.attributes = attributes;
        }

        @Override
        public AttributeContainerInternal getAttributes() {
            return this.attributes;
        }

        @Override
        public boolean isCanBeConsumed() {
            return this.delegate.isCanBeConsumed();
        }

        @Override
        public boolean isCanBeResolved() {
            return this.delegate.isCanBeResolved();
        }

        @Override
        public Set<String> getHierarchy() {
            return this.delegate.getHierarchy();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public DisplayName asDescribable() {
            return this.delegate.asDescribable();
        }

        @Override
        public List<? extends LocalOriginDependencyMetadata> getDependencies() {
            return this.delegate.getDependencies();
        }

        @Override
        public Set<? extends LocalComponentArtifactMetadata> getArtifacts() {
            return this.delegate.getArtifacts();
        }

        @Override
        public Set<? extends VariantMetadata> getVariants() {
            return this.delegate.getVariants();
        }

        @Override
        public ModuleExclusion getExclusions(ModuleExclusions moduleExclusions) {
            return this.delegate.getExclusions(moduleExclusions);
        }

        @Override
        public boolean isTransitive() {
            return this.delegate.isTransitive();
        }

        @Override
        public boolean isVisible() {
            return this.delegate.isVisible();
        }

        @Override
        public ComponentArtifactMetadata artifact(IvyArtifactName artifact) {
            return this.delegate.artifact(artifact);
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Set<String> getExtendsFrom() {
            return this.delegate.getExtendsFrom();
        }

        @Override
        public Set<LocalFileDependencyMetadata> getFiles() {
            return this.delegate.getFiles();
        }
    }
}

