/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.StartParameter;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.internal.tasks.GeneratedSubclasses;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.BuildCacheServiceFactory;
import org.gradle.caching.configuration.BuildCache;
import org.gradle.caching.configuration.internal.BuildCacheConfigurationInternal;
import org.gradle.caching.internal.BuildOperationFiringBuildCacheServiceDecorator;
import org.gradle.caching.internal.DispatchingBuildCacheService;
import org.gradle.caching.internal.FinalizeBuildCacheConfigurationBuildOperationType;
import org.gradle.caching.internal.ForwardingBuildCacheService;
import org.gradle.caching.internal.NoOpBuildCacheService;
import org.gradle.caching.internal.PushOrPullPreventingBuildCacheServiceDecorator;
import org.gradle.caching.internal.RoleAwareBuildCacheService;
import org.gradle.caching.internal.ShortCircuitingErrorHandlerBuildCacheServiceDecorator;
import org.gradle.internal.Cast;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.progress.BuildOperationDescriptor;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.Path;
import org.gradle.util.SingleMessageLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildCacheServiceProvider {
    private static final Logger LOGGER = Logging.getLogger(BuildCacheServiceProvider.class);
    private static final int MAX_ERROR_COUNT_FOR_BUILD_CACHE = 3;
    private final BuildCacheConfigurationInternal buildCacheConfiguration;
    private final BuildOperationExecutor buildOperationExecutor;
    private final Instantiator instantiator;
    private final StartParameter startParameter;
    private final TemporaryFileProvider temporaryFileProvider;

    @Inject
    public BuildCacheServiceProvider(BuildCacheConfigurationInternal buildCacheConfiguration, StartParameter startParameter, Instantiator instantiator, BuildOperationExecutor buildOperationExecutor, TemporaryFileProvider temporaryFileProvider) {
        this.buildCacheConfiguration = buildCacheConfiguration;
        this.startParameter = startParameter;
        this.instantiator = instantiator;
        this.buildOperationExecutor = buildOperationExecutor;
        this.temporaryFileProvider = temporaryFileProvider;
    }

    public BuildCacheService createBuildCacheService(final Path buildIdentityPath) {
        return (BuildCacheService)this.buildOperationExecutor.call((CallableBuildOperation)new CallableBuildOperation<BuildCacheService>(){

            public BuildCacheService call(BuildOperationContext context) {
                RoleAwareBuildCacheService remoteRoleAware;
                boolean remoteEnabled;
                if (!BuildCacheServiceProvider.this.startParameter.isBuildCacheEnabled()) {
                    context.setResult((Object)FinalizeBuildCacheConfigurationBuildOperationType.ResultImpl.disabled());
                    return new NoOpBuildCacheService();
                }
                if (BuildCacheServiceProvider.this.startParameter.isBuildCacheEnabled()) {
                    SingleMessageLogger.incubatingFeatureUsed((String)"Build cache");
                }
                BuildCache local = BuildCacheServiceProvider.this.buildCacheConfiguration.getLocal();
                BuildCache remote = BuildCacheServiceProvider.this.buildCacheConfiguration.getRemote();
                boolean localEnabled = local != null && local.isEnabled();
                boolean bl = remoteEnabled = remote != null && remote.isEnabled();
                if (remoteEnabled && BuildCacheServiceProvider.this.startParameter.isOffline()) {
                    remoteEnabled = false;
                    LOGGER.warn("Remote build cache is disabled when running with --offline.");
                }
                DescribedBuildCacheService localDescribedService = localEnabled ? BuildCacheServiceProvider.this.createRawBuildCacheService(local, "local", buildIdentityPath) : null;
                DescribedBuildCacheService remoteDescribedService = remoteEnabled ? BuildCacheServiceProvider.this.createRawBuildCacheService(remote, "remote", buildIdentityPath) : null;
                context.setResult((Object)new FinalizeBuildCacheConfigurationBuildOperationType.ResultImpl(true, local != null && local.isEnabled(), remote != null && remote.isEnabled() && !BuildCacheServiceProvider.this.startParameter.isOffline(), localDescribedService == null ? null : localDescribedService.description, remoteDescribedService == null ? null : remoteDescribedService.description));
                RoleAwareBuildCacheService localRoleAware = localEnabled ? BuildCacheServiceProvider.this.decorate(localDescribedService.service, "local") : null;
                RoleAwareBuildCacheService roleAwareBuildCacheService = remoteRoleAware = remoteEnabled ? BuildCacheServiceProvider.this.decorate(remoteDescribedService.service, "remote") : null;
                if (localEnabled && remoteEnabled) {
                    return new DispatchingBuildCacheService(localRoleAware, local.isPush(), remoteRoleAware, remote.isPush(), BuildCacheServiceProvider.this.temporaryFileProvider);
                }
                if (localEnabled) {
                    return BuildCacheServiceProvider.preventPushIfNecessary(localRoleAware, local.isPush());
                }
                if (remoteEnabled) {
                    return BuildCacheServiceProvider.preventPushIfNecessary(remoteRoleAware, remote.isPush());
                }
                if (!BuildCacheServiceProvider.this.startParameter.isBuildCacheEnabled()) {
                    return new NoOpBuildCacheService();
                }
                LOGGER.warn("Task output caching is enabled, but no build caches are configured or enabled.");
                return new NoOpBuildCacheService();
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)"Finalize build cache configuration").details((Object)new FinalizeBuildCacheConfigurationBuildOperationType.DetailsImpl());
            }
        });
    }

    private static RoleAwareBuildCacheService preventPushIfNecessary(RoleAwareBuildCacheService buildCacheService, boolean pushEnabled) {
        return pushEnabled ? buildCacheService : BuildCacheServiceProvider.preventPush(buildCacheService);
    }

    private static PushOrPullPreventingBuildCacheServiceDecorator preventPush(RoleAwareBuildCacheService buildCacheService) {
        return new PushOrPullPreventingBuildCacheServiceDecorator(true, false, buildCacheService);
    }

    private RoleAwareBuildCacheService decorate(BuildCacheService rawService, String role) {
        ForwardingBuildCacheService decoratedService = new BuildCacheServiceWithRole(role, rawService);
        decoratedService = new BuildOperationFiringBuildCacheServiceDecorator(this.buildOperationExecutor, (RoleAwareBuildCacheService)((Object)decoratedService));
        decoratedService = new ShortCircuitingErrorHandlerBuildCacheServiceDecorator(3, this.startParameter, (RoleAwareBuildCacheService)((Object)decoratedService));
        return decoratedService;
    }

    private <T extends BuildCache> DescribedBuildCacheService createRawBuildCacheService(T configuration, String role, Path buildIdentityPath) {
        Class castFactoryType = (Class)Cast.uncheckedCast(this.buildCacheConfiguration.getBuildCacheServiceFactoryType(configuration.getClass()));
        BuildCacheServiceFactory factory = (BuildCacheServiceFactory)this.instantiator.newInstance(castFactoryType, new Object[0]);
        Describer describer = new Describer();
        BuildCacheService service = factory.createBuildCacheService(configuration, describer);
        ImmutableSortedMap config = ImmutableSortedMap.copyOf((Map)describer.configParams);
        BuildCacheDescription description = new BuildCacheDescription(configuration, describer.type, config);
        BuildCacheServiceProvider.logConfig(buildIdentityPath, role, description);
        return new DescribedBuildCacheService(service, description);
    }

    private static void logConfig(Path buildIdentityPath, String role, BuildCacheDescription description) {
        if (LOGGER.isLifecycleEnabled()) {
            boolean pullOnly;
            StringBuilder config = new StringBuilder();
            boolean bl = pullOnly = !description.isPush();
            if (!description.config.isEmpty() || pullOnly) {
                Object configMap;
                if (pullOnly) {
                    configMap = new LinkedHashMap();
                    configMap.put("pull-only", null);
                    configMap.putAll(description.config);
                } else {
                    configMap = description.config;
                }
                config.append(" (");
                Joiner.on((String)", ").appendTo(config, Iterables.transform(configMap.entrySet(), (Function)new Function<Map.Entry<String, String>, String>(){

                    public String apply(Map.Entry<String, String> input) {
                        if (input.getValue() == null) {
                            return input.getKey();
                        }
                        return input.getKey() + " = " + input.getValue();
                    }
                }));
                config.append(")");
            }
            String buildDescription = buildIdentityPath.equals(Path.ROOT) ? "the root build" : "build '" + buildIdentityPath + "'";
            LOGGER.lifecycle("Using {} {} build cache for {}{}.", new Object[]{role, description.type == null ? description.className : description.type, buildDescription, config});
        }
    }

    private static class DescribedBuildCacheService {
        private final BuildCacheService service;
        private final BuildCacheDescription description;

        private DescribedBuildCacheService(BuildCacheService service, BuildCacheDescription description) {
            this.service = service;
            this.description = description;
        }
    }

    private static class Describer
    implements BuildCacheServiceFactory.Describer {
        private String type;
        private Map<String, String> configParams = new HashMap<String, String>();

        private Describer() {
        }

        public BuildCacheServiceFactory.Describer type(String type) {
            if (type == null) {
                throw new IllegalArgumentException("'type' argument cannot be null");
            }
            this.type = type;
            return this;
        }

        public BuildCacheServiceFactory.Describer config(String name, String value) {
            if (name == null) {
                throw new IllegalArgumentException("'name' argument cannot be null");
            }
            if (value == null) {
                throw new IllegalArgumentException("'value' argument cannot be null");
            }
            this.configParams.put(name, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BuildCacheDescription
    implements FinalizeBuildCacheConfigurationBuildOperationType.Result.BuildCacheDescription {
        private final String className;
        private final boolean push;
        private final String type;
        private final ImmutableSortedMap<String, String> config;

        private BuildCacheDescription(BuildCache buildCache, String type, ImmutableSortedMap<String, String> config) {
            this.className = GeneratedSubclasses.unpack(buildCache.getClass()).getName();
            this.push = buildCache.isPush();
            this.type = type;
            this.config = config;
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public boolean isPush() {
            return this.push;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public Map<String, String> getConfig() {
            return this.config;
        }
    }

    private static class BuildCacheServiceWithRole
    extends ForwardingBuildCacheService
    implements RoleAwareBuildCacheService {
        private final String role;
        private final BuildCacheService delegate;

        private BuildCacheServiceWithRole(String role, BuildCacheService delegate) {
            this.role = role;
            this.delegate = delegate;
        }

        protected BuildCacheService delegate() {
            return this.delegate;
        }

        public String getRole() {
            return this.role;
        }
    }
}

