/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.configuration;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.avalon.framework.configuration.AbstractConfiguration;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.ConfigurationUtil;
import org.apache.avalon.framework.configuration.DefaultConfiguration;

public class DefaultImmutableConfiguration
extends AbstractConfiguration
implements Serializable {
    protected static final Configuration[] EMPTY_ARRAY = new Configuration[0];
    private final String m_name;
    private final String m_location;
    private final String m_namespace;
    private final String m_prefix;
    private final HashMap m_attributes;
    private final ArrayList m_children;
    private final String m_value;

    public DefaultImmutableConfiguration(Configuration config) throws ConfigurationException {
        Configuration[] children;
        this.m_name = config.getName();
        this.m_location = config.getLocation();
        this.m_namespace = config.getNamespace();
        this.m_prefix = config instanceof AbstractConfiguration ? ((AbstractConfiguration)config).getPrefix() : "";
        this.m_value = config.getValue(null);
        String[] attributes = config.getAttributeNames();
        if (attributes.length > 0) {
            this.m_attributes = new HashMap();
            for (int i = 0; i < attributes.length; ++i) {
                String name = attributes[i];
                String value = config.getAttribute(name, null);
                this.m_attributes.put(name, value);
            }
        } else {
            this.m_attributes = null;
        }
        if ((children = config.getChildren()).length > 0) {
            this.m_children = new ArrayList();
            for (int i = 0; i < children.length; ++i) {
                this.m_children.add(new DefaultImmutableConfiguration(children[i]));
            }
        } else {
            this.m_children = null;
        }
    }

    public String getName() {
        return this.m_name;
    }

    public String getNamespace() throws ConfigurationException {
        if (null != this.m_namespace) {
            return this.m_namespace;
        }
        throw new ConfigurationException("No namespace (not even default \"\") is associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    protected String getPrefix() throws ConfigurationException {
        if (null != this.m_prefix) {
            return this.m_prefix;
        }
        throw new ConfigurationException("No prefix (not even default \"\") is associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    public String getLocation() {
        return this.m_location;
    }

    public String getValue(String defaultValue) {
        if (null != this.m_value) {
            return this.m_value;
        }
        return defaultValue;
    }

    public String getValue() throws ConfigurationException {
        if (null != this.m_value) {
            return this.m_value;
        }
        throw new ConfigurationException("No value is associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    public String[] getAttributeNames() {
        if (null == this.m_attributes) {
            return new String[0];
        }
        return this.m_attributes.keySet().toArray(new String[0]);
    }

    public Configuration[] getChildren() {
        if (null == this.m_children) {
            return new Configuration[0];
        }
        return this.m_children.toArray(new Configuration[0]);
    }

    public String getAttribute(String name) throws ConfigurationException {
        String value;
        String string = value = null != this.m_attributes ? (String)this.m_attributes.get(name) : null;
        if (null != value) {
            return value;
        }
        throw new ConfigurationException("No attribute named \"" + name + "\" is " + "associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    public Configuration getChild(String name, boolean createNew) {
        if (null != this.m_children) {
            int size = this.m_children.size();
            for (int i = 0; i < size; ++i) {
                Configuration configuration = (Configuration)this.m_children.get(i);
                if (!name.equals(configuration.getName())) continue;
                return configuration;
            }
        }
        if (createNew) {
            return new DefaultConfiguration(name, "<generated>" + this.getLocation(), this.m_namespace, this.m_prefix);
        }
        return null;
    }

    public Configuration[] getChildren(String name) {
        if (null == this.m_children) {
            return new Configuration[0];
        }
        ArrayList<Configuration> children = new ArrayList<Configuration>();
        int size = this.m_children.size();
        for (int i = 0; i < size; ++i) {
            Configuration configuration = (Configuration)this.m_children.get(i);
            if (!name.equals(configuration.getName())) continue;
            children.add(configuration);
        }
        return children.toArray(new Configuration[0]);
    }

    public int getChildCount() {
        if (null == this.m_children) {
            return 0;
        }
        return this.m_children.size();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Configuration)) {
            return false;
        }
        return ConfigurationUtil.equals(this, (Configuration)other);
    }

    public int hashCode() {
        int hash = this.m_prefix.hashCode();
        if (this.m_name != null) {
            hash ^= this.m_name.hashCode();
        }
        hash >>>= 7;
        if (this.m_location != null) {
            hash ^= this.m_location.hashCode();
        }
        hash >>>= 7;
        if (this.m_namespace != null) {
            hash ^= this.m_namespace.hashCode();
        }
        hash >>>= 7;
        if (this.m_attributes != null) {
            hash ^= this.m_attributes.hashCode();
        }
        hash >>>= 7;
        if (this.m_children != null) {
            hash ^= ((AbstractList)this.m_children).hashCode();
        }
        hash >>>= 7;
        if (this.m_value != null) {
            hash ^= this.m_value.hashCode();
        }
        return hash >>>= 7;
    }
}

