/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.proxy;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.engine.AssociationQueryExecutor;
import org.grails.datastore.mapping.proxy.EntityProxyMethodHandler;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.util.ReflectionUtils;

public class AssociationQueryProxyHandler
extends EntityProxyMethodHandler {
    protected final Session session;
    protected final AssociationQueryExecutor executor;
    protected final Serializable associationKey;
    protected Object target;

    public AssociationQueryProxyHandler(Session session, AssociationQueryExecutor executor, Serializable associationKey) {
        super(executor.getIndexedEntity().getJavaClass());
        this.session = session;
        this.executor = executor;
        this.associationKey = associationKey;
    }

    @Override
    protected Object isProxyInitiated(Object self) {
        return this.target != null;
    }

    @Override
    protected Object getProxyKey(Object self) {
        return this.associationKey;
    }

    @Override
    protected Object resolveDelegate(Object self) {
        if (this.target == null) {
            List results = this.executor.query(this.associationKey);
            if (this.executor.doesReturnKeys()) {
                if (!results.isEmpty()) {
                    this.target = this.session.retrieve(this.executor.getIndexedEntity().getJavaClass(), (Serializable)results.get(0));
                }
            } else if (!results.isEmpty()) {
                this.target = results.get(0);
            }
            if (this.target == null) {
                throw new DataIntegrityViolationException("Proxy for [" + this.proxyClass.getName() + "] for association [" + this.executor.getIndexedEntity().getName() + "] could not be initialized");
            }
        }
        return this.target;
    }

    @Override
    protected Object handleInvocationFallback(Object self, Method thisMethod, Object[] args) {
        Object actualTarget = this.getProxyTarget(self);
        if (!thisMethod.getDeclaringClass().isInstance(actualTarget)) {
            if (Modifier.isPublic(thisMethod.getModifiers())) {
                Method method = ReflectionUtils.findMethod(actualTarget.getClass(), (String)thisMethod.getName(), (Class[])thisMethod.getParameterTypes());
                if (method != null) {
                    ReflectionUtils.makeAccessible((Method)method);
                    thisMethod = method;
                }
            } else {
                Method method = ReflectionUtils.findMethod(actualTarget.getClass(), (String)thisMethod.getName(), (Class[])thisMethod.getParameterTypes());
                if (method != null) {
                    thisMethod = method;
                }
            }
        }
        return ReflectionUtils.invokeMethod((Method)thisMethod, (Object)actualTarget, (Object[])args);
    }
}

