/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.fxml;

import com.sun.javafx.collections.MapListenerHelper;
import com.sun.javafx.fxml.PropertyName;
import com.sun.javafx.fxml.PropertyNotFoundException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.Property;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import sun.reflect.misc.FieldUtil;
import sun.reflect.misc.MethodUtil;
import sun.reflect.misc.ReflectUtil;

public class BeanAdapter
extends AbstractMap<String, Object>
implements ObservableMap<String, Object> {
    private Object bean;
    private HashMap<String, Method> getterMethods = new HashMap();
    private HashMap<String, Method> setterMethods = new HashMap();
    private HashMap<String, Method> propertyModelMethods = new HashMap();
    private HashMap<String, String> aliases = new HashMap();
    private PropertyEntrySet entrySet = new PropertyEntrySet();
    private LinkedList<PropertyInvalidationListener> propertyInvalidationListeners = null;
    private MapListenerHelper<String, Object> listenerHelper;
    public static final String GET_PREFIX = "get";
    public static final String IS_PREFIX = "is";
    public static final String SET_PREFIX = "set";
    public static final String PROPERTY_MODEL_SUFFIX = "Property";
    public static final String VALUE_OF_METHOD_NAME = "valueOf";
    public static final String CHANGE_LISTENERS_SUFFIX = "ChangeListeners";

    public BeanAdapter() {
        this(null);
    }

    public BeanAdapter(Object object) {
        this.setBean(object);
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object object) {
        if (object instanceof Map) {
            throw new IllegalArgumentException("Invalid bean.");
        }
        Object object2 = this.bean;
        if (object2 != object) {
            Class<?> clazz;
            if (MapListenerHelper.hasListeners(this.listenerHelper)) {
                this.unregisterPropertyChangeHandlers();
            }
            this.bean = object;
            Class<?> clazz2 = object2 == null ? null : object2.getClass();
            Class<?> clazz3 = clazz = object == null ? null : object.getClass();
            if (clazz2 != clazz) {
                this.updateMethodCache();
            }
            if (MapListenerHelper.hasListeners(this.listenerHelper)) {
                this.registerPropertyChangeHandlers();
            }
        }
    }

    private void updateMethodCache() {
        this.getterMethods.clear();
        this.setterMethods.clear();
        if (this.bean != null) {
            Object object;
            Object object2;
            String string;
            Object object3;
            int n;
            Method method;
            int n2;
            Class<?> clazz = this.bean.getClass();
            Method[] methodArray = MethodUtil.getMethods(clazz);
            for (n2 = 0; n2 < methodArray.length; ++n2) {
                method = methodArray[n2];
                n = method.getModifiers();
                if ((n & 8) != 0 || (object3 = (string = method.getName()).startsWith(GET_PREFIX) ? "get" : (string.startsWith(IS_PREFIX) ? IS_PREFIX : null)) == null || ((Class<?>[])(object2 = method.getParameterTypes())).length != 0) continue;
                object = BeanAdapter.getKey(string, object3);
                PropertyName propertyName = method.getAnnotation(PropertyName.class);
                if (propertyName != null) {
                    this.aliases.put((String)object, propertyName.value());
                    object = this.aliases.get(object);
                }
                this.getterMethods.put((String)object, method);
            }
            for (n2 = 0; n2 < methodArray.length; ++n2) {
                method = methodArray[n2];
                n = method.getModifiers();
                if ((n & 8) != 0) continue;
                string = method.getName();
                if (string.startsWith(SET_PREFIX)) {
                    object3 = method.getParameterTypes();
                    if (((Class<?>[])object3).length != 1) continue;
                    object2 = BeanAdapter.getKey(string, SET_PREFIX);
                    object = this.getterMethods.get(object2);
                    if (object == null) {
                        object2 = this.aliases.get(object2);
                        object = this.getterMethods.get(object2);
                    }
                    if (object == null || object3[0] != ((Method)object).getReturnType()) continue;
                    this.setterMethods.put((String)object2, method);
                    continue;
                }
                if (!string.endsWith(PROPERTY_MODEL_SUFFIX) || ((Class<?>[])(object3 = method.getParameterTypes())).length != 0) continue;
                object2 = string.substring(0, string.length() - PROPERTY_MODEL_SUFFIX.length());
                object = this.getterMethods.get(object2);
                if (object == null) {
                    object2 = this.aliases.get(object2);
                    object = this.getterMethods.get(object2);
                }
                if (object == null) continue;
                this.propertyModelMethods.put((String)object2, method);
            }
        }
    }

    private static String getKey(String string, String string2) {
        return Character.toLowerCase(string.charAt(string2.length())) + string.substring(string2.length() + 1);
    }

    @Override
    public Object get(Object object) {
        Method method;
        if (object == null) {
            throw new NullPointerException();
        }
        Object object2 = null;
        if (this.bean != null && (method = this.getterMethods.get(object.toString())) != null) {
            try {
                object2 = MethodUtil.invoke(method, this.bean, null);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
        }
        return object2;
    }

    @Override
    public Object put(String string, Object object) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (this.bean == null) {
            throw new IllegalStateException();
        }
        Method method = this.setterMethods.get(string);
        if (method == null) {
            throw new PropertyNotFoundException("Property \"" + string + "\" does not exist" + " or is read-only.");
        }
        try {
            MethodUtil.invoke(method, this.bean, new Object[]{BeanAdapter.coerce(object, this.getType(string))});
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
        return null;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.getterMethods.containsKey(object);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.bean == null ? Collections.EMPTY_SET : this.entrySet;
    }

    public boolean isReadOnly(String string) {
        return !this.setterMethods.containsKey(string);
    }

    public Class<?> getType(String string) {
        Method method = this.getterMethods.get(string);
        return method == null ? null : method.getReturnType();
    }

    public Type getGenericType(String string) {
        Method method = this.getterMethods.get(string);
        return method == null ? null : method.getGenericReturnType();
    }

    public Property<Object> getPropertyModel(String string) {
        Property property;
        Method method = this.propertyModelMethods.get(string);
        if (method != null) {
            try {
                property = (Property)MethodUtil.invoke(method, this.bean, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
        } else {
            property = null;
        }
        return property;
    }

    @Override
    public void addListener(InvalidationListener invalidationListener) {
        if (!MapListenerHelper.hasListeners(this.listenerHelper)) {
            this.registerPropertyChangeHandlers();
        }
        this.listenerHelper = MapListenerHelper.addListener(this.listenerHelper, invalidationListener);
    }

    @Override
    public void addListener(MapChangeListener<? super String, ? super Object> mapChangeListener) {
        if (!MapListenerHelper.hasListeners(this.listenerHelper)) {
            this.registerPropertyChangeHandlers();
        }
        this.listenerHelper = MapListenerHelper.addListener(this.listenerHelper, mapChangeListener);
    }

    @Override
    public void removeListener(InvalidationListener invalidationListener) {
        this.listenerHelper = MapListenerHelper.removeListener(this.listenerHelper, invalidationListener);
        if (!MapListenerHelper.hasListeners(this.listenerHelper)) {
            this.unregisterPropertyChangeHandlers();
        }
    }

    @Override
    public void removeListener(MapChangeListener<? super String, ? super Object> mapChangeListener) {
        this.listenerHelper = MapListenerHelper.removeListener(this.listenerHelper, mapChangeListener);
        if (!MapListenerHelper.hasListeners(this.listenerHelper)) {
            this.unregisterPropertyChangeHandlers();
        }
    }

    private void registerPropertyChangeHandlers() {
        this.propertyInvalidationListeners = new LinkedList();
        for (String string : this.keySet()) {
            Property<Object> property = this.getPropertyModel(string);
            if (property == null) continue;
            PropertyInvalidationListener propertyInvalidationListener = new PropertyInvalidationListener(string);
            property.addListener(propertyInvalidationListener);
            this.propertyInvalidationListeners.add(propertyInvalidationListener);
        }
    }

    private void unregisterPropertyChangeHandlers() {
        for (PropertyInvalidationListener propertyInvalidationListener : this.propertyInvalidationListeners) {
            Property<Object> property = this.getPropertyModel(propertyInvalidationListener.key);
            property.removeListener(propertyInvalidationListener);
        }
        this.propertyInvalidationListeners = null;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof BeanAdapter) {
            BeanAdapter beanAdapter = (BeanAdapter)object;
            bl = this.bean == beanAdapter.bean;
        }
        return bl;
    }

    @Override
    public int hashCode() {
        return this.bean == null ? -1 : this.bean.hashCode();
    }

    public static <T> T coerce(Object object, Class<? extends T> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        Object object2 = null;
        if (object == null) {
            object2 = null;
        } else if (clazz.isAssignableFrom(object.getClass())) {
            object2 = object;
        } else if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            object2 = Boolean.valueOf(object.toString());
        } else if (clazz == Character.class || clazz == Character.TYPE) {
            object2 = Character.valueOf(object.toString().charAt(0));
        } else if (clazz == Byte.class || clazz == Byte.TYPE) {
            object2 = object instanceof Number ? Byte.valueOf(((Number)object).byteValue()) : Byte.valueOf(object.toString());
        } else if (clazz == Short.class || clazz == Short.TYPE) {
            object2 = object instanceof Number ? Short.valueOf(((Number)object).shortValue()) : Short.valueOf(object.toString());
        } else if (clazz == Integer.class || clazz == Integer.TYPE) {
            object2 = object instanceof Number ? Integer.valueOf(((Number)object).intValue()) : Integer.valueOf(object.toString());
        } else if (clazz == Long.class || clazz == Long.TYPE) {
            object2 = object instanceof Number ? Long.valueOf(((Number)object).longValue()) : Long.valueOf(object.toString());
        } else if (clazz == BigInteger.class) {
            object2 = object instanceof Number ? BigInteger.valueOf(((Number)object).longValue()) : new BigInteger(object.toString());
        } else if (clazz == Float.class || clazz == Float.TYPE) {
            object2 = object instanceof Number ? Float.valueOf(((Number)object).floatValue()) : Float.valueOf(object.toString());
        } else if (clazz == Double.class || clazz == Double.TYPE) {
            object2 = object instanceof Number ? Double.valueOf(((Number)object).doubleValue()) : Double.valueOf(object.toString());
        } else if (clazz == Number.class) {
            String string = object.toString();
            object2 = string.contains(".") ? (Number)Double.valueOf(string) : (Number)Long.valueOf(string);
        } else if (clazz == BigDecimal.class) {
            object2 = object instanceof Number ? BigDecimal.valueOf(((Number)object).doubleValue()) : new BigDecimal(object.toString());
        } else {
            if (clazz == Class.class) {
                try {
                    object2 = ReflectUtil.forName(object.toString());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IllegalArgumentException(classNotFoundException);
                }
            }
            Class<?> clazz2 = object.getClass();
            Method method = null;
            while (method == null && clazz2 != null) {
                try {
                    ReflectUtil.checkPackageAccess(clazz);
                    method = clazz.getDeclaredMethod(VALUE_OF_METHOD_NAME, clazz2);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (method != null) continue;
                clazz2 = clazz2.getSuperclass();
            }
            if (method == null) {
                throw new IllegalArgumentException("Unable to coerce " + object + " to " + clazz + ".");
            }
            if (clazz.isEnum() && object instanceof String && Character.isLowerCase(((String)object).charAt(0))) {
                object = BeanAdapter.toAllCaps((String)object);
            }
            try {
                object2 = MethodUtil.invoke(method, null, new Object[]{object});
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
            catch (SecurityException securityException) {
                throw new RuntimeException(securityException);
            }
        }
        return (T)object2;
    }

    public static <T> T get(Object object, Class<?> clazz, String string) {
        Object object2 = null;
        Class<?> clazz2 = object.getClass();
        Method method = BeanAdapter.getStaticGetterMethod(clazz, string, clazz2);
        if (method != null) {
            try {
                object2 = MethodUtil.invoke(method, null, new Object[]{object});
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
        }
        return (T)object2;
    }

    public static void put(Object object, Class<?> clazz, String string, Object object2) {
        Class<?> clazz2;
        Class<?> clazz3 = object.getClass();
        Method method = null;
        if (object2 != null) {
            method = BeanAdapter.getStaticSetterMethod(clazz, string, object2.getClass(), clazz3);
        }
        if (method == null && (clazz2 = BeanAdapter.getType(clazz, string, clazz3)) != null) {
            method = BeanAdapter.getStaticSetterMethod(clazz, string, clazz2, clazz3);
            object2 = BeanAdapter.coerce(object2, clazz2);
        }
        if (method == null) {
            throw new PropertyNotFoundException("Static property \"" + string + "\" does not exist" + " or is read-only.");
        }
        try {
            MethodUtil.invoke(method, null, new Object[]{object, object2});
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    public static boolean isDefined(Class<?> clazz, String string, Class<?> clazz2) {
        return BeanAdapter.getStaticGetterMethod(clazz, string, clazz2) != null;
    }

    public static Class<?> getType(Class<?> clazz, String string, Class<?> clazz2) {
        Method method = BeanAdapter.getStaticGetterMethod(clazz, string, clazz2);
        return method == null ? null : method.getReturnType();
    }

    public static Type getGenericType(Class<?> clazz, String string, Class<?> clazz2) {
        Method method = BeanAdapter.getStaticGetterMethod(clazz, string, clazz2);
        return method == null ? null : method.getGenericReturnType();
    }

    public static Class<?> getListItemType(Type type) {
        Type type2 = BeanAdapter.getGenericListItemType(type);
        if (type2 instanceof ParameterizedType) {
            type2 = ((ParameterizedType)type2).getRawType();
        }
        return (Class)type2;
    }

    public static Class<?> getMapValueType(Type type) {
        Type type2 = BeanAdapter.getGenericMapValueType(type);
        if (type2 instanceof ParameterizedType) {
            type2 = ((ParameterizedType)type2).getRawType();
        }
        return (Class)type2;
    }

    public static Type getGenericListItemType(Type type) {
        Object object = null;
        Type type2 = type;
        while (type2 != null) {
            Object object2;
            Type type3;
            if (type2 instanceof ParameterizedType) {
                type3 = (ParameterizedType)type2;
                object2 = (Class)type3.getRawType();
                if (!List.class.isAssignableFrom((Class<?>)object2)) break;
                object = type3.getActualTypeArguments()[0];
                break;
            }
            type3 = (Class)type2;
            object2 = ((Class)type3).getGenericInterfaces();
            for (int i = 0; i < ((Type[])object2).length; ++i) {
                ParameterizedType parameterizedType;
                Class clazz;
                Type type4 = object2[i];
                if (!(type4 instanceof ParameterizedType) || !List.class.isAssignableFrom(clazz = (Class)(parameterizedType = (ParameterizedType)type4).getRawType())) continue;
                object = parameterizedType.getActualTypeArguments()[0];
                break;
            }
            if (object != null) break;
            type2 = ((Class)type3).getGenericSuperclass();
        }
        if (object != null && object instanceof TypeVariable) {
            object = Object.class;
        }
        return object;
    }

    public static Type getGenericMapValueType(Type type) {
        Object object = null;
        Type type2 = type;
        while (type2 != null) {
            Object object2;
            Type type3;
            if (type2 instanceof ParameterizedType) {
                type3 = (ParameterizedType)type2;
                object2 = (Class)type3.getRawType();
                if (!Map.class.isAssignableFrom((Class<?>)object2)) break;
                object = type3.getActualTypeArguments()[1];
                break;
            }
            type3 = (Class)type2;
            object2 = ((Class)type3).getGenericInterfaces();
            for (int i = 0; i < ((Type[])object2).length; ++i) {
                ParameterizedType parameterizedType;
                Class clazz;
                Type type4 = object2[i];
                if (!(type4 instanceof ParameterizedType) || !Map.class.isAssignableFrom(clazz = (Class)(parameterizedType = (ParameterizedType)type4).getRawType())) continue;
                object = parameterizedType.getActualTypeArguments()[1];
                break;
            }
            if (object != null) break;
            type2 = ((Class)type3).getGenericSuperclass();
        }
        if (object != null && object instanceof TypeVariable) {
            object = Object.class;
        }
        return object;
    }

    public static Object getConstantValue(Class<?> clazz, String string) {
        Object object;
        Field field;
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        if (string == null) {
            throw new IllegalArgumentException();
        }
        try {
            field = FieldUtil.getField(clazz, string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalArgumentException(noSuchFieldException);
        }
        int n = field.getModifiers();
        if ((n & 8) == 0 || (n & 0x10) == 0) {
            throw new IllegalArgumentException("Field is not a constant.");
        }
        try {
            object = field.get(null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException(illegalAccessException);
        }
        return object;
    }

    private static Method getStaticGetterMethod(Class<?> clazz, String string, Class<?> clazz2) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (string == null) {
            throw new NullPointerException();
        }
        Method method = null;
        if (clazz2 != null) {
            string = Character.toUpperCase(string.charAt(0)) + string.substring(1);
            String string2 = GET_PREFIX + string;
            String string3 = IS_PREFIX + string;
            try {
                method = MethodUtil.getMethod(clazz, string2, new Class[]{clazz2});
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (method == null) {
                try {
                    method = MethodUtil.getMethod(clazz, string3, new Class[]{clazz2});
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (method == null) {
                Class<?>[] classArray = clazz2.getInterfaces();
                for (int i = 0; i < classArray.length; ++i) {
                    try {
                        method = MethodUtil.getMethod(clazz, string2, new Class[]{classArray[i]});
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    if (method == null) {
                        try {
                            method = MethodUtil.getMethod(clazz, string3, new Class[]{classArray[i]});
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                    if (method != null) break;
                }
            }
            if (method == null) {
                method = BeanAdapter.getStaticGetterMethod(clazz, string, clazz2.getSuperclass());
            }
        }
        return method;
    }

    private static Method getStaticSetterMethod(Class<?> clazz, String string, Class<?> clazz2, Class<?> clazz3) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (string == null) {
            throw new NullPointerException();
        }
        if (clazz2 == null) {
            throw new NullPointerException();
        }
        Method method = null;
        if (clazz3 != null) {
            string = Character.toUpperCase(string.charAt(0)) + string.substring(1);
            String string2 = SET_PREFIX + string;
            try {
                method = MethodUtil.getMethod(clazz, string2, new Class[]{clazz3, clazz2});
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (method == null) {
                Class<?>[] classArray = clazz3.getInterfaces();
                for (int i = 0; i < classArray.length; ++i) {
                    try {
                        method = MethodUtil.getMethod(clazz, string2, new Class[]{classArray[i], clazz2});
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    if (method != null) break;
                }
            }
            if (method == null) {
                method = BeanAdapter.getStaticSetterMethod(clazz, string, clazz2, clazz3.getSuperclass());
            }
        }
        return method;
    }

    private static String toAllCaps(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isUpperCase(c)) {
                stringBuilder.append('_');
            }
            stringBuilder.append(Character.toUpperCase(c));
        }
        return stringBuilder.toString();
    }

    private static class BeanAdapterChangeEvent
    extends MapChangeListener.Change<String, Object> {
        private String key;

        public BeanAdapterChangeEvent(BeanAdapter beanAdapter, String string) {
            super(beanAdapter);
            this.key = string;
        }

        @Override
        public boolean wasAdded() {
            return false;
        }

        @Override
        public boolean wasRemoved() {
            return true;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValueAdded() {
            return null;
        }

        @Override
        public Object getValueRemoved() {
            return null;
        }
    }

    private class PropertyEntry
    implements Map.Entry<String, Object> {
        private String key;

        public PropertyEntry(String string) {
            this.key = string;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return BeanAdapter.this.get(this.key);
        }

        @Override
        public Object setValue(Object object) {
            return BeanAdapter.this.put(this.key, object);
        }
    }

    private class PropertyEntrySet
    extends AbstractSet<Map.Entry<String, Object>> {
        private PropertyEntrySet() {
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            return new PropertyEntrySetIterator();
        }
    }

    private class PropertyEntrySetIterator
    implements Iterator<Map.Entry<String, Object>> {
        private Iterator<Map.Entry<String, Method>> getterMethodIterator;
        private String nextKey;

        public PropertyEntrySetIterator() {
            this.getterMethodIterator = BeanAdapter.this.getterMethods.entrySet().iterator();
            this.nextKey = null;
            this.nextKey();
        }

        @Override
        public boolean hasNext() {
            return this.nextKey != null;
        }

        @Override
        public Map.Entry<String, Object> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String string = this.nextKey;
            this.nextKey();
            return new PropertyEntry(string);
        }

        private void nextKey() {
            this.nextKey = null;
            while (this.getterMethodIterator.hasNext() && this.nextKey == null) {
                Map.Entry<String, Method> entry = this.getterMethodIterator.next();
                String string = entry.getKey();
                Method method = entry.getValue();
                Class<?> clazz = method.getReturnType();
                if (!BeanAdapter.this.setterMethods.keySet().contains(string) && !List.class.isAssignableFrom(clazz) && !Map.class.isAssignableFrom(clazz)) continue;
                this.nextKey = string;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class PropertyInvalidationListener
    implements InvalidationListener {
        public String key;

        public PropertyInvalidationListener(String string) {
            this.key = string;
        }

        @Override
        public void invalidated(Observable observable) {
            MapListenerHelper.fireValueChangedEvent(BeanAdapter.this.listenerHelper, new BeanAdapterChangeEvent(BeanAdapter.this, this.key));
        }
    }
}

