/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.control.behavior.ListCellBehavior;
import com.sun.javafx.scene.control.behavior.OrientedKeyBinding;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventType;
import javafx.geometry.Orientation;
import javafx.scene.control.Control;
import javafx.scene.control.FocusModel;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;

public class ListViewBehavior<T>
extends BehaviorBase<ListView<T>> {
    protected static final List<KeyBinding> LIST_VIEW_BINDINGS = new ArrayList<KeyBinding>();
    private boolean isShiftDown = false;
    private boolean isCtrlDown = false;
    private Callback<Integer, Integer> onScrollPageUp;
    private Callback<Integer, Integer> onScrollPageDown;
    private Runnable onFocusPreviousRow;
    private Runnable onFocusNextRow;
    private Runnable onSelectPreviousRow;
    private Runnable onSelectNextRow;
    private Runnable onMoveToFirstCell;
    private Runnable onMoveToLastCell;
    private boolean selectionChanging = false;
    private ListChangeListener<Integer> selectedIndicesListener = new ListChangeListener<Integer>(){

        @Override
        public void onChanged(ListChangeListener.Change change) {
            block0: while (change.next()) {
                if (!ListViewBehavior.this.selectionChanging) {
                    if (change.getList().isEmpty()) {
                        ListViewBehavior.this.setAnchor(-1);
                    } else if (!change.getList().contains(ListViewBehavior.this.getAnchor())) {
                        ListViewBehavior.this.setAnchor(-1);
                    }
                }
                int n = change.getAddedSize();
                if (ListViewBehavior.this.hasAnchor() || n <= 0) continue;
                List list = change.getAddedSubList();
                for (int i = 0; i < n; ++i) {
                    int n2 = (Integer)list.get(i);
                    if (n2 < 0) continue;
                    ListViewBehavior.this.setAnchor(n2);
                    continue block0;
                }
            }
        }
    };
    private final ListChangeListener itemsListListener = new ListChangeListener(){

        public void onChanged(ListChangeListener.Change change) {
            while (change.next()) {
                if (change.wasAdded() && change.getFrom() <= ListViewBehavior.this.getAnchor()) {
                    ListViewBehavior.this.setAnchor(ListViewBehavior.this.getAnchor() + change.getAddedSize());
                    continue;
                }
                if (!change.wasRemoved() || change.getFrom() > ListViewBehavior.this.getAnchor()) continue;
                ListViewBehavior.this.setAnchor(ListViewBehavior.this.getAnchor() - change.getRemovedSize());
            }
        }
    };

    @Override
    protected void callAction(String string) {
        if ("SelectPreviousRow".equals(string)) {
            this.selectPreviousRow();
        } else if ("SelectNextRow".equals(string)) {
            this.selectNextRow();
        } else if ("SelectFirstRow".equals(string)) {
            this.selectFirstRow();
        } else if ("SelectLastRow".equals(string)) {
            this.selectLastRow();
        } else if ("SelectAllToFirstRow".equals(string)) {
            this.selectAllToFirstRow();
        } else if ("SelectAllToLastRow".equals(string)) {
            this.selectAllToLastRow();
        } else if ("SelectAllPageUp".equals(string)) {
            this.selectAllPageUp();
        } else if ("SelectAllPageDown".equals(string)) {
            this.selectAllPageDown();
        } else if ("AlsoSelectNextRow".equals(string)) {
            this.alsoSelectNextRow();
        } else if ("AlsoSelectPreviousRow".equals(string)) {
            this.alsoSelectPreviousRow();
        } else if ("ClearSelection".equals(string)) {
            this.clearSelection();
        } else if ("SelectAll".equals(string)) {
            this.selectAll();
        } else if ("ScrollUp".equals(string)) {
            this.scrollPageUp();
        } else if ("ScrollDown".equals(string)) {
            this.scrollPageDown();
        } else if ("FocusPreviousRow".equals(string)) {
            this.focusPreviousRow();
        } else if ("FocusNextRow".equals(string)) {
            this.focusNextRow();
        } else if ("FocusPageUp".equals(string)) {
            this.focusPageUp();
        } else if ("FocusPageDown".equals(string)) {
            this.focusPageDown();
        } else if ("Activate".equals(string)) {
            this.activate();
        } else if ("CancelEdit".equals(string)) {
            this.cancelEdit();
        } else if ("FocusFirstRow".equals(string)) {
            this.focusFirstRow();
        } else if ("FocusLastRow".equals(string)) {
            this.focusLastRow();
        } else if ("toggleFocusOwnerSelection".equals(string)) {
            this.toggleFocusOwnerSelection();
        } else if ("SelectAllToFocus".equals(string)) {
            this.selectAllToFocus();
        } else if ("DiscontinuousSelectNextRow".equals(string)) {
            this.discontinuousSelectNextRow();
        } else if ("DiscontinuousSelectPreviousRow".equals(string)) {
            this.discontinuousSelectPreviousRow();
        } else if ("DiscontinuousSelectPageUp".equals(string)) {
            this.discontinuousSelectPageUp();
        } else if ("DiscontinuousSelectPageDown".equals(string)) {
            this.discontinuousSelectPageDown();
        } else if ("DiscontinuousSelectAllToLastRow".equals(string)) {
            this.discontinuousSelectAllToLastRow();
        } else if ("DiscontinuousSelectAllToFirstRow".equals(string)) {
            this.discontinuousSelectAllToFirstRow();
        } else {
            super.callAction(string);
        }
    }

    @Override
    protected List<KeyBinding> createKeyBindings() {
        return LIST_VIEW_BINDINGS;
    }

    @Override
    protected void callActionForEvent(KeyEvent keyEvent) {
        this.isShiftDown = keyEvent.getEventType() == KeyEvent.KEY_PRESSED && keyEvent.isShiftDown();
        this.isCtrlDown = keyEvent.getEventType() == KeyEvent.KEY_PRESSED && keyEvent.isControlDown();
        super.callActionForEvent(keyEvent);
    }

    public void setOnScrollPageUp(Callback<Integer, Integer> callback) {
        this.onScrollPageUp = callback;
    }

    public void setOnScrollPageDown(Callback<Integer, Integer> callback) {
        this.onScrollPageDown = callback;
    }

    public void setOnFocusPreviousRow(Runnable runnable) {
        this.onFocusPreviousRow = runnable;
    }

    public void setOnFocusNextRow(Runnable runnable) {
        this.onFocusNextRow = runnable;
    }

    public void setOnSelectPreviousRow(Runnable runnable) {
        this.onSelectPreviousRow = runnable;
    }

    public void setOnSelectNextRow(Runnable runnable) {
        this.onSelectNextRow = runnable;
    }

    public void setOnMoveToFirstCell(Runnable runnable) {
        this.onMoveToFirstCell = runnable;
    }

    public void setOnMoveToLastCell(Runnable runnable) {
        this.onMoveToLastCell = runnable;
    }

    public ListViewBehavior(ListView listView) {
        super(listView);
        listView.itemsProperty().addListener(new ChangeListener<ObservableList<T>>(){

            @Override
            public void changed(ObservableValue observableValue, ObservableList observableList, ObservableList observableList2) {
                if (observableList != null) {
                    observableList.removeListener(ListViewBehavior.this.itemsListListener);
                }
                if (observableList2 != null) {
                    observableList2.addListener(ListViewBehavior.this.itemsListListener);
                }
            }
        });
        if (listView.getItems() != null) {
            listView.getItems().addListener(this.itemsListListener);
        }
        ((ListView)this.getControl()).selectionModelProperty().addListener(new ChangeListener<MultipleSelectionModel<T>>(){

            @Override
            public void changed(ObservableValue<? extends MultipleSelectionModel<T>> observableValue, MultipleSelectionModel<T> multipleSelectionModel, MultipleSelectionModel<T> multipleSelectionModel2) {
                if (multipleSelectionModel != null) {
                    multipleSelectionModel.getSelectedIndices().removeListener(ListViewBehavior.this.selectedIndicesListener);
                }
                if (multipleSelectionModel2 != null) {
                    multipleSelectionModel2.getSelectedIndices().addListener(ListViewBehavior.this.selectedIndicesListener);
                }
            }
        });
        if (listView.getSelectionModel() != null) {
            listView.getSelectionModel().getSelectedIndices().addListener(this.selectedIndicesListener);
        }
    }

    private void setAnchor(int n) {
        ListCellBehavior.setAnchor((ListView)this.getControl(), n);
    }

    private int getAnchor() {
        return ListCellBehavior.getAnchor((ListView)this.getControl());
    }

    private boolean hasAnchor() {
        return ListCellBehavior.hasAnchor((ListView)this.getControl());
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        if (!mouseEvent.isShiftDown()) {
            int n = ((ListView)this.getControl()).getSelectionModel().getSelectedIndex();
            this.setAnchor(n);
        }
        if (!((ListView)this.getControl()).isFocused() && ((ListView)this.getControl()).isFocusTraversable()) {
            ((ListView)this.getControl()).requestFocus();
        }
    }

    private int getRowCount() {
        ObservableList observableList = ((ListView)this.getControl()).getItems();
        if (observableList == null) {
            return 0;
        }
        return observableList.size();
    }

    private void clearSelection() {
        ((ListView)this.getControl()).getSelectionModel().clearSelection();
    }

    private void scrollPageUp() {
        int n = -1;
        if (this.onScrollPageUp != null) {
            n = this.onScrollPageUp.call(this.getAnchor());
        }
        if (n == -1) {
            return;
        }
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        multipleSelectionModel.clearAndSelect(n);
    }

    private void scrollPageDown() {
        int n = -1;
        if (this.onScrollPageDown != null) {
            n = this.onScrollPageDown.call(this.getAnchor());
        }
        if (n == -1) {
            return;
        }
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        multipleSelectionModel.clearAndSelect(n);
    }

    private void focusFirstRow() {
        FocusModel focusModel = ((ListView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        focusModel.focus(0);
        if (this.onMoveToFirstCell != null) {
            this.onMoveToFirstCell.run();
        }
    }

    private void focusLastRow() {
        FocusModel focusModel = ((ListView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        focusModel.focus(this.getRowCount() - 1);
        if (this.onMoveToLastCell != null) {
            this.onMoveToLastCell.run();
        }
    }

    private void focusPreviousRow() {
        FocusModel focusModel = ((ListView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        focusModel.focusPrevious();
        if (!this.isCtrlDown || this.getAnchor() == -1) {
            this.setAnchor(focusModel.getFocusedIndex());
        }
        if (this.onFocusPreviousRow != null) {
            this.onFocusPreviousRow.run();
        }
    }

    private void focusNextRow() {
        FocusModel focusModel = ((ListView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        focusModel.focusNext();
        if (!this.isCtrlDown || this.getAnchor() == -1) {
            this.setAnchor(focusModel.getFocusedIndex());
        }
        if (this.onFocusNextRow != null) {
            this.onFocusNextRow.run();
        }
    }

    private void focusPageUp() {
        int n = this.onScrollPageUp.call(this.getAnchor());
        FocusModel focusModel = ((ListView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        focusModel.focus(n);
    }

    private void focusPageDown() {
        int n = this.onScrollPageDown.call(this.getAnchor());
        FocusModel focusModel = ((ListView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        focusModel.focus(n);
    }

    private void alsoSelectPreviousRow() {
        FocusModel focusModel = ((ListView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        if (this.isShiftDown && this.getAnchor() != -1) {
            int n = focusModel.getFocusedIndex() - 1;
            int n2 = this.getAnchor();
            if (!this.hasAnchor()) {
                this.setAnchor(focusModel.getFocusedIndex());
            }
            this.clearSelectionOutsideRange(n2, n);
            if (n2 > n) {
                multipleSelectionModel.selectRange(n2, n - 1);
            } else {
                multipleSelectionModel.selectRange(n2, n + 1);
            }
        } else {
            multipleSelectionModel.selectPrevious();
        }
        this.onSelectPreviousRow.run();
    }

    private void alsoSelectNextRow() {
        FocusModel focusModel = ((ListView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        if (this.isShiftDown && this.getAnchor() != -1) {
            int n = focusModel.getFocusedIndex() + 1;
            int n2 = this.getAnchor();
            if (!this.hasAnchor()) {
                this.setAnchor(focusModel.getFocusedIndex());
            }
            this.clearSelectionOutsideRange(n2, n);
            if (n2 > n) {
                multipleSelectionModel.selectRange(n2, n - 1);
            } else {
                multipleSelectionModel.selectRange(n2, n + 1);
            }
        } else {
            multipleSelectionModel.selectNext();
        }
        this.onSelectNextRow.run();
    }

    private void clearSelectionOutsideRange(int n, int n2) {
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(multipleSelectionModel.getSelectedIndices());
        this.selectionChanging = true;
        for (int i = 0; i < arrayList.size(); ++i) {
            int n5 = (Integer)arrayList.get(i);
            if (n5 >= n3 && n5 < n4) continue;
            multipleSelectionModel.clearSelection(n5);
        }
        this.selectionChanging = false;
    }

    private void selectPreviousRow() {
        FocusModel focusModel = ((ListView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex();
        if (n <= 0) {
            return;
        }
        this.setAnchor(n - 1);
        ((ListView)this.getControl()).getSelectionModel().clearAndSelect(n - 1);
        this.onSelectPreviousRow.run();
    }

    private void selectNextRow() {
        FocusModel focusModel = ((ListView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex();
        if (n == this.getRowCount() - 1) {
            return;
        }
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        this.setAnchor(n + 1);
        multipleSelectionModel.clearAndSelect(n + 1);
        if (this.onSelectNextRow != null) {
            this.onSelectNextRow.run();
        }
    }

    private void selectFirstRow() {
        if (this.getRowCount() > 0) {
            ((ListView)this.getControl()).getSelectionModel().clearAndSelect(0);
            if (this.onMoveToFirstCell != null) {
                this.onMoveToFirstCell.run();
            }
        }
    }

    private void selectLastRow() {
        ((ListView)this.getControl()).getSelectionModel().clearAndSelect(this.getRowCount() - 1);
        if (this.onMoveToLastCell != null) {
            this.onMoveToLastCell.run();
        }
    }

    private void selectAllPageUp() {
        FocusModel focusModel = ((ListView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex();
        if (this.isShiftDown) {
            n = this.getAnchor() == -1 ? n : this.getAnchor();
            this.setAnchor(n);
        }
        int n2 = this.onScrollPageUp.call(this.getAnchor());
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        this.selectionChanging = true;
        multipleSelectionModel.clearSelection();
        multipleSelectionModel.selectRange(n2, n + 1);
        this.selectionChanging = false;
    }

    private void selectAllPageDown() {
        FocusModel focusModel = ((ListView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex();
        if (this.isShiftDown) {
            n = this.getAnchor() == -1 ? n : this.getAnchor();
            this.setAnchor(n);
        }
        int n2 = this.onScrollPageDown.call(this.getAnchor());
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        this.selectionChanging = true;
        multipleSelectionModel.clearSelection();
        multipleSelectionModel.selectRange(n, n2 + 1);
        this.selectionChanging = false;
    }

    private void selectAllToFirstRow() {
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        int n = multipleSelectionModel.getSelectedIndex();
        if (this.isShiftDown) {
            n = this.hasAnchor() ? multipleSelectionModel.getSelectedIndex() : this.getAnchor();
        }
        multipleSelectionModel.clearSelection();
        multipleSelectionModel.selectRange(0, n + 1);
        if (this.isShiftDown) {
            this.setAnchor(n);
        }
        ((ListView)this.getControl()).getFocusModel().focus(0);
        if (this.onMoveToFirstCell != null) {
            this.onMoveToFirstCell.run();
        }
    }

    private void selectAllToLastRow() {
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        int n = multipleSelectionModel.getSelectedIndex();
        if (this.isShiftDown) {
            n = this.hasAnchor() ? multipleSelectionModel.getSelectedIndex() : this.getAnchor();
        }
        multipleSelectionModel.clearSelection();
        multipleSelectionModel.selectRange(n, this.getRowCount());
        if (this.isShiftDown) {
            this.setAnchor(n);
        }
        if (this.onMoveToLastCell != null) {
            this.onMoveToLastCell.run();
        }
    }

    private void selectAll() {
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        multipleSelectionModel.selectAll();
    }

    private void selectAllToFocus() {
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        FocusModel focusModel = ((ListView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex();
        int n2 = this.getAnchor();
        multipleSelectionModel.clearSelection();
        int n3 = n2;
        int n4 = n2 > n ? n - 1 : n + 1;
        multipleSelectionModel.selectRange(n3, n4);
        this.setAnchor(n2);
    }

    private void cancelEdit() {
        ((ListView)this.getControl()).edit(-1);
    }

    private void activate() {
        int n = ((ListView)this.getControl()).getFocusModel().getFocusedIndex();
        ((ListView)this.getControl()).getSelectionModel().select(n);
        ((ListView)this.getControl()).edit(n);
    }

    private void toggleFocusOwnerSelection() {
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        FocusModel focusModel = ((ListView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex();
        if (multipleSelectionModel.isSelected(n)) {
            multipleSelectionModel.clearSelection(n);
            focusModel.focus(n);
        } else {
            multipleSelectionModel.select(n);
        }
        this.setAnchor(n);
    }

    private void discontinuousSelectPreviousRow() {
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        FocusModel focusModel = ((ListView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex() - 1;
        if (n < 0) {
            return;
        }
        multipleSelectionModel.select(n);
    }

    private void discontinuousSelectNextRow() {
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        FocusModel focusModel = ((ListView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex() + 1;
        multipleSelectionModel.select(n);
    }

    private void discontinuousSelectPageUp() {
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        FocusModel focusModel = ((ListView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex();
        int n2 = this.onScrollPageUp.call(this.getAnchor());
        multipleSelectionModel.selectRange(n2, n + 1);
    }

    private void discontinuousSelectPageDown() {
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        FocusModel focusModel = ((ListView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex();
        int n2 = this.onScrollPageDown.call(this.getAnchor());
        multipleSelectionModel.selectRange(n, n2 + 1);
    }

    private void discontinuousSelectAllToFirstRow() {
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        FocusModel focusModel = ((ListView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex();
        multipleSelectionModel.selectRange(0, n);
        if (this.onMoveToFirstCell != null) {
            this.onMoveToFirstCell.run();
        }
    }

    private void discontinuousSelectAllToLastRow() {
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        FocusModel focusModel = ((ListView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex() + 1;
        multipleSelectionModel.selectRange(n, this.getRowCount());
        if (this.onMoveToLastCell != null) {
            this.onMoveToLastCell.run();
        }
    }

    static {
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.TAB, "TraverseNext"));
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.TAB, "TraversePrevious").shift());
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.HOME, "SelectFirstRow"));
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.END, "SelectLastRow"));
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.HOME, "SelectAllToFirstRow").shift());
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.END, "SelectAllToLastRow").shift());
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, "SelectAllPageUp").shift());
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, "SelectAllPageDown").shift());
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SPACE, "SelectAllToFocus").shift());
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, "ScrollUp"));
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, "ScrollDown"));
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.ENTER, "Activate"));
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SPACE, "Activate"));
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.F2, "Activate"));
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.ESCAPE, "CancelEdit"));
        if (PlatformUtil.isMac()) {
            LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.A, "SelectAll").meta());
            LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.HOME, "FocusFirstRow").meta());
            LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.END, "FocusLastRow").meta());
            LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SPACE, "toggleFocusOwnerSelection").ctrl().meta());
            LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, "FocusPageUp").meta());
            LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, "FocusPageDown").meta());
        } else {
            LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.A, "SelectAll").ctrl());
            LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.HOME, "FocusFirstRow").ctrl());
            LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.END, "FocusLastRow").ctrl());
            LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SPACE, "toggleFocusOwnerSelection").ctrl());
            LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, "FocusPageUp").ctrl());
            LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, "FocusPageDown").ctrl());
        }
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.UP, "SelectPreviousRow").vertical());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.KP_UP, "SelectPreviousRow").vertical());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.DOWN, "SelectNextRow").vertical());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.KP_DOWN, "SelectNextRow").vertical());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.UP, "AlsoSelectPreviousRow").vertical().shift());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.KP_UP, "AlsoSelectPreviousRow").vertical().shift());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.DOWN, "AlsoSelectNextRow").vertical().shift());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.KP_DOWN, "AlsoSelectNextRow").vertical().shift());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.LEFT, "TraverseLeft").vertical());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.KP_LEFT, "TraverseLeft").vertical());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.RIGHT, "TraverseRight").vertical());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.KP_RIGHT, "TraverseRight").vertical());
        if (PlatformUtil.isMac()) {
            LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.UP, "FocusPreviousRow").vertical().meta());
            LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.DOWN, "FocusNextRow").vertical().meta());
            LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.UP, "DiscontinuousSelectPreviousRow").vertical().meta().shift());
            LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.DOWN, "DiscontinuousSelectNextRow").vertical().meta().shift());
            LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.PAGE_UP, "DiscontinuousSelectPageUp").vertical().meta().shift());
            LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.PAGE_DOWN, "DiscontinuousSelectPageDown").vertical().meta().shift());
            LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.HOME, "DiscontinuousSelectAllToFirstRow").vertical().meta().shift());
            LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.END, "DiscontinuousSelectAllToLastRow").vertical().meta().shift());
        } else {
            LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.UP, "FocusPreviousRow").vertical().ctrl());
            LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.DOWN, "FocusNextRow").vertical().ctrl());
            LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.UP, "DiscontinuousSelectPreviousRow").vertical().ctrl().shift());
            LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.DOWN, "DiscontinuousSelectNextRow").vertical().ctrl().shift());
            LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.PAGE_UP, "DiscontinuousSelectPageUp").vertical().ctrl().shift());
            LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.PAGE_DOWN, "DiscontinuousSelectPageDown").vertical().ctrl().shift());
            LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.HOME, "DiscontinuousSelectAllToFirstRow").vertical().ctrl().shift());
            LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.END, "DiscontinuousSelectAllToLastRow").vertical().ctrl().shift());
        }
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.LEFT, "SelectPreviousRow"));
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.KP_LEFT, "SelectPreviousRow"));
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.RIGHT, "SelectNextRow"));
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.KP_RIGHT, "SelectNextRow"));
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.LEFT, "AlsoSelectPreviousRow").shift());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.KP_LEFT, "AlsoSelectPreviousRow").shift());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.RIGHT, "AlsoSelectNextRow").shift());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.KP_RIGHT, "AlsoSelectNextRow").shift());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.UP, "TraverseUp"));
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.KP_UP, "TraverseUp"));
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.DOWN, "TraverseDown"));
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.KP_DOWN, "TraverseDown"));
        if (PlatformUtil.isMac()) {
            LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.LEFT, "FocusPreviousRow").meta());
            LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.RIGHT, "FocusNextRow").meta());
        } else {
            LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.LEFT, "FocusPreviousRow").ctrl());
            LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.RIGHT, "FocusNextRow").ctrl());
        }
        if (PlatformUtil.isMac()) {
            LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.BACK_SLASH, "ClearSelection").meta());
        } else {
            LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.BACK_SLASH, "ClearSelection").ctrl());
        }
    }

    private static class ListViewKeyBinding
    extends OrientedKeyBinding {
        public ListViewKeyBinding(KeyCode keyCode, String string) {
            super(keyCode, string);
        }

        public ListViewKeyBinding(KeyCode keyCode, EventType<KeyEvent> eventType, String string) {
            super(keyCode, eventType, string);
        }

        @Override
        public boolean getVertical(Control control) {
            return ((ListView)control).getOrientation() == Orientation.VERTICAL;
        }
    }
}

