/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.script;

import org.apache.log4j.Logger;
import org.parosproxy.paros.core.proxy.ProxyListener;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.script.ExtensionScript;
import org.zaproxy.zap.extension.script.ScriptWrapper;

public class ProxyListenerScript
implements ProxyListener {
    public static final int PROXY_LISTENER_ORDER = 4998;
    private ExtensionScript extension = null;
    private static final Logger logger = Logger.getLogger(ProxyListenerScript.class);

    public ProxyListenerScript(ExtensionScript extensionScript) {
        this.extension = extensionScript;
    }

    @Override
    public int getArrangeableListenerOrder() {
        return 4998;
    }

    @Override
    public boolean onHttpRequestSend(HttpMessage httpMessage) {
        for (ScriptWrapper scriptWrapper : this.extension.getScripts("proxy")) {
            if (!scriptWrapper.isEnabled()) continue;
            try {
                if (this.extension.invokeProxyScript(scriptWrapper, httpMessage, true)) continue;
                return false;
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        return true;
    }

    @Override
    public boolean onHttpResponseReceive(HttpMessage httpMessage) {
        for (ScriptWrapper scriptWrapper : this.extension.getScripts("proxy")) {
            if (!scriptWrapper.isEnabled()) continue;
            try {
                if (this.extension.invokeProxyScript(scriptWrapper, httpMessage, false)) continue;
                return false;
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        return true;
    }
}

