/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.Gradient;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.Color;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class LinearGradient
extends Gradient {
    public static final String TAG_NAME = "lineargradient";
    float x1 = 0.0f;
    float y1 = 0.0f;
    float x2 = 1.0f;
    float y2 = 0.0f;

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    protected void build() throws SVGException {
        super.build();
        StyleAttribute styleAttribute = new StyleAttribute();
        if (this.getPres(styleAttribute.setName("x1"))) {
            this.x1 = styleAttribute.getFloatValueWithUnits();
        }
        if (this.getPres(styleAttribute.setName("y1"))) {
            this.y1 = styleAttribute.getFloatValueWithUnits();
        }
        if (this.getPres(styleAttribute.setName("x2"))) {
            this.x2 = styleAttribute.getFloatValueWithUnits();
        }
        if (this.getPres(styleAttribute.setName("y2"))) {
            this.y2 = styleAttribute.getFloatValueWithUnits();
        }
    }

    @Override
    public Paint getPaint(Rectangle2D rectangle2D, AffineTransform affineTransform) {
        Paint paint;
        MultipleGradientPaint.CycleMethod cycleMethod;
        switch (this.spreadMethod) {
            default: {
                cycleMethod = MultipleGradientPaint.CycleMethod.NO_CYCLE;
                break;
            }
            case 1: {
                cycleMethod = MultipleGradientPaint.CycleMethod.REPEAT;
                break;
            }
            case 2: {
                cycleMethod = MultipleGradientPaint.CycleMethod.REFLECT;
            }
        }
        Point2D.Float float_ = new Point2D.Float(this.x1, this.y1);
        Point2D.Float float_2 = new Point2D.Float(this.x2, this.y2);
        if (float_.equals(float_2)) {
            Color[] colorArray = this.getStopColors();
            paint = colorArray.length > 0 ? colorArray[0] : Color.black;
        } else if (this.gradientUnits == 1) {
            paint = new LinearGradientPaint(float_, float_2, this.getStopFractions(), this.getStopColors(), cycleMethod, MultipleGradientPaint.ColorSpaceType.SRGB, this.gradientTransform == null ? new AffineTransform() : this.gradientTransform);
        } else {
            AffineTransform affineTransform2 = new AffineTransform();
            affineTransform2.translate(rectangle2D.getX(), rectangle2D.getY());
            double d = Math.max(1.0, rectangle2D.getWidth());
            double d2 = Math.max(1.0, rectangle2D.getHeight());
            affineTransform2.scale(d, d2);
            if (this.gradientTransform != null) {
                affineTransform2.concatenate(this.gradientTransform);
            }
            paint = new LinearGradientPaint(float_, float_2, this.getStopFractions(), this.getStopColors(), cycleMethod, MultipleGradientPaint.ColorSpaceType.SRGB, affineTransform2);
        }
        return paint;
    }

    @Override
    public boolean updateTime(double d) throws SVGException {
        float f;
        boolean bl = super.updateTime(d);
        StyleAttribute styleAttribute = new StyleAttribute();
        boolean bl2 = false;
        if (this.getPres(styleAttribute.setName("x1")) && (f = styleAttribute.getFloatValueWithUnits()) != this.x1) {
            this.x1 = f;
            bl2 = true;
        }
        if (this.getPres(styleAttribute.setName("y1")) && (f = styleAttribute.getFloatValueWithUnits()) != this.y1) {
            this.y1 = f;
            bl2 = true;
        }
        if (this.getPres(styleAttribute.setName("x2")) && (f = styleAttribute.getFloatValueWithUnits()) != this.x2) {
            this.x2 = f;
            bl2 = true;
        }
        if (this.getPres(styleAttribute.setName("y2")) && (f = styleAttribute.getFloatValueWithUnits()) != this.y2) {
            this.y2 = f;
            bl2 = true;
        }
        return bl || bl2;
    }
}

