/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences;

import org.openstreetmap.josm.data.preferences.AbstractProperty;

public class CachingProperty<T>
extends AbstractProperty<T>
implements AbstractProperty.ValueChangeListener<T> {
    private T cache;
    private boolean cacheActive;
    private final AbstractProperty<T> toCache;

    CachingProperty(AbstractProperty<T> abstractProperty) {
        super(abstractProperty.getKey(), abstractProperty.getDefaultValue());
        this.toCache = abstractProperty;
        this.addWeakListener(this);
    }

    @Override
    public synchronized T get() {
        if (!this.cacheActive) {
            this.cache = this.toCache.get();
            this.cacheActive = true;
        }
        return this.cache;
    }

    @Override
    public boolean put(T t) {
        return this.toCache.put(t);
    }

    @Override
    public synchronized void valueChanged(AbstractProperty.ValueChangeEvent<? extends T> valueChangeEvent) {
        this.cacheActive = false;
    }
}

