/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset.query;

import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.FormatStyle;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.tools.I18n;

public class TimeValidator
extends AbstractTextComponentValidator {
    public TimeValidator(JTextComponent jTextComponent) {
        super(jTextComponent);
    }

    public static TimeValidator decorate(JTextComponent jTextComponent) {
        return new TimeValidator(jTextComponent);
    }

    @Override
    public boolean isValid() {
        if (this.getComponent().getText().trim().isEmpty()) {
            return true;
        }
        return this.getTime() != null;
    }

    public String getStandardTooltipTextAsHtml() {
        return "<html>" + this.getStandardTooltipText() + "</html>";
    }

    public String getStandardTooltipText() {
        ZonedDateTime zonedDateTime = ZonedDateTime.now();
        return I18n.tr("Please enter a valid time in the usual format for your locale.<br>Example: {0}<br>Example: {1}<br>Example: {2}<br>Example: {3}<br>", DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT).format(zonedDateTime), DateTimeFormatter.ofLocalizedTime(FormatStyle.MEDIUM).format(zonedDateTime), DateTimeFormatter.ofLocalizedTime(FormatStyle.LONG).format(zonedDateTime), DateTimeFormatter.ofLocalizedTime(FormatStyle.FULL).format(zonedDateTime));
    }

    @Override
    public void validate() {
        if (!this.isValid()) {
            String string = "<html>The current value isn't a valid time.<br>" + this.getStandardTooltipText() + "</html>";
            this.feedbackInvalid(string);
            return;
        }
        String string = "<html>" + this.getStandardTooltipText() + "</html>";
        this.feedbackValid(string);
    }

    public LocalTime getTime() {
        if (this.getComponent().getText().trim().isEmpty()) {
            return LocalTime.MIDNIGHT;
        }
        for (FormatStyle formatStyle : FormatStyle.values()) {
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofLocalizedTime(formatStyle);
            try {
                return LocalTime.parse(this.getComponent().getText(), dateTimeFormatter);
            }
            catch (DateTimeParseException dateTimeParseException) {
                Main.trace(dateTimeParseException);
            }
        }
        return LocalTime.MIDNIGHT;
    }
}

