/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.modules;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.modules.CoreLocalPathVirtualFile;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/modules/CoreJrtFileSystem;", "Lcom/intellij/openapi/vfs/DeprecatedVirtualFileSystem;", "fileSystem", "Ljava/nio/file/FileSystem;", "(Ljava/nio/file/FileSystem;)V", "findFileByPath", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "Ljava/nio/file/Path;", "", "getProtocol", "refresh", "", "asynchronous", "", "refreshAndFindFileByPath", "Companion", "kotlin-compiler"})
public final class CoreJrtFileSystem
extends DeprecatedVirtualFileSystem {
    private final FileSystem fileSystem;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getProtocol() {
        return "jrt";
    }

    private final VirtualFile findFileByPath(Path path) {
        return Files.exists(path, new LinkOption[0]) ? (VirtualFile)new CoreLocalPathVirtualFile(this, path) : null;
    }

    @Override
    @Nullable
    public VirtualFile findFileByPath(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        Path path2 = this.fileSystem.getPath(path, new String[0]);
        Intrinsics.checkExpressionValueIsNotNull(path2, "fileSystem.getPath(path)");
        return this.findFileByPath(path2);
    }

    @Override
    public void refresh(boolean asynchronous) {
    }

    @Override
    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        return this.findFileByPath(path);
    }

    public CoreJrtFileSystem(@NotNull FileSystem fileSystem) {
        Intrinsics.checkParameterIsNotNull(fileSystem, "fileSystem");
        this.fileSystem = fileSystem;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/modules/CoreJrtFileSystem$Companion;", "", "()V", "create", "Lorg/jetbrains/kotlin/cli/jvm/modules/CoreJrtFileSystem;", "jdkHome", "Ljava/io/File;", "kotlin-compiler"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @Nullable
        public final CoreJrtFileSystem create(@NotNull File jdkHome) {
            FileSystem fileSystem;
            FileSystem fileSystem2;
            Intrinsics.checkParameterIsNotNull(jdkHome, "jdkHome");
            URI rootUri = URI.create("jrt:/");
            if (SystemInfo.isJavaVersionAtLeast("9")) {
                fileSystem2 = FileSystems.newFileSystem(rootUri, MapsKt.mapOf(TuplesKt.to("java.home", jdkHome.getAbsolutePath())));
            } else {
                void elements$iv;
                URLClassLoader uRLClassLoader;
                File jrtFsJar = new File(jdkHome, "lib/jrt-fs.jar");
                if (!jrtFsJar.exists()) {
                    return null;
                }
                Object[] objectArray = new URL[]{jrtFsJar.toURI().toURL()};
                URLClassLoader uRLClassLoader2 = uRLClassLoader;
                URLClassLoader uRLClassLoader3 = uRLClassLoader;
                void var9_7 = elements$iv;
                uRLClassLoader2((URL[])var9_7, (ClassLoader)null);
                URLClassLoader classLoader = uRLClassLoader3;
                fileSystem2 = FileSystems.newFileSystem(rootUri, MapsKt.emptyMap(), (ClassLoader)classLoader);
            }
            FileSystem fileSystem3 = fileSystem = fileSystem2;
            Intrinsics.checkExpressionValueIsNotNull(fileSystem3, "fileSystem");
            return new CoreJrtFileSystem(fileSystem3);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

