/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.memorylint.rules;

import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.heapwalk.memorylint.Histogram;
import org.netbeans.modules.profiler.heapwalk.memorylint.MemoryLint;
import org.netbeans.modules.profiler.heapwalk.memorylint.Rule;
import org.netbeans.modules.profiler.heapwalk.memorylint.Utils;
import org.openide.util.NbBundle;

public class RetainedSetByClass
extends Rule {
    private MemoryLint context;

    public RetainedSetByClass() {
        super(NbBundle.getMessage(RetainedSetByClass.class, (String)"LBL_RSBC_Name"), NbBundle.getMessage(RetainedSetByClass.class, (String)"LBL_RSBC_Desc"));
    }

    @Override
    public String getHTMLDescription() {
        return NbBundle.getMessage(RetainedSetByClass.class, (String)"LBL_RSBC_LongDesc");
    }

    @Override
    public void perform() {
        Heap heap = this.context.getHeap();
        List list = heap.getAllClasses();
        Histogram<Histogram.Entry> histogram = new Histogram<Histogram.Entry>();
        for (JavaClass javaClass : list) {
            Logger.getLogger(RetainedSetByClass.class.getName()).log(Level.FINE, "Executing rule on class {0}.", javaClass);
            this.performClass(javaClass, histogram);
            if (!this.context.isInterruped()) continue;
            return;
        }
        this.summary(histogram);
    }

    @Override
    public void prepare(MemoryLint memoryLint) {
        this.context = memoryLint;
    }

    @Override
    protected JComponent createCustomizer() {
        return null;
    }

    private void performClass(JavaClass javaClass, Histogram<Histogram.Entry> histogram) {
        Set<Instance> set = Utils.getRetainedSet(javaClass.getInstances(), this.context.getHeap());
        String string = javaClass.getName();
        string = Utils.printClass(this.context, string);
        for (Instance instance : set) {
            histogram.add(string, new Histogram.Entry(instance.getSize()));
        }
    }

    private void summary(Histogram histogram) {
        this.context.appendResults(histogram.toString(0));
    }
}

