/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.FloatingWindowTransparencyManager;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.PersistenceHandler;
import org.netbeans.core.windows.SplitConstraint;
import org.netbeans.core.windows.Switches;
import org.netbeans.core.windows.TopComponentGroupImpl;
import org.netbeans.core.windows.TopComponentTracker;
import org.netbeans.core.windows.ViewRequest;
import org.netbeans.core.windows.ViewRequestor;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.WindowSystemSnapshot;
import org.netbeans.core.windows.model.DockingStatus;
import org.netbeans.core.windows.model.Model;
import org.netbeans.core.windows.model.ModelElement;
import org.netbeans.core.windows.model.ModelFactory;
import org.netbeans.core.windows.options.WinSysPrefs;
import org.netbeans.core.windows.view.ControllerHandler;
import org.netbeans.core.windows.view.dnd.TopComponentDraggable;
import org.openide.windows.TopComponent;

final class Central
implements ControllerHandler {
    private final Model model = ModelFactory.createWindowSystemModel();
    private final ViewRequestor viewRequestor = new ViewRequestor(this);
    private ModeImpl modeBeingMaximized = null;
    private static final Object GROUP_SELECTED = new Object();

    public void topComponentRequestAttention(ModeImpl modeImpl, TopComponent topComponent) {
        String string = this.getModeName(modeImpl);
        this.viewRequestor.scheduleRequest(new ViewRequest(string, 63, topComponent, topComponent));
    }

    public void topComponentCancelRequestAttention(ModeImpl modeImpl, TopComponent topComponent) {
        String string = this.getModeName(modeImpl);
        this.viewRequestor.scheduleRequest(new ViewRequest(string, 64, topComponent, topComponent));
    }

    public void topComponentAttentionHighlight(ModeImpl modeImpl, TopComponent topComponent, boolean bl) {
        String string = this.getModeName(modeImpl);
        this.viewRequestor.scheduleRequest(new ViewRequest(string, bl ? 65 : 66, topComponent, topComponent));
    }

    public void setVisible(boolean bl) {
        if (this.isVisible() == bl) {
            return;
        }
        this.model.setVisible(bl);
        this.viewRequestor.scheduleRequest(new ViewRequest(null, 0, null, bl));
    }

    public void setMainWindowBoundsJoined(Rectangle rectangle) {
        if (rectangle == null) {
            return;
        }
        Rectangle rectangle2 = this.getMainWindowBoundsJoined();
        if (rectangle2.equals(rectangle)) {
            return;
        }
        this.model.setMainWindowBoundsJoined(rectangle);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 1, rectangle2, rectangle));
        }
    }

    public void setMainWindowBoundsSeparated(Rectangle rectangle) {
        if (rectangle == null) {
            return;
        }
        Rectangle rectangle2 = this.getMainWindowBoundsSeparated();
        if (rectangle2.equals(rectangle)) {
            return;
        }
        this.model.setMainWindowBoundsSeparated(rectangle);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 2, rectangle2, rectangle));
        }
    }

    public void setMainWindowFrameStateJoined(int n) {
        int n2 = this.getMainWindowFrameStateJoined();
        if (n2 == n) {
            return;
        }
        this.model.setMainWindowFrameStateJoined(n);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 3, n2, n));
        }
    }

    public void setMainWindowFrameStateSeparated(int n) {
        int n2 = this.getMainWindowFrameStateSeparated();
        if (n2 == n) {
            return;
        }
        this.model.setMainWindowFrameStateSeparated(n);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 4, n2, n));
        }
    }

    public void setActiveMode(ModeImpl modeImpl) {
        Object object;
        if (modeImpl != null && (object = modeImpl.getOpenedTopComponents()).isEmpty()) {
            return;
        }
        object = this.getActiveMode();
        if (modeImpl == object) {
            boolean bl;
            ModeImpl modeImpl2 = this.model.getSlidingMode("bottom");
            boolean bl2 = modeImpl2 == null || modeImpl2.getSelectedTopComponent() == null;
            modeImpl2 = this.model.getSlidingMode("left");
            boolean bl3 = modeImpl2 == null || modeImpl2.getSelectedTopComponent() == null;
            modeImpl2 = this.model.getSlidingMode("right");
            boolean bl4 = modeImpl2 == null || modeImpl2.getSelectedTopComponent() == null;
            modeImpl2 = this.model.getSlidingMode("top");
            boolean bl5 = bl = modeImpl2 == null || modeImpl2.getSelectedTopComponent() == null;
            if (bl2 && bl3 && bl4 && bl) {
                return;
            }
        }
        this.model.setActiveMode(modeImpl);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 9, object, modeImpl));
        }
        WindowManagerImpl.getInstance().doFirePropertyChange("activeMode", object, modeImpl);
        if (modeImpl != null) {
            WindowManagerImpl.notifyRegistryTopComponentActivated(modeImpl.getSelectedTopComponent());
        } else {
            WindowManagerImpl.notifyRegistryTopComponentActivated(null);
        }
    }

    public void setEditorAreaBounds(Rectangle rectangle) {
        if (rectangle == null) {
            return;
        }
        Rectangle rectangle2 = this.getEditorAreaBounds();
        if (rectangle2.equals(rectangle)) {
            return;
        }
        this.model.setEditorAreaBounds(rectangle);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 7, rectangle2, rectangle));
        }
    }

    public void setEditorAreaConstraints(SplitConstraint[] splitConstraintArray) {
        Object[] objectArray = this.getEditorAreaConstraints();
        if (Arrays.equals(objectArray, splitConstraintArray)) {
            return;
        }
        this.model.setEditorAreaConstraints(splitConstraintArray);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 8, objectArray, splitConstraintArray));
        }
    }

    public void setEditorAreaState(int n) {
        int n2 = this.getEditorAreaState();
        if (n == n2) {
            return;
        }
        int n3 = n == 0 ? 0 : 1;
        for (ModeImpl object : this.getModes()) {
            Object object2;
            if (object.getKind() == 0 && object.getState() != n3) {
                this.model.setModeState(object, n3);
                if (n == 1 && ((Rectangle)(object2 = this.model.getModeBounds(object))).isEmpty()) {
                    this.model.setModeBounds(object, this.model.getModeBoundsSeparatedHelp(object));
                }
            }
            if (object.getKind() != 2 || n != 1) continue;
            object2 = object.getTopComponents();
            for (int i = 0; i < ((TopComponent[])object2).length; ++i) {
                String string = WindowManagerImpl.getInstance().findTopComponentID((TopComponent)object2[i]);
                ModeImpl modeImpl = this.model.getModeTopComponentPreviousMode(object, string);
                if (modeImpl == null || !this.model.getModes().contains(modeImpl)) {
                    SplitConstraint[] splitConstraintArray = this.model.getModeTopComponentPreviousConstraints(object, string);
                    splitConstraintArray = splitConstraintArray == null ? new SplitConstraint[]{} : splitConstraintArray;
                    modeImpl = WindowManagerImpl.getInstance().createModeImpl(ModeImpl.getUnusedModeName(), 0, false);
                    this.model.setModeState(modeImpl, n3);
                    this.model.addMode(modeImpl, splitConstraintArray);
                }
                this.moveTopComponentIntoMode(modeImpl, (TopComponent)object2[i]);
            }
        }
        if (n == 1) {
            Rectangle rectangle;
            Rectangle rectangle2 = this.model.getEditorAreaBounds();
            if (rectangle2.isEmpty()) {
                this.model.setEditorAreaBounds(this.model.getEditorAreaBoundsHelp());
            }
            if ((rectangle = this.model.getMainWindowBoundsSeparated()).isEmpty()) {
                this.model.setMainWindowBoundsSeparated(this.model.getMainWindowBoundsSeparatedHelp());
            }
        }
        this.model.setEditorAreaState(n);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 5, n2, n));
        }
        WindowManagerImpl.getInstance().doFirePropertyChange("editorAreaState", n2, n);
    }

    public void setEditorAreaFrameState(int n) {
        int n2 = this.getEditorAreaFrameState();
        if (n2 == n) {
            return;
        }
        this.model.setEditorAreaFrameState(n);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 6, n2, n));
        }
    }

    void switchMaximizedMode(ModeImpl modeImpl) {
        ModeImpl modeImpl2 = this.getCurrentMaximizedMode();
        if (modeImpl == modeImpl2) {
            return;
        }
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        if (null == modeImpl) {
            if (this.isViewMaximized()) {
                if (this.isEditorMaximized()) {
                    this.restoreViews(this.model.getMaximizedDockingStatus());
                } else {
                    this.restoreViews(this.model.getDefaultDockingStatus());
                }
                ModeImpl modeImpl3 = this.getViewMaximizedMode();
                if (modeImpl3.getTopComponents().length == 1) {
                    TopComponent topComponent = modeImpl3.getTopComponents()[0];
                    String string = windowManagerImpl.findTopComponentID(topComponent);
                    ModeImpl modeImpl4 = this.getModeTopComponentPreviousMode(string, modeImpl3);
                    int n = this.model.getModeTopComponentPreviousIndex(modeImpl3, string);
                    if (null == modeImpl4) {
                        SplitConstraint[] splitConstraintArray;
                        if (!(modeImpl4 != null && this.model.getModes().contains(modeImpl4) || (splitConstraintArray = this.model.getModeTopComponentPreviousConstraints(modeImpl3, string)) == null)) {
                            modeImpl4 = WindowManagerImpl.getInstance().createModeImpl(ModeImpl.getUnusedModeName(), 0, false);
                            this.model.addMode(modeImpl4, splitConstraintArray);
                        }
                        if (modeImpl4 == null) {
                            modeImpl4 = WindowManagerImpl.getInstance().getDefaultViewMode();
                        }
                    }
                    modeImpl4.addOpenedTopComponent(topComponent, n);
                    modeImpl4.setSelectedTopComponent(topComponent);
                    this.setActiveMode(modeImpl4);
                    this.model.removeMode(modeImpl3);
                } else {
                    Logger.getLogger(Central.class.getName()).log(Level.WARNING, "A 'view' mode is maximized but it has wrong number of TopComponents, Mode=[" + modeImpl3.getName() + "], TC count=" + modeImpl3.getTopComponents().length);
                }
                this.setViewMaximizedMode(null);
            } else if (this.isEditorMaximized()) {
                this.model.getMaximizedDockingStatus().mark();
                ModeImpl modeImpl5 = this.getActiveMode();
                this.restoreViews(this.model.getDefaultDockingStatus());
                this.setEditorMaximizedMode(null);
                this.setActiveMode(modeImpl5);
            }
        } else {
            assert (!this.isViewMaximized());
            if (modeImpl.getKind() == 1) {
                this.model.getDefaultDockingStatus().mark();
                this.restoreViews(this.model.getMaximizedDockingStatus());
                this.setEditorMaximizedMode(modeImpl);
            } else if (modeImpl.getKind() == 0) {
                TopComponent topComponent = modeImpl.getSelectedTopComponent();
                if (null == topComponent) {
                    if (modeImpl.getOpenedTopComponents().isEmpty()) {
                        return;
                    }
                    topComponent = modeImpl.getOpenedTopComponents().get(0);
                }
                if (this.isEditorMaximized()) {
                    this.model.getMaximizedDockingStatus().mark();
                } else {
                    this.model.getDefaultDockingStatus().mark();
                }
                this.modeBeingMaximized = modeImpl;
                String string = windowManagerImpl.findTopComponentID(topComponent);
                int n = modeImpl.getOpenedTopComponents().indexOf(topComponent);
                ModeImpl modeImpl6 = WindowManagerImpl.getInstance().createModeImpl(ModeImpl.getUnusedModeName(), 0, true);
                this.model.addMode(modeImpl6, new SplitConstraint[0]);
                modeImpl6.addOpenedTopComponent(topComponent);
                modeImpl6.setSelectedTopComponent(topComponent);
                this.setModeTopComponentPreviousMode(string, modeImpl6, modeImpl, n);
                this.setViewMaximizedMode(modeImpl6);
                this.slideAllViews();
                this.setActiveMode(modeImpl6);
                this.modeBeingMaximized = null;
            } else {
                throw new IllegalArgumentException("Cannot maximize a sliding view");
            }
        }
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 11, modeImpl2, this.getCurrentMaximizedMode()));
        }
        WindowManagerImpl.getInstance().doFirePropertyChange("maximizedMode", modeImpl2, this.getCurrentMaximizedMode());
    }

    void setEditorMaximizedMode(ModeImpl modeImpl) {
        this.model.setEditorMaximizedMode(modeImpl);
    }

    void setViewMaximizedMode(ModeImpl modeImpl) {
        this.model.setViewMaximizedMode(modeImpl);
    }

    public void setModeConstraints(ModeImpl modeImpl, SplitConstraint[] splitConstraintArray) {
        Object[] objectArray = this.getModeConstraints(modeImpl);
        if (Arrays.equals(splitConstraintArray, objectArray)) {
            return;
        }
        this.model.setModeConstraints(modeImpl, splitConstraintArray);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 14, objectArray, splitConstraintArray));
        }
    }

    public void addMode(ModeImpl modeImpl, SplitConstraint[] splitConstraintArray) {
        SplitConstraint[] splitConstraintArray2 = this.getModeConstraints(modeImpl);
        if (splitConstraintArray == splitConstraintArray2) {
            return;
        }
        this.model.addMode(modeImpl, splitConstraintArray);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 12, null, modeImpl));
        }
        WindowManagerImpl.getInstance().doFirePropertyChange("modes", null, null);
    }

    final void setModeName(ModeImpl modeImpl, String string) {
        this.model.setModeName(modeImpl, string);
    }

    public void removeMode(ModeImpl modeImpl) {
        if (!this.getModes().contains(modeImpl)) {
            return;
        }
        this.model.removeMode(modeImpl);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 13, null, modeImpl));
        }
        WindowManagerImpl.getInstance().doFirePropertyChange("modes", null, null);
    }

    public void setToolbarConfigName(String string) {
        String string2 = this.getToolbarConfigName();
        if (string2.equals(string)) {
            return;
        }
        this.model.setToolbarConfigName(string);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 10, string2, string));
        }
    }

    public void updateUI() {
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 61, null, null));
        }
    }

    private void closeMode(ModeImpl modeImpl) {
        if (modeImpl == null) {
            return;
        }
        TopComponent[] topComponentArray = this.getModeOpenedTopComponents(modeImpl).toArray(new TopComponent[0]);
        for (int i = 0; i < topComponentArray.length; ++i) {
            if (PersistenceHandler.isTopComponentPersistentWhenClosed(topComponentArray[i])) {
                this.model.addModeClosedTopComponent(modeImpl, topComponentArray[i]);
                continue;
            }
            if (Boolean.TRUE.equals(topComponentArray[i].getClientProperty((Object)"KeepNonPersistentTCInModelWhenClosed"))) {
                this.model.addModeClosedTopComponent(modeImpl, topComponentArray[i]);
                continue;
            }
            this.model.removeModeTopComponent(modeImpl, topComponentArray[i], null);
        }
        ModeImpl modeImpl2 = this.getActiveMode();
        ModeImpl modeImpl3 = modeImpl == modeImpl2 ? this.setSomeModeActive() : modeImpl2;
        boolean bl = false;
        if (!modeImpl.isPermanent() && this.model.getModeTopComponents(modeImpl).isEmpty() && this.doCheckSlidingModes(modeImpl)) {
            this.model.removeMode(modeImpl);
            bl = true;
        }
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(modeImpl, 45, null, null));
        }
        for (int i = 0; i < topComponentArray.length; ++i) {
            WindowManagerImpl.getInstance().notifyTopComponentClosed(topComponentArray[i]);
        }
        if (modeImpl2 != modeImpl3) {
            WindowManagerImpl.getInstance().doFirePropertyChange("activeMode", modeImpl2, modeImpl3);
        }
        if (bl) {
            WindowManagerImpl.getInstance().doFirePropertyChange("modes", null, null);
        }
        if (modeImpl3 != null) {
            WindowManagerImpl.notifyRegistryTopComponentActivated(modeImpl3.getSelectedTopComponent());
        } else {
            WindowManagerImpl.notifyRegistryTopComponentActivated(null);
        }
    }

    private ModeImpl setSomeModeActive() {
        for (ModeImpl modeImpl : this.getModes()) {
            if (modeImpl.getOpenedTopComponents().isEmpty() || 2 == modeImpl.getKind()) continue;
            this.model.setActiveMode(modeImpl);
            return modeImpl;
        }
        this.model.setActiveMode(null);
        return this.model.getActiveMode();
    }

    public void setModeBounds(ModeImpl modeImpl, Rectangle rectangle) {
        if (rectangle == null) {
            return;
        }
        Rectangle rectangle2 = this.getModeBounds(modeImpl);
        if (rectangle2.equals(rectangle)) {
            return;
        }
        this.model.setModeBounds(modeImpl, rectangle);
        if (this.isVisible() && this.getEditorAreaState() == 1) {
            this.viewRequestor.scheduleRequest(new ViewRequest(modeImpl, 20, rectangle2, rectangle));
        }
        modeImpl.doFirePropertyChange("bounds", rectangle2, rectangle);
    }

    public void setModeFrameState(ModeImpl modeImpl, int n) {
        int n2 = this.getModeFrameState(modeImpl);
        if (n == n2) {
            return;
        }
        this.model.setModeFrameState(modeImpl, n);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(modeImpl, 21, n2, n));
        }
    }

    public void setModeSelectedTopComponent(ModeImpl modeImpl, TopComponent topComponent) {
        if (!(modeImpl.getKind() == 2 && topComponent == null || this.getModeOpenedTopComponents(modeImpl).contains(topComponent))) {
            return;
        }
        TopComponent topComponent2 = this.getModeSelectedTopComponent(modeImpl);
        if (topComponent == topComponent2) {
            return;
        }
        this.model.setModeSelectedTopComponent(modeImpl, topComponent);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(modeImpl, 22, topComponent2, topComponent));
        }
        if (modeImpl == this.getActiveMode()) {
            WindowManagerImpl.notifyRegistryTopComponentActivated(topComponent);
        }
    }

    public void setModePreviousSelectedTopComponentID(ModeImpl modeImpl, String string) {
        this.model.setModePreviousSelectedTopComponentID(modeImpl, string);
    }

    public void addModeOpenedTopComponent(ModeImpl modeImpl, TopComponent topComponent) {
        boolean bl = topComponent.isOpened();
        if (this.getModeOpenedTopComponents(modeImpl).contains(topComponent)) {
            return;
        }
        this.removeTopComponentFromOtherModes(modeImpl, topComponent);
        this.model.addModeOpenedTopComponent(modeImpl, topComponent);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(modeImpl, 23, null, topComponent));
        }
        if (!bl) {
            WindowManagerImpl.getInstance().notifyTopComponentOpened(topComponent);
        }
    }

    void addModeOpenedTopComponentNoNotify(ModeImpl modeImpl, TopComponent topComponent) {
        if (this.getModeOpenedTopComponents(modeImpl).contains(topComponent)) {
            return;
        }
        this.removeTopComponentFromOtherModes(modeImpl, topComponent);
        this.model.addModeOpenedTopComponent(modeImpl, topComponent);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(modeImpl, 23, null, topComponent));
        }
    }

    public void insertModeOpenedTopComponent(ModeImpl modeImpl, TopComponent topComponent, int n) {
        boolean bl = topComponent.isOpened();
        List<TopComponent> list = this.getModeOpenedTopComponents(modeImpl);
        if (n >= 0 && !list.isEmpty() && list.size() > n && list.get(n) == topComponent) {
            return;
        }
        this.removeTopComponentFromOtherModes(modeImpl, topComponent);
        this.model.insertModeOpenedTopComponent(modeImpl, topComponent, n);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(modeImpl, 23, null, topComponent));
        }
        if (!bl) {
            WindowManagerImpl.getInstance().notifyTopComponentOpened(topComponent);
        }
    }

    public boolean addModeClosedTopComponent(ModeImpl modeImpl, TopComponent topComponent) {
        boolean bl = this.getModeOpenedTopComponents(modeImpl).contains(topComponent);
        if (bl && !topComponent.canClose()) {
            return false;
        }
        if (this.containsModeTopComponent(modeImpl, topComponent) && !bl) {
            return false;
        }
        if (this.isViewMaximized() && modeImpl.getKind() == 2) {
            modeImpl = this.unSlide(topComponent, modeImpl);
        }
        this.removeTopComponentFromOtherModes(modeImpl, topComponent);
        this.model.addModeClosedTopComponent(modeImpl, topComponent);
        ModeImpl modeImpl2 = this.getActiveMode();
        ModeImpl modeImpl3 = this.model.getModeOpenedTopComponents(modeImpl).isEmpty() && modeImpl == modeImpl2 ? this.setSomeModeActive() : modeImpl2;
        if (this.getCurrentMaximizedMode() == modeImpl && this.model.getModeOpenedTopComponents(modeImpl).isEmpty()) {
            this.switchMaximizedMode(null);
        }
        if (this.isVisible() && bl) {
            this.viewRequestor.scheduleRequest(new ViewRequest(modeImpl, 24, null, topComponent));
        }
        if (modeImpl2 != modeImpl3) {
            WindowManagerImpl.getInstance().doFirePropertyChange("activeMode", modeImpl2, modeImpl3);
        }
        if (modeImpl3 != null) {
            WindowManagerImpl.notifyRegistryTopComponentActivated(modeImpl3.getSelectedTopComponent());
        } else {
            WindowManagerImpl.notifyRegistryTopComponentActivated(null);
        }
        if (bl) {
            WindowManagerImpl.getInstance().notifyTopComponentClosed(topComponent);
        }
        return true;
    }

    public void addModeUnloadedTopComponent(ModeImpl modeImpl, String string, int n) {
        TopComponentTracker.getDefault().add(string, modeImpl);
        this.model.addModeUnloadedTopComponent(modeImpl, string, n);
    }

    public void setUnloadedSelectedTopComponent(ModeImpl modeImpl, String string) {
        this.model.setModeUnloadedSelectedTopComponent(modeImpl, string);
    }

    public void setUnloadedPreviousSelectedTopComponent(ModeImpl modeImpl, String string) {
        this.model.setModeUnloadedPreviousSelectedTopComponent(modeImpl, string);
    }

    public List<String> getModeOpenedTopComponentsIDs(ModeImpl modeImpl) {
        return this.model.getModeOpenedTopComponentsIDs(modeImpl);
    }

    public List getModeClosedTopComponentsIDs(ModeImpl modeImpl) {
        return this.model.getModeClosedTopComponentsIDs(modeImpl);
    }

    public List<String> getModeTopComponentsIDs(ModeImpl modeImpl) {
        return this.model.getModeTopComponentsIDs(modeImpl);
    }

    private boolean removeTopComponentFromOtherModes(ModeImpl modeImpl, TopComponent topComponent) {
        boolean bl = false;
        for (ModeImpl modeImpl2 : this.model.getModes()) {
            if (modeImpl2 == modeImpl || !this.model.containsModeTopComponent(modeImpl2, topComponent)) continue;
            bl = true;
            this.model.removeModeTopComponent(modeImpl2, topComponent, null);
            boolean bl2 = false;
            if (!modeImpl2.isPermanent() && modeImpl2.isEmpty() && this.doCheckSlidingModes(modeImpl2) && modeImpl.getKind() != 2 && modeImpl2 != this.modeBeingMaximized) {
                this.model.removeMode(modeImpl2);
                bl2 = true;
            }
            if (!bl2) continue;
            WindowManagerImpl.getInstance().doFirePropertyChange("modes", null, null);
        }
        return bl;
    }

    public boolean removeModeTopComponent(ModeImpl modeImpl, TopComponent topComponent) {
        if (!this.containsModeTopComponent(modeImpl, topComponent)) {
            return false;
        }
        boolean bl = this.getModeOpenedTopComponents(modeImpl).contains(topComponent);
        if (bl && !topComponent.canClose()) {
            return false;
        }
        TopComponent topComponent2 = null;
        if (modeImpl.getKind() == 1) {
            topComponent2 = this.getRecentTopComponent(modeImpl, topComponent);
        }
        this.model.removeModeTopComponent(modeImpl, topComponent, topComponent2);
        ModeImpl modeImpl2 = this.getActiveMode();
        ModeImpl modeImpl3 = this.model.getModeOpenedTopComponents(modeImpl).isEmpty() && modeImpl == modeImpl2 ? this.setSomeModeActive() : modeImpl2;
        if (this.getCurrentMaximizedMode() == modeImpl && this.model.getModeOpenedTopComponents(modeImpl).isEmpty()) {
            this.switchMaximizedMode(null);
        }
        boolean bl2 = false;
        if (!modeImpl.isPermanent() && this.model.getModeTopComponents(modeImpl).isEmpty() && this.doCheckSlidingModes(modeImpl)) {
            this.model.removeMode(modeImpl);
            bl2 = true;
        }
        if (bl && this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(modeImpl, 24, null, topComponent));
        }
        if (bl) {
            WindowManagerImpl.getInstance().notifyTopComponentClosed(topComponent);
        }
        if (modeImpl2 != modeImpl3) {
            WindowManagerImpl.getInstance().doFirePropertyChange("activeMode", modeImpl2, modeImpl3);
        }
        if (bl2) {
            WindowManagerImpl.getInstance().doFirePropertyChange("modes", null, null);
        }
        if (modeImpl3 != null) {
            WindowManagerImpl.notifyRegistryTopComponentActivated(modeImpl3.getSelectedTopComponent());
        } else {
            WindowManagerImpl.notifyRegistryTopComponentActivated(null);
        }
        return true;
    }

    TopComponent getRecentTopComponent(ModeImpl modeImpl, TopComponent topComponent) {
        String[] stringArray;
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        if (!WinSysPrefs.HANDLER.getBoolean("editor.closing.activates.recent", true)) {
            stringArray = modeImpl.getOpenedTopComponents();
            int n = stringArray.indexOf(topComponent);
            if (stringArray.size() > 1 && n >= 0) {
                if (n > 0) {
                    return (TopComponent)stringArray.get(n - 1);
                }
                return (TopComponent)stringArray.get(1);
            }
        }
        for (String string : stringArray = windowManagerImpl.getRecentViewIDList()) {
            TopComponent topComponent2;
            ModeImpl modeImpl2 = this.findMode(string);
            if (modeImpl2 == null || modeImpl2 != modeImpl || (topComponent2 = windowManagerImpl.findTopComponent(string)) == topComponent) continue;
            return topComponent2;
        }
        return null;
    }

    private ModeImpl findMode(String string) {
        for (ModeImpl modeImpl : this.getModes()) {
            if (!modeImpl.getTopComponentsIDs().contains(string)) continue;
            return modeImpl;
        }
        return null;
    }

    boolean doCheckSlidingModes(ModeImpl modeImpl) {
        ModeImpl modeImpl2;
        String string;
        int n;
        TopComponent[] topComponentArray;
        ModeImpl modeImpl3 = this.model.getSlidingMode("bottom");
        if (modeImpl3 != null) {
            topComponentArray = modeImpl3.getTopComponents();
            for (n = 0; n < topComponentArray.length; ++n) {
                string = WindowManagerImpl.getInstance().findTopComponentID(topComponentArray[n]);
                modeImpl2 = this.model.getModeTopComponentPreviousMode(modeImpl3, string);
                if (modeImpl2 != modeImpl) continue;
                return false;
            }
        }
        if ((modeImpl3 = this.model.getSlidingMode("left")) != null) {
            topComponentArray = modeImpl3.getTopComponents();
            for (n = 0; n < topComponentArray.length; ++n) {
                string = WindowManagerImpl.getInstance().findTopComponentID(topComponentArray[n]);
                modeImpl2 = this.model.getModeTopComponentPreviousMode(modeImpl3, string);
                if (modeImpl2 != modeImpl) continue;
                return false;
            }
        }
        if ((modeImpl3 = this.model.getSlidingMode("right")) != null) {
            topComponentArray = modeImpl3.getTopComponents();
            for (n = 0; n < topComponentArray.length; ++n) {
                string = WindowManagerImpl.getInstance().findTopComponentID(topComponentArray[n]);
                modeImpl2 = this.model.getModeTopComponentPreviousMode(modeImpl3, string);
                if (modeImpl2 != modeImpl) continue;
                return false;
            }
        }
        if ((modeImpl3 = this.model.getSlidingMode("top")) != null) {
            topComponentArray = modeImpl3.getTopComponents();
            for (n = 0; n < topComponentArray.length; ++n) {
                string = WindowManagerImpl.getInstance().findTopComponentID(topComponentArray[n]);
                modeImpl2 = this.model.getModeTopComponentPreviousMode(modeImpl3, string);
                if (modeImpl2 != modeImpl) continue;
                return false;
            }
        }
        return true;
    }

    public void removeModeClosedTopComponentID(ModeImpl modeImpl, String string) {
        this.model.removeModeClosedTopComponentID(modeImpl, string);
    }

    public boolean isGroupOpened(TopComponentGroupImpl topComponentGroupImpl) {
        return this.model.isGroupOpened(topComponentGroupImpl);
    }

    public void openGroup(TopComponentGroupImpl topComponentGroupImpl) {
        WindowManagerImpl windowManagerImpl;
        if (this.isGroupOpened(topComponentGroupImpl)) {
            return;
        }
        if (this.isEditorMaximized() && this.isViewMaximized()) {
            this.switchMaximizedMode(null);
        }
        HashSet<TopComponent> hashSet = new HashSet<TopComponent>();
        Set<TopComponent> set = topComponentGroupImpl.getTopComponents();
        for (TopComponent object22 : set) {
            if (!object22.isOpened()) continue;
            hashSet.add(object22);
        }
        set = topComponentGroupImpl.getOpeningSet();
        HashSet hashSet2 = new HashSet(set.size());
        ArrayList<TopComponent> arrayList = new ArrayList<TopComponent>();
        for (TopComponent topComponent : set) {
            String string;
            if (topComponent.isOpened()) continue;
            windowManagerImpl = WindowManagerImpl.getInstance();
            ModeImpl modeImpl = (ModeImpl)windowManagerImpl.findMode(topComponent);
            if (modeImpl == null) {
                modeImpl = windowManagerImpl.getDefaultViewMode();
            } else if (modeImpl.getOpenedTopComponentsIDs().isEmpty()) {
                hashSet2.add(modeImpl);
            }
            this.model.addModeOpenedTopComponent(modeImpl, topComponent);
            if (topComponent.getClientProperty(GROUP_SELECTED) != null) {
                topComponent.requestVisible();
            }
            if (this.isEditorMaximized() && modeImpl.getState() != 1 && !this.isTopComponentDockedInMaximizedMode(string = windowManagerImpl.findTopComponentID(topComponent)) && modeImpl.getKind() != 2) {
                this.slide(topComponent, modeImpl, this.getSlideSideForMode(modeImpl));
            }
            arrayList.add(topComponent);
        }
        this.model.openGroup(topComponentGroupImpl, new HashSet<TopComponent>(arrayList), hashSet);
        Iterator<Object> iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            ModeImpl modeImpl = (ModeImpl)iterator.next();
            windowManagerImpl = modeImpl.getPreviousSelectedTopComponent();
            if (null == windowManagerImpl) continue;
            modeImpl.setSelectedTopComponent((TopComponent)windowManagerImpl);
        }
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(topComponentGroupImpl, 42, null, arrayList.toArray(new TopComponent[0])));
        }
        for (TopComponent topComponent : arrayList) {
            WindowManagerImpl.getInstance().notifyTopComponentOpened(topComponent);
        }
    }

    public void closeGroup(TopComponentGroupImpl topComponentGroupImpl) {
        if (!this.isGroupOpened(topComponentGroupImpl)) {
            return;
        }
        if (this.isViewMaximized()) {
            this.switchMaximizedMode(null);
        }
        Set set = topComponentGroupImpl.getClosingSet();
        ArrayList<TopComponent> arrayList = new ArrayList<TopComponent>();
        Set<TopComponent> set2 = this.model.getGroupOpenedTopComponents(topComponentGroupImpl);
        Set<TopComponent> set3 = this.model.getGroupOpenedBeforeTopComponents(topComponentGroupImpl);
        for (TopComponent object2 : this.model.getGroupTopComponents(topComponentGroupImpl)) {
            boolean bl = set3.contains(object2);
            boolean topComponent = set2.contains(object2);
            if (object2.isOpened()) {
                if (bl || topComponent) continue;
                this.model.addGroupOpeningTopComponent(topComponentGroupImpl, object2);
                continue;
            }
            if (!bl && !topComponent) continue;
            this.model.removeGroupOpeningTopComponent(topComponentGroupImpl, object2);
        }
        ArrayList arrayList2 = new ArrayList(set.size());
        for (TopComponent topComponent : set) {
            ModeImpl topComponent2;
            if (!topComponent.isOpened() || set3.contains(topComponent) || null == (topComponent2 = (ModeImpl)WindowManagerImpl.getInstance().findMode(topComponent))) continue;
            arrayList2.add(topComponent2);
        }
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            String string;
            ModeImpl modeImpl = (ModeImpl)iterator.next();
            TopComponent topComponent = modeImpl.getSelectedTopComponent();
            if (null == topComponent || null == (string = WindowManagerImpl.getInstance().findTopComponentID(topComponent))) continue;
            this.setModePreviousSelectedTopComponentID(modeImpl, string);
        }
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        for (TopComponent topComponent : set) {
            if (!topComponent.isOpened() || set3.contains(topComponent) || windowManagerImpl.isEditorTopComponent(topComponent)) continue;
            boolean bl = false;
            Object object = this.model.getTopComponentGroups().iterator();
            while (object.hasNext()) {
                TopComponentGroupImpl topComponentGroupImpl2 = object.next();
                if (topComponentGroupImpl2 == topComponentGroupImpl || !topComponentGroupImpl2.isOpened() || !topComponentGroupImpl2.getOpeningSet().contains(topComponent)) continue;
                bl = true;
                break;
            }
            if (bl || (object = (ModeImpl)WindowManagerImpl.getInstance().findMode(topComponent)) == null) continue;
            if (((ModeImpl)object).getSelectedTopComponent() == topComponent) {
                topComponent.putClientProperty(GROUP_SELECTED, (Object)Boolean.TRUE);
            } else {
                topComponent.putClientProperty(GROUP_SELECTED, null);
            }
            if (PersistenceHandler.isTopComponentPersistentWhenClosed(topComponent)) {
                this.model.addModeClosedTopComponent((ModeImpl)object, topComponent);
            } else if (Boolean.TRUE.equals(topComponent.getClientProperty((Object)"KeepNonPersistentTCInModelWhenClosed"))) {
                this.model.addModeClosedTopComponent((ModeImpl)object, topComponent);
            } else {
                this.model.removeModeTopComponent((ModeImpl)object, topComponent, null);
            }
            arrayList.add(topComponent);
        }
        this.model.closeGroup(topComponentGroupImpl);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(topComponentGroupImpl, 43, null, arrayList.toArray(new TopComponent[0])));
        }
        for (TopComponent topComponent : arrayList) {
            WindowManagerImpl.getInstance().notifyTopComponentClosed(topComponent);
        }
    }

    public void addTopComponentGroup(TopComponentGroupImpl topComponentGroupImpl) {
        this.model.addTopComponentGroup(topComponentGroupImpl);
    }

    public void removeTopComponentGroup(TopComponentGroupImpl topComponentGroupImpl) {
        this.model.removeTopComponentGroup(topComponentGroupImpl);
    }

    public boolean addGroupUnloadedTopComponent(TopComponentGroupImpl topComponentGroupImpl, String string) {
        return this.model.addGroupUnloadedTopComponent(topComponentGroupImpl, string);
    }

    public boolean removeGroupUnloadedTopComponent(TopComponentGroupImpl topComponentGroupImpl, String string) {
        return this.model.removeGroupUnloadedTopComponent(topComponentGroupImpl, string);
    }

    public boolean addGroupUnloadedOpeningTopComponent(TopComponentGroupImpl topComponentGroupImpl, String string) {
        return this.model.addGroupUnloadedOpeningTopComponent(topComponentGroupImpl, string);
    }

    public boolean removeGroupUnloadedOpeningTopComponent(TopComponentGroupImpl topComponentGroupImpl, String string) {
        return this.model.removeGroupUnloadedOpeningTopComponent(topComponentGroupImpl, string);
    }

    public boolean addGroupUnloadedClosingTopComponent(TopComponentGroupImpl topComponentGroupImpl, String string) {
        return this.model.addGroupUnloadedClosingTopComponent(topComponentGroupImpl, string);
    }

    public boolean removeGroupUnloadedClosingTopComponent(TopComponentGroupImpl topComponentGroupImpl, String string) {
        return this.model.removeGroupUnloadedClosingTopComponent(topComponentGroupImpl, string);
    }

    public boolean addGroupUnloadedOpenedTopComponent(TopComponentGroupImpl topComponentGroupImpl, String string) {
        if (!this.isGroupOpened(topComponentGroupImpl)) {
            return false;
        }
        return this.model.addGroupUnloadedOpenedTopComponent(topComponentGroupImpl, string);
    }

    public Set getGroupOpenedTopComponents(TopComponentGroupImpl topComponentGroupImpl) {
        return this.model.getGroupOpenedTopComponents(topComponentGroupImpl);
    }

    public Set<String> getGroupTopComponentsIDs(TopComponentGroupImpl topComponentGroupImpl) {
        return this.model.getGroupTopComponentsIDs(topComponentGroupImpl);
    }

    public Set<String> getGroupOpeningSetIDs(TopComponentGroupImpl topComponentGroupImpl) {
        return this.model.getGroupOpeningSetIDs(topComponentGroupImpl);
    }

    public Set<String> getGroupClosingSetIDs(TopComponentGroupImpl topComponentGroupImpl) {
        return this.model.getGroupClosingSetIDs(topComponentGroupImpl);
    }

    public Set<String> getGroupOpenedTopComponentsIDs(TopComponentGroupImpl topComponentGroupImpl) {
        return this.model.getGroupOpenedTopComponentsIDs(topComponentGroupImpl);
    }

    public boolean isVisible() {
        return this.model.isVisible();
    }

    public Set<? extends ModeImpl> getModes() {
        return this.model.getModes();
    }

    public Rectangle getMainWindowBoundsJoined() {
        return this.model.getMainWindowBoundsJoined();
    }

    public Rectangle getMainWindowBoundsSeparated() {
        return this.model.getMainWindowBoundsSeparated();
    }

    public int getMainWindowFrameStateJoined() {
        return this.model.getMainWindowFrameStateJoined();
    }

    public int getMainWindowFrameStateSeparated() {
        return this.model.getMainWindowFrameStateSeparated();
    }

    public ModeImpl getActiveMode() {
        return this.model.getActiveMode();
    }

    public ModeImpl getLastActiveEditorMode() {
        return this.model.getLastActiveEditorMode();
    }

    public Rectangle getEditorAreaBounds() {
        return this.model.getEditorAreaBounds();
    }

    public SplitConstraint[] getEditorAreaConstraints() {
        return this.model.getEditorAreaConstraints();
    }

    public int getEditorAreaState() {
        return this.model.getEditorAreaState();
    }

    public int getEditorAreaFrameState() {
        return this.model.getEditorAreaFrameState();
    }

    public Component getEditorAreaComponent() {
        return this.viewRequestor.getEditorAreaComponent();
    }

    ModeImpl getCurrentMaximizedMode() {
        if (this.isViewMaximized()) {
            return this.model.getViewMaximizedMode();
        }
        if (this.isEditorMaximized()) {
            return this.model.getEditorMaximizedMode();
        }
        return null;
    }

    ModeImpl getEditorMaximizedMode() {
        return this.model.getEditorMaximizedMode();
    }

    ModeImpl getViewMaximizedMode() {
        return this.model.getViewMaximizedMode();
    }

    public SplitConstraint[] getModeConstraints(ModeImpl modeImpl) {
        return this.model.getModeConstraints(modeImpl);
    }

    public String getToolbarConfigName() {
        return this.model.getToolbarConfigName();
    }

    public String getModeName(ModeImpl modeImpl) {
        return this.model.getModeName(modeImpl);
    }

    public Rectangle getModeBounds(ModeImpl modeImpl) {
        return this.model.getModeBounds(modeImpl);
    }

    public int getModeState(ModeImpl modeImpl) {
        return this.model.getModeState(modeImpl);
    }

    public int getModeKind(ModeImpl modeImpl) {
        return this.model.getModeKind(modeImpl);
    }

    public String getModeSide(ModeImpl modeImpl) {
        return this.model.getModeSide(modeImpl);
    }

    public int getModeFrameState(ModeImpl modeImpl) {
        return this.model.getModeFrameState(modeImpl);
    }

    public boolean isModePermanent(ModeImpl modeImpl) {
        return this.model.isModePermanent(modeImpl);
    }

    public boolean isModeEmpty(ModeImpl modeImpl) {
        return this.model.isModeEmpty(modeImpl);
    }

    public boolean containsModeTopComponent(ModeImpl modeImpl, TopComponent topComponent) {
        return this.model.containsModeTopComponent(modeImpl, topComponent);
    }

    public TopComponent getModeSelectedTopComponent(ModeImpl modeImpl) {
        return this.model.getModeSelectedTopComponent(modeImpl);
    }

    public String getModePreviousSelectedTopComponentID(ModeImpl modeImpl) {
        return this.model.getModePreviousSelectedTopComponentID(modeImpl);
    }

    public List<TopComponent> getModeTopComponents(ModeImpl modeImpl) {
        return this.model.getModeTopComponents(modeImpl);
    }

    public List<TopComponent> getModeOpenedTopComponents(ModeImpl modeImpl) {
        return this.model.getModeOpenedTopComponents(modeImpl);
    }

    public int getModeTopComponentTabPosition(ModeImpl modeImpl, TopComponent topComponent) {
        return this.model.getModeOpenedTopComponentTabPosition(modeImpl, topComponent);
    }

    boolean isModeMinimized(ModeImpl modeImpl) {
        return this.model.isModeMinimized(modeImpl);
    }

    void setModeMinimized(ModeImpl modeImpl, boolean bl) {
        this.model.setModeMinimized(modeImpl, bl);
    }

    Collection<String> getModeOtherNames(ModeImpl modeImpl) {
        return this.model.getModeOtherNames(modeImpl);
    }

    void addModeOtherName(ModeImpl modeImpl, String string) {
        this.model.addModeOtherName(modeImpl, string);
    }

    public Set<TopComponentGroupImpl> getTopComponentGroups() {
        return this.model.getTopComponentGroups();
    }

    public String getGroupName(TopComponentGroupImpl topComponentGroupImpl) {
        return this.model.getGroupName(topComponentGroupImpl);
    }

    public Set<TopComponent> getGroupTopComponents(TopComponentGroupImpl topComponentGroupImpl) {
        return this.model.getGroupTopComponents(topComponentGroupImpl);
    }

    public Set<TopComponent> getGroupOpeningTopComponents(TopComponentGroupImpl topComponentGroupImpl) {
        return this.model.getGroupOpeningTopComponents(topComponentGroupImpl);
    }

    public Set getGroupClosingTopComponents(TopComponentGroupImpl topComponentGroupImpl) {
        return this.model.getGroupClosingTopComponents(topComponentGroupImpl);
    }

    public void topComponentDisplayNameChanged(ModeImpl modeImpl, TopComponent topComponent) {
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(modeImpl, 31, null, topComponent));
        }
    }

    public void topComponentDisplayNameAnnotation(ModeImpl modeImpl, TopComponent topComponent) {
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(modeImpl, 32, null, topComponent));
        }
    }

    public void topComponentToolTipChanged(ModeImpl modeImpl, TopComponent topComponent) {
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(modeImpl, 33, null, topComponent));
        }
    }

    public void topComponentIconChanged(ModeImpl modeImpl, TopComponent topComponent) {
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(modeImpl, 34, null, topComponent));
        }
    }

    public void topComponentMakeBusy(ModeImpl modeImpl, TopComponent topComponent, boolean bl) {
        String string = this.getModeName(modeImpl);
        this.viewRequestor.scheduleRequest(new ViewRequest(string, bl ? 70 : 71, topComponent, topComponent));
    }

    public void resetModel() {
        this.model.reset();
    }

    ModeImpl attachModeToSide(ModeImpl modeImpl, String string, String string2, int n, boolean bl) {
        ModeImpl modeImpl2 = WindowManagerImpl.getInstance().createModeImpl(string2, n, bl);
        this.model.addModeToSide(modeImpl2, modeImpl, string);
        return modeImpl2;
    }

    private ModeImpl attachModeToSide(ModeImpl modeImpl, String string, int n) {
        return this.attachModeToSide(modeImpl, string, ModeImpl.getUnusedModeName(), n, false);
    }

    private ModeImpl attachModeAroundDesktop(String string) {
        ModeImpl modeImpl = WindowManagerImpl.getInstance().createModeImpl(ModeImpl.getUnusedModeName(), 0, false);
        this.model.addModeAround(modeImpl, string);
        return modeImpl;
    }

    private ModeImpl attachModeAroundEditor(String string, int n) {
        ModeImpl modeImpl = WindowManagerImpl.getInstance().createModeImpl(ModeImpl.getUnusedModeName(), n, false);
        this.model.addModeAroundEditor(modeImpl, string);
        return modeImpl;
    }

    private ModeImpl createFloatingMode(Rectangle rectangle, int n) {
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        ModeImpl modeImpl = windowManagerImpl.createModeImpl(ModeImpl.getUnusedModeName(), n, 1, false);
        modeImpl.setBounds(rectangle);
        this.model.addMode(modeImpl, new SplitConstraint[]{new SplitConstraint(1, 100, 0.5)});
        return modeImpl;
    }

    public void activateModeTopComponent(ModeImpl modeImpl, TopComponent topComponent) {
        Component component;
        if (!this.getModeOpenedTopComponents(modeImpl).contains(topComponent)) {
            return;
        }
        ModeImpl modeImpl2 = this.getActiveMode();
        if (modeImpl2 != null && modeImpl2.equals(modeImpl) && topComponent != null && topComponent.equals(this.model.getModeSelectedTopComponent(modeImpl)) && (component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) != null && SwingUtilities.isDescendingFrom(component, (Component)topComponent)) {
            this.slideOutSlidingWindows(modeImpl);
            return;
        }
        this.model.setActiveMode(modeImpl);
        this.model.setModeSelectedTopComponent(modeImpl, topComponent);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(modeImpl, 44, null, topComponent));
            if (modeImpl.getState() == 1 && null != (component = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)topComponent)) && component != WindowManagerImpl.getInstance().getMainWindow() && (((Frame)component).getExtendedState() & 1) > 0) {
                ((Frame)component).setExtendedState(((Frame)component).getExtendedState() - 1);
            }
        }
        WindowManagerImpl.notifyRegistryTopComponentActivated(topComponent);
        if (modeImpl2 != modeImpl) {
            WindowManagerImpl.getInstance().doFirePropertyChange("activeMode", modeImpl2, modeImpl);
        }
    }

    protected void slideOutSlidingWindows(ModeImpl modeImpl) {
        for (ModeImpl modeImpl2 : this.getModes()) {
            if (modeImpl.equals(modeImpl2) || modeImpl2.getKind() != 2 || null == modeImpl2.getSelectedTopComponent()) continue;
            this.setModeSelectedTopComponent(modeImpl2, null);
        }
    }

    public boolean isDragInProgress() {
        return this.viewRequestor.isDragInProgress();
    }

    public Frame getMainWindow() {
        return this.viewRequestor.getMainWindow();
    }

    public String guessSlideSide(TopComponent topComponent) {
        return this.viewRequestor.guessSlideSide(topComponent);
    }

    String getSlideSideForMode(ModeImpl modeImpl) {
        return this.model.getSlideSideForMode(modeImpl);
    }

    public boolean isDocked(TopComponent topComponent) {
        ModeImpl modeImpl = (ModeImpl)WindowManagerImpl.getInstance().findMode(topComponent);
        return modeImpl != null && modeImpl.getState() == 0;
    }

    public void createModeModel(ModeImpl modeImpl, String string, int n, int n2, boolean bl) {
        this.model.createModeModel(modeImpl, string, n, n2, bl);
    }

    public void createGroupModel(TopComponentGroupImpl topComponentGroupImpl, String string, boolean bl) {
        this.model.createGroupModel(topComponentGroupImpl, string, bl);
    }

    public WindowSystemSnapshot createWindowSystemSnapshot() {
        return this.model.createWindowSystemSnapshot();
    }

    @Override
    public void userActivatedMode(ModeImpl modeImpl) {
        if (modeImpl != null) {
            this.setActiveMode(modeImpl);
        }
    }

    @Override
    public void userActivatedModeWindow(ModeImpl modeImpl) {
        if (modeImpl != null) {
            this.setActiveMode(modeImpl);
        }
    }

    @Override
    public void userActivatedEditorWindow() {
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        TopComponent[] topComponentArray = windowManagerImpl.getRecentViewList();
        for (int i = 0; i < topComponentArray.length; ++i) {
            TopComponent topComponent = topComponentArray[i];
            ModeImpl modeImpl = (ModeImpl)windowManagerImpl.findMode(topComponent);
            if (modeImpl == null || modeImpl.getKind() != 1 || modeImpl.getOpenedTopComponents().isEmpty()) continue;
            this.setActiveMode(modeImpl);
            return;
        }
        ModeImpl modeImpl = windowManagerImpl.getDefaultEditorMode();
        if (modeImpl != null && !modeImpl.getOpenedTopComponents().isEmpty()) {
            this.setActiveMode(modeImpl);
        } else {
            this.setActiveMode(null);
        }
    }

    @Override
    public void userActivatedTopComponent(ModeImpl modeImpl, TopComponent topComponent) {
        if (modeImpl != null) {
            this.setModeSelectedTopComponent(modeImpl, topComponent);
        }
    }

    @Override
    public void userResizedMainWindow(Rectangle rectangle) {
        if (this.getEditorAreaState() == 0) {
            this.model.setMainWindowBoundsJoined(rectangle);
        } else {
            this.model.setMainWindowBoundsSeparated(rectangle);
        }
    }

    @Override
    public void userResizedMainWindowBoundsSeparatedHelp(Rectangle rectangle) {
        if (this.getEditorAreaState() == 0 && this.getMainWindowBoundsSeparated().isEmpty()) {
            this.model.setMainWindowBoundsUserSeparatedHelp(rectangle);
        }
    }

    @Override
    public void userResizedEditorArea(Rectangle rectangle) {
        this.model.setEditorAreaBounds(rectangle);
    }

    @Override
    public void userResizedEditorAreaBoundsHelp(Rectangle rectangle) {
        if (this.getEditorAreaState() == 0 && this.getEditorAreaBounds().isEmpty()) {
            this.model.setEditorAreaBoundsUserHelp(rectangle);
        }
    }

    @Override
    public void userResizedModeBounds(ModeImpl modeImpl, Rectangle rectangle) {
        Rectangle rectangle2 = this.model.getModeBounds(modeImpl);
        this.model.setModeBounds(modeImpl, rectangle);
        modeImpl.doFirePropertyChange("bounds", rectangle2, rectangle);
    }

    @Override
    public void userResizedModeBoundsSeparatedHelp(ModeImpl modeImpl, Rectangle rectangle) {
        this.model.setModeBoundsSeparatedHelp(modeImpl, rectangle);
    }

    @Override
    public void userChangedFrameStateMainWindow(int n) {
        if (this.getEditorAreaState() == 0) {
            this.model.setMainWindowFrameStateJoined(n);
        } else {
            this.model.setMainWindowFrameStateSeparated(n);
        }
    }

    @Override
    public void userChangedFrameStateEditorArea(int n) {
        this.model.setEditorAreaFrameState(n);
    }

    @Override
    public void userChangedFrameStateMode(ModeImpl modeImpl, int n) {
        this.model.setModeFrameState(modeImpl, n);
    }

    @Override
    public void userChangedSplit(ModelElement[] modelElementArray, double[] dArray) {
        this.model.setSplitWeights(modelElementArray, dArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void userClosedTopComponent(ModeImpl modeImpl, TopComponent topComponent) {
        ModeImpl modeImpl2;
        void var4_9;
        if (modeImpl == this.getCurrentMaximizedMode() && this.isViewMaximized()) {
            this.switchMaximizedMode(null);
            for (ModeImpl modeImpl3 : this.getModes()) {
                if (!modeImpl3.containsTopComponent(topComponent)) continue;
                this.userClosedTopComponent(modeImpl3, topComponent);
                return;
            }
        }
        TopComponent topComponent2 = null;
        if (modeImpl.getKind() == 1) {
            topComponent2 = this.getRecentTopComponent(modeImpl, topComponent);
        }
        boolean bl = false;
        if (PersistenceHandler.isTopComponentPersistentWhenClosed(topComponent)) {
            boolean bl2 = this.addModeClosedTopComponent(modeImpl, topComponent);
        } else if (Boolean.TRUE.equals(topComponent.getClientProperty((Object)"KeepNonPersistentTCInModelWhenClosed"))) {
            boolean bl3 = this.addModeClosedTopComponent(modeImpl, topComponent);
        } else {
            boolean bl4 = this.removeModeTopComponent(modeImpl, topComponent);
        }
        if (var4_9 != false && modeImpl.getKind() == 1 && "editor".equals(modeImpl.getName()) && modeImpl.getOpenedTopComponentsIDs().isEmpty() && null != (modeImpl2 = this.findSomeOtherEditorModeImpl())) {
            for (String string : modeImpl2.getClosedTopComponentsIDs()) {
                modeImpl.addUnloadedTopComponent(string);
            }
            List<TopComponent> list = modeImpl2.getOpenedTopComponents();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                TopComponent topComponent3 = (TopComponent)iterator.next();
                int n = modeImpl2.getTopComponentTabPosition(topComponent3);
                modeImpl.addOpenedTopComponent(topComponent3, n);
            }
            this.removeMode(modeImpl2);
        }
        if (topComponent2 != null && var4_9 != false) {
            topComponent2.requestActive();
        }
        if (TopComponent.getRegistry().getOpened().isEmpty()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Frame frame = Central.this.getMainWindow();
                    if (null != frame && frame.isVisible()) {
                        frame.invalidate();
                        frame.repaint();
                    }
                }
            });
        }
    }

    private ModeImpl findSomeOtherEditorModeImpl() {
        for (ModeImpl modeImpl : this.getModes()) {
            if (modeImpl.getKind() != 1 || "editor".equals(modeImpl.getName()) || modeImpl.getOpenedTopComponentsIDs().isEmpty() || modeImpl.isPermanent() || modeImpl.getState() == 1) continue;
            return modeImpl;
        }
        return null;
    }

    @Override
    public void userClosedMode(ModeImpl modeImpl) {
        if (modeImpl != null) {
            boolean bl = true;
            for (TopComponent object : modeImpl.getOpenedTopComponents()) {
                if (Switches.isClosingEnabled(object)) continue;
                bl = false;
                break;
            }
            if (bl) {
                this.closeMode(modeImpl);
            } else {
                ArrayList<TopComponent> arrayList = new ArrayList<TopComponent>(modeImpl.getOpenedTopComponents());
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    TopComponent topComponent = (TopComponent)iterator.next();
                    if (!Switches.isClosingEnabled(topComponent)) continue;
                    this.userClosedTopComponent(modeImpl, topComponent);
                }
            }
            if (modeImpl.getOpenedTopComponents().isEmpty() && modeImpl == this.getCurrentMaximizedMode()) {
                this.switchMaximizedMode(null);
            }
        }
    }

    @Override
    public void userDroppedTopComponents(ModeImpl modeImpl, TopComponentDraggable topComponentDraggable) {
        boolean bl = false;
        if (topComponentDraggable.isTopComponentTransfer()) {
            bl = this.moveTopComponentIntoMode(modeImpl, topComponentDraggable.getTopComponent());
        } else {
            TopComponent topComponent = topComponentDraggable.getMode().getSelectedTopComponent();
            this.mergeModes(topComponentDraggable.getMode(), modeImpl, -1);
            if (null != topComponent) {
                modeImpl.setSelectedTopComponent(topComponent);
            }
        }
        this.updateViewAfterDnD(bl);
    }

    @Override
    public void userDroppedTopComponents(ModeImpl modeImpl, TopComponentDraggable topComponentDraggable, int n) {
        boolean bl = false;
        if (topComponentDraggable.isTopComponentTransfer()) {
            bl = this.moveTopComponentIntoMode(modeImpl, topComponentDraggable.getTopComponent(), n);
        } else {
            TopComponent topComponent = topComponentDraggable.getMode().getSelectedTopComponent();
            this.mergeModes(topComponentDraggable.getMode(), modeImpl, n);
            if (null != topComponent) {
                modeImpl.setSelectedTopComponent(topComponent);
            }
        }
        this.updateViewAfterDnD(bl);
    }

    @Override
    public void userDroppedTopComponents(ModeImpl modeImpl, TopComponentDraggable topComponentDraggable, String string) {
        ModeImpl modeImpl2 = this.attachModeToSide(modeImpl, string, modeImpl.getKind());
        if (topComponentDraggable.isTopComponentTransfer()) {
            this.moveTopComponentIntoMode(modeImpl2, topComponentDraggable.getTopComponent());
        } else if (modeImpl2.getKind() != topComponentDraggable.getKind()) {
            this.mergeModes(topComponentDraggable.getMode(), modeImpl2, -1);
        } else {
            this.dockMode(modeImpl2, topComponentDraggable.getMode());
        }
        this.updateViewAfterDnD(true);
    }

    @Override
    public void userDroppedTopComponentsIntoEmptyEditor(TopComponentDraggable topComponentDraggable) {
        ModeImpl modeImpl = (ModeImpl)WindowManagerImpl.getInstance().findMode("editor");
        if (null == modeImpl || modeImpl.getState() == 1) {
            for (ModeImpl modeImpl2 : this.getModes()) {
                if (modeImpl2.getKind() != 1 || modeImpl2.getState() != 0) continue;
                modeImpl = modeImpl2;
                break;
            }
        }
        if (null == modeImpl || modeImpl == topComponentDraggable.getMode()) {
            if (topComponentDraggable.isModeTransfer() && topComponentDraggable.getMode().getKind() == 1) {
                this.userDockedMode(topComponentDraggable.getMode());
            }
            return;
        }
        if (topComponentDraggable.isTopComponentTransfer()) {
            this.moveTopComponentIntoMode(modeImpl, topComponentDraggable.getTopComponent());
        } else if (modeImpl.getKind() != topComponentDraggable.getKind()) {
            this.mergeModes(topComponentDraggable.getMode(), modeImpl, 0);
        } else {
            this.dockMode(modeImpl, topComponentDraggable.getMode());
        }
        this.updateViewAfterDnD(true);
    }

    @Override
    public void userDroppedTopComponentsAround(TopComponentDraggable topComponentDraggable, String string) {
        ModeImpl modeImpl = this.attachModeAroundDesktop(string);
        if (topComponentDraggable.isTopComponentTransfer()) {
            this.moveTopComponentIntoMode(modeImpl, topComponentDraggable.getTopComponent());
        } else {
            this.dockMode(modeImpl, topComponentDraggable.getMode());
        }
        this.updateViewAfterDnD(true);
    }

    @Override
    public void userDroppedTopComponentsAroundEditor(TopComponentDraggable topComponentDraggable, String string) {
        ModeImpl modeImpl = this.attachModeAroundEditor(string, topComponentDraggable.getKind());
        if (topComponentDraggable.isTopComponentTransfer()) {
            this.moveTopComponentIntoMode(modeImpl, topComponentDraggable.getTopComponent());
        } else {
            this.dockMode(modeImpl, topComponentDraggable.getMode());
        }
        this.updateViewAfterDnD(true);
    }

    @Override
    public void userDroppedTopComponentsIntoFreeArea(TopComponentDraggable topComponentDraggable, Rectangle rectangle) {
        if (topComponentDraggable.isTopComponentTransfer()) {
            ModeImpl modeImpl = this.createFloatingMode(rectangle, topComponentDraggable.getKind());
            this.moveTopComponentIntoMode(modeImpl, topComponentDraggable.getTopComponent());
            modeImpl.setSelectedTopComponent(topComponentDraggable.getTopComponent());
        } else {
            this.userUndockedMode(topComponentDraggable.getMode(), rectangle);
        }
        this.updateViewAfterDnD(false);
    }

    public void userUndockedMode(ModeImpl modeImpl) {
        if (this.getCurrentMaximizedMode() == modeImpl) {
            this.switchMaximizedMode(null);
        }
        Rectangle rectangle = null;
        TopComponent topComponent = modeImpl.getSelectedTopComponent();
        if (null != topComponent) {
            Point point = topComponent.getLocation();
            Dimension dimension = topComponent.getSize();
            SwingUtilities.convertPointToScreen(point, (Component)topComponent);
            rectangle = new Rectangle(point, dimension);
        }
        this.userUndockedMode(modeImpl, rectangle);
    }

    private void userUndockedMode(ModeImpl modeImpl, Rectangle rectangle) {
        int n = modeImpl.getKind();
        if (n == 2) {
            n = 0;
        }
        if (this.getCurrentMaximizedMode() == modeImpl) {
            this.switchMaximizedMode(null);
        }
        if (null != rectangle) {
            this.model.setModeBounds(modeImpl, rectangle);
        }
        SplitConstraint[] splitConstraintArray = modeImpl.getConstraints();
        this.model.setModeState(modeImpl, 1);
        ModeImpl modeImpl2 = WindowManagerImpl.getInstance().createMode(null, modeImpl.getKind(), 0, true, splitConstraintArray);
        splitConstraintArray = modeImpl2.getConstraints();
        List<String> list = modeImpl.getOpenedTopComponentsIDs();
        for (String string : this.getModeTopComponentsIDs(modeImpl)) {
            this.model.setModeTopComponentPreviousMode(modeImpl, string, modeImpl2, list.indexOf(string));
            this.model.setModeTopComponentPreviousConstraints(modeImpl, string, splitConstraintArray);
        }
        this.model.setModeConstraints(modeImpl, new SplitConstraint[0]);
        this.updateViewAfterDnD(false);
        WindowManagerImpl.getInstance().doFirePropertyChange("modes", null, null);
    }

    public void userDockedMode(ModeImpl modeImpl) {
        int n = modeImpl.getKind();
        if (n == 2) {
            n = 0;
        }
        this.switchMaximizedMode(null);
        TopComponent topComponent = modeImpl.getSelectedTopComponent();
        if (!modeImpl.isPermanent()) {
            for (TopComponent topComponent2 : modeImpl.getOpenedTopComponents()) {
                this.userDockedTopComponent(topComponent2, modeImpl);
            }
        } else {
            SplitConstraint[] splitConstraintArray;
            List<String> list = modeImpl.getTopComponentsIDs();
            if (!list.isEmpty()) {
                Object object;
                splitConstraintArray = list.get(0);
                ModeImpl modeImpl2 = this.model.getModeTopComponentPreviousMode(modeImpl, (String)splitConstraintArray);
                if (!(null != modeImpl2 && this.model.getModes().contains(modeImpl2) || null == (object = this.model.getModeTopComponentPreviousConstraints(modeImpl, (String)splitConstraintArray)))) {
                    modeImpl2 = this.findJoinedMode(n, (SplitConstraint[])object);
                }
                if (null == modeImpl2) {
                    object = this.model.getModeTopComponentPreviousConstraints(modeImpl, (String)splitConstraintArray);
                    if (null != object) {
                        this.model.setModeConstraints(modeImpl, (SplitConstraint[])object);
                    }
                    this.model.setModeState(modeImpl, 0);
                } else if (modeImpl2.isPermanent() && !modeImpl2.getTopComponentsIDs().isEmpty()) {
                    object = modeImpl.getOpenedTopComponentsIDs();
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        int n2 = this.model.getModeTopComponentPreviousIndex(modeImpl, string);
                        TopComponent topComponent3 = WindowManagerImpl.getInstance().findTopComponent(string);
                        modeImpl2.addOpenedTopComponent(topComponent3, n2);
                    }
                    this.mergeModes(modeImpl, modeImpl2, -1);
                    modeImpl = null;
                } else {
                    this.dockMode(modeImpl2, modeImpl);
                }
            }
            if (null != modeImpl) {
                splitConstraintArray = modeImpl.getConstraints();
                if (null == splitConstraintArray || splitConstraintArray.length == 0) {
                    this.model.setModeConstraints(modeImpl, new SplitConstraint[]{new SplitConstraint(1, 0, 0.2)});
                }
                this.model.setModeState(modeImpl, 0);
            }
        }
        this.updateViewAfterDnD(false);
        if (null != topComponent) {
            topComponent.requestActive();
        }
        WindowManagerImpl.getInstance().doFirePropertyChange("modes", null, null);
    }

    private void mergeModes(ModeImpl modeImpl, ModeImpl modeImpl2, int n) {
        ModeImpl modeImpl3 = null;
        SplitConstraint[] splitConstraintArray = null;
        if (modeImpl.isPermanent() && !modeImpl2.isPermanent()) {
            modeImpl3 = this.getPreviousMode(modeImpl);
            splitConstraintArray = this.getPreviousConstraints(modeImpl);
        } else {
            modeImpl3 = this.getPreviousMode(modeImpl2);
            splitConstraintArray = this.getPreviousConstraints(modeImpl2);
        }
        int n2 = n;
        for (String iterator2 : modeImpl.getTopComponentsIDs()) {
            modeImpl2.addUnloadedTopComponent(iterator2, n2);
            if (n2 < 0) continue;
            ++n2;
        }
        n2 = n;
        List<TopComponent> list = modeImpl.getOpenedTopComponents();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TopComponent topComponent = (TopComponent)iterator.next();
            modeImpl2.addOpenedTopComponent(topComponent, n2);
            if (n2 >= 0) {
                ++n2;
            }
            TopComponentTracker.getDefault().add(topComponent, modeImpl2);
        }
        if (modeImpl.isPermanent()) {
            modeImpl2.addOtherName(modeImpl.getName());
            for (String string : modeImpl.getOtherNames()) {
                modeImpl2.addOtherName(string);
            }
        }
        if (modeImpl.isPermanent()) {
            this.model.makeModePermanent(modeImpl2);
        }
        if (modeImpl2.getState() == 1) {
            this.setPreviousMode(modeImpl2, modeImpl3);
            this.setPreviousConstraints(modeImpl2, splitConstraintArray);
        }
        this.model.removeMode(modeImpl);
    }

    private ModeImpl getPreviousMode(ModeImpl modeImpl) {
        ModeImpl modeImpl2 = null;
        if (modeImpl.getState() == 0) {
            modeImpl2 = modeImpl;
        } else {
            List<String> list = modeImpl.getTopComponentsIDs();
            if (!list.isEmpty()) {
                modeImpl2 = this.model.getModeTopComponentPreviousMode(modeImpl, list.get(0));
            }
        }
        if (modeImpl2 != null && !this.getModes().contains(modeImpl2)) {
            modeImpl2 = null;
        }
        return modeImpl2;
    }

    private SplitConstraint[] getPreviousConstraints(ModeImpl modeImpl) {
        ModeImpl modeImpl2 = this.getPreviousMode(modeImpl);
        if (null != modeImpl2) {
            return modeImpl.getConstraints();
        }
        List<String> list = modeImpl.getTopComponentsIDs();
        if (!list.isEmpty()) {
            return this.model.getModeTopComponentPreviousConstraints(modeImpl, list.get(0));
        }
        return null;
    }

    private void setPreviousMode(ModeImpl modeImpl, ModeImpl modeImpl2) {
        for (String string : modeImpl.getTopComponentsIDs()) {
            int n = this.model.getModeTopComponentPreviousIndex(modeImpl, string);
            this.model.setModeTopComponentPreviousMode(modeImpl, string, modeImpl2, n);
        }
    }

    private void setPreviousConstraints(ModeImpl modeImpl, SplitConstraint[] splitConstraintArray) {
        for (String string : modeImpl.getTopComponentsIDs()) {
            this.model.setModeTopComponentPreviousConstraints(modeImpl, string, splitConstraintArray);
        }
    }

    private void dockMode(ModeImpl modeImpl, ModeImpl modeImpl2) {
        ModeImpl modeImpl3 = this.getPreviousMode(modeImpl2);
        List<TopComponent> list = modeImpl.getOpenedTopComponents();
        for (TopComponent object : list) {
            modeImpl2.addOpenedTopComponent(object);
        }
        for (String string : modeImpl.getClosedTopComponentsIDs()) {
            modeImpl2.addUnloadedTopComponent(string);
        }
        this.model.dockMode(modeImpl, modeImpl2);
        this.setPreviousMode(modeImpl2, null);
        this.setPreviousConstraints(modeImpl2, null);
        if (null != modeImpl3 && modeImpl3.getTopComponentsIDs().isEmpty()) {
            this.model.removeMode(modeImpl3);
        }
    }

    void userMinimizedMode(ModeImpl modeImpl) {
        List<TopComponent> list = modeImpl.getOpenedTopComponents();
        TopComponent topComponent = modeImpl.getSelectedTopComponent();
        String string = this.getSlideSideForMode(modeImpl);
        for (TopComponent topComponent2 : list) {
            this.slide(topComponent2, modeImpl, string);
        }
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        int n = 0;
        for (TopComponent topComponent3 : list) {
            ModeImpl modeImpl2 = (ModeImpl)windowManagerImpl.findMode(topComponent3);
            if (null == modeImpl2) continue;
            String string2 = windowManagerImpl.findTopComponentID(topComponent3);
            this.model.setModeTopComponentPreviousMode(modeImpl2, string2, modeImpl, n++);
        }
        this.setModeMinimized(modeImpl, true);
        if (null != topComponent) {
            modeImpl.setPreviousSelectedTopComponentID(windowManagerImpl.findTopComponentID(topComponent));
        }
    }

    void userRestoredMode(ModeImpl modeImpl, ModeImpl modeImpl2) {
        TopComponent topComponent = modeImpl2.getPreviousSelectedTopComponent();
        this.setModeMinimized(modeImpl2, false);
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        for (TopComponent topComponent2 : modeImpl.getOpenedTopComponents()) {
            String string = windowManagerImpl.findTopComponentID(topComponent2);
            ModeImpl modeImpl3 = this.model.getModeTopComponentPreviousMode(modeImpl, string);
            if (null == modeImpl3 || !modeImpl3.equals(modeImpl2)) continue;
            int n = this.model.getModeTopComponentPreviousIndex(modeImpl, string);
            this.moveTopComponentIntoMode(modeImpl3, topComponent2, n);
        }
        if (null != topComponent) {
            modeImpl2.setSelectedTopComponent(topComponent);
        }
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 48, null, null));
        }
        this.setActiveMode(modeImpl2);
    }

    @Override
    public void userUndockedTopComponent(TopComponent topComponent, ModeImpl modeImpl) {
        Point point = topComponent.getLocation();
        Dimension dimension = topComponent.getSize();
        SwingUtilities.convertPointToScreen(point, (Component)topComponent);
        Rectangle rectangle = new Rectangle(point, dimension);
        int n = modeImpl.getKind();
        if (n == 2) {
            n = 0;
        }
        if (this.getCurrentMaximizedMode() == modeImpl && modeImpl.getOpenedTopComponents().size() == 1 && modeImpl.getOpenedTopComponents().get(0) == topComponent) {
            this.switchMaximizedMode(null);
        }
        ModeImpl modeImpl2 = this.createFloatingMode(rectangle, n);
        this.moveTopComponentIntoMode(modeImpl2, topComponent);
        this.updateViewAfterDnD(false);
        WindowManagerImpl.getInstance().doFirePropertyChange("modes", null, null);
    }

    @Override
    public void userDockedTopComponent(TopComponent topComponent, ModeImpl modeImpl) {
        SplitConstraint[] splitConstraintArray;
        ModeImpl modeImpl2 = null;
        String string = WindowManagerImpl.getInstance().findTopComponentID(topComponent);
        ModeImpl modeImpl3 = (ModeImpl)WindowManagerImpl.getInstance().findMode(topComponent);
        modeImpl2 = this.model.getModeTopComponentPreviousMode(modeImpl3, string);
        int n = this.model.getModeTopComponentPreviousIndex(modeImpl3, string);
        int n2 = modeImpl.getKind();
        if (!(modeImpl2 != null && this.model.getModes().contains(modeImpl2) && modeImpl2.getState() != 1 || (splitConstraintArray = this.model.getModeTopComponentPreviousConstraints(modeImpl3, string)) == null || null != (modeImpl2 = this.findJoinedMode(n2, splitConstraintArray)))) {
            modeImpl2 = WindowManagerImpl.getInstance().createModeImpl(ModeImpl.getUnusedModeName(), n2, false);
            this.model.addMode(modeImpl2, splitConstraintArray);
        }
        if (modeImpl2 == null) {
            modeImpl2 = n2 == 1 ? WindowManagerImpl.getInstance().getDefaultEditorMode() : WindowManagerImpl.getInstance().getDefaultViewMode();
        }
        this.moveTopComponentIntoMode(modeImpl2, topComponent, n);
        this.updateViewAfterDnD(false);
        WindowManagerImpl.getInstance().doFirePropertyChange("modes", null, null);
    }

    void userStartedKeyboardDragAndDrop(TopComponentDraggable topComponentDraggable) {
        this.viewRequestor.userStartedKeyboardDragAndDrop(topComponentDraggable);
    }

    private ModeImpl findJoinedMode(int n, SplitConstraint[] splitConstraintArray) {
        for (ModeImpl modeImpl : this.getModes()) {
            SplitConstraint[] splitConstraintArray2;
            if (modeImpl.getKind() != n || modeImpl.getState() != 0 || (splitConstraintArray2 = modeImpl.getConstraints()).length != splitConstraintArray.length) continue;
            boolean bl = true;
            for (int i = 0; i < splitConstraintArray.length; ++i) {
                if (splitConstraintArray[i].orientation == splitConstraintArray2[i].orientation && splitConstraintArray[i].index == splitConstraintArray2[i].index) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return modeImpl;
        }
        return null;
    }

    private boolean moveTopComponentIntoMode(ModeImpl modeImpl, TopComponent topComponent) {
        return this.moveTopComponentIntoMode(modeImpl, topComponent, -1);
    }

    private boolean moveTopComponentIntoMode(ModeImpl modeImpl, TopComponent topComponent, int n) {
        int n2;
        boolean bl = false;
        boolean bl2 = modeImpl.getKind() == 2;
        boolean bl3 = modeImpl.getState() == 1;
        ModeImpl modeImpl2 = null;
        String string = WindowManagerImpl.getInstance().findTopComponentID(topComponent);
        if (!modeImpl.canContain(topComponent)) {
            return false;
        }
        TopComponentTracker.getDefault().add(topComponent, modeImpl);
        for (ModeImpl object : this.model.getModes()) {
            if (!this.model.containsModeTopComponent(object, topComponent)) continue;
            if (object.getKind() == 2 || object.getState() == 1) {
                modeImpl2 = this.model.getModeTopComponentPreviousMode(object, string);
                break;
            }
            modeImpl2 = object;
            break;
        }
        if (!topComponent.isOpened()) {
            topComponent.open();
        }
        int n3 = n2 = modeImpl2 != null && (bl2 || bl3) ? modeImpl2.getOpenedTopComponentsIDs().indexOf(string) : -1;
        if (this.removeTopComponentFromOtherModes(modeImpl, topComponent)) {
            bl = true;
        }
        if (n > -1) {
            this.model.insertModeOpenedTopComponent(modeImpl, topComponent, n);
        } else {
            this.model.addModeOpenedTopComponent(modeImpl, topComponent);
        }
        if (modeImpl2 != null && (bl2 || bl3)) {
            ModeImpl modeImpl3;
            List<String> list;
            if (bl3 && modeImpl.isPermanent() && !(list = modeImpl.getTopComponentsIDs()).isEmpty() && null != (modeImpl3 = this.model.getModeTopComponentPreviousMode(modeImpl, list.get(0)))) {
                modeImpl2 = modeImpl3;
            }
            this.model.setModeTopComponentPreviousMode(modeImpl, string, modeImpl2, n2);
            this.model.setModeTopComponentPreviousConstraints(modeImpl, string, this.model.getModeConstraints(modeImpl2));
        }
        if (!bl2) {
            this.model.setActiveMode(modeImpl);
            this.model.setModeSelectedTopComponent(modeImpl, topComponent);
        } else {
            this.sortSlidedOutTopComponentsByPrevModes(modeImpl);
            if (modeImpl2 != null && modeImpl2 == this.getActiveMode() && modeImpl2.getOpenedTopComponents().isEmpty()) {
                this.setSomeModeActive();
            }
            if (modeImpl.getBounds().width == 0 && modeImpl.getBounds().height == 0) {
                modeImpl.setBounds(topComponent.getBounds());
            }
        }
        return bl;
    }

    private void sortSlidedOutTopComponentsByPrevModes(ModeImpl modeImpl) {
        if (!Switches.isModeSlidingEnabled()) {
            return;
        }
        List<String> list = modeImpl.getOpenedTopComponentsIDs();
    }

    private void updateViewAfterDnD(boolean bl) {
        if (bl) {
            this.switchMaximizedMode(null);
        }
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 46, null, null));
            FloatingWindowTransparencyManager.getDefault().update();
        }
    }

    public void addSlidingMode(ModeImpl modeImpl, ModeImpl modeImpl2, String string, Map<String, Integer> map) {
        ModeImpl modeImpl3 = this.model.getSlidingMode(string);
        if (modeImpl3 != null) {
            return;
        }
        modeImpl3 = WindowManagerImpl.getInstance().createModeImpl(ModeImpl.getUnusedModeName(), 2, false);
        this.model.addSlidingMode(modeImpl, string, map);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 12, null, modeImpl));
        }
        WindowManagerImpl.getInstance().doFirePropertyChange("modes", null, null);
    }

    @Override
    public void userEnabledAutoHide(TopComponent topComponent, ModeImpl modeImpl, String string) {
        if (this.isViewMaximized()) {
            this.switchMaximizedMode(null);
        }
        String string2 = WindowManagerImpl.getInstance().findTopComponentID(topComponent);
        if (this.isEditorMaximized()) {
            this.setTopComponentDockedInMaximizedMode(string2, false);
        }
        this.slide(topComponent, modeImpl, string);
    }

    void slide(TopComponent topComponent, ModeImpl modeImpl, String string) {
        ModeImpl modeImpl2 = this.model.getSlidingMode(string);
        if (modeImpl2 == null) {
            modeImpl2 = WindowManagerImpl.getInstance().createModeImpl(ModeImpl.getUnusedModeName(), 2, false);
            this.model.addSlidingMode(modeImpl2, string, null);
            this.model.setModeBounds(modeImpl2, new Rectangle(topComponent.getBounds()));
        }
        ModeImpl modeImpl3 = this.getActiveMode();
        this.moveTopComponentIntoMode(modeImpl2, topComponent);
        ModeImpl modeImpl4 = this.getActiveMode();
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 47, null, null));
        }
        if (modeImpl3 != modeImpl4) {
            WindowManagerImpl.getInstance().doFirePropertyChange("activeMode", modeImpl3, modeImpl4);
        }
        if (modeImpl4 != null) {
            WindowManagerImpl.notifyRegistryTopComponentActivated(modeImpl4.getSelectedTopComponent());
        } else {
            WindowManagerImpl.notifyRegistryTopComponentActivated(null);
        }
    }

    @Override
    public void userResizedSlidingMode(ModeImpl modeImpl, Rectangle rectangle) {
        this.model.setModeBounds(modeImpl, new Rectangle(rectangle));
        String string = this.model.getSlidingModeConstraints(modeImpl);
        this.model.setSlideInSize(string, modeImpl.getSelectedTopComponent(), "bottom".equals(string) || "top".equals(string) ? rectangle.height : rectangle.width);
        if (null != modeImpl.getSelectedTopComponent()) {
            String string2 = WindowManagerImpl.getInstance().findTopComponentID(modeImpl.getSelectedTopComponent());
            this.model.setTopComponentMaximizedWhenSlidedIn(string2, false);
        }
    }

    @Override
    public void userDisabledAutoHide(TopComponent topComponent, ModeImpl modeImpl) {
        if (this.isViewMaximized()) {
            this.switchMaximizedMode(null);
        }
        String string = WindowManagerImpl.getInstance().findTopComponentID(topComponent);
        if (this.isEditorMaximized()) {
            this.setTopComponentDockedInMaximizedMode(string, true);
        }
        this.unSlide(topComponent, modeImpl);
    }

    private ModeImpl unSlide(TopComponent topComponent, ModeImpl modeImpl) {
        SplitConstraint[] splitConstraintArray;
        String string = WindowManagerImpl.getInstance().findTopComponentID(topComponent);
        ModeImpl modeImpl2 = this.model.getModeTopComponentPreviousMode(modeImpl, string);
        int n = this.model.getModeTopComponentPreviousIndex(modeImpl, string);
        if (!(modeImpl2 != null && this.model.getModes().contains(modeImpl2) || (splitConstraintArray = this.model.getModeTopComponentPreviousConstraints(modeImpl, string)) == null)) {
            modeImpl2 = WindowManagerImpl.getInstance().createModeImpl(ModeImpl.getUnusedModeName(), modeImpl.getKind(), false);
            this.model.addMode(modeImpl2, splitConstraintArray);
        }
        if (modeImpl2 == null) {
            modeImpl2 = modeImpl.getKind() == 1 ? WindowManagerImpl.getInstance().getDefaultEditorMode() : WindowManagerImpl.getInstance().getDefaultViewMode();
        }
        this.moveTopComponentIntoMode(modeImpl2, topComponent, n);
        modeImpl2.setMinimized(false);
        if (modeImpl.isEmpty()) {
            this.model.removeMode(modeImpl);
        }
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 48, null, null));
        }
        WindowManagerImpl.getInstance().doFirePropertyChange("activeMode", null, this.getActiveMode());
        return modeImpl2;
    }

    void setTopComponentMinimized(TopComponent topComponent, boolean bl) {
        if (!topComponent.isOpened()) {
            return;
        }
        if (this.isTopComponentMinimized(topComponent) == bl) {
            return;
        }
        ModeImpl modeImpl = (ModeImpl)WindowManagerImpl.getInstance().findMode(topComponent);
        if (null == modeImpl || modeImpl.getState() != 0) {
            return;
        }
        if (bl) {
            this.slide(topComponent, modeImpl, this.guessSlideSide(topComponent));
        } else {
            this.unSlide(topComponent, modeImpl);
        }
        WindowManagerImpl.getInstance().doFirePropertyChange("modes", null, null);
    }

    boolean isTopComponentMinimized(TopComponent topComponent) {
        if (!topComponent.isOpened()) {
            return false;
        }
        ModeImpl modeImpl = (ModeImpl)WindowManagerImpl.getInstance().findMode(topComponent);
        return null != modeImpl && modeImpl.getKind() == 2;
    }

    public ModeImpl getModeTopComponentPreviousMode(String string, ModeImpl modeImpl) {
        return this.model.getModeTopComponentPreviousMode(modeImpl, string);
    }

    public int getModeTopComponentPreviousIndex(String string, ModeImpl modeImpl) {
        return this.model.getModeTopComponentPreviousIndex(modeImpl, string);
    }

    public void setModeTopComponentPreviousMode(String string, ModeImpl modeImpl, ModeImpl modeImpl2, int n) {
        this.model.setModeTopComponentPreviousMode(modeImpl, string, modeImpl2, n);
    }

    Map<String, Integer> getSlideInSizes(String string) {
        return this.model.getSlideInSizes(string);
    }

    void setTopComponentDockedInMaximizedMode(String string, boolean bl) {
        if (bl) {
            this.model.getMaximizedDockingStatus().addDocked(string);
        } else {
            this.model.getMaximizedDockingStatus().addSlided(string);
        }
    }

    boolean isTopComponentDockedInMaximizedMode(String string) {
        return this.model.getMaximizedDockingStatus().isDocked(string);
    }

    void setTopComponentSlidedInDefaultMode(String string, boolean bl) {
        if (bl) {
            this.model.getDefaultDockingStatus().addSlided(string);
        } else {
            this.model.getDefaultDockingStatus().addDocked(string);
        }
    }

    boolean isTopComponentMaximizedWhenSlidedIn(String string) {
        return this.model.isTopComponentMaximizedWhenSlidedIn(string);
    }

    void setTopComponentMaximizedWhenSlidedIn(String string, boolean bl) {
        this.model.setTopComponentMaximizedWhenSlidedIn(string, bl);
    }

    void userToggledTopComponentSlideInMaximize(String string) {
        this.setTopComponentMaximizedWhenSlidedIn(string, !this.isTopComponentMaximizedWhenSlidedIn(string));
        if (this.isVisible()) {
            TopComponent topComponent = WindowManagerImpl.getInstance().findTopComponent(string);
            ModeImpl modeImpl = WindowManagerImpl.getInstance().findModeForOpenedID(string);
            if (null != topComponent && null != modeImpl && null != modeImpl.getSide()) {
                this.viewRequestor.scheduleRequest(new ViewRequest(topComponent, 67, null, modeImpl.getSide()));
            }
        }
    }

    boolean isTopComponentSlidedInDefaultMode(String string) {
        return this.model.getDefaultDockingStatus().isSlided(string);
    }

    boolean isEditorMaximized() {
        return null != this.model.getEditorMaximizedMode();
    }

    boolean isViewMaximized() {
        return null != this.model.getViewMaximizedMode();
    }

    private void restoreViews(DockingStatus dockingStatus) {
        TopComponent topComponent;
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        Set<? extends ModeImpl> set = this.getModes();
        for (ModeImpl modeImpl : set) {
            String string;
            if (modeImpl.getState() == 1) continue;
            if (modeImpl.getKind() == 0) {
                topComponent = this.getModeOpenedTopComponents(modeImpl);
                Collections.reverse(topComponent);
                for (TopComponent topComponent2 : topComponent) {
                    string = windowManagerImpl.findTopComponentID(topComponent2);
                    if (!dockingStatus.shouldSlide(string)) continue;
                    this.slide(topComponent2, modeImpl, this.guessSlideSide(topComponent2));
                }
                continue;
            }
            if (modeImpl.getKind() != 2) continue;
            topComponent = this.getModeOpenedTopComponents(modeImpl);
            Collections.reverse(topComponent);
            for (TopComponent topComponent2 : topComponent) {
                string = windowManagerImpl.findTopComponentID(topComponent2);
                if (!dockingStatus.shouldDock(string)) continue;
                this.unSlide(topComponent2, modeImpl);
            }
        }
        for (ModeImpl modeImpl : set) {
            if (modeImpl.getState() == 1 || modeImpl.getKind() != 0 || null == (topComponent = modeImpl.getPreviousSelectedTopComponent())) continue;
            this.setModeSelectedTopComponent(modeImpl, topComponent);
        }
    }

    private void slideAllViews() {
        List<TopComponent> list;
        HashMap<TopComponent, String> hashMap = new HashMap<TopComponent, String>(30);
        Set<? extends ModeImpl> set = this.getModes();
        for (ModeImpl modeImpl : set) {
            if (modeImpl.getKind() != 0 || modeImpl == this.getViewMaximizedMode() || modeImpl.getState() == 1) continue;
            list = this.getModeOpenedTopComponents(modeImpl);
            for (TopComponent topComponent : list) {
                hashMap.put(topComponent, this.guessSlideSide(topComponent));
            }
        }
        for (ModeImpl modeImpl : set) {
            if (modeImpl.getKind() != 0 || modeImpl == this.getViewMaximizedMode() || modeImpl.getState() == 1) continue;
            list = this.getModeOpenedTopComponents(modeImpl);
            Collections.reverse(list);
            for (TopComponent topComponent : list) {
                this.slide(topComponent, modeImpl, (String)hashMap.get(topComponent));
            }
        }
    }

    void newTabGroup(TopComponent topComponent) {
        ModeImpl modeImpl = (ModeImpl)WindowManagerImpl.getInstance().findMode(topComponent);
        if (null == modeImpl) {
            return;
        }
        ModeImpl modeImpl2 = this.attachModeToSide(modeImpl, null, modeImpl.getKind());
        this.moveTopComponentIntoMode(modeImpl2, topComponent);
        this.updateViewAfterDnD(true);
        topComponent.requestActive();
        WindowManagerImpl.getInstance().doFirePropertyChange("modes", null, null);
    }

    void collapseTabGroup(ModeImpl modeImpl) {
        ModeImpl modeImpl2 = this.findClosestNeighbor(modeImpl);
        if (null == modeImpl2) {
            return;
        }
        TopComponent topComponent = modeImpl.getSelectedTopComponent();
        this.mergeModes(modeImpl, modeImpl2, -1);
        if (null != topComponent) {
            topComponent.requestActive();
        }
        this.updateViewAfterDnD(true);
        WindowManagerImpl.getInstance().doFirePropertyChange("modes", null, null);
    }

    private ModeImpl findClosestNeighbor(ModeImpl modeImpl) {
        ArrayList<ModeImpl> arrayList = new ArrayList<ModeImpl>(this.model.getModes().size());
        ModeImpl modeImpl2 = null;
        ModeImpl modeImpl3 = null;
        SplitConstraint[] splitConstraintArray = modeImpl.getConstraints();
        int n = splitConstraintArray[splitConstraintArray.length - 1].index;
        for (ModeImpl modeImpl4 : this.model.getModes()) {
            if (modeImpl == modeImpl4 || modeImpl4.getKind() != modeImpl.getKind() || modeImpl4.getState() != modeImpl.getState()) continue;
            SplitConstraint[] splitConstraintArray2 = modeImpl4.getConstraints();
            if (this.sameSplit(splitConstraintArray, splitConstraintArray2)) {
                int n2 = splitConstraintArray2[splitConstraintArray.length - 1].index;
                if (n < n2) {
                    if (null == modeImpl2 || n2 > modeImpl2.getConstraints()[splitConstraintArray.length - 1].index) {
                        modeImpl2 = modeImpl4;
                    }
                } else if (null == modeImpl3 || n2 < modeImpl3.getConstraints()[splitConstraintArray.length - 1].index) {
                    modeImpl3 = modeImpl4;
                }
            }
            arrayList.add(modeImpl4);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        if (null != modeImpl2) {
            return modeImpl2;
        }
        if (null != modeImpl3) {
            return modeImpl3;
        }
        Collections.sort(arrayList, new Comparator<ModeImpl>(){

            @Override
            public int compare(ModeImpl modeImpl, ModeImpl modeImpl2) {
                SplitConstraint[] splitConstraintArray = modeImpl.getConstraints();
                SplitConstraint[] splitConstraintArray2 = modeImpl2.getConstraints();
                return splitConstraintArray.length - splitConstraintArray2.length;
            }
        });
        return (ModeImpl)arrayList.get(0);
    }

    private boolean sameSplit(SplitConstraint[] splitConstraintArray, SplitConstraint[] splitConstraintArray2) {
        if (splitConstraintArray.length != splitConstraintArray2.length) {
            return false;
        }
        for (int i = 0; i < splitConstraintArray.length - 1; ++i) {
            if (splitConstraintArray[i].orientation == splitConstraintArray2[i].orientation && splitConstraintArray[i].index == splitConstraintArray2[i].index) continue;
            return false;
        }
        return splitConstraintArray[splitConstraintArray.length - 1].orientation == splitConstraintArray2[splitConstraintArray2.length - 1].orientation;
    }
}

