/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.ui;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptor;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import com.sun.tools.visualvm.core.ui.DataSourceCaption;
import com.sun.tools.visualvm.core.ui.DataSourceView;
import com.sun.tools.visualvm.core.ui.DataSourceWindowManager;
import com.sun.tools.visualvm.core.ui.DataSourceWindowTabbedPane;
import com.sun.tools.visualvm.uisupport.UISupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataSourceWindow
extends TopComponent
implements PropertyChangeListener {
    private static final RequestProcessor PROCESSOR = new RequestProcessor("DataSourceWindow Processor", 5);
    private int viewsCount = 0;
    private DataSource dataSource;
    private DataSourceDescriptor dataSourceDescriptor;
    private DataSourceWindowTabbedPane.ViewContainer singleViewContainer;
    private JPanel multiViewContainer;
    private AlertListener alertListener;
    private DataSourceWindowTabbedPane tabbedContainer;

    public DataSourceWindow(DataSource dataSource) {
        this.dataSource = dataSource;
        this.initAppearance();
        this.initComponents();
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void addView(DataSourceView view) {
        if (this.viewsCount == 0) {
            this.singleViewContainer = new DataSourceWindowTabbedPane.ViewContainer(new DataSourceCaption<DataSource>(this.dataSource), view);
            this.add(this.singleViewContainer, "Center");
            this.doLayout();
            this.alertListener = new AlertListener();
        } else if (this.viewsCount == 1) {
            this.remove(this.singleViewContainer);
            this.add(this.multiViewContainer, "Center");
            this.tabbedContainer.addView(this.dataSource, this.singleViewContainer.getView());
            this.tabbedContainer.addView(this.dataSource, view);
            this.doLayout();
            this.singleViewContainer.getCaption().finish();
            this.singleViewContainer = null;
        } else {
            this.tabbedContainer.addView(this.dataSource, view);
        }
        ++this.viewsCount;
        view.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.alertListener, (Object)view));
    }

    public void selectView(DataSourceView view) {
        if (this.viewsCount > 1) {
            int viewIndex = this.indexOf(view);
            if (viewIndex == -1) {
                throw new RuntimeException("View " + view + " not present in DataSourceWindow " + this);
            }
            this.tabbedContainer.setViewIndex(viewIndex);
        }
    }

    public void removeView(final DataSourceView view) {
        if (this.viewsCount == 1) {
            if (view != this.singleViewContainer.getView()) {
                throw new RuntimeException("View " + view + " not present in DataSourceWindow " + this);
            }
            this.remove(this.singleViewContainer);
            this.singleViewContainer.getCaption().finish();
            this.singleViewContainer = null;
        } else {
            int viewIndex = this.indexOf(view);
            if (viewIndex == -1) {
                throw new RuntimeException("View " + view + " not present in DataSourceWindow " + this);
            }
            this.tabbedContainer.removeView(viewIndex);
            if (this.viewsCount == 2) {
                this.singleViewContainer = new DataSourceWindowTabbedPane.ViewContainer(new DataSourceCaption<DataSource>(this.dataSource), this.tabbedContainer.getViews().get(0));
                this.remove(this.multiViewContainer);
                this.tabbedContainer.removeView(0);
                this.add(this.singleViewContainer, "Center");
                this.doLayout();
            }
        }
        PROCESSOR.post(new Runnable(){

            public void run() {
                view.viewRemoved();
            }
        });
        DataSourceWindowManager.sharedInstance().unregisterClosedView(view);
        --this.viewsCount;
        if (this.viewsCount == 0 && this.isOpened()) {
            this.close();
        }
    }

    public void removeAllViews() {
        List<DataSourceView> views = this.getViews();
        for (DataSourceView view : views) {
            this.removeView(view);
        }
    }

    public List<DataSourceView> getViews() {
        if (this.viewsCount == 1) {
            return Collections.singletonList(this.singleViewContainer.getView());
        }
        return this.tabbedContainer.getViews();
    }

    public boolean containsView(DataSourceView view) {
        return this.indexOf(view) != -1;
    }

    private int indexOf(DataSourceView view) {
        if (this.viewsCount == 1) {
            return view == this.singleViewContainer.getView() ? 0 : -1;
        }
        return this.tabbedContainer.indexOfView(view);
    }

    protected final void componentActivated() {
        super.componentActivated();
        if (this.singleViewContainer != null) {
            this.singleViewContainer.requestFocusInWindow();
        } else if (this.getComponentCount() > 0) {
            this.getComponent(0).requestFocusInWindow();
        }
    }

    protected final void componentClosed() {
        this.dataSourceDescriptor.removePropertyChangeListener(this);
        this.removeAllViews();
        DataSourceWindowManager.sharedInstance().unregisterClosedWindow(this);
        super.componentClosed();
    }

    @Override
    public void propertyChange(final PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("prop_name".equals(propertyName)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DataSourceWindow.this.setName((String)evt.getNewValue());
                }
            });
        } else if ("prop_icon".equals(propertyName)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DataSourceWindow.this.setIcon((Image)evt.getNewValue());
                }
            });
        } else if (this.tabbedContainer.isCloseEvent(evt)) {
            this.removeView(this.tabbedContainer.getView((DataSourceWindowTabbedPane.ViewContainer)evt.getNewValue()));
        }
    }

    private void initAppearance() {
        this.dataSourceDescriptor = DataSourceDescriptorFactory.getDescriptor(this.dataSource);
        this.dataSourceDescriptor.addPropertyChangeListener(this);
        this.setName(this.dataSourceDescriptor.getName());
        this.setIcon(this.dataSourceDescriptor.getIcon());
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.tabbedContainer = new DataSourceWindowTabbedPane();
        this.tabbedContainer.addCloseListener(this);
        this.multiViewContainer = new JPanel(new BorderLayout());
        if (UISupport.isAquaLookAndFeel()) {
            this.multiViewContainer.setOpaque(true);
            this.multiViewContainer.setBackground(UISupport.getDefaultBackground());
        }
        this.multiViewContainer.add((Component)this.tabbedContainer, "Center");
        this.add(this.multiViewContainer, "Center");
    }

    private void setAlert(DataSourceView view, DataSourceView.Alert alert) {
        int viewIndex = this.tabbedContainer.indexOfView(view);
        this.tabbedContainer.setViewBackground(viewIndex, this.getAlertColor(alert));
        if (alert != DataSourceView.Alert.OK) {
            this.requestAttention(false);
        } else if (this.getApplicationAlert(alert) == DataSourceView.Alert.OK) {
            this.cancelRequestAttention();
        }
    }

    private Color getAlertColor(DataSourceView.Alert alert) {
        Color color = null;
        switch (alert) {
            case ERROR: {
                color = Color.RED;
                break;
            }
            case WARNING: {
                color = Color.YELLOW;
                break;
            }
            case OK: {
                color = null;
            }
        }
        return color;
    }

    private DataSourceView.Alert getApplicationAlert(DataSourceView.Alert alert) {
        if (alert == DataSourceView.Alert.ERROR) {
            return alert;
        }
        for (DataSourceView view : this.getViews()) {
            DataSourceView.Alert a = view.getAlert();
            if (a == DataSourceView.Alert.ERROR) {
                return a;
            }
            if (a != DataSourceView.Alert.WARNING) continue;
            alert = a;
        }
        return alert;
    }

    public int getPersistenceType() {
        return 2;
    }

    protected String preferredID() {
        return this.getClass().getName();
    }

    private class AlertListener
    implements PropertyChangeListener {
        private AlertListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("Alert".equals(evt.getPropertyName())) {
                DataSourceWindow.this.setAlert((DataSourceView)evt.getSource(), (DataSourceView.Alert)((Object)evt.getNewValue()));
            }
        }
    }
}

