/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.gui.jmapviewer.interfaces.TemplatedTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TMSTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TileSourceInfo;

public class TemplatedTMSTileSource
extends TMSTileSource
implements TemplatedTileSource {
    private Random rand;
    private String[] randomParts;
    private final Map<String, String> headers = new HashMap<String, String>();
    private static final String COOKIE_HEADER = "Cookie";
    private static final String PATTERN_ZOOM = "\\{(?:(\\d+)-)?z(?:oom)?([+-]\\d+)?\\}";
    private static final String PATTERN_X = "\\{x\\}";
    private static final String PATTERN_Y = "\\{y\\}";
    private static final String PATTERN_Y_YAHOO = "\\{!y\\}";
    private static final String PATTERN_NEG_Y = "\\{-y\\}";
    private static final String PATTERN_SWITCH = "\\{switch:([^}]+)\\}";
    private static final String PATTERN_HEADER = "\\{header\\(([^,]+),([^}]+)\\)\\}";
    private static final String[] ALL_PATTERNS = new String[]{"\\{header\\(([^,]+),([^}]+)\\)\\}", "\\{(?:(\\d+)-)?z(?:oom)?([+-]\\d+)?\\}", "\\{x\\}", "\\{y\\}", "\\{!y\\}", "\\{-y\\}", "\\{switch:([^}]+)\\}"};

    public TemplatedTMSTileSource(TileSourceInfo tileSourceInfo) {
        super(tileSourceInfo);
        String string = tileSourceInfo.getCookies();
        if (string != null && !string.isEmpty()) {
            this.headers.put(COOKIE_HEADER, string);
        }
        this.handleTemplate();
    }

    private void handleTemplate() {
        Matcher matcher = Pattern.compile(".*\\{switch:([^}]+)\\}.*").matcher(this.baseUrl);
        if (matcher.matches()) {
            this.rand = new Random();
            this.randomParts = matcher.group(1).split(",");
        }
        Pattern pattern = Pattern.compile(PATTERN_HEADER);
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher2 = pattern.matcher(this.baseUrl);
        while (matcher2.find()) {
            this.headers.put(matcher2.group(1), matcher2.group(2));
            matcher2.appendReplacement(stringBuffer, "");
        }
        matcher2.appendTail(stringBuffer);
        this.baseUrl = stringBuffer.toString();
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public String getTileUrl(int n, int n2, int n3) {
        String string;
        int n4 = n;
        Matcher matcher = Pattern.compile(".*\\{(?:(\\d+)-)?z(?:oom)?([+-]\\d+)?\\}.*").matcher(this.baseUrl);
        if (matcher.matches()) {
            if (matcher.group(1) != null) {
                n4 = Integer.parseInt(matcher.group(1)) - n;
            }
            if (matcher.group(2) != null) {
                string = matcher.group(2);
                if (string.startsWith("+")) {
                    string = string.substring(1);
                }
                n4 += Integer.parseInt(string);
            }
        }
        string = this.baseUrl.replaceAll(PATTERN_ZOOM, Integer.toString(n4)).replaceAll(PATTERN_X, Integer.toString(n2)).replaceAll(PATTERN_Y, Integer.toString(n3)).replaceAll(PATTERN_Y_YAHOO, Integer.toString((int)Math.pow(2.0, n - 1) - 1 - n3)).replaceAll(PATTERN_NEG_Y, Integer.toString((int)Math.pow(2.0, n) - 1 - n3));
        if (this.rand != null) {
            string = string.replaceAll(PATTERN_SWITCH, this.randomParts[this.rand.nextInt(this.randomParts.length)]);
        }
        return string;
    }

    public static void checkUrl(String string) {
        assert (string != null && !"".equals(string)) : "URL cannot be null or empty";
        Matcher matcher = Pattern.compile("\\{[^}]*\\}").matcher(string);
        while (matcher.find()) {
            boolean bl = false;
            for (String string2 : ALL_PATTERNS) {
                if (!matcher.group().matches(string2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            throw new IllegalArgumentException(matcher.group() + " is not a valid TMS argument. Please check this server URL:\n" + string);
        }
    }
}

