/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.MergeNodesAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.preferences.ColorProperty;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.draw.MapViewPath;
import org.openstreetmap.josm.gui.draw.SymbolShape;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.KeyPressReleaseListener;
import org.openstreetmap.josm.gui.util.ModifierExListener;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class ExtrudeAction
extends MapMode
implements MapViewPaintable,
KeyPressReleaseListener,
ModifierExListener {
    private Mode mode = Mode.select;
    private boolean alwaysCreateNodes;
    private boolean nodeDragWithoutCtrl;
    private long mouseDownTime;
    private transient WaySegment selectedSegment;
    private transient Node selectedNode;
    private Color mainColor;
    private transient Stroke mainStroke;
    private boolean ignoreSharedNodes;
    private boolean keepSegmentDirection;
    private Color helperColor;
    private transient Stroke helperStrokeDash;
    private transient Stroke helperStrokeRA;
    private transient Stroke oldLineStroke;
    private double symbolSize;
    private transient List<ReferenceSegment> possibleMoveDirections;
    private transient List<Node> movingNodeList;
    private transient ReferenceSegment activeMoveDirection;
    private Point initialMousePos;
    private int initialMoveDelay = 200;
    private int initialMoveThreshold = 1;
    private EastNorth initialN1en;
    private EastNorth initialN2en;
    private EastNorth newN1en;
    private EastNorth newN2en;
    private transient MoveCommand moveCommand;
    private transient MoveCommand moveCommand2;
    private final Cursor cursorCreateNew;
    private final Cursor cursorTranslate;
    private final Cursor cursorCreateNodes;
    private boolean dualAlignEnabled;
    private boolean dualAlignActive;
    private transient ReferenceSegment dualAlignSegment1;
    private transient ReferenceSegment dualAlignSegment2;
    private boolean dualAlignSegmentCollapsed;
    private final DualAlignChangeAction dualAlignChangeAction;
    private final JCheckBoxMenuItem dualAlignCheckboxMenuItem;
    private final transient Shortcut dualAlignShortcut;
    private boolean useRepeatedShortcut;
    private boolean ignoreNextKeyRelease;

    public ExtrudeAction() {
        super(I18n.tr("Extrude", new Object[0]), "extrude/extrude", I18n.tr("Create areas", new Object[0]), Shortcut.registerShortcut("mapmode:extrude", I18n.tr("Mode: {0}", I18n.tr("Extrude", new Object[0])), 88, 5003), ImageProvider.getCursor("normal", "rectangle"));
        this.putValue("help", HelpUtil.ht("/Action/Extrude"));
        this.cursorCreateNew = ImageProvider.getCursor("normal", "rectangle_plus");
        this.cursorTranslate = ImageProvider.getCursor("normal", "rectangle_move");
        this.cursorCreateNodes = ImageProvider.getCursor("normal", "rectangle_plussmall");
        this.dualAlignEnabled = false;
        this.dualAlignChangeAction = new DualAlignChangeAction();
        this.dualAlignCheckboxMenuItem = this.addDualAlignMenuItem();
        this.dualAlignCheckboxMenuItem.getAction().setEnabled(false);
        this.dualAlignCheckboxMenuItem.setState(this.dualAlignEnabled);
        this.dualAlignShortcut = Shortcut.registerShortcut("mapmode:extrudedualalign", I18n.tr("Mode: {0}", I18n.tr("Extrude Dual alignment", new Object[0])), 65535, 5000);
        this.readPreferences();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.dualAlignChangeAction.destroy();
    }

    private JCheckBoxMenuItem addDualAlignMenuItem() {
        int n = Main.main.menu.editMenu.getItemCount();
        for (int i = n - 1; i > 0; --i) {
            JMenuItem jMenuItem = Main.main.menu.editMenu.getItem(i);
            if (jMenuItem == null || jMenuItem.getAction() == null || !(jMenuItem.getAction() instanceof DualAlignChangeAction)) continue;
            Main.main.menu.editMenu.remove(i);
        }
        return MainMenu.addWithCheckbox(Main.main.menu.editMenu, this.dualAlignChangeAction, MainMenu.WINDOW_MENU_GROUP.VOLATILE);
    }

    @Override
    public String getModeHelpText() {
        StringBuilder stringBuilder;
        if (this.mode == Mode.select) {
            stringBuilder = new StringBuilder(I18n.tr("Drag a way segment to make a rectangle. Ctrl-drag to move a segment along its normal, Alt-drag to create a new rectangle, double click to add a new node.", new Object[0]));
            if (this.dualAlignEnabled) {
                stringBuilder.append(' ').append(I18n.tr("Dual alignment active.", new Object[0]));
                if (this.dualAlignSegmentCollapsed) {
                    stringBuilder.append(' ').append(I18n.tr("Segment collapsed due to its direction reversing.", new Object[0]));
                }
            }
        } else {
            if (this.mode == Mode.translate) {
                stringBuilder = new StringBuilder(I18n.tr("Move a segment along its normal, then release the mouse button.", new Object[0]));
            } else if (this.mode == Mode.translate_node) {
                stringBuilder = new StringBuilder(I18n.tr("Move the node along one of the segments, then release the mouse button.", new Object[0]));
            } else if (this.mode == Mode.extrude || this.mode == Mode.create_new) {
                stringBuilder = new StringBuilder(I18n.tr("Draw a rectangle of the desired size, then release the mouse button.", new Object[0]));
            } else {
                Main.warn("Extrude: unknown mode " + (Object)((Object)this.mode));
                stringBuilder = new StringBuilder();
            }
            if (this.dualAlignActive) {
                stringBuilder.append(' ').append(I18n.tr("Dual alignment active.", new Object[0]));
                if (this.dualAlignSegmentCollapsed) {
                    stringBuilder.append(' ').append(I18n.tr("Segment collapsed due to its direction reversing.", new Object[0]));
                }
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean layerIsSupported(Layer layer) {
        return layer instanceof OsmDataLayer;
    }

    @Override
    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener(this);
        Main.map.mapView.addMouseMotionListener(this);
        this.ignoreNextKeyRelease = true;
        Main.map.keyDetector.addKeyListener(this);
        Main.map.keyDetector.addModifierExListener(this);
    }

    @Override
    protected void readPreferences() {
        this.initialMoveDelay = Main.pref.getInteger("edit.initial-move-delay", 200);
        this.initialMoveThreshold = Main.pref.getInteger("extrude.initial-move-threshold", 1);
        this.mainColor = new ColorProperty(I18n.marktr("Extrude: main line"), Color.RED).get();
        this.helperColor = new ColorProperty(I18n.marktr("Extrude: helper line"), Color.ORANGE).get();
        this.helperStrokeDash = GuiHelper.getCustomizedStroke(Main.pref.get("extrude.stroke.helper-line", "1 4"));
        this.helperStrokeRA = new BasicStroke(1.0f);
        this.symbolSize = Main.pref.getDouble("extrude.angle-symbol-radius", 8.0);
        this.nodeDragWithoutCtrl = Main.pref.getBoolean("extrude.drag-nodes-without-ctrl", false);
        this.oldLineStroke = GuiHelper.getCustomizedStroke(Main.pref.get("extrude.ctrl.stroke.old-line", "1"));
        this.mainStroke = GuiHelper.getCustomizedStroke(Main.pref.get("extrude.stroke.main", "3"));
        this.ignoreSharedNodes = Main.pref.getBoolean("extrude.ignore-shared-nodes", true);
        this.dualAlignCheckboxMenuItem.getAction().setEnabled(true);
        this.useRepeatedShortcut = Main.pref.getBoolean("extrude.dualalign.toggleOnRepeatedX", true);
        this.keepSegmentDirection = Main.pref.getBoolean("extrude.dualalign.keep-segment-direction", true);
    }

    @Override
    public void exitMode() {
        Main.map.mapView.removeMouseListener(this);
        Main.map.mapView.removeMouseMotionListener(this);
        Main.map.mapView.removeTemporaryLayer(this);
        this.dualAlignCheckboxMenuItem.getAction().setEnabled(false);
        Main.map.keyDetector.removeKeyListener(this);
        Main.map.keyDetector.removeModifierExListener(this);
        super.exitMode();
    }

    @Override
    public void modifiersExChanged(int n) {
        if (!Main.isDisplayingMapView() || !Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        this.updateKeyModifiersEx(n);
        if (this.mode == Mode.select) {
            Main.map.mapView.setNewCursor(this.ctrl ? this.cursorTranslate : (this.alt ? this.cursorCreateNew : (this.shift ? this.cursorCreateNodes : this.cursor)), (Object)this);
        }
    }

    @Override
    public void doKeyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void doKeyReleased(KeyEvent keyEvent) {
        if (!(this.dualAlignShortcut.isEvent(keyEvent) || this.useRepeatedShortcut && this.getShortcut().isEvent(keyEvent))) {
            return;
        }
        if (this.ignoreNextKeyRelease) {
            this.ignoreNextKeyRelease = false;
        } else {
            this.toggleDualAlign();
        }
    }

    private void toggleDualAlign() {
        this.dualAlignEnabled = !this.dualAlignEnabled;
        this.dualAlignCheckboxMenuItem.setState(this.dualAlignEnabled);
        this.updateStatusLine();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!Main.map.mapView.isActiveLayerVisible()) {
            return;
        }
        if (!((Boolean)this.getValue("active")).booleanValue()) {
            return;
        }
        if (mouseEvent.getButton() != 1) {
            return;
        }
        this.requestFocusInMapView();
        this.updateKeyModifiers(mouseEvent);
        this.selectedNode = Main.map.mapView.getNearestNode(mouseEvent.getPoint(), OsmPrimitive::isSelectable);
        this.selectedSegment = Main.map.mapView.getNearestWaySegment(mouseEvent.getPoint(), OsmPrimitive::isSelectable);
        if (this.selectedSegment == null && this.selectedNode == null) {
            return;
        }
        if (this.selectedNode != null) {
            if (this.ctrl || this.nodeDragWithoutCtrl) {
                this.movingNodeList = new ArrayList<Node>();
                this.movingNodeList.add(this.selectedNode);
                this.calculatePossibleDirectionsByNode();
                if (this.possibleMoveDirections.isEmpty()) {
                    return;
                }
                this.mode = Mode.translate_node;
                this.dualAlignActive = false;
            }
        } else {
            if (this.dualAlignEnabled && this.checkDualAlignConditions()) {
                this.dualAlignActive = true;
                this.calculatePossibleDirectionsForDualAlign();
                this.dualAlignSegmentCollapsed = false;
            } else {
                this.dualAlignActive = false;
                this.calculatePossibleDirectionsBySegment();
            }
            if (this.ctrl) {
                this.mode = Mode.translate;
                this.movingNodeList = new ArrayList<Node>();
                this.movingNodeList.add(this.selectedSegment.getFirstNode());
                this.movingNodeList.add(this.selectedSegment.getSecondNode());
            } else if (this.alt) {
                this.mode = Mode.create_new;
                this.getLayerManager().getEditDataSet().setSelected(this.selectedSegment.way);
                this.alwaysCreateNodes = true;
            } else {
                this.mode = Mode.extrude;
                this.getLayerManager().getEditDataSet().setSelected(this.selectedSegment.way);
                this.alwaysCreateNodes = this.shift;
            }
        }
        this.newN1en = null;
        this.newN2en = null;
        this.moveCommand = null;
        this.moveCommand2 = null;
        Main.map.mapView.addTemporaryLayer(this);
        this.updateStatusLine();
        Main.map.mapView.repaint();
        this.mouseDownTime = System.currentTimeMillis();
        this.initialMousePos = mouseEvent.getPoint();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!Main.map.mapView.isActiveLayerVisible()) {
            return;
        }
        if (System.currentTimeMillis() - this.mouseDownTime < (long)this.initialMoveDelay) {
            return;
        }
        if (this.mode != Mode.select) {
            EastNorth eastNorth = Main.map.mapView.getEastNorth(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
            EastNorth eastNorth2 = this.calculateBestMovementAndNewNodes(eastNorth);
            Main.map.mapView.setNewCursor(13, (Object)this);
            if (this.dualAlignActive) {
                if (this.mode != Mode.extrude && this.mode != Mode.create_new && this.mode == Mode.translate) {
                    EastNorth eastNorth3 = this.newN1en.subtract(this.initialN1en);
                    EastNorth eastNorth4 = this.newN2en.subtract(this.initialN2en);
                    if (this.moveCommand == null || this.moveCommand2 == null) {
                        this.moveCommand = new MoveCommand((OsmPrimitive)this.movingNodeList.get(0), eastNorth3.getX(), eastNorth3.getY());
                        this.moveCommand2 = new MoveCommand((OsmPrimitive)this.movingNodeList.get(1), eastNorth4.getX(), eastNorth4.getY());
                        SequenceCommand sequenceCommand = new SequenceCommand(I18n.tr("Extrude Way", new Object[0]), this.moveCommand, this.moveCommand2);
                        Main.main.undoRedo.add(sequenceCommand);
                    } else {
                        this.moveCommand.moveAgainTo(eastNorth3.getX(), eastNorth3.getY());
                        this.moveCommand2.moveAgainTo(eastNorth4.getX(), eastNorth4.getY());
                    }
                }
            } else if (eastNorth2 != null && this.mode != Mode.extrude && this.mode != Mode.create_new && (this.mode == Mode.translate_node || this.mode == Mode.translate)) {
                if (this.moveCommand == null) {
                    this.moveCommand = new MoveCommand(new ArrayList<OsmPrimitive>(this.movingNodeList), eastNorth2);
                    Main.main.undoRedo.add(this.moveCommand);
                } else {
                    this.moveCommand.moveAgainTo(eastNorth2.getX(), eastNorth2.getY());
                }
            }
            Main.map.mapView.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!Main.map.mapView.isActiveLayerVisible()) {
            return;
        }
        if (this.mode != Mode.select) {
            if (this.mode == Mode.create_new) {
                if (mouseEvent.getPoint().distance(this.initialMousePos) > (double)this.initialMoveThreshold && this.newN1en != null) {
                    this.createNewRectangle();
                }
            } else if (this.mode == Mode.extrude) {
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getPoint().equals(this.initialMousePos)) {
                    ExtrudeAction.addNewNode(mouseEvent);
                } else if (mouseEvent.getPoint().distance(this.initialMousePos) > (double)this.initialMoveThreshold && this.newN1en != null && this.selectedSegment != null) {
                    try {
                        this.performExtrusion();
                    }
                    catch (DataIntegrityProblemException dataIntegrityProblemException) {
                        Main.error(dataIntegrityProblemException);
                    }
                }
            } else if (this.mode == Mode.translate || this.mode == Mode.translate_node) {
                this.joinNodesIfCollapsed(this.movingNodeList);
            }
            this.updateKeyModifiers(mouseEvent);
            Main.map.mapView.setNewCursor(this.ctrl ? this.cursorTranslate : (this.alt ? this.cursorCreateNew : (this.shift ? this.cursorCreateNodes : this.cursor)), (Object)this);
            Main.map.mapView.removeTemporaryLayer(this);
            this.selectedSegment = null;
            this.moveCommand = null;
            this.mode = Mode.select;
            this.dualAlignSegmentCollapsed = false;
            this.updateStatusLine();
            Main.map.mapView.repaint();
        }
    }

    private static void addNewNode(MouseEvent mouseEvent) {
        WaySegment waySegment = Main.map.mapView.getNearestWaySegment(mouseEvent.getPoint(), OsmPrimitive::isSelectable);
        if (waySegment != null) {
            Node node = new Node(Main.map.mapView.getLatLon(mouseEvent.getX(), mouseEvent.getY()));
            EastNorth eastNorth = waySegment.getFirstNode().getEastNorth();
            EastNorth eastNorth2 = waySegment.getSecondNode().getEastNorth();
            node.setEastNorth(Geometry.closestPointToSegment(eastNorth, eastNorth2, node.getEastNorth()));
            Way way = new Way(waySegment.way);
            way.addNode(waySegment.lowerIndex + 1, node);
            SequenceCommand sequenceCommand = new SequenceCommand(I18n.tr("Add a new node to an existing way", new Object[0]), new AddCommand(node), new ChangeCommand(waySegment.way, way));
            Main.main.undoRedo.add(sequenceCommand);
        }
    }

    private void createNewRectangle() {
        if (this.selectedSegment == null) {
            return;
        }
        LinkedList<Command> linkedList = new LinkedList<Command>();
        Node node = new Node(this.newN2en);
        Node node2 = new Node(this.newN1en);
        Way way = new Way();
        way.addNode(this.selectedSegment.getFirstNode());
        way.addNode(this.selectedSegment.getSecondNode());
        way.addNode(node);
        if (!this.dualAlignSegmentCollapsed) {
            way.addNode(node2);
        }
        way.addNode(this.selectedSegment.getFirstNode());
        linkedList.add(new AddCommand(node));
        if (!this.dualAlignSegmentCollapsed) {
            linkedList.add(new AddCommand(node2));
        }
        linkedList.add(new AddCommand(way));
        SequenceCommand sequenceCommand = new SequenceCommand(I18n.tr("Extrude Way", new Object[0]), linkedList);
        Main.main.undoRedo.add(sequenceCommand);
        this.getLayerManager().getEditDataSet().setSelected(way);
    }

    private void performExtrusion() {
        Object object;
        Node node;
        LinkedList<Command> linkedList = new LinkedList<Command>();
        Way way = new Way(this.selectedSegment.way);
        boolean bl = false;
        boolean bl2 = way.getNodesCount() == 2;
        int n = this.selectedSegment.lowerIndex + 1;
        Node node2 = this.getPreviousNode(this.selectedSegment.lowerIndex);
        boolean bl3 = node2 != null && Geometry.segmentsParallel(this.initialN1en, node2.getEastNorth(), this.initialN1en, this.newN1en);
        boolean bl4 = node2 != null && Math.abs(Geometry.getCornerAngle(node2.getEastNorth(), this.initialN1en, this.newN1en)) < 1.0E-5;
        boolean bl5 = ExtrudeAction.hasNodeOtherWays(this.selectedSegment.getFirstNode(), this.selectedSegment.way);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (bl3 && !this.alwaysCreateNodes && !bl5) {
            node = this.selectedSegment.getFirstNode();
            linkedList.add(new MoveCommand(node, Main.getProjection().eastNorth2latlon(this.newN1en)));
            arrayList.add(node);
        } else if (this.ignoreSharedNodes && bl4 && !this.alwaysCreateNodes && bl5) {
            node = this.selectedSegment.getFirstNode();
            object = new Node(Main.getProjection().eastNorth2latlon(this.newN1en));
            way.addNode(n, (Node)object);
            way.removeNode(node);
            bl = true;
            linkedList.add(new AddCommand((OsmPrimitive)object));
            arrayList.add((Node)object);
        } else {
            node = new Node(Main.getProjection().eastNorth2latlon(this.newN1en));
            way.addNode(n, node);
            bl = true;
            ++n;
            linkedList.add(new AddCommand(node));
            arrayList.add(node);
        }
        node = this.getNextNode(this.selectedSegment.lowerIndex + 1);
        bl3 = node != null && Geometry.segmentsParallel(this.initialN2en, node.getEastNorth(), this.initialN2en, this.newN2en);
        bl4 = node != null && Math.abs(Geometry.getCornerAngle(node.getEastNorth(), this.initialN2en, this.newN2en)) < 1.0E-5;
        bl5 = ExtrudeAction.hasNodeOtherWays(this.selectedSegment.getSecondNode(), this.selectedSegment.way);
        if (bl3 && !this.alwaysCreateNodes && !bl5) {
            object = this.selectedSegment.getSecondNode();
            linkedList.add(new MoveCommand((Node)object, Main.getProjection().eastNorth2latlon(this.newN2en)));
            arrayList.add((Node)object);
        } else if (this.ignoreSharedNodes && bl4 && !this.alwaysCreateNodes && bl5) {
            object = this.selectedSegment.getSecondNode();
            Node node3 = new Node(Main.getProjection().eastNorth2latlon(this.newN2en));
            way.addNode(n, node3);
            way.removeNode((Node)object);
            bl = true;
            linkedList.add(new AddCommand(node3));
            arrayList.add(node3);
        } else {
            object = new Node(Main.getProjection().eastNorth2latlon(this.newN2en));
            way.addNode(n, (Node)object);
            bl = true;
            linkedList.add(new AddCommand((OsmPrimitive)object));
            arrayList.add((Node)object);
        }
        if (bl2) {
            way.addNode(this.selectedSegment.getFirstNode());
            bl = true;
        }
        if (bl) {
            linkedList.add(new ChangeCommand(this.selectedSegment.way, way));
        }
        object = new SequenceCommand(I18n.tr("Extrude Way", new Object[0]), linkedList);
        Main.main.undoRedo.add((Command)object);
        this.joinNodesIfCollapsed(arrayList);
    }

    private void joinNodesIfCollapsed(List<Node> list) {
        if (!this.dualAlignActive || this.newN1en == null || this.newN2en == null) {
            return;
        }
        if (this.newN1en.distance(this.newN2en) > 1.0E-6) {
            return;
        }
        Node node = MergeNodesAction.selectTargetNode(list);
        Node node2 = MergeNodesAction.selectTargetLocationNode(list);
        Command command = MergeNodesAction.mergeNodes(Main.getLayerManager().getEditLayer(), list, node, node2);
        if (command != null) {
            Main.main.undoRedo.add(command);
        } else {
            Main.main.undoRedo.undo();
        }
    }

    private static boolean hasNodeOtherWays(Node node, Way way) {
        for (OsmPrimitive osmPrimitive : node.getReferrers()) {
            if (!(osmPrimitive instanceof Way) || !osmPrimitive.isUsable() || osmPrimitive == way) continue;
            return true;
        }
        return false;
    }

    private EastNorth calculateBestMovement(EastNorth eastNorth) {
        EastNorth eastNorth2 = Main.map.mapView.getEastNorth(this.initialMousePos.x, this.initialMousePos.y);
        EastNorth eastNorth3 = eastNorth.subtract(eastNorth2);
        double d = Double.POSITIVE_INFINITY;
        EastNorth eastNorth4 = null;
        this.activeMoveDirection = null;
        for (ReferenceSegment referenceSegment : this.possibleMoveDirections) {
            double d2;
            EastNorth eastNorth5 = ExtrudeAction.calculateSegmentOffset(this.initialN1en, this.initialN2en, referenceSegment.en, eastNorth);
            if (eastNorth5 == null || !(d > (d2 = eastNorth5.distance(eastNorth3)))) continue;
            d = d2;
            this.activeMoveDirection = referenceSegment;
            eastNorth4 = eastNorth5;
        }
        return eastNorth4;
    }

    private static EastNorth calculateSegmentOffset(EastNorth eastNorth, EastNorth eastNorth2, EastNorth eastNorth3, EastNorth eastNorth4) {
        EastNorth eastNorth5 = eastNorth.distanceSq(eastNorth2) > 1.0E-7 ? Geometry.getLineLineIntersection(eastNorth, eastNorth2, eastNorth4, eastNorth4.add(eastNorth3)) : Geometry.closestPointToLine(eastNorth4, eastNorth4.add(eastNorth3), eastNorth);
        if (eastNorth5 == null) {
            return null;
        }
        return eastNorth4.subtract(eastNorth5);
    }

    private void calculatePossibleDirectionsBySegment() {
        Object object;
        this.initialN1en = this.selectedSegment.getFirstNode().getEastNorth();
        this.initialN2en = this.selectedSegment.getSecondNode().getEastNorth();
        this.possibleMoveDirections = new ArrayList<ReferenceSegment>();
        this.possibleMoveDirections.add(new ReferenceSegment(new EastNorth(this.initialN1en.getY() - this.initialN2en.getY(), this.initialN2en.getX() - this.initialN1en.getX()), this.initialN1en, this.initialN2en, true));
        Node node = this.getPreviousNode(this.selectedSegment.lowerIndex);
        if (node != null) {
            object = node.getEastNorth();
            this.possibleMoveDirections.add(new ReferenceSegment(new EastNorth(this.initialN1en.getX() - ((EastNorth)object).getX(), this.initialN1en.getY() - ((EastNorth)object).getY()), this.initialN1en, (EastNorth)object, false));
        }
        if ((object = this.getNextNode(this.selectedSegment.lowerIndex + 1)) != null) {
            EastNorth eastNorth = object.getEastNorth();
            this.possibleMoveDirections.add(new ReferenceSegment(new EastNorth(this.initialN2en.getX() - eastNorth.getX(), this.initialN2en.getY() - eastNorth.getY()), this.initialN2en, eastNorth, false));
        }
    }

    private void calculatePossibleDirectionsByNode() {
        this.initialN2en = this.initialN1en = this.selectedNode.getEastNorth();
        this.possibleMoveDirections = new ArrayList<ReferenceSegment>();
        for (OsmPrimitive osmPrimitive : this.selectedNode.getReferrers()) {
            if (!(osmPrimitive instanceof Way) || !osmPrimitive.isUsable()) continue;
            for (Node node : ((Way)osmPrimitive).getNeighbours(this.selectedNode)) {
                EastNorth eastNorth = node.getEastNorth();
                this.possibleMoveDirections.add(new ReferenceSegment(new EastNorth(this.initialN1en.getX() - eastNorth.getX(), this.initialN1en.getY() - eastNorth.getY()), this.initialN1en, eastNorth, false));
            }
        }
    }

    private boolean checkDualAlignConditions() {
        Node node = this.getPreviousNode(this.selectedSegment.lowerIndex);
        Node node2 = this.getNextNode(this.selectedSegment.lowerIndex + 1);
        if (node == null || node2 == null) {
            return false;
        }
        EastNorth eastNorth = this.selectedSegment.getFirstNode().getEastNorth();
        EastNorth eastNorth2 = this.selectedSegment.getSecondNode().getEastNorth();
        if (eastNorth.distance(node.getEastNorth()) < 1.0E-4 || eastNorth2.distance(node2.getEastNorth()) < 1.0E-4) {
            return false;
        }
        boolean bl = Geometry.segmentsParallel(eastNorth, node.getEastNorth(), eastNorth, eastNorth2);
        boolean bl2 = Geometry.segmentsParallel(eastNorth2, node2.getEastNorth(), eastNorth, eastNorth2);
        return !bl && !bl2;
    }

    private void calculatePossibleDirectionsForDualAlign() {
        Object object;
        this.initialN1en = this.selectedSegment.getFirstNode().getEastNorth();
        this.initialN2en = this.selectedSegment.getSecondNode().getEastNorth();
        this.possibleMoveDirections = new ArrayList<ReferenceSegment>();
        this.possibleMoveDirections.add(new ReferenceSegment(new EastNorth(this.initialN1en.getY() - this.initialN2en.getY(), this.initialN2en.getX() - this.initialN1en.getX()), this.initialN1en, this.initialN2en, true));
        Node node = this.getPreviousNode(this.selectedSegment.lowerIndex);
        if (node != null) {
            object = node.getEastNorth();
            this.dualAlignSegment1 = new ReferenceSegment(new EastNorth(this.initialN1en.getX() - ((EastNorth)object).getX(), this.initialN1en.getY() - ((EastNorth)object).getY()), this.initialN1en, (EastNorth)object, false);
        }
        if ((object = this.getNextNode(this.selectedSegment.lowerIndex + 1)) != null) {
            EastNorth eastNorth = object.getEastNorth();
            this.dualAlignSegment2 = new ReferenceSegment(new EastNorth(this.initialN2en.getX() - eastNorth.getX(), this.initialN2en.getY() - eastNorth.getY()), this.initialN2en, eastNorth, false);
        }
    }

    private EastNorth calculateBestMovementAndNewNodes(EastNorth eastNorth) {
        EastNorth eastNorth2 = this.calculateBestMovement(eastNorth);
        EastNorth eastNorth3 = this.initialN1en.add(eastNorth2);
        double d = Main.getProjection().eastNorth2latlon(this.initialN1en).greatCircleDistance(Main.getProjection().eastNorth2latlon(eastNorth3));
        Main.map.statusLine.setDist(d);
        this.updateStatusLine();
        if (this.dualAlignActive) {
            eastNorth3 = this.initialN1en.add(eastNorth2);
            EastNorth eastNorth4 = this.initialN2en.add(eastNorth2);
            this.newN1en = Geometry.getLineLineIntersection(eastNorth3, eastNorth4, this.dualAlignSegment1.p1, this.dualAlignSegment1.p2);
            this.newN2en = Geometry.getLineLineIntersection(eastNorth3, eastNorth4, this.dualAlignSegment2.p1, this.dualAlignSegment2.p2);
            if (this.newN1en == null || this.newN2en == null) {
                return eastNorth2;
            }
            if (this.keepSegmentDirection && ExtrudeAction.isOppositeDirection(this.newN1en, this.newN2en, this.initialN1en, this.initialN2en)) {
                EastNorth eastNorth5;
                this.newN1en = eastNorth5 = Geometry.getLineLineIntersection(this.dualAlignSegment1.p1, this.dualAlignSegment1.p2, this.dualAlignSegment2.p1, this.dualAlignSegment2.p2);
                this.newN2en = eastNorth5;
                this.dualAlignSegmentCollapsed = true;
            } else {
                this.dualAlignSegmentCollapsed = false;
            }
        } else {
            this.newN1en = eastNorth3;
            this.newN2en = this.initialN2en.add(eastNorth2);
        }
        return eastNorth2;
    }

    private int getPreviousNodeIndex(int n) {
        if (n > 0) {
            return n - 1;
        }
        if (this.selectedSegment.way.isClosed()) {
            return this.selectedSegment.way.getNodesCount() - 2;
        }
        return -1;
    }

    private Node getPreviousNode(int n) {
        int n2 = this.getPreviousNodeIndex(n);
        if (n2 >= 0) {
            return this.selectedSegment.way.getNode(n2);
        }
        return null;
    }

    private int getNextNodeIndex(int n) {
        int n2 = this.selectedSegment.way.getNodesCount();
        if (n < n2 - 1) {
            return n + 1;
        }
        if (this.selectedSegment.way.isClosed()) {
            return 1;
        }
        return -1;
    }

    private Node getNextNode(int n) {
        int n2 = this.getNextNodeIndex(n);
        if (n2 >= 0) {
            return this.selectedSegment.way.getNode(n2);
        }
        return null;
    }

    @Override
    public void paint(Graphics2D graphics2D, MapView mapView, Bounds bounds) {
        Graphics2D graphics2D2 = graphics2D;
        if (this.mode != Mode.select) {
            if (this.newN1en != null) {
                Point2D point2D;
                EastNorth eastNorth = this.initialN1en;
                EastNorth eastNorth2 = this.initialN2en;
                EastNorth eastNorth3 = this.newN1en;
                EastNorth eastNorth4 = this.newN2en;
                Point2D point2D2 = point2D = this.activeMoveDirection != null ? this.getNormalUniVector() : null;
                if (this.mode == Mode.extrude || this.mode == Mode.create_new) {
                    graphics2D2.setColor(this.mainColor);
                    graphics2D2.setStroke(this.mainStroke);
                    MapViewPath mapViewPath = new MapViewPath(mapView);
                    mapViewPath.moveTo(eastNorth);
                    mapViewPath.lineTo(eastNorth3);
                    mapViewPath.lineTo(eastNorth4);
                    mapViewPath.lineTo(eastNorth2);
                    mapViewPath.lineTo(eastNorth);
                    graphics2D2.draw(mapViewPath);
                    if (this.dualAlignActive) {
                        this.drawReferenceSegment(graphics2D2, mapView, this.dualAlignSegment1);
                        this.drawReferenceSegment(graphics2D2, mapView, this.dualAlignSegment2);
                    } else if (this.activeMoveDirection != null && point2D != null) {
                        this.drawReferenceSegment(graphics2D2, mapView, this.activeMoveDirection);
                        if (this.activeMoveDirection.perpendicular) {
                            double d;
                            double d2 = this.activeMoveDirection.p1.heading(this.activeMoveDirection.p2);
                            double d3 = d2 - (d = Math.atan2(point2D.getY(), point2D.getX()));
                            if (d3 < 0.0) {
                                d3 += Math.PI * 2;
                            }
                            boolean bl = Math.abs(d3 - Math.PI) > 1.0E-5;
                            Point point = mapView.getPoint(this.activeMoveDirection.p1);
                            this.drawAngleSymbol(graphics2D2, point, point2D, bl);
                        }
                    }
                } else if (this.mode == Mode.translate || this.mode == Mode.translate_node) {
                    graphics2D2.setColor(this.mainColor);
                    if (eastNorth.distance(eastNorth2) < 3.0) {
                        graphics2D2.setStroke(this.mainStroke);
                        graphics2D2.draw(new MapViewPath(mapView).shapeAround(eastNorth, SymbolShape.CIRCLE, this.symbolSize));
                    } else {
                        graphics2D2.setStroke(this.oldLineStroke);
                        graphics2D2.draw(new MapViewPath(mapView).moveTo(eastNorth).lineTo(eastNorth2));
                    }
                    if (this.dualAlignActive) {
                        this.drawReferenceSegment(graphics2D2, mapView, this.dualAlignSegment1);
                        this.drawReferenceSegment(graphics2D2, mapView, this.dualAlignSegment2);
                    } else if (this.activeMoveDirection != null) {
                        graphics2D2.setColor(this.helperColor);
                        graphics2D2.setStroke(this.helperStrokeDash);
                        Point2D point2D3 = mapView.getPoint2D(eastNorth.interpolate(eastNorth2, 0.5));
                        Line2D line2D = ExtrudeAction.createSemiInfiniteLine(point2D3, point2D, graphics2D2);
                        graphics2D2.draw(line2D);
                        if (this.activeMoveDirection.perpendicular) {
                            graphics2D2.setStroke(this.helperStrokeRA);
                            graphics2D2.setColor(this.mainColor);
                            this.drawAngleSymbol(graphics2D2, point2D3, point2D, false);
                        }
                    }
                }
            }
            graphics2D2.setStroke(this.helperStrokeRA);
        }
    }

    private Point2D getNormalUniVector() {
        double d = 1.0 / this.activeMoveDirection.en.length();
        Point2D.Double double_ = new Point2D.Double(this.activeMoveDirection.en.getX() * d, this.activeMoveDirection.en.getY() * d);
        if (this.newN1en != null && this.newN1en.getX() > this.initialN1en.getX() != ((Point2D)double_).getX() > -0.0) {
            double_ = new Point2D.Double(-((Point2D)double_).getX(), -((Point2D)double_).getY());
        }
        ((Point2D)double_).setLocation(((Point2D)double_).getX(), -((Point2D)double_).getY());
        return double_;
    }

    private static boolean isOppositeDirection(EastNorth eastNorth, EastNorth eastNorth2, EastNorth eastNorth3, EastNorth eastNorth4) {
        return (eastNorth.getX() - eastNorth2.getX()) * (eastNorth3.getX() - eastNorth4.getX()) + (eastNorth.getY() - eastNorth2.getY()) * (eastNorth3.getY() - eastNorth4.getY()) < 0.0;
    }

    private void drawAngleSymbol(Graphics2D graphics2D, Point2D point2D, Point2D point2D2, boolean bl) {
        double d = 1.0 / graphics2D.getTransform().getScaleX();
        double d2 = this.symbolSize * d * point2D2.getX();
        double d3 = this.symbolSize * d * point2D2.getY();
        double d4 = point2D.getX();
        double d5 = point2D.getY();
        double d6 = bl ? -1.0 : 1.0;
        Point2D.Double double_ = new Point2D.Double(d4 + d2, d5 + d3);
        Point2D.Double double_2 = new Point2D.Double(d4 - d3 * d6, d5 + d2 * d6);
        Point2D.Double double_3 = new Point2D.Double(((Point2D)double_).getX() - d3 * d6, ((Point2D)double_).getY() + d2 * d6);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)((Point2D)double_).getX(), (float)((Point2D)double_).getY());
        generalPath.lineTo((float)((Point2D)double_3).getX(), (float)((Point2D)double_3).getY());
        generalPath.lineTo((float)((Point2D)double_2).getX(), (float)((Point2D)double_2).getY());
        graphics2D.setStroke(this.helperStrokeRA);
        graphics2D.draw(generalPath);
    }

    private void drawReferenceSegment(Graphics2D graphics2D, MapView mapView, ReferenceSegment referenceSegment) {
        graphics2D.setColor(this.helperColor);
        graphics2D.setStroke(this.helperStrokeDash);
        graphics2D.draw(new MapViewPath(mapView).moveTo(referenceSegment.p1).lineTo(referenceSegment.p2));
    }

    private static Line2D createSemiInfiniteLine(Point2D point2D, Point2D point2D2, Graphics2D graphics2D) {
        Rectangle rectangle = graphics2D.getDeviceConfiguration().getBounds();
        try {
            AffineTransform affineTransform = graphics2D.getTransform().createInverse();
            Point2D point2D3 = affineTransform.deltaTransform(new Point2D.Double(rectangle.width, 0.0), null);
            Point2D point2D4 = affineTransform.deltaTransform(new Point2D.Double(0.0, rectangle.height), null);
            double d = Math.abs(point2D3.getX()) + Math.abs(point2D3.getY()) + Math.abs(point2D4.getX()) + Math.abs(point2D4.getY());
            return new Line2D.Double(point2D, new Point2D.Double(point2D.getX() + point2D2.getX() * d, point2D.getY() + point2D2.getY() * d));
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            Main.debug(noninvertibleTransformException);
            return new Line2D.Double(point2D, new Point2D.Double(point2D.getX() + point2D2.getX() * 10.0, point2D.getY() + point2D2.getY() * 10.0));
        }
    }

    private class DualAlignChangeAction
    extends JosmAction {
        DualAlignChangeAction() {
            super(I18n.tr("Dual alignment", new Object[0]), "mapmode/extrude/dualalign", I18n.tr("Switch dual alignment mode while extruding", new Object[0]), null, false);
            this.putValue("help", HelpUtil.ht("/Action/Extrude#DualAlign"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ExtrudeAction.this.toggleDualAlign();
        }

        @Override
        protected void updateEnabledState() {
            this.setEnabled(Main.map != null && Main.map.mapMode instanceof ExtrudeAction);
        }
    }

    private static class ReferenceSegment {
        public final EastNorth en;
        public final EastNorth p1;
        public final EastNorth p2;
        public final boolean perpendicular;

        ReferenceSegment(EastNorth eastNorth, EastNorth eastNorth2, EastNorth eastNorth3, boolean bl) {
            this.en = eastNorth;
            this.p1 = eastNorth2;
            this.p2 = eastNorth3;
            this.perpendicular = bl;
        }

        public String toString() {
            return "ReferenceSegment[en=" + this.en + ", p1=" + this.p1 + ", p2=" + this.p2 + ", perp=" + this.perpendicular + ']';
        }
    }

    static enum Mode {
        extrude,
        translate,
        select,
        create_new,
        translate_node;

    }
}

