/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressTaskId;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmEditorPane;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.WindowGeometry;

public class SplashScreen
extends JFrame
implements ChangeListener {
    private final transient SplashProgressMonitor progressMonitor;
    private final SplashScreenProgressRenderer progressRenderer;

    public SplashScreen() {
        this.setUndecorated(true);
        Container container = this.getContentPane();
        EtchedBorder etchedBorder = new EtchedBorder(1, Color.white, Color.gray);
        if (container instanceof JComponent) {
            ((JComponent)container).setBorder(etchedBorder);
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new EmptyBorder(10, 10, 2, 10));
        container.add(jPanel);
        JLabel jLabel = new JLabel(ImageProvider.get("logo.svg", ImageProvider.ImageSizes.SPLASH_LOGO));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 70);
        jPanel.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel("JOSM \u2013 " + I18n.tr("Java OpenStreetMap Editor", new Object[0]));
        jLabel2.setFont(GuiHelper.getTitleFont());
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(30, 0, 0, 0);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        JLabel jLabel3 = new JLabel(I18n.tr("Version {0}", Version.getInstance().getVersionString()));
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        JSeparator jSeparator = new JSeparator(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(15, 0, 5, 0);
        jPanel.add((Component)jSeparator, gridBagConstraints);
        this.progressRenderer = new SplashScreenProgressRenderer();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        jPanel.add((Component)this.progressRenderer, gridBagConstraints);
        this.progressMonitor = new SplashProgressMonitor(null, this);
        this.pack();
        WindowGeometry.centerOnScreen(this.getSize(), "gui.geometry").applySafe(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                SplashScreen.this.setVisible(false);
            }
        });
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        GuiHelper.runInEDT(() -> this.progressRenderer.setTasks(this.progressMonitor.toString()));
    }

    public SplashProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    private static class SplashScreenProgressRenderer
    extends JPanel {
        private final JosmEditorPane lblTaskTitle = new JosmEditorPane();
        private final JProgressBar progressBar = new JProgressBar(0);
        private static final String LABEL_HTML = "<html><style>ul {margin-top: 0; margin-bottom: 0; padding: 0;} li {margin: 0; padding: 0;}</style>";

        protected void build() {
            this.setLayout(new GridBagLayout());
            JosmEditorPane.makeJLabelLike(this.lblTaskTitle, false);
            this.lblTaskTitle.setText(LABEL_HTML);
            JScrollPane jScrollPane = new JScrollPane(this.lblTaskTitle, 20, 31);
            jScrollPane.setPreferredSize(new Dimension(0, 320));
            jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.add((Component)jScrollPane, GBC.eol().insets(5, 5, 0, 0).fill(2));
            this.progressBar.setIndeterminate(true);
            this.add((Component)this.progressBar, GBC.eol().insets(5, 15, 0, 0).fill(2));
        }

        SplashScreenProgressRenderer() {
            this.build();
        }

        public void setTasks(String string) {
            this.lblTaskTitle.setText(LABEL_HTML + string);
            this.lblTaskTitle.setCaretPosition(this.lblTaskTitle.getDocument().getLength());
        }
    }

    public static class SplashProgressMonitor
    extends Task
    implements ProgressMonitor {
        private final String name;
        private final ChangeListener listener;
        private final List<Task> tasks = new CopyOnWriteArrayList<Task>();
        private SplashProgressMonitor latestSubtask;

        public SplashProgressMonitor(String string, ChangeListener changeListener) {
            this.name = string;
            this.listener = changeListener;
        }

        @Override
        public StringBuilder toHtml(StringBuilder stringBuilder) {
            stringBuilder.append(Utils.firstNonNull(this.name, ""));
            if (!this.tasks.isEmpty()) {
                stringBuilder.append("<ul>");
                for (Task task : this.tasks) {
                    stringBuilder.append("<li>");
                    task.toHtml(stringBuilder);
                    stringBuilder.append("</li>");
                }
                stringBuilder.append("</ul>");
            }
            return stringBuilder;
        }

        @Override
        public void beginTask(String string) {
            if (string != null && !string.isEmpty()) {
                if (Main.isDebugEnabled()) {
                    Main.debug(string);
                }
                MeasurableTask measurableTask = new MeasurableTask(string);
                this.tasks.add(measurableTask);
                this.listener.stateChanged(null);
            }
        }

        @Override
        public void beginTask(String string, int n) {
            this.beginTask(string);
        }

        @Override
        public void setCustomText(String string) {
            this.beginTask(string);
        }

        @Override
        public void setExtraText(String string) {
            this.beginTask(string);
        }

        @Override
        public void indeterminateSubTask(String string) {
            this.subTask(string);
        }

        @Override
        public void subTask(String string) {
            if (Main.isDebugEnabled()) {
                Main.debug(string);
            }
            this.latestSubtask = new SplashProgressMonitor(string, this.listener);
            this.tasks.add(this.latestSubtask);
            this.listener.stateChanged(null);
        }

        @Override
        public ProgressMonitor createSubTaskMonitor(int n, boolean bl) {
            if (this.latestSubtask != null) {
                return this.latestSubtask;
            }
            return this;
        }

        @Override
        @Deprecated
        public void finishTask() {
        }

        public void finishTask(String string) {
            Task task = Utils.find(this.tasks, new MeasurableTask(string)::equals);
            if (task instanceof MeasurableTask) {
                ((MeasurableTask)task).finish();
                if (Main.isDebugEnabled()) {
                    Main.debug(I18n.tr("{0} completed in {1}", string, ((MeasurableTask)task).duration));
                }
                this.listener.stateChanged(null);
            }
        }

        @Override
        public void invalidate() {
        }

        @Override
        public void setTicksCount(int n) {
        }

        @Override
        public int getTicksCount() {
            return 0;
        }

        @Override
        public void setTicks(int n) {
        }

        @Override
        public int getTicks() {
            return 0;
        }

        @Override
        public void worked(int n) {
        }

        @Override
        public boolean isCanceled() {
            return false;
        }

        @Override
        public void cancel() {
        }

        @Override
        public void addCancelListener(ProgressMonitor.CancelListener cancelListener) {
        }

        @Override
        public void removeCancelListener(ProgressMonitor.CancelListener cancelListener) {
        }

        @Override
        public void appendLogMessage(String string) {
        }

        @Override
        public void setProgressTaskId(ProgressTaskId progressTaskId) {
        }

        @Override
        public ProgressTaskId getProgressTaskId() {
            return null;
        }

        @Override
        public Component getWindowParent() {
            return Main.parent;
        }
    }

    private static class MeasurableTask
    extends Task {
        private final String name;
        private final long start;
        private String duration = "";

        MeasurableTask(String string) {
            this.name = string;
            this.start = System.currentTimeMillis();
        }

        public void finish() {
            if (this.isFinished()) {
                throw new IllegalStateException("This task has already been finished: " + this.name);
            }
            long l = System.currentTimeMillis() - this.start;
            if (l >= 0L) {
                this.duration = I18n.tr(" ({0})", Utils.getDurationString(l));
            }
        }

        public boolean isFinished() {
            return !this.duration.isEmpty();
        }

        @Override
        public StringBuilder toHtml(StringBuilder stringBuilder) {
            return stringBuilder.append(this.name).append("<i style='color: #666666;'>").append(this.duration).append("</i>");
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            MeasurableTask measurableTask = (MeasurableTask)object;
            return Objects.equals(this.name, measurableTask.name) && this.isFinished() == measurableTask.isFinished();
        }

        public int hashCode() {
            return Objects.hashCode(this.name);
        }
    }

    private static abstract class Task {
        private Task() {
        }

        public abstract StringBuilder toHtml(StringBuilder var1);

        public final String toString() {
            return this.toHtml(new StringBuilder(1024)).toString();
        }
    }
}

