/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;
import org.openstreetmap.josm.gui.dialogs.ChangesetDialog;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheManager;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetDiscussionPanel;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.date.DateUtils;

public class VersionInfoPanel
extends JPanel
implements ChangeListener {
    private final PointInTimeType pointInTimeType;
    private final transient HistoryBrowserModel model;
    private JMultilineLabel lblInfo;
    private UrlLabel lblUser;
    private UrlLabel lblChangeset;
    private final JButton lblChangesetComments = new JButton(ImageProvider.get("dialogs/notes/note_comment"));
    private final OpenChangesetDialogAction changesetCommentsDialogAction = new OpenChangesetDialogAction(ChangesetDiscussionPanel.class);
    private final OpenChangesetDialogAction changesetDialogAction = new OpenChangesetDialogAction(null);
    private final JButton changesetButton = new JButton(this.changesetDialogAction);
    private JPanel pnlChangesetSource;
    private JPanel pnlChangesetImageryUsed;
    private JLabel lblSource;
    private JLabel lblImageryUsed;
    private JTextArea texChangesetComment;
    private JTextArea texChangesetSource;
    private JTextArea texChangesetImageryUsed;

    protected static JTextArea buildTextArea(String string) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        jTextArea.setOpaque(false);
        jTextArea.setToolTipText(string);
        return jTextArea;
    }

    protected static JLabel buildLabel(String string, String string2, JTextArea jTextArea) {
        JLabel jLabel = new JLabel("<html><p style='margin-top:" + jTextArea.getMargin().top + "'>" + string + "</html>");
        jLabel.setFont(jTextArea.getFont());
        jLabel.setToolTipText(string2);
        jLabel.setLabelFor(jTextArea);
        return jLabel;
    }

    protected static JPanel buildTextPanel(JLabel jLabel, JTextArea jTextArea) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jLabel, GBC.std().anchor(18));
        jPanel.add((Component)jTextArea, GBC.eol().insets(2, 0, 0, 0).fill());
        return jPanel;
    }

    protected void build() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.lblInfo = new JMultilineLabel("");
        jPanel.add((Component)this.lblInfo, "Center");
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)new JLabel(I18n.tr("User:", new Object[0])), GBC.std());
        this.lblUser = new UrlLabel("", 2);
        jPanel2.add((Component)this.lblUser, GBC.eol().insets(5, 0, 0, 0).weight(1.0, 0.0));
        this.changesetButton.setMargin(new Insets(0, 0, 0, 2));
        jPanel2.add((Component)this.changesetButton, GBC.std().fill().weight(0.0, 0.0));
        this.lblChangeset = new UrlLabel("", 2);
        jPanel2.add((Component)this.lblChangeset, GBC.std().insets(5, 0, 0, 0).weight(1.0, 0.0));
        this.lblChangesetComments.setAction(this.changesetCommentsDialogAction);
        this.lblChangesetComments.setMargin(new Insets(0, 0, 0, 0));
        this.lblChangesetComments.setIcon(new ImageProvider("dialogs/notes/note_comment").setMaxSize(12).get());
        jPanel2.add((Component)this.lblChangesetComments, GBC.eol());
        this.texChangesetComment = VersionInfoPanel.buildTextArea(I18n.tr("Changeset comment", new Object[0]));
        this.texChangesetSource = VersionInfoPanel.buildTextArea(I18n.tr("Changeset source", new Object[0]));
        this.texChangesetImageryUsed = VersionInfoPanel.buildTextArea(I18n.tr("Imagery used", new Object[0]));
        this.lblSource = VersionInfoPanel.buildLabel(I18n.tr("<b>Source</b>:", new Object[0]), I18n.tr("Changeset source", new Object[0]), this.texChangesetSource);
        this.lblImageryUsed = VersionInfoPanel.buildLabel(I18n.tr("<b>Imagery</b>:", new Object[0]), I18n.tr("Imagery used", new Object[0]), this.texChangesetImageryUsed);
        this.pnlChangesetSource = VersionInfoPanel.buildTextPanel(this.lblSource, this.texChangesetSource);
        this.pnlChangesetImageryUsed = VersionInfoPanel.buildTextPanel(this.lblImageryUsed, this.texChangesetImageryUsed);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.add((Component)this.texChangesetComment, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.add((Component)this.pnlChangesetSource, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        this.add((Component)this.pnlChangesetImageryUsed, gridBagConstraints);
    }

    protected HistoryOsmPrimitive getPrimitive() {
        if (this.model == null || this.pointInTimeType == null) {
            return null;
        }
        return this.model.getPointInTime(this.pointInTimeType);
    }

    protected String getInfoText(Date date, long l, boolean bl) {
        String string;
        if (bl) {
            OsmDataLayer osmDataLayer = Main.getLayerManager().getEditLayer();
            string = I18n.tr("<html>Version <strong>{0}</strong> currently edited in layer ''{1}''</html>", Long.toString(l), osmDataLayer == null ? I18n.tr("unknown", new Object[0]) : Utils.escapeReservedCharactersHTML(osmDataLayer.getName()));
        } else {
            String string2 = "?";
            if (date != null) {
                string2 = DateUtils.formatDateTime(date, 3, 3);
            }
            string = I18n.tr("<html>Version <strong>{0}</strong> created on <strong>{1}</strong></html>", Long.toString(l), string2);
        }
        return string;
    }

    public VersionInfoPanel() {
        this.pointInTimeType = null;
        this.model = null;
        this.build();
    }

    public VersionInfoPanel(HistoryBrowserModel historyBrowserModel, PointInTimeType pointInTimeType) {
        CheckParameterUtil.ensureParameterNotNull((Object)pointInTimeType, "pointInTimeType");
        CheckParameterUtil.ensureParameterNotNull(historyBrowserModel, "model");
        this.model = historyBrowserModel;
        this.pointInTimeType = pointInTimeType;
        historyBrowserModel.addChangeListener(this);
        this.build();
    }

    protected static String getUserUrl(String string) {
        return Main.getBaseUserUrl() + '/' + Utils.encodeUrl(string).replaceAll("\\+", "%20");
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        HistoryOsmPrimitive historyOsmPrimitive = this.getPrimitive();
        if (historyOsmPrimitive != null) {
            Changeset changeset = historyOsmPrimitive.getChangeset();
            this.update(changeset, this.model.isLatest(historyOsmPrimitive), historyOsmPrimitive.getTimestamp(), historyOsmPrimitive.getVersion());
        }
    }

    public void update(OsmPrimitive osmPrimitive, boolean bl) {
        this.update(Changeset.fromPrimitive(osmPrimitive), bl, osmPrimitive.getTimestamp(), osmPrimitive.getVersion());
    }

    public void update(Changeset changeset, boolean bl, Date date, long l) {
        Object object;
        this.lblInfo.setText(this.getInfoText(date, l, bl));
        if (!bl && changeset != null) {
            object = changeset.getUser();
            String string = Main.getBaseBrowseUrl() + "/changeset/" + changeset.getId();
            this.lblChangeset.setUrl(string);
            this.lblChangeset.setDescription(Long.toString(changeset.getId()));
            this.changesetCommentsDialogAction.setId(changeset.getId());
            this.lblChangesetComments.setVisible(changeset.getCommentsCount() > 0);
            this.lblChangesetComments.setText(String.valueOf(changeset.getCommentsCount()));
            this.lblChangesetComments.setToolTipText(I18n.trn("This changeset has {0} comment", "This changeset has {0} comments", changeset.getCommentsCount(), changeset.getCommentsCount()));
            this.changesetDialogAction.setId(changeset.getId());
            this.changesetButton.setEnabled(true);
            String string2 = "";
            if (object != null) {
                string2 = ((User)object).getName();
            }
            this.lblUser.setDescription(string2);
            if (object != null && object != User.getAnonymous()) {
                this.lblUser.setUrl(VersionInfoPanel.getUserUrl(string2));
            } else {
                this.lblUser.setUrl(null);
            }
        } else {
            object = JosmUserIdentityManager.getInstance().getUserName();
            if (object == null) {
                this.lblUser.setDescription(I18n.tr("anonymous", new Object[0]));
                this.lblUser.setUrl(null);
            } else {
                this.lblUser.setDescription((String)object);
                this.lblUser.setUrl(VersionInfoPanel.getUserUrl((String)object));
            }
            this.lblChangeset.setDescription(I18n.tr("none", new Object[0]));
            this.lblChangeset.setUrl(null);
            this.lblChangesetComments.setVisible(false);
            this.changesetDialogAction.setId(null);
            this.changesetButton.setEnabled(false);
        }
        object = this.model != null ? this.model.getPointInTime(this.pointInTimeType.opposite()).getChangeset() : null;
        VersionInfoPanel.updateText(changeset, "comment", this.texChangesetComment, null, (Changeset)object, this.texChangesetComment);
        VersionInfoPanel.updateText(changeset, "source", this.texChangesetSource, this.lblSource, (Changeset)object, this.pnlChangesetSource);
        VersionInfoPanel.updateText(changeset, "imagery_used", this.texChangesetImageryUsed, this.lblImageryUsed, (Changeset)object, this.pnlChangesetImageryUsed);
    }

    protected static void updateText(Changeset changeset, String string, JTextArea jTextArea, JLabel jLabel, Changeset changeset2, JComponent jComponent) {
        String string2;
        String string3 = string2 = changeset != null ? changeset.get(string) : null;
        if (jLabel != null) {
            jLabel.setVisible(string2 != null && !Utils.isStripEmpty(string2));
        }
        jTextArea.setText(string2);
        jComponent.setVisible(string2 != null || changeset2 != null && changeset2.get(string) != null);
    }

    static class OpenChangesetDialogAction
    extends AbstractAction {
        private final Class<? extends JComponent> componentToSelect;
        private Integer id;

        OpenChangesetDialogAction(Class<? extends JComponent> clazz) {
            super(I18n.tr("Changeset", new Object[0]), new ImageProvider("dialogs/changeset", "changesetmanager").resetMaxSize(new Dimension(16, 16)).get());
            this.putValue("ShortDescription", I18n.tr("Opens the Changeset Manager window for the selected changesets", new Object[0]));
            this.componentToSelect = clazz;
        }

        void setId(Integer n) {
            this.id = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.id != null) {
                ChangesetDialog.LaunchChangesetManager.displayChangesets(Collections.singleton(this.id));
            }
            if (this.componentToSelect != null) {
                ChangesetCacheManager.getInstance().setSelectedComponentInDetailPanel(this.componentToSelect);
            }
        }
    }
}

